/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.filter.BodyC14NFilter;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceValidity;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Transform;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.URITransportSetter;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignature;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.XPathUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.context.MessageContext;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ReferenceProcessor {
    private static final TraceComponent tc = Tr.register(ReferenceProcessor.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final boolean DEBUG = false;
    private static final QName TYPE_Q = new QName("", "Type");
    private static final QName URI_Q = new QName("", "URI");
    private static final QName ALGO_Q = new QName("", "Algorithm");
    public static long digestTime;

    private ReferenceProcessor() {
    }

    static byte[] getTransformedOctets(SignatureContext signatureContext, OMDocument oMDocument, OMElement oMElement, int n) throws IOException, SignatureStructureException, TransformException, NoSuchAlgorithmException {
        Object object;
        Object object2;
        String string = null;
        TransformContext transformContext = null;
        Vector vector = null;
        OMElement oMElement2 = XSignature.getFirstChild(oMElement, "Transforms");
        OMAttribute oMAttribute = oMElement.getAttribute(TYPE_Q);
        String string2 = oMAttribute == null ? null : oMAttribute.getAttributeValue();
        OMAttribute oMAttribute2 = oMElement.getAttribute(URI_Q);
        if (oMAttribute2 == null) {
            object2 = signatureContext.getNullURIHandler();
            if (object2 == null) {
                throw new TransformException("A Reference element has no URI attribute, but NullURIHandler is not registered.");
            }
            transformContext = object2.getContent();
            if (transformContext.getType() == 3) {
                object = transformContext.getNode();
                if (DOMUtil.getOwnerDocument((OMNode)object) != null && DOMUtil.getOwnerDocument((OMNode)object) == oMDocument || object == oMDocument) {
                    vector = ReferenceProcessor.fixTree((OMNode)object, oMElement2);
                } else {
                    ReferenceProcessor.fixTree((OMNode)object, oMElement2);
                }
            }
        } else {
            string = oMAttribute2.getAttributeValue();
            if (string == null) {
                string = "";
            }
            int n2 = -1;
            if (string.length() > 0 && (n2 = string.indexOf(35)) < 0 && oMElement2 == null) {
                byte[] byArray = URITransportSetter.getContent(string, signatureContext.getEntityResolver(), null);
                if (signatureContext.getResourceShower() != null) {
                    signatureContext.getResourceShower().showSignedResource(signatureContext.getOwnerElement(), n, string, string2, byArray, null);
                }
                return byArray;
            }
            String string3 = null;
            if (n2 >= 0) {
                object = string.substring(0, n2);
                string3 = string.substring(n2 + 1);
            } else {
                object = string;
            }
            if (((String)object).length() > 0 && string3 == null) {
                transformContext = new TransformContext(signatureContext, (String)object);
            } else {
                OMDocument oMDocument2 = null;
                if (((String)object).length() == 0) {
                    oMDocument2 = oMDocument;
                    vector = ReferenceProcessor.fixTree(oMDocument.getOMDocumentElement(), oMElement2);
                } else if (string3 != null) {
                    try {
                        InputSource inputSource = null;
                        if (signatureContext.getEntityResolver() != null) {
                            inputSource = signatureContext.getEntityResolver().resolveEntity(null, (String)object);
                        }
                        oMDocument2 = inputSource == null ? signatureContext.parse(new InputSource((String)object)) : signatureContext.parse(inputSource);
                    }
                    catch (SAXException sAXException) {
                        throw TransformException.create(sAXException);
                    }
                    catch (XMLStreamException xMLStreamException) {
                        throw TransformException.create(xMLStreamException);
                    }
                }
                transformContext = string3 != null ? ReferenceProcessor.idToInput(signatureContext, (String)object, oMDocument2, string3) : new TransformContext(signatureContext, oMDocument2.getOMDocumentElement());
            }
        }
        object2 = ReferenceProcessor.getBodyC14NResultIfSourcedElement(transformContext, oMElement2);
        if (object2 == null) {
            ReferenceProcessor.transform(oMElement, transformContext, signatureContext.getAlgorithmFactory());
        }
        if (signatureContext.getResourceShower() != null) {
            signatureContext.getResourceShower().showSignedResource(signatureContext.getOwnerElement(), n, string, string2, transformContext.getOctets(), transformContext.getEncoding());
        }
        object = transformContext.getOctets();
        if (vector != null) {
            XPathUtil.cleanTree(vector);
        }
        return object;
    }

    private static byte[] getBodyC14NResultIfSourcedElement(TransformContext transformContext, OMElement oMElement) throws TransformException {
        try {
            Object object;
            int n;
            Object object2;
            Object object3;
            Object object4;
            SignatureContext signatureContext = transformContext.getSignatureContext();
            Map map = signatureContext.getContext();
            if (map == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no context");
                }
                return null;
            }
            Boolean bl = (Boolean)map.get("com.ibm.ws.wssecurity.filter.BodyC14NFilter.IS_OUTBOUND_GOLDEN_PATH");
            if (bl == null || !bl.booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "not in golden path");
                }
                return null;
            }
            MessageContext messageContext = (MessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
            if (messageContext == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no MessageContext");
                }
                return null;
            }
            if (transformContext.getType() != 3) {
                return null;
            }
            OMNode oMNode = transformContext.getNode();
            if (oMNode.getType() != 1) {
                return null;
            }
            OMElement oMElement2 = (OMElement)oMNode;
            if (!(oMElement2 instanceof SOAPBody)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the target is not soap body");
                }
                return null;
            }
            OMNode oMNode2 = oMElement2.getFirstOMChild();
            if (oMNode2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "soap body has no child");
                }
                return null;
            }
            if (!(oMNode2 instanceof OMSourcedElementImpl)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "soap body content is not OMSourcedElement");
                }
                return null;
            }
            OMSourcedElementImpl oMSourcedElementImpl = (OMSourcedElementImpl)oMNode2;
            if (oMSourcedElementImpl.getNextOMSibling() != null) {
                return null;
            }
            OMDataSource oMDataSource = oMSourcedElementImpl.getDataSource();
            if (tc.isDebugEnabled()) {
                if (oMDataSource == null) {
                    Tr.debug(tc, "OMDataSource is null");
                } else {
                    Tr.debug(tc, "OMDataSource type is " + oMDataSource.getClass().getName());
                }
                Tr.debug(tc, "ose.isExpanded() is " + oMSourcedElementImpl.isExpanded());
            }
            byte[] byArray = null;
            if (oMDataSource == null || oMSourcedElementImpl.isExpanded() || !(oMDataSource instanceof OMDataSourceExt)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting body byte[] from XMLStreamWriter");
                }
                object4 = new ByteArrayOutputStream(2048);
                object3 = new OMOutputFormat();
                ((OMOutputFormat)object3).setIgnoreXMLDeclaration(true);
                object2 = StAXUtils.createXMLStreamWriter((OutputStream)object4);
                MTOMXMLStreamWriter mTOMXMLStreamWriter = new MTOMXMLStreamWriter((XMLStreamWriter)object2);
                mTOMXMLStreamWriter.setOutputFormat((OMOutputFormat)object3);
                oMSourcedElementImpl.serializeAndConsume(mTOMXMLStreamWriter);
                ((OutputStream)object4).flush();
                mTOMXMLStreamWriter.close();
                object2.close();
                byArray = ((ByteArrayOutputStream)object4).toByteArray();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Getting body byte[] from OMDataSource");
                }
                object4 = (OMDataSourceExt)oMDataSource;
                byArray = object4.getXMLBytes("utf-8");
            }
            object4 = StAXUtils.createXMLStreamReader(new ByteArrayInputStream(byArray));
            object3 = new BodyC14NFilter((XMLStreamReader)object4);
            object2 = (Boolean)map.get("com.ibm.ws.wssecurity.filter.BodyC14NFilter.IS_INCL_NS_ALL_PREFIXES");
            if (object2 != null && ((Boolean)object2).booleanValue()) {
                ((BodyC14NFilter)object3).setInclNsMode(1);
            }
            map.put("com.ibm.ws.wssecurity.filter.BodyC14NFilter.IS_INCL_NS_ALL_PREFIXES", null);
            ((BodyC14NFilter)object3).init((XMLStreamReader)object4, messageContext, oMElement2);
            while ((n = ((BodyC14NFilter)object3).next()) != 8) {
            }
            object4.close();
            byte[] byArray2 = ((BodyC14NFilter)object3).getBodyC14NBytes();
            transformContext.setContent(byArray2, "UTF-8");
            if (((BodyC14NFilter)object3).getInclNsMode() == 1) {
                object = ((BodyC14NFilter)object3).getInclNsPrefixListAsString();
                OMElement oMElement3 = (OMElement)oMElement.getFirstOMChild();
                OMElement oMElement4 = null;
                if (object != null) {
                    oMElement4 = oMElement3.getOMFactory().createOMElement("InclusiveNamespaces", "http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
                    oMElement4.declareNamespace("http://www.w3.org/2001/10/xml-exc-c14n#", "ec");
                    oMElement4.addAttribute("PrefixList", (String)object, null);
                    oMElement3.addChild(oMElement4);
                }
            }
            object = byArray;
            messageContext.setProperty("com.ibm.ws.wssecurity.filter.BodyC14NFilter.BODY_CONTENT_C14N_RESULT", object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "[C14N] bodyContentBytes = " + new String((byte[])object));
            }
            return byArray2;
        }
        catch (XMLStreamException xMLStreamException) {
            throw TransformException.create(xMLStreamException);
        }
        catch (IOException iOException) {
            throw TransformException.create(iOException);
        }
    }

    private static byte[] internalConversionFromCharsToBytes(char[] cArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
            outputStreamWriter.write(cArray);
            outputStreamWriter.flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] _internalConversionFromCharsToBytes(char[] cArray) {
        int n = cArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if ('\u0000' < c && c < '\u007f') {
                byArray[i] = (byte)c;
                continue;
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(byArray, 0, i);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF8");
                outputStreamWriter.write(cArray, i, n - i);
                outputStreamWriter.flush();
                return byteArrayOutputStream.toByteArray();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return byArray;
    }

    private static String getIdFromXPointer(String string) {
        if (!string.endsWith(")")) {
            return null;
        }
        if (!(string = string.substring("xpointer(".length(), string.length() - 1).trim()).startsWith("id(") || !string.endsWith(")")) {
            return null;
        }
        if ((string = string.substring("id(".length(), string.length() - 1).trim()).length() < 3) {
            return null;
        }
        char c = string.charAt(0);
        char c2 = string.charAt(string.length() - 1);
        if ((c == '\"' || c == '\'') && c == c2) {
            return string.substring(1, string.length() - 1);
        }
        return null;
    }

    private static TransformContext idToInput(SignatureContext signatureContext, String string, OMDocument oMDocument, String string2) throws IllegalArgumentException {
        TransformContext transformContext;
        IDResolver iDResolver = signatureContext.getIDResolver0();
        if (string2.startsWith("xpointer(")) {
            if (string2.equals("xpointer(/)")) {
                ArrayList arrayList = XPathCanonicalizer.toNodeset(oMDocument.getOMDocumentElement(), null, true);
                transformContext = new TransformContext(signatureContext, arrayList);
            } else {
                String string3 = ReferenceProcessor.getIdFromXPointer(string2);
                if (string3 == null) {
                    throw new IllegalArgumentException("No support for xpointer '" + string2 + "'");
                }
                string2 = string3;
                if (iDResolver == null) {
                    throw new IllegalArgumentException("No IDResolver is registered.");
                }
                OMElement oMElement = iDResolver.resolveID(oMDocument, string2);
                if (oMElement == null) {
                    throw new IllegalArgumentException("Can't resolve ID: '" + string2 + "' in '" + string + "'");
                }
                ArrayList arrayList = XPathCanonicalizer.toNodeset(oMElement, null, true);
                transformContext = new TransformContext(signatureContext, arrayList);
            }
        } else {
            if (iDResolver == null) {
                throw new IllegalArgumentException("No IDResolver is registered.");
            }
            OMElement oMElement = iDResolver.resolveID(oMDocument, string2);
            if (oMElement == null) {
                throw new IllegalArgumentException("Can't resolve ID: '" + string2 + "' in '" + string + "'");
            }
            transformContext = new TransformContext(signatureContext, oMElement);
        }
        return transformContext;
    }

    private static Vector fixTree(OMNode oMNode, OMElement oMElement) {
        if (oMElement == null) {
            return null;
        }
        OMElement oMElement2 = XSignature.getFirstChild(oMElement, "Transform");
        if (oMElement2 == null) {
            return null;
        }
        String string = oMElement2.getAttributeValue(ALGO_Q);
        if ("http://www.w3.org/TR/2001/REC-xml-c14n-20010315".equals(string) || "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments".equals(string) || "http://www.w3.org/2001/10/xml-exc-c14n#".equals(string) || "http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(string)) {
            OMNode oMNode2;
            for (oMNode2 = oMElement2.getNextOMSibling(); oMNode2 != null && oMNode2.getType() != 1; oMNode2 = oMNode2.getNextOMSibling()) {
            }
            if (oMNode2 == null) {
                return null;
            }
        }
        return XPathUtil.fixTree(oMNode);
    }

    private static byte[] transform(OMElement oMElement, TransformContext transformContext, AlgorithmFactory algorithmFactory) throws SignatureStructureException, TransformException, NoSuchAlgorithmException {
        OMElement oMElement2 = XSignature.getFirstChild(oMElement, "Transforms");
        if (oMElement2 == null) {
            return transformContext.getOctets();
        }
        OMNode oMNode = DOMUtil.getFirstChild2(oMElement2);
        while (oMNode != null) {
            OMElement oMElement3;
            if (oMNode.getType() == 1 && XSignature.isDsigElement(oMElement3 = (OMElement)oMNode, "Transform")) {
                String string = oMElement3.getAttributeValue(ALGO_Q);
                if (string == null || string.length() == 0) {
                    throw new SignatureStructureException("No Algorithm in a Transform element.");
                }
                Transform transform = algorithmFactory.getTransform(string);
                if (transform == null) {
                    throw new TransformException("No such algorithm: " + string);
                }
                transform.setParameter(DOMUtil.getFirstChildElement(oMElement3));
                transform.transform(transformContext);
            }
            oMNode = DOMUtil.getNextSibling2(oMNode);
        }
        return transformContext.getOctets();
    }

    static byte[] calculateDigestValue(OMElement oMElement, byte[] byArray, AlgorithmFactory algorithmFactory) throws SignatureStructureException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        OMElement oMElement2 = XSignature.getFirstChild(oMElement, "DigestMethod");
        if (oMElement2 == null) {
            throw new SignatureStructureException("No DigestMethod element.");
        }
        String string = oMElement2.getAttributeValue(ALGO_Q);
        if (string == null || string.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute, or empty Algorithm attribute.");
        }
        AlgorithmParameterSpec algorithmParameterSpec = algorithmFactory.unmarshalParameter(string, oMElement2);
        MessageDigest messageDigest = algorithmFactory.getMessageDigest(string, algorithmParameterSpec);
        long l = System.currentTimeMillis();
        messageDigest.reset();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        algorithmFactory.releaseMessageDigest(string, messageDigest);
        digestTime += System.currentTimeMillis() - l;
        return byArray2;
    }

    private static byte[] digest(SignatureContext signatureContext, OMElement oMElement, int n) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, TransformException, IOException {
        OMDocument oMDocument = DOMUtil.getOwnerDocument(oMElement);
        byte[] byArray = ReferenceProcessor.getTransformedOctets(signatureContext, oMDocument, oMElement, n);
        return ReferenceProcessor.calculateDigestValue(oMElement, byArray, signatureContext.getAlgorithmFactory());
    }

    static void substDigest(SignatureContext signatureContext, OMElement oMElement, int n) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, TransformException, IOException {
        byte[] byArray = ReferenceProcessor.digest(signatureContext, oMElement, n);
        OMElement oMElement2 = XSignature.getFirstChild(oMElement, "DigestValue");
        if (oMElement2 == null) {
            throw new SignatureStructureException("No DigestValue element.");
        }
        DOMUtil.removeAllChildren(oMElement2);
        OMFactory oMFactory = oMElement.getOMFactory();
        oMElement2.addChild(oMFactory.createOMText(Base64.encode(byArray)));
    }

    static ReferenceValidity verify(SignatureContext signatureContext, OMElement oMElement, int n) {
        ReferenceValidity referenceValidity;
        block3: {
            OMAttribute oMAttribute = oMElement.getAttribute(URI_Q);
            OMAttribute oMAttribute2 = oMElement.getAttribute(TYPE_Q);
            referenceValidity = new ReferenceValidity(oMAttribute == null ? null : oMAttribute.getAttributeValue(), oMAttribute2 == null ? null : oMAttribute2.getAttributeValue());
            byte[] byArray = null;
            try {
                byArray = ReferenceProcessor.digest(signatureContext, oMElement, n);
                OMElement oMElement2 = XSignature.getFirstChild(oMElement, "DigestValue");
                if (oMElement2 == null) {
                    throw new SignatureStructureException("No DigestValue element.");
                }
                byte[] byArray2 = Base64.decode(DOMUtil.getStringValue(oMElement2));
                referenceValidity.valid = MessageDigest.isEqual(byArray, byArray2);
                referenceValidity.message = referenceValidity.valid ? "Ok." : "Digest value mismatch: calculated: " + Base64.encode(byArray);
            }
            catch (Exception exception) {
                referenceValidity.valid = false;
                referenceValidity.message = exception.getMessage();
                if (referenceValidity.message != null) break block3;
                referenceValidity.message = exception.getClass().getName();
            }
        }
        return referenceValidity;
    }
}

