/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfoGenerator;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceProcessor;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignature;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.SimpleKey;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;

class ProcessKey {
    static final boolean DEBUG = false;

    private ProcessKey() {
    }

    private static String encodeBigInteger(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        int n = 0;
        while (byArray[n] == 0) {
            ++n;
        }
        return Base64.encode(byArray, n, byArray.length - n);
    }

    private static boolean matchClass(Class clazz, String string) {
        if (clazz.getName().equals(string)) {
            return true;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && ProcessKey.matchClass(clazz2, string)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!ProcessKey.matchClass(classArray[i], string)) continue;
            return true;
        }
        return false;
    }

    private static boolean instanceOf(Object object, String string) {
        return ProcessKey.matchClass(object.getClass(), string);
    }

    static OMElement createKeyValue(OMFactory oMFactory, IndentConfig indentConfig, Key key) {
        OMElement oMElement = oMFactory.createOMElement("KeyValue", "http://www.w3.org/2000/09/xmldsig#", "");
        if (ProcessKey.instanceOf(key, "java.security.interfaces.DSAPublicKey")) {
            DOMUtil.addIndent(oMElement, indentConfig, 3);
            DSAPublicKey dSAPublicKey = (DSAPublicKey)key;
            DSAParams dSAParams = dSAPublicKey.getParams();
            OMElement oMElement2 = oMFactory.createOMElement("DSAKeyValue", "http://www.w3.org/2000/09/xmldsig#", "");
            DOMUtil.addIndent(oMElement2, indentConfig, 4);
            String string = ProcessKey.encodeBigInteger(dSAParams.getP());
            if (indentConfig.doIndentation()) {
                string = Base64.format(string, indentConfig.getUnit() * 5, "\n", DOMUtil.getSpaces(indentConfig, 4));
            }
            oMElement2.addChild(DOMUtil.createTextElementNS(oMFactory, "http://www.w3.org/2000/09/xmldsig#", "", "P", string));
            DOMUtil.addIndent(oMElement2, indentConfig, 4);
            string = ProcessKey.encodeBigInteger(dSAParams.getQ());
            oMElement2.addChild(DOMUtil.createTextElementNS(oMFactory, "http://www.w3.org/2000/09/xmldsig#", "", "Q", string));
            DOMUtil.addIndent(oMElement2, indentConfig, 4);
            string = ProcessKey.encodeBigInteger(dSAParams.getG());
            if (indentConfig.doIndentation()) {
                string = Base64.format(string, indentConfig.getUnit() * 5, "\n", DOMUtil.getSpaces(indentConfig, 4));
            }
            oMElement2.addChild(DOMUtil.createTextElementNS(oMFactory, "http://www.w3.org/2000/09/xmldsig#", "", "G", string));
            DOMUtil.addIndent(oMElement2, indentConfig, 4);
            string = ProcessKey.encodeBigInteger(dSAPublicKey.getY());
            if (indentConfig.doIndentation()) {
                string = Base64.format(string, indentConfig.getUnit() * 5, "\n", DOMUtil.getSpaces(indentConfig, 4));
            }
            oMElement2.addChild(DOMUtil.createTextElementNS(oMFactory, "http://www.w3.org/2000/09/xmldsig#", "", "Y", string));
            DOMUtil.addIndent(oMElement2, indentConfig, 3);
            oMElement.addChild(oMElement2);
            DOMUtil.addIndent(oMElement, indentConfig, 2);
        } else if (ProcessKey.instanceOf(key, "java.security.interfaces.RSAPublicKey")) {
            RSA.createKeyValue(oMFactory, indentConfig, key, oMElement);
        } else {
            oMElement.addChild(oMFactory.createOMText(Base64.encode(key.getEncoded())));
        }
        return oMElement;
    }

    static void printKey(Key key) {
        PrintStream printStream = System.err;
        if (key instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)key;
            DSAParams dSAParams = dSAPublicKey.getParams();
            printStream.println("P: " + dSAParams.getP());
            printStream.println("Q: " + dSAParams.getQ());
            printStream.println("G: " + dSAParams.getG());
            printStream.println("Y: " + dSAPublicKey.getY());
            printStream.println("P: " + ProcessKey.encodeBigInteger(dSAParams.getP()));
            printStream.println("Q: " + ProcessKey.encodeBigInteger(dSAParams.getQ()));
            printStream.println("G: " + ProcessKey.encodeBigInteger(dSAParams.getG()));
            printStream.println("Y: " + ProcessKey.encodeBigInteger(dSAPublicKey.getY()));
            printStream.print("P: ");
            ProcessKey.printByteArray(printStream, dSAParams.getP());
            printStream.print("Q: ");
            ProcessKey.printByteArray(printStream, dSAParams.getQ());
            printStream.print("G: ");
            ProcessKey.printByteArray(printStream, dSAParams.getG());
            printStream.print("Y: ");
            ProcessKey.printByteArray(printStream, dSAPublicKey.getY());
        } else if (ProcessKey.instanceOf(key, "java.security.interfaces.RSAPublicKey")) {
            RSA.print(printStream, key);
        } else {
            printStream.println("Neither DSAPublicky nor RsAPublicKey");
        }
    }

    private static void printByteArray(PrintStream printStream, BigInteger bigInteger) {
        printStream.println(Base64.toHexString(bigInteger.toByteArray()));
    }

    static Key createKey(OMElement oMElement) throws SignatureStructureException, NoSuchAlgorithmException, InvalidKeySpecException {
        Object object = DOMUtil.getFirstChild2(oMElement);
        while (object != null) {
            if (object.getType() == 1) {
                OMElement oMElement2 = (OMElement)object;
                if (!XSignature.isDsigElement(oMElement2)) {
                    throw new SignatureStructureException("Unknown element: " + oMElement2.getQName());
                }
                if (XSignature.isDsigElement(oMElement2, "DSAKeyValue")) {
                    return ProcessKey.createDSAKey(oMElement2);
                }
                if (XSignature.isDsigElement(oMElement2, "RSAKeyValue")) {
                    return ProcessKey.createRSAKey(oMElement2);
                }
                throw new SignatureStructureException("Unknown element: " + oMElement2.getQName());
            }
            object = DOMUtil.getNextSibling2((OMNode)object);
        }
        object = DOMUtil.getStringValue(oMElement);
        return new SimpleKey(Base64.decode((String)object));
    }

    static Key createDSAKey(OMElement oMElement) throws SignatureStructureException, NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        Object object = DOMUtil.getFirstChild2(oMElement);
        while (object != null) {
            if (object.getType() == 1) {
                OMElement oMElement2 = (OMElement)object;
                if (XSignature.isDsigElement(oMElement2, "P")) {
                    bigInteger = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(oMElement2)));
                } else if (XSignature.isDsigElement(oMElement2, "Q")) {
                    bigInteger2 = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(oMElement2)));
                } else if (XSignature.isDsigElement(oMElement2, "G")) {
                    bigInteger3 = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(oMElement2)));
                } else if (XSignature.isDsigElement(oMElement2, "Y")) {
                    bigInteger4 = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(oMElement2)));
                } else if (!(XSignature.isDsigElement(oMElement2, "J") || XSignature.isDsigElement(oMElement2, "Seed") || XSignature.isDsigElement(oMElement2, "PgenCounter"))) {
                    throw new SignatureStructureException("Unknown element: " + oMElement2.getQName());
                }
            }
            object = DOMUtil.getNextSibling2((OMNode)object);
        }
        if (bigInteger == null) {
            throw new SignatureStructureException("No P element in the DSAKeyValue element.");
        }
        if (bigInteger2 == null) {
            throw new SignatureStructureException("No Q element in the DSAKeyValue element.");
        }
        if (bigInteger3 == null) {
            throw new SignatureStructureException("No G element in the DSAKeyValue element.");
        }
        if (bigInteger4 == null) {
            throw new SignatureStructureException("No Y element in the DSAKeyValue element.");
        }
        object = KeyFactory.getInstance("DSA");
        return ((KeyFactory)object).generatePublic(new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3));
    }

    static Key createRSAKey(OMElement oMElement) throws SignatureStructureException, NoSuchAlgorithmException, InvalidKeySpecException {
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        Object object = DOMUtil.getFirstChild2(oMElement);
        while (object != null) {
            if (object.getType() == 1) {
                OMElement oMElement2 = (OMElement)object;
                if (XSignature.isDsigElement(oMElement2, "Modulus")) {
                    byte[] byArray = Base64.decode(DOMUtil.getStringValue(oMElement2));
                    bigInteger = new BigInteger(1, byArray);
                } else if (XSignature.isDsigElement(oMElement2, "Exponent")) {
                    bigInteger2 = new BigInteger(1, Base64.decode(DOMUtil.getStringValue(oMElement2)));
                } else {
                    throw new SignatureStructureException("Unknown element: " + oMElement2.getQName());
                }
            }
            object = DOMUtil.getNextSibling2((OMNode)object);
        }
        if (bigInteger == null) {
            throw new SignatureStructureException("No Modulus element in the RSAKeyValue element.");
        }
        if (bigInteger2 == null) {
            throw new SignatureStructureException("No Exponent element in the RSAKeyValue element.");
        }
        object = KeyFactory.getInstance("RSA");
        return ((KeyFactory)object).generatePublic(new RSAPublicKeySpec(bigInteger, bigInteger2));
    }

    static void setKeyInfo(OMElement oMElement, KeyInfoGenerator keyInfoGenerator) throws SignatureStructureException {
        OMElement oMElement2 = XSignature.getFirstChild(oMElement, "SignatureValue");
        if (oMElement2 == null) {
            throw new SignatureStructureException("The Signature element has no SignatureValue element.");
        }
        OMNode oMNode = oMElement2.getNextOMSibling();
        OMFactory oMFactory = oMElement.getOMFactory();
        OMElement oMElement3 = keyInfoGenerator.getKeyInfoElement(oMFactory);
        String string = oMElement.getNamespace().getPrefix();
        if (string != null && string.length() != 0) {
            oMElement3.declareDefaultNamespace("http://www.w3.org/2000/09/xmldsig#");
        }
        if (oMNode == null) {
            oMElement.addChild(oMFactory.createOMText("\n  "));
            oMElement.addChild(oMElement3);
        } else {
            oMNode.insertSiblingBefore(oMFactory.createOMText("\n  "));
            oMNode.insertSiblingBefore(oMElement3);
        }
    }

    static Key processKeyInfo(SignatureContext signatureContext, OMElement oMElement) throws CertificateException, NoSuchAlgorithmException, SignatureStructureException, InvalidKeySpecException, IOException, TransformException {
        Key key = null;
        Key key2 = null;
        int n = 0;
        OMNode oMNode = DOMUtil.getFirstChild2(oMElement);
        while (oMNode != null) {
            if (oMNode.getType() == 1) {
                Object object;
                ByteArrayInputStream byteArrayInputStream;
                Object object2;
                Object object3;
                OMElement oMElement2 = (OMElement)oMNode;
                if (XSignature.isDsigElement(oMElement2, "KeyValue")) {
                    key = ProcessKey.createKey(oMElement2);
                } else if (XSignature.isDsigElement(oMElement2, "RetrievalMethod")) {
                    object3 = ReferenceProcessor.getTransformedOctets(signatureContext, DOMUtil.getOwnerDocument(oMElement2), oMElement2, -1);
                    object2 = CertificateFactory.getInstance("X.509");
                    byteArrayInputStream = new ByteArrayInputStream((byte[])object3);
                    object = (X509Certificate)((CertificateFactory)object2).generateCertificate(byteArrayInputStream);
                    if (key == null) {
                        key = ((Certificate)object).getPublicKey();
                    }
                } else if (XSignature.isDsigElement(oMElement2, "X509Data")) {
                    object3 = DOMUtil.getFirstChild2(oMElement2);
                    while (object3 != null) {
                        if (object3.getType() == 1 && XSignature.isDsigElement((OMElement)(object2 = (OMElement)object3)) && XSignature.isDsigElement((OMElement)object2, "X509Certificate")) {
                            ++n;
                            object = Base64.decode(DOMUtil.getStringValue((OMNode)object2));
                            byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                            if (key2 == null) {
                                key2 = x509Certificate.getPublicKey();
                            }
                        }
                        object3 = DOMUtil.getNextSibling2((OMNode)object3);
                    }
                }
            }
            oMNode = DOMUtil.getNextSibling2(oMNode);
        }
        if (n > 1) {
            key2 = null;
        }
        return key != null ? key : key2;
    }

    private static class RSA {
        private RSA() {
        }

        static void createKeyValue(OMFactory oMFactory, IndentConfig indentConfig, Key key, OMElement oMElement) {
            DOMUtil.addIndent(oMElement, indentConfig, 3);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            OMElement oMElement2 = oMFactory.createOMElement("RSAKeyValue", "http://www.w3.org/2000/09/xmldsig#", "");
            DOMUtil.addIndent(oMElement2, indentConfig, 4);
            String string = ProcessKey.encodeBigInteger(rSAPublicKey.getModulus());
            if (indentConfig.doIndentation()) {
                string = Base64.format(string, indentConfig.getUnit() * 5, "\n", DOMUtil.getSpaces(indentConfig, 4));
            }
            oMElement2.addChild(DOMUtil.createTextElementNS(oMFactory, "http://www.w3.org/2000/09/xmldsig#", "", "Modulus", string));
            DOMUtil.addIndent(oMElement2, indentConfig, 4);
            string = ProcessKey.encodeBigInteger(rSAPublicKey.getPublicExponent());
            oMElement2.addChild(DOMUtil.createTextElementNS(oMFactory, "http://www.w3.org/2000/09/xmldsig#", "", "Exponent", string));
            DOMUtil.addIndent(oMElement2, indentConfig, 3);
            oMElement.addChild(oMElement2);
            DOMUtil.addIndent(oMElement, indentConfig, 2);
        }

        static void print(PrintStream printStream, Key key) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)key;
            printStream.println("Modulus: " + rSAPublicKey.getModulus());
            printStream.println("Exponent: " + rSAPublicKey.getPublicExponent());
            printStream.println("Modulus: " + ProcessKey.encodeBigInteger(rSAPublicKey.getModulus()));
            printStream.println("Exponent: " + ProcessKey.encodeBigInteger(rSAPublicKey.getPublicExponent()));
        }
    }
}

