/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceProcessor;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ReferenceValidity;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.Validity;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ValidityDOM;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignature;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

class ManifestProcessor {
    private ManifestProcessor() {
    }

    static OMElement digest(SignatureContext signatureContext) throws SignatureStructureException, TransformException, IOException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException {
        int n = 0;
        OMElement oMElement = DOMUtil.getFirstChildElement(signatureContext.getOwnerElement());
        while (oMElement != null) {
            if (!XSignature.isDsigElement(oMElement, "Reference")) {
                throw new SignatureStructureException("A Reference element is expected: " + oMElement.getQName());
            }
            ReferenceProcessor.substDigest(signatureContext, oMElement, n++);
            oMElement = DOMUtil.getNextElement(oMElement);
        }
        return signatureContext.getOwnerElement();
    }

    static Validity verify(SignatureContext signatureContext) {
        ValidityDOM validityDOM = new ValidityDOM();
        int n = 0;
        try {
            block6: for (OMNode oMNode = signatureContext.getOwnerElement().getFirstOMChild(); oMNode != null; oMNode = oMNode.getNextOMSibling()) {
                switch (oMNode.getType()) {
                    case 3: 
                    case 4: 
                    case 5: {
                        continue block6;
                    }
                    case 1: {
                        OMElement oMElement = (OMElement)oMNode;
                        if (XSignature.isDsigElement(oMElement, "Reference")) {
                            ReferenceValidity referenceValidity = ReferenceProcessor.verify(signatureContext, oMElement, n++);
                            validityDOM.addReferenceValidity(referenceValidity);
                            continue block6;
                        }
                    }
                    default: {
                        throw new SignatureStructureException("Invalid node in the Manifest element:" + ((OMElement)oMNode).getQName());
                    }
                }
            }
        }
        catch (SignatureStructureException signatureStructureException) {
            validityDOM.setSignedInfoMessage(signatureStructureException.getMessage());
        }
        validityDOM.setSignedInfoValidity(true);
        validityDOM.setSignedInfoMessage("N/A");
        validityDOM.setCoreValidity();
        return validityDOM;
    }
}

