/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.dsig;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfoGenerator;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.ProcessKey;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.SignatureStructureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignature;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.XSignatureException;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Vector;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;

public class KeyInfo
implements KeyInfoGenerator {
    public static final String DSAKEYVALUE = "http://www.w3.org/2000/09/xmldsig#DSAKeyValue";
    public static final String RSAKEYVALUE = "http://www.w3.org/2000/09/xmldsig#RSAKeyValue";
    public static final String X509DATA = "http://www.w3.org/2000/09/xmldsig#X509Data";
    public static final String PGPDATA = "http://www.w3.org/2000/09/xmldsig#PGPData";
    public static final String SPKIDATA = "http://www.w3.org/2000/09/xmldsig#SPKIData";
    public static final String MGMTDATA = "http://www.w3.org/2000/09/xmldsig#MgmtData";
    public static final String RAWX509CERT = "http://www.w3.org/2000/09/xmldsig#rawX509Certificate";
    OMElement keyInfo = null;
    String[] keyNames = null;
    Key keyValue = null;
    X509Data[] x5data = null;
    PGPData[] pgpData = null;
    SPKIData[] spkiData = null;
    String[] mgmtData = null;
    OMElement[] unknowns = null;
    OMElement[] rmethods = null;

    public static OMElement searchForKeyInfo(OMElement oMElement) {
        OMElement oMElement2 = null;
        OMNode oMNode = DOMUtil.getFirstChild2(oMElement);
        while (oMNode != null) {
            OMElement oMElement3;
            if (oMNode.getType() == 1 && XSignature.isDsigElement(oMElement3 = (OMElement)oMNode, "KeyInfo")) {
                oMElement2 = oMElement3;
                break;
            }
            oMNode = DOMUtil.getNextSibling2(oMNode);
        }
        return oMElement2;
    }

    public KeyInfo(OMElement oMElement) throws XSignatureException {
        this.keyInfo = oMElement;
        try {
            this.traverse();
        }
        catch (Exception exception) {
            throw new XSignatureException(exception);
        }
    }

    public KeyInfo() {
    }

    public OMElement getKeyInfo() {
        return this.keyInfo;
    }

    public OMElement getKeyInfoElement(OMFactory oMFactory) {
        return this.getKeyInfoElement(oMFactory, DOMUtil.DEFAULT_INDENT);
    }

    public OMElement getKeyInfoElement(OMFactory oMFactory, IndentConfig indentConfig) {
        int n;
        OMElement oMElement = oMFactory.createOMElement("KeyInfo", "http://www.w3.org/2000/09/xmldsig#", "");
        if (this.keyNames != null && this.keyNames.length > 0) {
            for (n = 0; n < this.keyNames.length; ++n) {
                DOMUtil.addIndent(oMElement, indentConfig, 2);
                oMElement.addChild(DOMUtil.createTextElementNS(oMFactory, "http://www.w3.org/2000/09/xmldsig#", "", "KeyName", this.keyNames[n]));
            }
        }
        if (this.keyValue != null) {
            DOMUtil.addIndent(oMElement, indentConfig, 2);
            oMElement.addChild(ProcessKey.createKeyValue(oMFactory, indentConfig, this.keyValue));
        }
        if (this.x5data != null && this.x5data.length > 0) {
            for (n = 0; n < this.x5data.length; ++n) {
                DOMUtil.addIndent(oMElement, indentConfig, 2);
                oMElement.addChild(this.x5data[n].createNode(oMFactory, indentConfig));
            }
        }
        if (this.pgpData != null && this.pgpData.length > 0) {
            for (n = 0; n < this.pgpData.length; ++n) {
                DOMUtil.addIndent(oMElement, indentConfig, 2);
                oMElement.addChild(this.pgpData[n].createNode(oMFactory, indentConfig));
            }
        }
        if (this.spkiData != null && this.spkiData.length > 0) {
            for (n = 0; n < this.spkiData.length; ++n) {
                DOMUtil.addIndent(oMElement, indentConfig, 2);
                oMElement.addChild(this.spkiData[n].createNode(oMFactory, indentConfig));
            }
        }
        if (this.mgmtData != null && this.mgmtData.length > 0) {
            for (n = 0; n < this.mgmtData.length; ++n) {
                DOMUtil.addIndent(oMElement, indentConfig, 2);
                oMElement.addChild(DOMUtil.createTextElementNS(oMFactory, "http://www.w3.org/2000/09/xmldsig#", "", "MgmtData", this.mgmtData[n]));
            }
        }
        if (this.unknowns != null && this.unknowns.length > 0) {
            for (n = 0; n < this.unknowns.length; ++n) {
                DOMUtil.addIndent(oMElement, indentConfig, 2);
                oMElement.addChild(this.unknowns[n]);
            }
        }
        DOMUtil.addIndent(oMElement, indentConfig, 1);
        return oMElement;
    }

    public void insertTo(OMElement oMElement) throws SignatureStructureException {
        this.insertTo(oMElement, null);
    }

    public void insertTo(OMElement oMElement, String string) throws SignatureStructureException {
        this.insertTo(oMElement, string, DOMUtil.DEFAULT_INDENT);
    }

    public void insertTo(OMElement oMElement, String string, IndentConfig indentConfig) throws SignatureStructureException {
        OMElement oMElement2 = XSignature.getFirstChild(oMElement, "SignatureValue");
        if (oMElement2 == null) {
            throw new SignatureStructureException("The Signature element has no SignatureValue element.");
        }
        OMNode oMNode = oMElement2.getNextOMSibling();
        OMFactory oMFactory = oMElement.getOMFactory();
        OMElement oMElement3 = this.getKeyInfoElement(oMFactory, indentConfig);
        if (string == null || string.length() == 0) {
            if (!oMElement.getLocalName().equals("Signature")) {
                oMElement3.declareDefaultNamespace("http://www.w3.org/2000/09/xmldsig#");
            }
        } else {
            OMNamespace oMNamespace;
            DOMUtil.replacePrefix(oMElement3, "http://www.w3.org/2000/09/xmldsig#", string);
            if (!string.equals(oMElement.getNamespace().getPrefix())) {
                oMElement3.declareNamespace("http://www.w3.org/2000/09/xmldsig#", string);
            }
            if ((oMNamespace = oMElement3.findNamespaceURI("")) != null && "http://www.w3.org/2000/09/xmldsig#".equals(oMNamespace.getName())) {
                oMElement3.declareDefaultNamespace("");
            }
        }
        DOMUtil.addIndentBefore(oMElement, oMNode, indentConfig, 1);
        if (oMNode == null) {
            oMElement.addChild(oMElement3);
        } else {
            oMNode.insertSiblingBefore(oMElement3);
        }
    }

    private void traverse() throws CertificateException, CRLException, SignatureStructureException, NoSuchAlgorithmException, InvalidKeySpecException {
        Vector<String> vector = null;
        Vector<X509Data> vector2 = null;
        Vector<OMElement> vector3 = null;
        Vector<PGPData> vector4 = null;
        Vector<SPKIData> vector5 = null;
        Vector<String> vector6 = null;
        Vector<OMElement> vector7 = null;
        OMNode oMNode = DOMUtil.getFirstChild2(this.keyInfo);
        while (oMNode != null) {
            OMElement oMElement;
            if (oMNode.getType() == 1 && XSignature.isDsigElement(oMElement = (OMElement)oMNode)) {
                if (XSignature.isDsigElement(oMElement, "KeyValue")) {
                    if (this.keyValue != null) {
                        throw new SignatureStructureException("Multiple KeyValue elements.");
                    }
                    this.keyValue = ProcessKey.createKey(oMElement);
                } else if (XSignature.isDsigElement(oMElement, "KeyName")) {
                    if (vector == null) {
                        vector = new Vector<String>();
                    }
                    vector.addElement(DOMUtil.getStringValue(oMElement));
                } else if (XSignature.isDsigElement(oMElement, "RetrievalMethod")) {
                    if (vector3 == null) {
                        vector3 = new Vector<OMElement>();
                    }
                    vector3.addElement(oMElement);
                } else if (XSignature.isDsigElement(oMElement, "X509Data")) {
                    if (vector2 == null) {
                        vector2 = new Vector<X509Data>();
                    }
                    vector2.addElement(new X509Data(oMElement));
                } else if (XSignature.isDsigElement(oMElement, "PGPData")) {
                    if (vector4 == null) {
                        vector4 = new Vector<PGPData>();
                    }
                    vector4.addElement(new PGPData(oMElement));
                } else if (XSignature.isDsigElement(oMElement, "SPKIData")) {
                    if (vector5 == null) {
                        vector5 = new Vector<SPKIData>();
                    }
                    vector5.addElement(new SPKIData(oMElement));
                } else if (XSignature.isDsigElement(oMElement, "MgmtData")) {
                    if (vector6 == null) {
                        vector6 = new Vector<String>();
                    }
                    vector6.addElement(DOMUtil.getStringValue(oMElement));
                } else {
                    if (vector7 == null) {
                        vector7 = new Vector<OMElement>();
                    }
                    vector7.addElement(oMElement);
                }
            }
            oMNode = DOMUtil.getNextSibling2(oMNode);
        }
        if (vector != null && vector.size() > 0) {
            this.keyNames = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                this.keyNames[i] = (String)vector.elementAt(i);
            }
        }
        if (vector2 != null && vector2.size() > 0) {
            this.x5data = new X509Data[vector2.size()];
            for (int i = 0; i < vector2.size(); ++i) {
                this.x5data[i] = (X509Data)vector2.elementAt(i);
            }
        }
        if (vector4 != null && vector4.size() > 0) {
            this.pgpData = new PGPData[vector4.size()];
            for (int i = 0; i < vector4.size(); ++i) {
                this.pgpData[i] = (PGPData)vector4.elementAt(i);
            }
        }
        if (vector5 != null && vector5.size() > 0) {
            this.spkiData = new SPKIData[vector5.size()];
            for (int i = 0; i < vector5.size(); ++i) {
                this.spkiData[i] = (SPKIData)vector5.elementAt(i);
            }
        }
        if (vector6 != null && vector6.size() > 0) {
            this.mgmtData = new String[vector6.size()];
            for (int i = 0; i < vector6.size(); ++i) {
                this.mgmtData[i] = (String)vector6.elementAt(i);
            }
        }
        if (vector3 != null && vector3.size() > 0) {
            this.rmethods = new OMElement[vector3.size()];
            for (int i = 0; i < vector3.size(); ++i) {
                this.rmethods[i] = (OMElement)vector3.elementAt(i);
            }
        }
        if (vector7 != null && vector7.size() > 0) {
            this.unknowns = new OMElement[vector7.size()];
            for (int i = 0; i < vector7.size(); ++i) {
                this.unknowns[i] = (OMElement)vector7.elementAt(i);
            }
        }
    }

    public OMElement[] getRetrievalMethods() {
        return this.rmethods;
    }

    public String[] getKeyNames() {
        return this.keyNames;
    }

    public void setKeyNames(String[] stringArray) {
        this.keyNames = stringArray;
    }

    public Key getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(Key key) {
        this.keyValue = key;
    }

    public X509Data[] getX509Data() {
        return this.x5data;
    }

    public void setX509Data(X509Data[] x509DataArray) {
        this.x5data = x509DataArray;
    }

    public PGPData[] getPGPData() {
        return this.pgpData;
    }

    public void setPGPData(PGPData[] pGPDataArray) {
        this.pgpData = pGPDataArray;
    }

    public SPKIData[] getSPKIData() {
        return this.spkiData;
    }

    public void setSPKIData(SPKIData[] sPKIDataArray) {
        this.spkiData = sPKIDataArray;
    }

    public String[] getMgmtData() {
        return this.mgmtData;
    }

    public void setMgmtData(String[] stringArray) {
        this.mgmtData = stringArray;
    }

    public OMElement[] getUnknownChildren() {
        return this.unknowns;
    }

    public void setUnknownChildren(OMElement[] oMElementArray) {
        this.unknowns = oMElementArray;
    }

    private static byte[] convertBoolean2Binary(boolean[] blArray) {
        int n = blArray.length >> 3;
        if ((blArray.length & 7) != 0) {
            ++n;
        }
        byte[] byArray = new byte[n];
        byte by = 0;
        for (int i = 0; i < n << 3; ++i) {
            int n2 = i & 7;
            if (i < blArray.length && blArray[i]) {
                by = (byte)(by | 1 << 7 - n2);
            }
            if (n2 != 7) continue;
            byArray[i >> 3] = by;
            by = 0;
        }
        return byArray;
    }

    public static class X509Data {
        String[] issuerNames = null;
        BigInteger[] serialNumbers = null;
        Object[] skis = null;
        String[] subjectNames = null;
        X509Certificate[] certs = null;
        X509CRL crl = null;
        private static final String OID_KEYIDENTIFIER = "2.5.29.14";

        X509Data(OMElement oMElement) throws CertificateException, CRLException, SignatureStructureException {
            Vector<Object> vector = null;
            Vector<byte[]> vector2 = null;
            Vector<String> vector3 = null;
            Vector<X509Certificate> vector4 = null;
            CertificateFactory certificateFactory = null;
            OMNode oMNode = DOMUtil.getFirstChild2(oMElement);
            while (oMNode != null) {
                OMElement oMElement2;
                if (oMNode.getType() == 1 && XSignature.isDsigElement(oMElement2 = (OMElement)oMNode)) {
                    Object object;
                    Object object2;
                    Object object3;
                    if (XSignature.isDsigElement(oMElement2, "X509Certificate")) {
                        if (vector4 == null) {
                            vector4 = new Vector<X509Certificate>();
                        }
                        if (certificateFactory == null) {
                            certificateFactory = CertificateFactory.getInstance("X.509");
                        }
                        object3 = Base64.decode(DOMUtil.getStringValue(oMElement2));
                        object2 = new ByteArrayInputStream((byte[])object3);
                        object = (X509Certificate)certificateFactory.generateCertificate((InputStream)object2);
                        vector4.addElement((X509Certificate)object);
                    } else if (XSignature.isDsigElement(oMElement2, "X509IssuerSerial")) {
                        if (vector == null) {
                            vector = new Vector<Object>();
                        }
                        if ((object3 = (Object)DOMUtil.getFirstChildElement(oMElement2)) != null && XSignature.isDsigElement((OMElement)object3, "X509IssuerName")) {
                            object2 = X509Data.decodeDName(DOMUtil.getStringValue((OMNode)object3));
                            object = DOMUtil.getNextElement((OMNode)object3);
                            if (object != null && XSignature.isDsigElement((OMElement)object, "X509SerialNumber")) {
                                BigInteger bigInteger = new BigInteger(DOMUtil.getStringValue((OMNode)object));
                                vector.addElement(object2);
                                vector.addElement(bigInteger);
                            }
                        }
                    } else if (XSignature.isDsigElement(oMElement2, "X509SKI")) {
                        if (vector2 == null) {
                            vector2 = new Vector<byte[]>();
                        }
                        vector2.addElement(Base64.decode(DOMUtil.getStringValue(oMElement2)));
                    } else if (XSignature.isDsigElement(oMElement2, "X509SubjectName")) {
                        if (vector3 == null) {
                            vector3 = new Vector<String>();
                        }
                        vector3.addElement(X509Data.decodeDName(DOMUtil.getStringValue(oMElement2)));
                    } else if (XSignature.isDsigElement(oMElement2, "X509CRL")) {
                        if (certificateFactory == null) {
                            certificateFactory = CertificateFactory.getInstance("X.509");
                        }
                        object3 = Base64.decode(DOMUtil.getStringValue(oMElement2));
                        object2 = new ByteArrayInputStream((byte[])object3);
                        this.crl = (X509CRL)certificateFactory.generateCRL((InputStream)object2);
                    }
                }
                oMNode = DOMUtil.getNextSibling2(oMNode);
            }
            if (vector != null && vector.size() > 0) {
                int n = vector.size() / 2;
                this.issuerNames = new String[n];
                this.serialNumbers = new BigInteger[n];
                for (int i = 0; i < n; ++i) {
                    this.issuerNames[i] = (String)vector.elementAt(i * 2);
                    this.serialNumbers[i] = (BigInteger)vector.elementAt(i * 2 + 1);
                }
            }
            if (vector2 != null && vector2.size() > 0) {
                this.skis = new Object[vector2.size()];
                for (int i = 0; i < vector2.size(); ++i) {
                    this.skis[i] = vector2.elementAt(i);
                }
            }
            if (vector3 != null && vector3.size() > 0) {
                this.subjectNames = new String[vector3.size()];
                for (int i = 0; i < vector3.size(); ++i) {
                    this.subjectNames[i] = (String)vector3.elementAt(i);
                }
            }
            if (vector4 != null && vector4.size() > 0) {
                this.certs = new X509Certificate[vector4.size()];
                for (int i = 0; i < vector4.size(); ++i) {
                    this.certs[i] = (X509Certificate)vector4.elementAt(i);
                }
            }
        }

        public X509Data() {
        }

        public String[] getIssuerNames() {
            return this.issuerNames;
        }

        public void setIssuerNames(String[] stringArray) {
            if (this.issuerNames == null) {
                this.serialNumbers = new BigInteger[stringArray.length];
                Arrays.fill(this.serialNumbers, BigInteger.ZERO);
                this.issuerNames = stringArray;
            }
        }

        public BigInteger[] getSerialNumbers() {
            return this.serialNumbers;
        }

        public String[] getSubjectNames() {
            return this.subjectNames;
        }

        public Object[] getSKIs() {
            return this.skis;
        }

        public X509Certificate[] getCertificates() {
            return this.certs;
        }

        public void setCertificates(X509Certificate[] x509CertificateArray) {
            this.certs = x509CertificateArray;
        }

        public void setCertificate(X509Certificate x509Certificate) {
            this.certs = new X509Certificate[1];
            this.certs[0] = x509Certificate;
        }

        public X509CRL getCRL() {
            return this.crl;
        }

        public void setCRL(X509CRL x509CRL) {
            this.crl = x509CRL;
        }

        public void setParameters(X509Certificate x509Certificate, boolean bl, boolean bl2, boolean bl3) {
            byte[] byArray;
            this.crl = null;
            this.issuerNames = null;
            this.serialNumbers = null;
            if (bl) {
                this.issuerNames = new String[1];
                this.serialNumbers = new BigInteger[1];
                this.issuerNames[0] = x509Certificate.getIssuerDN().getName();
                this.serialNumbers[0] = x509Certificate.getSerialNumber();
            }
            this.skis = null;
            if (bl2 && (byArray = x509Certificate.getExtensionValue(OID_KEYIDENTIFIER)) != null) {
                byte[] byArray2 = new byte[byArray.length - 4];
                System.arraycopy(byArray, 4, byArray2, 0, byArray.length - 4);
                this.skis = new Object[1];
                this.skis[0] = byArray2;
            }
            this.subjectNames = null;
            if (bl3) {
                this.subjectNames = new String[1];
                this.subjectNames[0] = x509Certificate.getSubjectDN().getName();
            }
        }

        public OMElement createNode(OMFactory oMFactory) {
            return this.createNode(oMFactory, null);
        }

        public OMElement createNode(OMFactory oMFactory, IndentConfig indentConfig) {
            Object object;
            Object object2;
            int n;
            OMElement oMElement = oMFactory.createOMElement("X509Data", "http://www.w3.org/2000/09/xmldsig#", "");
            if (this.issuerNames != null && this.issuerNames.length > 0) {
                for (n = 0; n < this.issuerNames.length; ++n) {
                    object2 = oMFactory.createOMElement("X509IssuerSerial", "http://www.w3.org/2000/09/xmldsig#", "");
                    DOMUtil.addIndent((OMElement)object2, indentConfig, 4);
                    object2.addChild(DOMUtil.createTextElementNS(oMFactory, "http://www.w3.org/2000/09/xmldsig#", "", "X509IssuerName", X509Data.encodeDName(this.issuerNames[n])));
                    DOMUtil.addIndent((OMElement)object2, indentConfig, 4);
                    object = this.serialNumbers[n].toString(10);
                    object2.addChild(DOMUtil.createTextElementNS(oMFactory, "http://www.w3.org/2000/09/xmldsig#", "", "X509SerialNumber", (String)object));
                    DOMUtil.addIndent((OMElement)object2, indentConfig, 3);
                    DOMUtil.addIndent(oMElement, indentConfig, 3);
                    oMElement.addChild((OMNode)object2);
                }
            }
            if (this.skis != null && this.skis.length > 0) {
                for (n = 0; n < this.skis.length; ++n) {
                    DOMUtil.addIndent(oMElement, indentConfig, 3);
                    oMElement.addChild(DOMUtil.createTextElementNS(oMFactory, "http://www.w3.org/2000/09/xmldsig#", "", "X509SKI", Base64.encode((byte[])this.skis[n])));
                }
            }
            if (this.subjectNames != null && this.subjectNames.length > 0) {
                for (n = 0; n < this.subjectNames.length; ++n) {
                    DOMUtil.addIndent(oMElement, indentConfig, 3);
                    oMElement.addChild(DOMUtil.createTextElementNS(oMFactory, "http://www.w3.org/2000/09/xmldsig#", "", "X509SubjectName", X509Data.encodeDName(this.subjectNames[n])));
                }
            }
            if (this.certs != null && this.certs.length > 0) {
                for (n = 0; n < this.certs.length; ++n) {
                    DOMUtil.addIndent(oMElement, indentConfig, 3);
                    try {
                        object = this.certs[n].getEncoded();
                        object2 = Base64.encode(object);
                        if (indentConfig == null || indentConfig.doIndentation()) {
                            object2 = Base64.format((String)object2, 0, "\n", DOMUtil.getSpaces(indentConfig, 3));
                        }
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        object2 = "*** Internal error: java.security.cert.CertificateEncodingException: " + this.certs[n];
                    }
                    oMElement.addChild(DOMUtil.createTextElementNS(oMFactory, "http://www.w3.org/2000/09/xmldsig#", "", "X509Certificate", (String)object2));
                }
            }
            if (this.crl != null) {
                String string;
                DOMUtil.addIndent(oMElement, indentConfig, 3);
                try {
                    string = Base64.encode(this.crl.getEncoded());
                }
                catch (CRLException cRLException) {
                    string = "*** Internal error: java.security.cert.CRLException: " + this.crl;
                }
                if (indentConfig == null || indentConfig.doIndentation()) {
                    string = Base64.format(string, 0, "\n", DOMUtil.getSpaces(indentConfig, 3));
                }
                oMElement.addChild(DOMUtil.createTextElementNS(oMFactory, "http://www.w3.org/2000/09/xmldsig#", "", "X509CRL", string));
            }
            DOMUtil.addIndent(oMElement, indentConfig, 2);
            return oMElement;
        }

        private static void encodeXS(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
            int n = stringBuffer2.length();
            if (n < 1) {
                return;
            }
            if (stringBuffer2.charAt(0) == '#') {
                stringBuffer.append('\\');
            }
            for (int i = 0; i < n; ++i) {
                char c = stringBuffer2.charAt(i);
                if (",+\"\\<>;".indexOf(c) >= 0) {
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue;
                }
                if (c <= '\u001f') {
                    stringBuffer.append('\\');
                    stringBuffer.append("0123456789abcdef".charAt(c >> 4 & 0xF));
                    stringBuffer.append("0123456789abcdef".charAt(c & 0xF));
                    continue;
                }
                if (c == ' ') {
                    if (i == n - 1) {
                        stringBuffer.append("\\20");
                        continue;
                    }
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append(c);
            }
        }

        private static void encodeJ(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
            char c;
            int n;
            int n2 = stringBuffer2.length();
            if (n2 < 1) {
                return;
            }
            boolean bl = false;
            if (stringBuffer2.charAt(0) == '#' || stringBuffer2.charAt(0) == ' ' || stringBuffer2.charAt(n2 - 1) == ' ') {
                bl = true;
            } else {
                for (n = 0; n < n2; ++n) {
                    c = stringBuffer2.charAt(n);
                    if (",=+<>#;".indexOf(c) < 0) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                stringBuffer.append('\"');
            }
            for (n = 0; n < n2; ++n) {
                c = stringBuffer2.charAt(n);
                if (c == '\\' || c == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            }
            if (bl) {
                stringBuffer.append('\"');
            }
        }

        private static int decodeAttributeType(StringBuffer stringBuffer, String string, int n) {
            int n2 = string.length();
            while (n < n2 && string.charAt(n) == ' ') {
                ++n;
            }
            if (n >= n2) {
                return n;
            }
            int n3 = n;
            while (n < n2 && string.charAt(n) != '=') {
                ++n;
            }
            if (n >= n2) {
                return n;
            }
            stringBuffer.append(string.substring(n3, n));
            stringBuffer.append('=');
            return ++n;
        }

        private static int decodeAttributeValue(StringBuffer stringBuffer, String string, int n) {
            int n2 = string.length();
            if (n >= n2) {
                return n;
            }
            if (string.charAt(n) == '#') {
                // empty if block
            }
            boolean bl = false;
            if (string.charAt(n) == '\"') {
                ++n;
                bl = true;
            }
            while (n < n2) {
                char c;
                if ((c = string.charAt(n++)) == '\\') {
                    char c2;
                    if (n >= n2) {
                        stringBuffer.append(c);
                        continue;
                    }
                    if ("0123456789abcdefABCDEF".indexOf(c = string.charAt(n++)) < 0) {
                        stringBuffer.append(c);
                        continue;
                    }
                    char c3 = (char)("0123456789abcdef".indexOf(Character.toLowerCase(c)) << 4);
                    if (n >= n2) {
                        stringBuffer.append('\\');
                        stringBuffer.append(c);
                        continue;
                    }
                    if ("0123456789abcdefABCDEF".indexOf(c2 = string.charAt(n++)) < 0) {
                        stringBuffer.append('\\');
                        stringBuffer.append(c);
                        stringBuffer.append(c2);
                        continue;
                    }
                    c3 = (char)(c3 + "0123456789abcdef".indexOf(Character.toLowerCase(c2)));
                    stringBuffer.append(c3);
                    continue;
                }
                if (bl && c == '\"') break;
                if (!bl && c == ',') {
                    --n;
                    break;
                }
                stringBuffer.append(c);
            }
            return n;
        }

        public static String encodeDName(String string) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n * 2);
            StringBuffer stringBuffer2 = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n && (n2 = X509Data.decodeAttributeType(stringBuffer, string, n2)) < n) {
                stringBuffer2.setLength(0);
                n2 = X509Data.decodeAttributeValue(stringBuffer2, string, n2);
                X509Data.encodeXS(stringBuffer, stringBuffer2);
                if (n2 >= n || string.charAt(n2) != ',') continue;
                stringBuffer.append(',');
                ++n2;
            }
            return new String(stringBuffer);
        }

        public static String decodeDName(String string) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n * 2);
            StringBuffer stringBuffer2 = new StringBuffer(n);
            int n2 = 0;
            while (n2 < n && (n2 = X509Data.decodeAttributeType(stringBuffer, string, n2)) < n) {
                stringBuffer2.setLength(0);
                n2 = X509Data.decodeAttributeValue(stringBuffer2, string, n2);
                X509Data.encodeJ(stringBuffer, stringBuffer2);
                if (n2 >= n || string.charAt(n2) != ',') continue;
                stringBuffer.append(", ");
                ++n2;
            }
            return new String(stringBuffer);
        }
    }

    public static class PGPData {
        String keyId;
        byte[] keyPacket;

        PGPData(OMElement oMElement) throws SignatureStructureException {
            OMElement oMElement2 = DOMUtil.getFirstChildElement(oMElement);
            if (oMElement2 == null) {
                throw new SignatureStructureException("PGPData element has no children.");
            }
            if (XSignature.isDsigElement(oMElement2, "PGPKeyID")) {
                this.keyId = DOMUtil.getStringValue(oMElement2);
                OMElement oMElement3 = DOMUtil.getNextElement(oMElement2);
                if (oMElement3 == null || !XSignature.isDsigElement(oMElement3, "PGPKeyPacket")) {
                    throw new SignatureStructureException("The next element of PGPKeyID is not PGPKeyPacket.");
                }
                this.keyPacket = Base64.decode(DOMUtil.getStringValue(oMElement3));
            }
        }

        public PGPData(String string, byte[] byArray) {
            this.keyId = string;
            this.keyPacket = byArray;
        }

        public String getKeyID() {
            return this.keyId;
        }

        public void setKeyID(String string) {
            this.keyId = string;
        }

        public byte[] getKeyPacket() {
            return this.keyPacket;
        }

        public void setKeyPacket(byte[] byArray) {
            this.keyPacket = byArray;
        }

        public OMElement createNode(OMFactory oMFactory) {
            return this.createNode(oMFactory, null);
        }

        public OMElement createNode(OMFactory oMFactory, IndentConfig indentConfig) {
            OMElement oMElement = oMFactory.createOMElement("PGPData", "http://www.w3.org/2000/09/xmldsig#", "");
            OMElement oMElement2 = oMFactory.createOMElement("PGPKeyID", "http://www.w3.org/2000/09/xmldsig#", "");
            OMElement oMElement3 = oMFactory.createOMElement("PGPKeyPacket", "http://www.w3.org/2000/09/xmldsig#", "");
            DOMUtil.appendText(oMElement2, this.keyId);
            DOMUtil.appendText(oMElement3, Base64.encode(this.keyPacket));
            DOMUtil.addIndent(oMElement, indentConfig, 3);
            oMElement.addChild(oMElement2);
            DOMUtil.addIndent(oMElement, indentConfig, 3);
            oMElement.addChild(oMElement3);
            DOMUtil.addIndent(oMElement, indentConfig, 2);
            return oMElement;
        }
    }

    public static class SPKIData {
        Object[] exps = null;
        OMElement[] unknowns = null;

        public SPKIData() {
        }

        SPKIData(OMElement oMElement) {
            int n;
            Vector<byte[]> vector = null;
            Vector<OMElement> vector2 = null;
            OMElement oMElement2 = DOMUtil.getFirstChildElement(oMElement);
            while (oMElement2 != null) {
                if (XSignature.isDsigElement(oMElement2, "SPKISexp")) {
                    if (vector == null) {
                        vector = new Vector<byte[]>();
                    }
                    vector.addElement(Base64.decode(DOMUtil.getStringValue(oMElement2)));
                } else {
                    if (vector2 == null) {
                        vector2 = new Vector<OMElement>();
                    }
                    vector2.addElement(oMElement2);
                }
                oMElement2 = DOMUtil.getNextElement(oMElement2);
            }
            if (vector != null && vector.size() > 0) {
                this.exps = new Object[vector.size()];
                for (n = 0; n < vector.size(); ++n) {
                    this.exps[n] = vector.elementAt(n);
                }
            }
            if (vector2 != null && vector2.size() > 0) {
                this.unknowns = new OMElement[vector2.size()];
                for (n = 0; n < vector2.size(); ++n) {
                    this.unknowns[n] = (OMElement)vector2.elementAt(n);
                }
            }
        }

        public Object[] getSexps() {
            return this.exps;
        }

        public void setSexps(Object[] objectArray) {
            this.exps = objectArray;
        }

        public OMElement[] getUnknownChildren() {
            return this.unknowns;
        }

        public void setUnknownChildren(OMElement[] oMElementArray) {
            this.unknowns = oMElementArray;
        }

        public OMElement createNode(OMFactory oMFactory) {
            return this.createNode(oMFactory, null);
        }

        public OMElement createNode(OMFactory oMFactory, IndentConfig indentConfig) {
            int n;
            OMElement oMElement = oMFactory.createOMElement("SPKIData", "http://www.w3.org/2000/09/xmldsig#", "");
            if (this.exps != null && this.exps.length > 0) {
                for (n = 0; n < this.exps.length; ++n) {
                    DOMUtil.addIndent(oMElement, indentConfig, 3);
                    oMElement.addChild(DOMUtil.createTextElementNS(oMFactory, "http://www.w3.org/2000/09/xmldsig#", "", "SPKISexp", Base64.encode((byte[])this.exps[n])));
                }
            }
            if (this.unknowns != null && this.unknowns.length > 0) {
                for (n = 0; n < this.unknowns.length; ++n) {
                    DOMUtil.addIndent(oMElement, indentConfig, 3);
                    oMElement.addChild(this.unknowns[n]);
                }
            }
            DOMUtil.addIndent(oMElement, indentConfig, 2);
            return oMElement;
        }
    }
}

