/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.domutil;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.C14nUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMAttributeWithOwner;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceProxy;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;

public class XPathCanonicalizer {
    static final boolean DEBUG = false;
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";

    public static byte[] serializeAll(OMDocument oMDocument, boolean bl) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            OMElement oMElement = oMDocument.getOMDocumentElement();
            XPathCanonicalizer.serializeNode(null, oMElement, null, bl, false, outputStreamWriter);
            ((Writer)outputStreamWriter).close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Internal Error: " + iOException);
        }
    }

    public static void serializeAll(OMDocument oMDocument, boolean bl, Writer writer) throws IOException {
        OMElement oMElement = oMDocument.getOMDocumentElement();
        XPathCanonicalizer.serializeNode(null, oMElement, null, bl, false, writer);
    }

    public static byte[] serializeSubset(OMNode oMNode, boolean bl) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            XPathCanonicalizer.serializeNode(oMNode, oMNode, null, bl, true, outputStreamWriter);
            ((Writer)outputStreamWriter).close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Internal Error: " + iOException);
        }
    }

    public static void serializeSubset(OMNode oMNode, boolean bl, Writer writer) throws IOException {
        XPathCanonicalizer.serializeNode(oMNode, oMNode, null, bl, true, writer);
    }

    public static ArrayList toNodeset(OMNode oMNode, OMNode oMNode2, boolean bl) {
        ArrayList arrayList = new ArrayList();
        XPathCanonicalizer.toNodeset_addNode(arrayList, oMNode, oMNode2, bl);
        return arrayList;
    }

    private static void toNodeset_addNode(ArrayList arrayList, OMNode oMNode, OMNode oMNode2, boolean bl) {
        if (oMNode == oMNode2) {
            return;
        }
        switch (oMNode.getType()) {
            case 1: {
                Object object;
                Object object2;
                arrayList.add(oMNode);
                Hashtable hashtable = XPathCanonicalizer.collectNamespaceNodesInAncestors(oMNode, true);
                Object object3 = hashtable.elements();
                while (object3.hasMoreElements()) {
                    object2 = (OMNamespace)object3.nextElement();
                    if (!(object2.getPrefix() != null && object2.getPrefix().length() != 0 || object2.getName() != null && object2.getName().length() != 0)) continue;
                    arrayList.add(new OMNamespaceWithOwner(oMNode, (OMNamespace)object2));
                }
                object3 = ((OMElement)oMNode).getAllDeclaredNamespaces();
                while (object3.hasNext()) {
                    object2 = (OMNamespace)object3.next();
                    arrayList.add(new OMNamespaceWithOwner(oMNode, (OMNamespace)object2));
                }
                object2 = ((OMElement)oMNode).getAllAttributes();
                while (object2.hasNext()) {
                    object = (OMAttribute)object2.next();
                    arrayList.add(new OMAttributeWithOwner(oMNode, (OMAttribute)object));
                }
                for (object = ((OMContainer)((Object)oMNode)).getFirstOMChild(); object != null; object = object.getNextOMSibling()) {
                    XPathCanonicalizer.toNodeset_addNode(arrayList, (OMNode)object, oMNode2, bl);
                }
                break;
            }
            case 9: {
                for (OMNode oMNode3 = ((OMContainer)((Object)oMNode)).getFirstOMChild(); oMNode3 != null; oMNode3 = oMNode3.getNextOMSibling()) {
                    XPathCanonicalizer.toNodeset_addNode(arrayList, oMNode3, oMNode2, bl);
                }
                break;
            }
            case 5: {
                if (!bl) break;
                arrayList.add(oMNode);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 12: {
                arrayList.add(oMNode);
                break;
            }
        }
    }

    public static byte[] serializeSubset(Iterator iterator, boolean bl) {
        ArrayList<OMNode> arrayList = new ArrayList<OMNode>();
        while (iterator.hasNext()) {
            OMNode oMNode = (OMNode)iterator.next();
            arrayList.add(oMNode);
        }
        return XPathCanonicalizer.serializeSubset(arrayList, bl);
    }

    public static void serializeSubset(Iterator iterator, boolean bl, Writer writer) throws IOException {
        ArrayList<OMNode> arrayList = new ArrayList<OMNode>();
        while (iterator.hasNext()) {
            OMNode oMNode = (OMNode)iterator.next();
            arrayList.add(oMNode);
        }
        XPathCanonicalizer.serializeSubset(arrayList, bl, writer);
    }

    public static byte[] serializeSubset(ArrayList arrayList, boolean bl) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            XPathCanonicalizer.serializeSubset(arrayList, bl, (Writer)outputStreamWriter);
            ((Writer)outputStreamWriter).close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Internal Error: " + iOException);
        }
    }

    private static boolean inNodeList(OMNode oMNode, ArrayList arrayList) {
        if (oMNode == null) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i) != oMNode) continue;
            return true;
        }
        return false;
    }

    public static void serializeSubset(ArrayList arrayList, boolean bl, Writer writer) throws IOException {
        Object object;
        Vector<Object> vector = new Vector<Object>(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            Hashtable hashtable;
            Hashtable hashtable2;
            OMNode oMNode;
            object = arrayList.get(i);
            if (object instanceof OMNode) {
                Object e;
                Object e2;
                oMNode = (OMNode)object;
                vector.addElement(oMNode);
                if (oMNode.getType() != 1) continue;
                hashtable2 = null;
                hashtable = null;
                OMContainer oMContainer = oMNode.getParent();
                if (oMContainer instanceof OMNode && !XPathCanonicalizer.inNodeList((OMNode)((Object)oMContainer), arrayList)) {
                    hashtable2 = XPathCanonicalizer.collectXMLPrefixAttributesInAncestors(oMNode);
                }
                if (i + 1 < arrayList.size() && (e2 = arrayList.get(i + 1)) instanceof OMNamespace && XPathCanonicalizer.isOwnerElement(oMNode, (OMNamespace)e2)) {
                    if (hashtable == null) {
                        hashtable = new Hashtable();
                    }
                    ++i;
                    while (i < arrayList.size() && (e = arrayList.get(i)) instanceof OMNamespace && XPathCanonicalizer.isOwnerElement(oMNode, (OMNamespace)e)) {
                        hashtable.put(((OMNamespace)e).getPrefix(), e);
                        ++i;
                    }
                    if (hashtable.containsKey("") && ((OMNamespace)hashtable.get("")).getName().length() == 0) {
                        hashtable.remove("");
                    }
                    --i;
                    vector.addElement(new OMNamespaces(oMNode, hashtable));
                } else if (hashtable != null) {
                    vector.addElement(new OMNamespaces(oMNode, hashtable));
                }
                if (i + 1 < arrayList.size() && (e = arrayList.get(i + 1)) instanceof OMAttribute && XPathCanonicalizer.isOwnerElement(oMNode, (OMAttribute)e)) {
                    Object e3;
                    if (hashtable2 == null) {
                        hashtable2 = new Hashtable();
                    }
                    ++i;
                    while (i < arrayList.size() && (e3 = arrayList.get(i)) instanceof OMAttribute && XPathCanonicalizer.isOwnerElement(oMNode, (OMAttribute)e3)) {
                        hashtable2.put(((OMAttribute)e3).getQName(), e3);
                        ++i;
                    }
                    --i;
                    vector.addElement(new OMAttributes(oMNode, hashtable2));
                    continue;
                }
                if (hashtable2 == null) continue;
                vector.addElement(new OMAttributes(oMNode, hashtable2));
                continue;
            }
            if (object instanceof OMNamespaceWithOwner) {
                oMNode = ((OMNamespaceWithOwner)object).getOwnerElement();
                hashtable2 = new Hashtable();
                while (i < arrayList.size() && (hashtable = (Hashtable)arrayList.get(i)) instanceof OMNamespace && oMNode == ((OMNamespaceWithOwner)((Object)hashtable)).getOwnerElement()) {
                    hashtable2.put(((OMNamespace)((Object)hashtable)).getPrefix(), hashtable);
                    ++i;
                }
                vector.addElement(new OMNamespaces(oMNode, hashtable2));
                --i;
                continue;
            }
            if (!(object instanceof OMAttributeWithOwner)) continue;
            oMNode = ((OMAttributeWithOwner)object).getOwnerElement();
            hashtable2 = new Hashtable();
            while (i < arrayList.size() && (hashtable = (Hashtable)arrayList.get(i)) instanceof OMAttribute && oMNode == ((OMAttributeWithOwner)((Object)hashtable)).getOwnerElement()) {
                hashtable2.put(((OMAttribute)((Object)hashtable)).getQName(), hashtable);
                ++i;
            }
            vector.addElement(new OMAttributes(oMNode, hashtable2));
            --i;
        }
        Stack stack = new Stack();
        object = new Stack();
        for (int i = 0; i < vector.size(); ++i) {
            XPathCanonicalizer.serializeSubset(stack, object, vector, i, bl, writer);
        }
    }

    private static void serializeSubset(Stack stack, Stack stack2, Vector vector, int n, boolean bl, Writer writer) throws IOException {
        OMContainer oMContainer;
        String string;
        Object e = vector.elementAt(n);
        if (e == null) {
            return;
        }
        if (e instanceof OMNamespaces) {
            OMNamespaces oMNamespaces = stack.empty() ? null : (OMNamespaces)stack.peek();
            ((OMNamespaces)e).serialize(oMNamespaces, writer);
            vector.setElementAt(null, n);
            return;
        }
        if (e instanceof OMAttributes) {
            OMAttributes oMAttributes = stack2.empty() ? null : (OMAttributes)stack2.peek();
            ((OMAttributes)e).serialize(oMAttributes, writer);
            vector.setElementAt(null, n);
            return;
        }
        OMNode oMNode = (OMNode)e;
        int n2 = oMNode.getType();
        if (n2 != 1) {
            XPathCanonicalizer.serializeNode(null, oMNode, null, bl, true, writer);
            return;
        }
        writer.write("<");
        OMElement oMElement = (OMElement)oMNode;
        String string2 = string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getPrefix();
        if (string != null && string.length() != 0) {
            writer.write(string);
            writer.write(":");
        }
        writer.write(oMElement.getLocalName());
        OMNamespaces oMNamespaces = stack.empty() ? null : (OMNamespaces)stack.peek();
        OMNamespaces oMNamespaces2 = null;
        int n3 = n + 1;
        if (n3 >= vector.size() || vector.elementAt(n3) instanceof OMNode) {
            oMContainer = oMNode.getParent();
            if (!(oMContainer instanceof OMDocument) && oMNamespaces != null && oMNamespaces.contains("")) {
                writer.write(" xmlns=\"\"");
            }
        } else if (vector.elementAt(n3) instanceof OMNamespaces) {
            oMNamespaces2 = (OMNamespaces)vector.elementAt(n3);
            if (!oMNamespaces2.contains("") && !((oMContainer = oMNode.getParent()) instanceof OMDocument) && oMNamespaces != null && oMNamespaces.contains("")) {
                writer.write(" xmlns=\"\"");
            }
            oMNamespaces2.serialize(oMNamespaces, writer);
            vector.setElementAt(null, n3);
            ++n3;
        }
        oMContainer = stack2.empty() ? null : (OMAttributes)stack2.peek();
        OMAttributes oMAttributes = null;
        if (n3 < vector.size() && vector.elementAt(n3) instanceof OMAttributes) {
            oMAttributes = (OMAttributes)vector.elementAt(n3);
            oMAttributes.serialize((OMAttributes)((Object)oMContainer), writer);
            vector.setElementAt(null, n3);
        }
        writer.write(">");
        stack.push(oMNamespaces2);
        stack2.push(oMAttributes);
        while (n3 < vector.size()) {
            if (vector.elementAt(n3) == null) {
                ++n3;
                continue;
            }
            if (!XPathCanonicalizer.isAncestor(vector.elementAt(n3), oMNode)) break;
            XPathCanonicalizer.serializeSubset(stack, stack2, vector, n3, bl, writer);
            vector.setElementAt(null, n3++);
        }
        stack.pop();
        stack2.pop();
        writer.write("</");
        if (string != null && string.length() != 0) {
            writer.write(string);
            writer.write(":");
        }
        writer.write(oMElement.getLocalName());
        writer.write(">");
    }

    static boolean isAncestor(Object object, OMNode oMNode) {
        OMNode oMNode2 = object instanceof OMAttributes ? ((OMAttributes)object).parent : (object instanceof OMNamespaces ? ((OMNamespaces)object).parent : (OMNode)object);
        while (oMNode2 != oMNode) {
            OMContainer oMContainer = oMNode2.getParent();
            if (oMContainer instanceof OMDocument || oMContainer == null) {
                return false;
            }
            oMNode2 = (OMNode)((Object)oMContainer);
        }
        return true;
    }

    static boolean isOwnerElement(OMNode oMNode, OMAttribute oMAttribute) {
        if (!(oMNode instanceof OMElement)) {
            return false;
        }
        if (oMAttribute instanceof OMAttributeWithOwner && ((OMAttributeWithOwner)oMAttribute).getOwnerElement() == oMNode) {
            return true;
        }
        OMElement oMElement = (OMElement)oMNode;
        Iterator iterator = oMElement.getAllAttributes();
        while (iterator.hasNext()) {
            if (!oMAttribute.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    static boolean isOwnerElement(OMNode oMNode, OMNamespace oMNamespace) {
        if (!(oMNode instanceof OMElement)) {
            return false;
        }
        if (oMNamespace instanceof OMNamespaceWithOwner && ((OMNamespaceWithOwner)oMNamespace).getOwnerElement() == oMNode) {
            return true;
        }
        OMElement oMElement = (OMElement)oMNode;
        Iterator iterator = oMElement.getAllDeclaredNamespaces();
        while (iterator.hasNext()) {
            if (!oMNamespace.equals(iterator.next())) continue;
            return true;
        }
        return false;
    }

    static void serializeNode(OMNode oMNode, OMNode oMNode2, OMNode oMNode3, boolean bl, boolean bl2, Writer writer) throws IOException {
        XPathCanonicalizer.serializeNode(oMNode, null, null, oMNode2, oMNode3, bl, bl2, writer);
    }

    private static void serializeNode(OMNode oMNode, Stack stack, Stack stack2, OMNode oMNode2, OMNode oMNode3, boolean bl, boolean bl2, Writer writer) throws IOException {
        if (oMNode3 == oMNode2) {
            return;
        }
        switch (oMNode2.getType()) {
            case 1: {
                String string;
                OMElement oMElement = (OMElement)oMNode2;
                if (stack == null) {
                    stack = new Stack();
                }
                if (stack2 == null) {
                    stack2 = new Stack();
                }
                writer.write("<");
                String string2 = string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getPrefix();
                if (string != null && string.length() != 0) {
                    writer.write(string);
                    writer.write(":");
                }
                writer.write(oMElement.getLocalName());
                XPathCanonicalizer.serializeNamespaces(oMNode, stack, oMElement, writer);
                XPathCanonicalizer.serializeAttributes(oMNode, stack2, oMElement, bl2, writer);
                writer.write(">");
                for (OMNode oMNode4 = oMElement.getFirstOMChild(); oMNode4 != null; oMNode4 = oMNode4.getNextOMSibling()) {
                    XPathCanonicalizer.serializeNode(oMNode, stack, stack2, oMNode4, oMNode3, bl, bl2, writer);
                }
                stack.pop();
                stack2.pop();
                writer.write("</");
                if (string != null && string.length() != 0) {
                    writer.write(string);
                    writer.write(":");
                }
                writer.write(oMElement.getLocalName());
                writer.write(">");
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                C14nUtil.serializeText(((OMText)oMNode2).getText(), writer);
                break;
            }
            case 9: {
                for (OMNode oMNode5 = ((OMContainer)((Object)oMNode2)).getFirstOMChild(); oMNode5 != null; oMNode5 = oMNode5.getNextOMSibling()) {
                    XPathCanonicalizer.serializeNode(oMNode, stack, stack2, oMNode5, oMNode3, bl, bl2, writer);
                }
                break;
            }
            case 3: {
                C14nUtil.serializePI(oMNode2, writer);
                break;
            }
            case 5: {
                if (!bl) break;
                C14nUtil.serializeComment(oMNode2, writer);
                break;
            }
        }
    }

    private static boolean isTopElement(OMNode oMNode, OMElement oMElement) {
        if (oMNode == oMElement) {
            return true;
        }
        OMContainer oMContainer = oMElement.getParent();
        if (oMContainer != null) {
            if (oMContainer instanceof OMElement) {
                return false;
            }
            if (oMContainer instanceof OMDocument) {
                return true;
            }
            throw new RuntimeException("Internal Error: Unexpected node type: " + ((OMNode)((Object)oMContainer)).getType());
        }
        return true;
    }

    private static void serializeAttributes(OMNode oMNode, Stack stack, OMElement oMElement, boolean bl, Writer writer) throws IOException {
        String[] stringArray;
        Object object;
        Hashtable<QName, Object> hashtable = new Hashtable<QName, Object>();
        Iterator iterator = oMElement.getAllAttributes();
        while (iterator.hasNext()) {
            object = (OMAttribute)iterator.next();
            hashtable.put(object.getQName(), object);
        }
        if (bl && (object = XPathCanonicalizer.collectXMLPrefixAttributesInAncestors(oMElement)) != null) {
            Enumeration enumeration = ((Hashtable)object).elements();
            while (enumeration.hasMoreElements()) {
                stringArray = (String[])enumeration.nextElement();
                hashtable.put(stringArray.getQName(), stringArray);
            }
        }
        object = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(hashtable);
        int n = hashtable.size();
        stringArray = new String[n];
        int[] nArray = new int[n];
        OMAttribute[] oMAttributeArray = new OMAttribute[n];
        int n2 = 0;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            OMAttribute oMAttribute = (OMAttribute)enumeration.nextElement();
            nArray[n2] = n2;
            oMAttributeArray[n2] = oMAttribute;
            stringArray[n2] = XPathCanonicalizer.createSortedString(oMAttribute);
            ++n2;
        }
        C14nUtil.heapSort(nArray, stringArray, n);
        for (int i = 0; i < n; ++i) {
            OMAttribute oMAttribute;
            OMAttribute oMAttribute2 = oMAttributeArray[nArray[i]];
            QName qName = oMAttribute2.getQName();
            boolean bl2 = false;
            if (qName.getPrefix() != null && qName.getPrefix().equals("xml") && object != null && (oMAttribute = (OMAttribute)((Hashtable)object).get(qName)) != null && oMAttribute.getAttributeValue() != null && oMAttribute.getAttributeValue().equals(oMAttribute2.getAttributeValue())) continue;
            C14nUtil.serializeAttribute(oMAttribute2, writer, bl2);
        }
    }

    private static void serializeNamespaces(OMNode oMNode, Stack stack, OMElement oMElement, Writer writer) throws IOException {
        OMNamespace oMNamespace;
        Hashtable hashtable = XPathCanonicalizer.collectNamespaceNodesInAncestors(oMElement, false);
        Iterator iterator = oMElement.getAllDeclaredNamespaces();
        while (iterator.hasNext()) {
            oMNamespace = (OMNamespace)iterator.next();
            hashtable.put(oMNamespace.getPrefix(), oMNamespace);
        }
        oMNamespace = stack.isEmpty() ? null : (Hashtable)stack.peek();
        stack.push(hashtable);
        int n = hashtable.size();
        String[] stringArray = new String[n];
        int[] nArray = new int[n];
        OMNamespace[] oMNamespaceArray = new OMNamespace[n];
        int n2 = 0;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            OMNamespace oMNamespace2 = (OMNamespace)enumeration.nextElement();
            nArray[n2] = n2;
            oMNamespaceArray[n2] = oMNamespace2;
            stringArray[n2] = XPathCanonicalizer.createSortedString(oMNamespace2);
            ++n2;
        }
        C14nUtil.heapSort(nArray, stringArray, n);
        for (int i = 0; i < n; ++i) {
            OMNamespace oMNamespace3;
            OMNamespace oMNamespace4 = oMNamespaceArray[nArray[i]];
            String string = oMNamespace4.getPrefix();
            boolean bl = false;
            if (string.equals("xml")) continue;
            if (!(string != null && string.length() != 0 || oMNamespace4.getName() != null && oMNamespace4.getName().length() != 0)) {
                if (XPathCanonicalizer.isTopElement(oMNode, oMElement)) continue;
                boolean bl2 = false;
                for (int j = stack.size() - 1; j >= 0; --j) {
                    Hashtable hashtable2 = (Hashtable)stack.elementAt(j);
                    OMNamespace oMNamespace5 = (OMNamespace)hashtable2.get("");
                    if (oMNamespace5 == null || oMNamespace5.getName() == null || oMNamespace5.getName().length() <= 0) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) continue;
            }
            bl = true;
            if (oMNamespace != null && (oMNamespace3 = (OMNamespace)((Hashtable)((Object)oMNamespace)).get(string)) != null && oMNamespace3.getName() != null && oMNamespace3.getName().equals(oMNamespace4.getName())) continue;
            C14nUtil.serializeNamespace(oMNamespace4, writer, bl);
        }
    }

    public static Hashtable collectNamespaceNodesInAncestors(OMNode oMNode, boolean bl) {
        Object object;
        OMNode oMNode2 = oMNode;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        OMFactory oMFactory = oMNode.getOMFactory();
        if (oMNode2.getType() == 1 && ((OMElement)oMNode2).findNamespaceURI("xml") == null) {
            if (bl) {
                hashtable.put("xml", new OMNamespaceProxy(oMNode, oMFactory, XML_NAMESPACE, "xml"));
            } else {
                object = oMFactory.createOMNamespace(XML_NAMESPACE, "xml");
                hashtable.put("xml", object);
            }
        }
        if (oMNode2.getType() != 1) {
            object = oMNode2.getParent();
            oMNode2 = object instanceof OMDocument ? null : (OMElement)object;
        }
        while (oMNode2 != null) {
            Object object2;
            object = ((OMElement)oMNode2).getAllDeclaredNamespaces();
            if (object != null) {
                while (object.hasNext()) {
                    OMNamespace oMNamespace;
                    object2 = (OMNamespace)object.next();
                    String string = object2.getPrefix();
                    if (hashtable.containsKey(string)) continue;
                    if (oMNode2 == oMNode) {
                        hashtable.put(string, object2);
                        continue;
                    }
                    if (bl) {
                        oMNamespace = new OMNamespaceProxy(oMNode, oMFactory, object2.getName(), string);
                        hashtable.put(string, oMNamespace);
                        continue;
                    }
                    oMNamespace = oMFactory.createOMNamespace(object2.getName(), string);
                    hashtable.put(string, oMNamespace);
                }
            }
            if ((object2 = oMNode2.getParent()) instanceof OMDocument) {
                oMNode2 = null;
                continue;
            }
            oMNode2 = (OMElement)object2;
        }
        return hashtable;
    }

    public static void copyNamespaceNodesInAncestors(OMElement oMElement) {
        OMElement oMElement2 = oMElement;
        OMContainer oMContainer = oMElement2.getParent();
        while (oMContainer instanceof OMElement) {
            oMElement2 = (OMElement)oMContainer;
            Iterator iterator = oMElement2.getAllDeclaredNamespaces();
            if (iterator == null) continue;
            while (iterator.hasNext()) {
                OMNamespace oMNamespace = (OMNamespace)iterator.next();
                oMElement.declareNamespace(oMNamespace);
            }
        }
    }

    public static void copyNamespaceNodesInAncestorsRecursively(OMNode oMNode) {
        if (oMNode.getType() != 1) {
            return;
        }
        XPathCanonicalizer.copyNamespaceNodesInAncestors((OMElement)oMNode);
        for (OMNode oMNode2 = ((OMElement)oMNode).getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
            switch (oMNode2.getType()) {
                case 1: 
                case 9: {
                    XPathCanonicalizer.copyNamespaceNodesInAncestorsRecursively(oMNode2);
                }
            }
        }
    }

    public static Hashtable collectXMLPrefixAttributesInAncestors(OMNode oMNode) {
        Object object;
        Object object2;
        Hashtable<QName, Object> hashtable = null;
        Object object3 = oMNode.getParent();
        while (object3 instanceof OMElement) {
            object2 = ((OMElement)object3).getAllAttributes();
            if (object2 != null) {
                while (object2.hasNext()) {
                    object = (OMAttribute)object2.next();
                    QName qName = object.getQName();
                    if (!"xml".equals(qName.getPrefix()) || hashtable != null && hashtable.containsKey(qName)) continue;
                    if (hashtable == null) {
                        hashtable = new Hashtable<QName, Object>();
                    }
                    hashtable.put(qName, object);
                }
            }
            object3 = ((OMElement)object3).getParent();
        }
        if (hashtable != null && (object3 = ((OMElement)oMNode).getAllAttributes()) != null) {
            while (object3.hasNext()) {
                object2 = (OMAttribute)object3.next();
                object = object2.getQName();
                if (!"xml".equals(((QName)object).getPrefix()) || !hashtable.containsKey(object)) continue;
                hashtable.remove(object);
            }
        }
        return hashtable;
    }

    private static String createSortedString(OMAttribute oMAttribute) {
        String string = oMAttribute.getLocalName();
        String string2 = oMAttribute.getNamespace() == null ? null : oMAttribute.getNamespace().getName();
        String string3 = string2 == null || string2.length() == 0 ? "\u0001" + string : string2 + "\u0001" + string;
        return string3;
    }

    private static String createSortedString(OMNamespace oMNamespace) {
        String string = oMNamespace.getPrefix();
        if (string == null || string.length() == 0) {
            return "\u0000";
        }
        return "\u0000" + string;
    }

    static class OMNamespaces {
        OMNode parent;
        Hashtable namespaces;
        Hashtable rendered;

        OMNamespaces(OMNode oMNode, Hashtable hashtable) {
            this.parent = oMNode;
            this.namespaces = hashtable;
            if (this.namespaces == null) {
                this.namespaces = new Hashtable();
            }
            this.rendered = null;
        }

        boolean contains(String string) {
            return this.namespaces.containsKey(string);
        }

        private boolean rendered(String string) {
            if (this.rendered == null) {
                return false;
            }
            return this.rendered.containsKey(string);
        }

        private void setRendered(String string, OMNamespace oMNamespace) {
            if (this.rendered == null) {
                this.rendered = new Hashtable();
            }
            this.rendered.put(string, oMNamespace);
        }

        void serialize(OMNamespaces oMNamespaces, Writer writer) throws IOException {
            OMNamespace oMNamespace;
            int n;
            int n2 = this.namespaces.size();
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            OMNamespace[] oMNamespaceArray = new OMNamespace[n2];
            Enumeration enumeration = this.namespaces.elements();
            for (n = 0; n < n2; ++n) {
                oMNamespace = (OMNamespace)enumeration.nextElement();
                nArray[n] = n;
                oMNamespaceArray[n] = oMNamespace;
                stringArray[n] = XPathCanonicalizer.createSortedString(oMNamespace);
            }
            C14nUtil.heapSort(nArray, stringArray, n2);
            for (n = 0; n < n2; ++n) {
                oMNamespace = oMNamespaceArray[nArray[n]];
                String string = oMNamespace.getPrefix();
                boolean bl = false;
                if (string.equals("xml")) continue;
                bl = true;
                if (oMNamespaces != null && oMNamespaces.contains(string) && oMNamespaces.get(string).getName().equals(oMNamespace.getName())) continue;
                C14nUtil.serializeNamespace(oMNamespace, writer, bl);
            }
        }

        Enumeration enumeration() {
            return this.namespaces.elements();
        }

        OMNamespace get(String string) {
            return (OMNamespace)this.namespaces.get(string);
        }

        private void remove(String string) {
            Object v = this.namespaces.remove(string);
            if (v == null) {
                // empty if block
            }
        }

        private boolean usePrefix(String string) {
            if (string.length() == 0) {
                return false;
            }
            Enumeration enumeration = this.enumeration();
            while (enumeration.hasMoreElements()) {
                OMNamespace oMNamespace = (OMNamespace)enumeration.nextElement();
                String string2 = oMNamespace.getPrefix();
                if (string2 == null || !string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        private static boolean renderedInAncestors(Stack stack, String string, String string2) {
            if (stack == null || stack.isEmpty()) {
                return false;
            }
            for (int i = stack.size() - 1; i >= 0; --i) {
                OMNamespaces oMNamespaces = (OMNamespaces)stack.elementAt(i);
                if (!oMNamespaces.rendered(string) || !oMNamespaces.get(string).getName().equals(string2)) continue;
                return true;
            }
            return false;
        }

        private boolean utilizedInNearest(Stack stack, OMNamespace oMNamespace) {
            if (stack == null || stack.isEmpty()) {
                return false;
            }
            String string = oMNamespace.getPrefix();
            for (int i = stack.size() - 1; i >= 0; --i) {
                String string2;
                OMNamespaces oMNamespaces = (OMNamespaces)stack.elementAt(i);
                if (oMNamespaces.parent == null) continue;
                OMNamespace oMNamespace2 = ((OMElement)oMNamespaces.parent).getNamespace();
                String string3 = string2 = oMNamespace2 == null ? null : oMNamespace2.getPrefix();
                if (string2 == null) {
                    string2 = "";
                }
                if (!string.equals(string2) && !oMNamespaces.usePrefix(string)) continue;
                return oMNamespaces.contains(oMNamespace.getPrefix()) && oMNamespaces.get(oMNamespace.getPrefix()).getName().equals(oMNamespace.getName());
            }
            return false;
        }

        void serialize(Stack stack, Hashtable hashtable, String string, Writer writer) throws IOException {
            OMNamespace oMNamespace;
            int n;
            int n2 = this.namespaces.size();
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            OMNamespace[] oMNamespaceArray = new OMNamespace[n2];
            Enumeration enumeration = this.namespaces.elements();
            for (n = 0; n < n2; ++n) {
                oMNamespace = (OMNamespace)enumeration.nextElement();
                nArray[n] = n;
                oMNamespaceArray[n] = oMNamespace;
                stringArray[n] = XPathCanonicalizer.createSortedString(oMNamespace);
            }
            C14nUtil.heapSort(nArray, stringArray, n2);
            for (n = 0; n < n2; ++n) {
                oMNamespace = oMNamespaceArray[nArray[n]];
                String string2 = oMNamespace.getPrefix();
                boolean bl = false;
                if (string2.equals("xml")) continue;
                bl = true;
                if (hashtable != null && hashtable.get(string2) != null) {
                    OMNamespaces oMNamespaces = null;
                    if (stack != null && !stack.isEmpty()) {
                        oMNamespaces = (OMNamespaces)stack.elementAt(stack.size() - 1);
                    }
                    if (oMNamespaces != null && oMNamespaces.contains(string2) && oMNamespaces.get(string2).getName().equals(oMNamespace.getName())) {
                        continue;
                    }
                } else if (string == null || OMNamespaces.renderedInAncestors(stack, string2, oMNamespace.getName()) && this.utilizedInNearest(stack, oMNamespace) || string != null && !string.equals(string2) && !this.usePrefix(string2)) continue;
                this.setRendered(string2, oMNamespace);
                C14nUtil.serializeNamespace(oMNamespace, writer, bl);
            }
        }

        public String toString() {
            return "OMNamespaces[#=" + this.namespaces.size() + "]";
        }
    }

    static class OMAttributes {
        OMNode parent;
        Hashtable attributes;

        OMAttributes(OMNode oMNode, Hashtable hashtable) {
            this.parent = oMNode;
            this.attributes = hashtable;
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            }
        }

        boolean contains(QName qName) {
            return this.attributes.containsKey(qName);
        }

        void serialize(OMAttributes oMAttributes, Writer writer) throws IOException {
            OMAttribute oMAttribute;
            int n;
            int n2 = this.attributes.size();
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            OMAttribute[] oMAttributeArray = new OMAttribute[n2];
            Enumeration enumeration = this.attributes.elements();
            for (n = 0; n < n2; ++n) {
                oMAttribute = (OMAttribute)enumeration.nextElement();
                nArray[n] = n;
                oMAttributeArray[n] = oMAttribute;
                stringArray[n] = XPathCanonicalizer.createSortedString(oMAttribute);
            }
            C14nUtil.heapSort(nArray, stringArray, n2);
            for (n = 0; n < n2; ++n) {
                oMAttribute = oMAttributeArray[nArray[n]];
                String string = oMAttribute.getNamespace() == null ? null : oMAttribute.getNamespace().getPrefix();
                boolean bl = false;
                if (string == null || string.equals("xml")) {
                    // empty if block
                }
                C14nUtil.serializeAttribute(oMAttribute, writer, bl);
            }
        }

        Enumeration enumeration() {
            return this.attributes.elements();
        }

        OMAttribute get(QName qName) {
            return (OMAttribute)this.attributes.get(qName);
        }

        private void remove(QName qName) {
            Object v = this.attributes.remove(qName);
            if (v == null) {
                // empty if block
            }
        }

        private boolean usePrefix(String string) {
            if (string.length() == 0) {
                return false;
            }
            Enumeration enumeration = this.enumeration();
            while (enumeration.hasMoreElements()) {
                OMAttribute oMAttribute = (OMAttribute)enumeration.nextElement();
                String string2 = oMAttribute.getNamespace() == null ? null : oMAttribute.getNamespace().getPrefix();
                if (string2 == null || !string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        void serialize(Stack stack, Hashtable hashtable, String string, Writer writer) throws IOException {
            OMAttribute oMAttribute;
            int n;
            int n2 = this.attributes.size();
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            OMAttribute[] oMAttributeArray = new OMAttribute[n2];
            Enumeration enumeration = this.attributes.elements();
            for (n = 0; n < n2; ++n) {
                oMAttribute = (OMAttribute)enumeration.nextElement();
                nArray[n] = n;
                oMAttributeArray[n] = oMAttribute;
                stringArray[n] = XPathCanonicalizer.createSortedString(oMAttribute);
            }
            C14nUtil.heapSort(nArray, stringArray, n2);
            for (n = 0; n < n2; ++n) {
                oMAttribute = oMAttributeArray[nArray[n]];
                boolean bl = false;
                C14nUtil.serializeAttribute(oMAttribute, writer, bl);
            }
        }

        public String toString() {
            return "OMAttributes[#=" + this.attributes.size() + "]";
        }
    }
}

