/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.domutil;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.NOOPVisitor;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMDocType;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;

public class ToXMLVisitor
extends NOOPVisitor {
    protected Writer writer = null;
    protected String encoding = null;
    protected boolean isPrintNonSpecifiedAttributes = true;

    public ToXMLVisitor(Writer writer, String string) {
        this.writer = writer;
        this.encoding = string;
    }

    public ToXMLVisitor(Writer writer) {
        this(writer, null);
    }

    public void setPrintNonSpecifiedAttributes(boolean bl) {
        this.isPrintNonSpecifiedAttributes = bl;
    }

    public boolean getPrintNonSpecifiedAttributes() {
        return this.isPrintNonSpecifiedAttributes;
    }

    public void visitDocumentPre(OMDocument oMDocument) throws Exception {
        this.writer.write("<?xml version=\"1.0\"?>");
    }

    public void visitDocumentPost(OMDocument oMDocument) throws Exception {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitElementPre(OMElement oMElement) throws Exception {
        Object object;
        Iterator iterator;
        String string;
        this.writer.write("<");
        String string2 = string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getPrefix();
        if (string != null && string.length() != 0) {
            this.writer.write(string);
            this.writer.write(":");
        }
        this.writer.write(oMElement.getLocalName());
        Iterator iterator2 = iterator = oMElement.getAllDeclaredNamespaces();
        synchronized (iterator2) {
            while (iterator.hasNext()) {
                object = (OMNamespace)iterator.next();
                this.visitNamespacePre((OMNamespace)object);
            }
        }
        iterator2 = oMElement.getAllAttributes();
        object = iterator2;
        synchronized (object) {
            while (iterator2.hasNext()) {
                OMAttribute oMAttribute = (OMAttribute)iterator2.next();
                this.visitAttributePre(oMAttribute);
            }
        }
        if (oMElement.getChildren().hasNext()) {
            this.writer.write(">");
        } else {
            this.writer.write("/>");
        }
    }

    public void visitElementPost(OMElement oMElement) throws Exception {
        if (oMElement.getChildren().hasNext()) {
            String string;
            this.writer.write("</");
            String string2 = string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getPrefix();
            if (string != null && string.length() != 0) {
                this.writer.write(string);
                this.writer.write(":");
            }
            this.writer.write(oMElement.getLocalName());
            this.writer.write(">");
        }
    }

    public void visitAttributePre(OMAttribute oMAttribute) throws Exception {
        String string;
        this.writer.write(" ");
        String string2 = string = oMAttribute.getNamespace() == null ? null : oMAttribute.getNamespace().getPrefix();
        if (string != null && string.length() != 0) {
            this.writer.write(string);
            this.writer.write(":");
        }
        this.writer.write(oMAttribute.getLocalName());
        this.writer.write("=\"");
        this.writer.write(oMAttribute.getAttributeValue());
        this.writer.write("\"");
    }

    public void visitProcessingInstructionPre(OMProcessingInstruction oMProcessingInstruction) throws Exception {
        this.writer.write("<?");
        this.writer.write(oMProcessingInstruction.getTarget());
        if (oMProcessingInstruction.getValue().length() > 0) {
            this.writer.write(" ");
            this.writer.write(oMProcessingInstruction.getValue());
        }
        this.writer.write("?>");
    }

    public void visitCommentPre(OMComment oMComment) throws Exception {
        this.writer.write("<!--");
        this.writer.write(oMComment.getValue());
        this.writer.write("-->");
    }

    public void visitTextPre(OMText oMText) throws Exception {
        this.escapedWrite(this.writer, oMText.getText(), "<&", this.encoding);
    }

    public void visitDocumentTypePre(OMDocType oMDocType) throws Exception {
        this.writer.write("<!DOCTYPE ");
        this.writer.write(oMDocType.getValue());
        this.writer.write(">");
    }

    public void escapedWrite(Writer writer, String string, String string2) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                writer.write("&lt;");
                continue;
            }
            if ('>' == c) {
                writer.write("&gt;");
                continue;
            }
            if ('&' == c) {
                writer.write("&amp;");
                continue;
            }
            if ('\ud800' <= c && c < '\udc00') {
                int n;
                if (i + 1 >= string.length()) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " ?");
                }
                if (56320 > (n = string.charAt(++i)) || n >= 57344) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " " + Integer.toHexString(n));
                }
                n = (c - 55296 << 10) + n - 56320 + 65536;
                writer.write("&#x");
                writer.write(Integer.toHexString(n));
                writer.write(";");
                continue;
            }
            writer.write(c);
        }
    }

    public void escapedWrite(Writer writer, String string, String string2, String string3) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = string2.indexOf(c);
            if (n >= 0) {
                writer.write("&#");
                writer.write(Integer.toString(c));
                writer.write(";");
                continue;
            }
            if ('\ud800' <= c && c < '\udc00') {
                int n2;
                if (i + 1 >= string.length()) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " ?");
                }
                if (56320 > (n2 = string.charAt(++i)) || n2 >= 57344) {
                    throw new RuntimeException("Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " " + Integer.toHexString(n2));
                }
                n2 = (c - 55296 << 10) + n2 - 56320 + 65536;
                writer.write("&#x");
                writer.write(Integer.toHexString(n2));
                writer.write(";");
                continue;
            }
            writer.write(c);
        }
    }
}

