/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.domutil;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.C14nUtil;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.OMNamespaceWithOwner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;

public class Serializer {
    private static final int ATTR_TAB_SIZE = 64;
    private static final String[] attrTab = new String[]{null, null, null, null, null, null, null, null, null, "&#x9;", "&#xA;", null, null, "&#xD;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&quot;", null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, null, null};

    static final void serializeAttribute(OMAttribute oMAttribute, Writer writer) throws IOException {
        Serializer.serializeAttribute(oMAttribute.getNamespace() == null ? null : oMAttribute.getNamespace().getPrefix(), oMAttribute.getLocalName(), oMAttribute.getAttributeValue(), writer);
    }

    static final void serializeAttribute(String string, String string2, String string3, Writer writer) throws IOException {
        int n = string3.length();
        int n2 = -1;
        writer.write(" ");
        if (string != null && string.length() != 0) {
            writer.write(string);
            writer.write(":");
        }
        writer.write(string2);
        writer.write("=\"");
        for (int i = 0; i < n; ++i) {
            String string4;
            char c = string3.charAt(i);
            String string5 = string4 = c < '@' ? attrTab[c] : null;
            if (string4 != null) {
                if (n2 >= 0) {
                    writer.write(string3, n2, i - n2);
                    n2 = -1;
                }
                writer.write(string4);
                continue;
            }
            if (n2 >= 0) continue;
            n2 = i;
        }
        if (n2 >= 0) {
            writer.write(string3, n2, n - n2);
        }
        writer.write("\"");
    }

    static final void serializeNamespaceDeclaration(OMNamespace oMNamespace, Writer writer) throws IOException {
        if (oMNamespace instanceof OMNamespaceWithOwner) {
            return;
        }
        Serializer.serializeNamespaceDeclaration(oMNamespace.getPrefix(), oMNamespace.getName(), writer);
    }

    static final void serializeNamespaceDeclaration(String string, String string2, Writer writer) throws IOException {
        int n = string2.length();
        int n2 = -1;
        writer.write(" xmlns");
        if (string != null && string.length() != 0) {
            writer.write(":");
            writer.write(string);
        }
        writer.write("=\"");
        for (int i = 0; i < n; ++i) {
            String string3;
            char c = string2.charAt(i);
            String string4 = string3 = c < '@' ? attrTab[c] : null;
            if (string3 != null) {
                if (n2 >= 0) {
                    writer.write(string2, n2, i - n2);
                    n2 = -1;
                }
                writer.write(string3);
                continue;
            }
            if (n2 >= 0) continue;
            n2 = i;
        }
        if (n2 >= 0) {
            writer.write(string2, n2, n - n2);
        }
        writer.write("\"");
    }

    public static void serialize(OMNode oMNode, Writer writer) throws IOException {
        switch (oMNode.getType()) {
            case 1: {
                Iterator iterator;
                OMElement oMElement = (OMElement)oMNode;
                Iterator iterator2 = oMElement.getAllDeclaredNamespaces();
                String string = oMElement.getNamespace() == null ? null : oMElement.getNamespace().getPrefix();
                String string2 = oMElement.getLocalName();
                writer.write("<");
                if (string != null && string.length() != 0) {
                    writer.write(string);
                    writer.write(":");
                }
                writer.write(string2);
                if (iterator2 != null) {
                    while (iterator2.hasNext()) {
                        Serializer.serializeNamespaceDeclaration((OMNamespace)iterator2.next(), writer);
                    }
                }
                if ((iterator = oMElement.getAllAttributes()) != null) {
                    while (iterator.hasNext()) {
                        Serializer.serializeAttribute((OMAttribute)iterator.next(), writer);
                    }
                }
                writer.write(">");
                for (OMNode oMNode2 = oMElement.getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
                    Serializer.serialize(oMNode2, writer);
                }
                writer.write("</");
                if (string != null && string.length() != 0) {
                    writer.write(string);
                    writer.write(":");
                }
                writer.write(string2);
                writer.write(">");
                break;
            }
            case 9: {
                for (OMNode oMNode3 = ((OMContainer)((Object)oMNode)).getFirstOMChild(); oMNode3 != null; oMNode3 = oMNode3.getNextOMSibling()) {
                    Serializer.serialize(oMNode3, writer);
                }
                break;
            }
            case 4: 
            case 12: {
                C14nUtil.serializeText(((OMText)oMNode).getText(), writer);
                break;
            }
            case 5: {
                C14nUtil.serializeComment(oMNode, writer);
                break;
            }
        }
    }

    public static byte[] serialize(OMNode oMNode) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        Serializer.serialize(oMNode, outputStreamWriter);
        ((Writer)outputStreamWriter).close();
        return byteArrayOutputStream.toByteArray();
    }
}

