/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.domutil;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.NOOPVisitor;
import java.io.IOException;
import java.io.Writer;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMDocType;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;

public class PrintNodeTreeVisitor
extends NOOPVisitor {
    protected Writer writer = null;
    protected int indent = 0;
    protected int dx = 2;

    public PrintNodeTreeVisitor(Writer writer) {
        this.writer = writer;
    }

    public void visitElementPre(OMElement oMElement) throws Exception {
        this.indent();
        this.writer.write("[Element] " + oMElement.getQName() + "\n");
        this.indent += this.dx;
    }

    public void visitElementPost(OMElement oMElement) throws Exception {
        this.indent -= this.dx;
    }

    public void visitTextPre(OMText oMText) throws Exception {
        this.indent();
        this.writer.write("[Text] \"");
        this.printText(oMText.getText());
        this.writer.write("\"\n");
    }

    public void visitProcessingInstructionPre(OMProcessingInstruction oMProcessingInstruction) throws Exception {
        this.indent();
        this.writer.write("[ProcessingInstruction] " + oMProcessingInstruction.getTarget() + " \"");
        this.printText(oMProcessingInstruction.getValue());
        this.writer.write("\"\n");
    }

    public void visitCommentPre(OMComment oMComment) throws Exception {
        this.indent();
        this.writer.write("[Comment] \"" + oMComment.getValue() + "\"\n");
    }

    public void visitDocumentPre(OMDocument oMDocument) throws Exception {
        this.indent();
        this.writer.write("[Document]\n");
        this.indent += this.dx;
    }

    public void visitDocumentPost(OMDocument oMDocument) throws Exception {
        this.indent -= this.dx;
        this.writer.flush();
    }

    public void visitDocumentTypePre(OMDocType oMDocType) throws Exception {
        this.indent();
        this.writer.write("[DocumentType] " + oMDocType.getValue() + "\n");
    }

    public void visitUnknownPre(OMNode oMNode) throws Exception {
        this.indent();
        this.writer.write("[???Unknown]\n");
    }

    protected void indent() throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            this.writer.write(" ");
        }
    }

    protected void printText(String string) throws IOException {
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    this.writer.write("&#x0d;");
                    continue block5;
                }
                case '\n': {
                    this.writer.write("&#x0a;");
                    continue block5;
                }
                case '\"': {
                    this.writer.write("&#x22;");
                    continue block5;
                }
                default: {
                    this.writer.write(c);
                }
            }
        }
    }
}

