/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.xml.xss4j.domutil;

import com.ibm.ws.wssecurity.xml.xss4j.domutil.IndentConfig;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;

public class DOMUtil {
    public static final String S_XMLNS = "xmlns";
    public static final String S_XMLNAMESPACEURI = "http://www.w3.org/XML/1998/namespace";
    public static final String S_XMLNSATTRIBUTEURI = "http://www.w3.org/2000/xmlns/";
    private static final String[] INDENT_STRINGS = new String[]{"\n", "\n ", "\n  ", "\n   ", "\n    ", "\n     ", "\n      ", "\n       ", "\n        ", "\n         ", "\n          "};
    public static IndentConfig DEFAULT_INDENT = new IndentConfig(){

        public boolean doIndentation() {
            return false;
        }

        public int getUnit() {
            return 2;
        }
    };

    private DOMUtil() {
    }

    public static String getStringValue(OMNode oMNode) {
        switch (oMNode.getType()) {
            case 1: 
            case 9: {
                OMNode oMNode2 = ((OMElement)oMNode).getFirstOMChild();
                if (oMNode2 == null) {
                    return "";
                }
                StringBuffer stringBuffer = new StringBuffer();
                DOMUtil.getStringValue0(oMNode, stringBuffer);
                return new String(stringBuffer);
            }
            case 4: 
            case 6: 
            case 12: {
                return ((OMText)oMNode).getText();
            }
            case 3: {
                return ((OMProcessingInstruction)oMNode).getValue();
            }
            case 5: {
                return ((OMComment)oMNode).getValue();
            }
        }
        throw new RuntimeException("Internal Error: Unexpected node type: " + oMNode.getType());
    }

    private static void getStringValue0(OMNode oMNode, StringBuffer stringBuffer) {
        switch (oMNode.getType()) {
            case 1: {
                for (OMNode oMNode2 = ((OMElement)oMNode).getFirstOMChild(); oMNode2 != null; oMNode2 = oMNode2.getNextOMSibling()) {
                    DOMUtil.getStringValue0(oMNode2, stringBuffer);
                }
                break;
            }
            case 4: 
            case 12: {
                stringBuffer.append(((OMText)oMNode).getText());
                break;
            }
        }
    }

    public static final OMElement createTextElementNS(OMFactory oMFactory, String string, String string2, String string3, String string4) {
        OMElement oMElement = oMFactory.createOMElement(string3, string, string2);
        oMElement.addChild(oMFactory.createOMText(string4));
        return oMElement;
    }

    public static final void appendText(OMElement oMElement, String string) {
        oMElement.addChild(oMElement.getOMFactory().createOMText(string));
    }

    public static final void removeAllChildren(OMElement oMElement) {
        Iterator iterator = oMElement.getChildren();
        while (iterator.hasNext()) {
            OMNode oMNode = (OMNode)iterator.next();
            oMNode.detach();
        }
    }

    public static String getNamespaceForPrefix(String string, OMElement oMElement) {
        if (string.equals("xml")) {
            return S_XMLNAMESPACEURI;
        }
        if (string.equals(S_XMLNS)) {
            return S_XMLNSATTRIBUTEURI;
        }
        OMNamespace oMNamespace = oMElement.findNamespaceURI(string);
        if (oMNamespace != null) {
            return oMNamespace.getName();
        }
        return null;
    }

    public static String getNamespace(OMElement oMElement) {
        OMNamespace oMNamespace = oMElement.getNamespace();
        return oMNamespace.getName();
    }

    public static OMNode getPreviousSibling2(OMNode oMNode) {
        OMNode oMNode2 = oMNode.getPreviousOMSibling();
        if (oMNode2 == null) {
            OMContainer oMContainer = oMNode.getParent();
            if (oMContainer instanceof OMDocument) {
                return null;
            }
            if (((OMNode)((Object)oMContainer)).getType() == 9) {
                oMNode2 = DOMUtil.getPreviousSibling2((OMNode)((Object)oMContainer));
            }
        } else {
            while (oMNode2.getType() == 9) {
                Iterator iterator = ((OMContainer)((Object)oMNode2)).getChildren();
                OMNode oMNode3 = null;
                while (iterator.hasNext()) {
                    oMNode3 = (OMNode)iterator.next();
                }
                if (oMNode3 == null) {
                    oMNode2 = DOMUtil.getPreviousSibling2(oMNode2);
                    break;
                }
                oMNode2 = oMNode3;
            }
        }
        return oMNode2;
    }

    public static OMNode getNextSibling2(OMNode oMNode) {
        OMNode oMNode2 = oMNode.getNextOMSibling();
        if (oMNode2 == null) {
            OMContainer oMContainer = oMNode.getParent();
            if (oMContainer instanceof OMDocument) {
                return null;
            }
            if (((OMNode)((Object)oMContainer)).getType() == 9) {
                oMNode2 = DOMUtil.getNextSibling2((OMNode)((Object)oMContainer));
            }
        } else {
            while (oMNode2.getType() == 9) {
                OMNode oMNode3 = ((OMContainer)((Object)oMNode2)).getFirstOMChild();
                if (oMNode3 == null) {
                    oMNode2 = DOMUtil.getNextSibling2(oMNode2);
                    break;
                }
                oMNode2 = oMNode3;
            }
        }
        return oMNode2;
    }

    public static OMNode getFirstChild2(OMNode oMNode) {
        if (!(oMNode instanceof OMContainer)) {
            return null;
        }
        OMNode oMNode2 = ((OMContainer)((Object)oMNode)).getFirstOMChild();
        while (oMNode2 != null && oMNode2.getType() == 9) {
            OMNode oMNode3 = ((OMContainer)((Object)oMNode2)).getFirstOMChild();
            if (oMNode3 == null) {
                oMNode2 = DOMUtil.getNextSibling2(oMNode2);
                break;
            }
            oMNode2 = oMNode3;
        }
        return oMNode2;
    }

    public static OMNode getLastChild2(OMNode oMNode) {
        if (!(oMNode instanceof OMContainer)) {
            return null;
        }
        Iterator iterator = ((OMContainer)((Object)oMNode)).getChildren();
        OMNode oMNode2 = null;
        while (iterator.hasNext()) {
            oMNode2 = (OMNode)iterator.next();
        }
        while (oMNode2 != null && oMNode2.getType() == 9) {
            Iterator iterator2 = ((OMContainer)((Object)oMNode2)).getChildren();
            OMNode oMNode3 = null;
            while (iterator2.hasNext()) {
                oMNode3 = (OMNode)iterator2.next();
            }
            if (oMNode3 == null) {
                oMNode2 = DOMUtil.getPreviousSibling2(oMNode2);
                break;
            }
            oMNode2 = oMNode3;
        }
        return oMNode2;
    }

    public static OMElement getNextElement(OMNode oMNode) {
        OMNode oMNode2 = oMNode;
        while ((oMNode2 = DOMUtil.getNextSibling2(oMNode2)) != null && oMNode2.getType() != 1) {
        }
        return (OMElement)oMNode2;
    }

    public static OMElement getFirstChildElement(OMNode oMNode) {
        OMNode oMNode2 = DOMUtil.getFirstChild2(oMNode);
        while (oMNode2 != null && oMNode2.getType() != 1) {
            oMNode2 = DOMUtil.getNextSibling2(oMNode2);
        }
        return (OMElement)oMNode2;
    }

    public static OMElement getFirstChildElementNamed(OMNode oMNode, String string) {
        if (!(oMNode instanceof OMContainer)) {
            return null;
        }
        OMNode oMNode2 = ((OMContainer)((Object)oMNode)).getFirstOMChild();
        while (!(oMNode2 == null || oMNode2.getType() == 1 && ((OMElement)oMNode2).getLocalName().equals(string))) {
            oMNode2 = DOMUtil.getNextSibling2(oMNode2);
        }
        return (OMElement)oMNode2;
    }

    public static OMElement getFirstChildElementNamed(OMNode oMNode, String string, String string2) {
        if (!(oMNode instanceof OMContainer)) {
            return null;
        }
        OMNode oMNode2 = ((OMContainer)((Object)oMNode)).getFirstOMChild();
        while (oMNode2 != null) {
            if (oMNode2.getType() == 1) {
                OMElement oMElement = (OMElement)oMNode2;
                String string3 = DOMUtil.getNamespace(oMElement);
                if ((string2.equals("*") || oMElement.getLocalName().equals(string2)) && (string == null && string3 == null || string != null && string.equals("*") || string != null && string.equals(string3))) break;
            }
            oMNode2 = DOMUtil.getNextSibling2(oMNode2);
        }
        return (OMElement)oMNode2;
    }

    public static boolean checkAllSpaces(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c <= ' ' && 0 <= " \t\r\n".indexOf(c)) continue;
            return false;
        }
        return true;
    }

    public static void writeEscapedAttribute(Writer writer, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                writer.write("&lt;");
                continue;
            }
            if ('&' == c) {
                writer.write("&amp;");
                continue;
            }
            if ('\t' == c) {
                writer.write("&#x9;");
                continue;
            }
            if ('\n' == c) {
                writer.write("&#xA;");
                continue;
            }
            if ('\r' == c) {
                writer.write("&#xD;");
                continue;
            }
            if ('\"' == c) {
                writer.write("&quot;");
                continue;
            }
            writer.write(c);
        }
    }

    public static void writeEscapedCharData(Writer writer, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                writer.write("&lt;");
                continue;
            }
            if ('&' == c) {
                writer.write("&amp;");
                continue;
            }
            if ('>' == c) {
                writer.write("&gt;");
                continue;
            }
            if ('\r' == c) {
                writer.write("&#xD;");
                continue;
            }
            writer.write(c);
        }
    }

    public static String escapeAttribute(String string) {
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("<&\t\n\r\"".indexOf(c) >= 0) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.length() * 2);
                    stringBuffer.append(string.substring(0, i));
                }
                if ('<' == c) {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if ('&' == c) {
                    stringBuffer.append("&amp;");
                    continue;
                }
                if ('\t' == c) {
                    stringBuffer.append("&#x9;");
                    continue;
                }
                if ('\n' == c) {
                    stringBuffer.append("&#xA;");
                    continue;
                }
                if ('\r' == c) {
                    stringBuffer.append("&#xD;");
                    continue;
                }
                if ('\"' != c) continue;
                stringBuffer.append("&quot;");
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return stringBuffer == null ? string : new String(stringBuffer);
    }

    public static String escapeCharData(String string) {
        StringBuffer stringBuffer = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("<&>\r".indexOf(c) >= 0) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(string.length() * 2);
                    stringBuffer.append(string.substring(0, i));
                }
                if ('<' == c) {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if ('&' == c) {
                    stringBuffer.append("&amp;");
                    continue;
                }
                if ('>' == c) {
                    stringBuffer.append("&gt;");
                    continue;
                }
                if ('\r' != c) continue;
                stringBuffer.append("&#xD;");
                continue;
            }
            if (stringBuffer == null) continue;
            stringBuffer.append(c);
        }
        return stringBuffer == null ? string : new String(stringBuffer);
    }

    public static void replacePrefix(OMElement oMElement, String string, String string2) {
        if (string == null && (oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName()) == null || string != null && string.equals(oMElement.getNamespace() == null ? null : oMElement.getNamespace().getName())) {
            oMElement.setNamespace(oMElement.getOMFactory().createOMNamespace(string, string2));
        }
        OMNode oMNode = DOMUtil.getFirstChild2(oMElement);
        while (oMNode != null) {
            if (oMNode.getType() == 1) {
                DOMUtil.replacePrefix((OMElement)oMNode, string, string2);
            }
            oMNode = DOMUtil.getNextSibling2(oMNode);
        }
    }

    private static String getIndentText(IndentConfig indentConfig, int n) {
        String string;
        if (!indentConfig.doIndentation()) {
            return null;
        }
        int n2 = indentConfig.getUnit() * n;
        if (n2 < INDENT_STRINGS.length) {
            string = INDENT_STRINGS[n2];
        } else {
            StringBuffer stringBuffer = new StringBuffer(1 + n2);
            stringBuffer.append(INDENT_STRINGS[INDENT_STRINGS.length - 1]);
            for (int i = INDENT_STRINGS.length - 1; i < n2; ++i) {
                stringBuffer.append(' ');
            }
            string = new String(stringBuffer);
        }
        return string;
    }

    public static String getSpaces(IndentConfig indentConfig, int n) {
        if (indentConfig == null) {
            indentConfig = DEFAULT_INDENT;
        }
        int n2 = indentConfig.getUnit() * n;
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(' ');
        }
        return new String(stringBuffer);
    }

    private static OMNode getIndentNode(OMFactory oMFactory, IndentConfig indentConfig, int n) {
        return oMFactory.createOMText(DOMUtil.getIndentText(indentConfig, n));
    }

    public static void addIndent(OMElement oMElement, IndentConfig indentConfig, int n) {
        if (indentConfig == null) {
            indentConfig = DEFAULT_INDENT;
        }
        if (!indentConfig.doIndentation()) {
            return;
        }
        oMElement.addChild(DOMUtil.getIndentNode(oMElement.getOMFactory(), indentConfig, n));
    }

    public static void addIndentBefore(OMElement oMElement, OMNode oMNode, IndentConfig indentConfig, int n) {
        if (indentConfig == null) {
            indentConfig = DEFAULT_INDENT;
        }
        if (!indentConfig.doIndentation()) {
            return;
        }
        OMNode oMNode2 = DOMUtil.getIndentNode(oMElement.getOMFactory(), indentConfig, n);
        if (oMNode == null) {
            oMElement.addChild(oMNode2);
        } else {
            oMNode.insertSiblingBefore(oMNode2);
        }
    }

    public static OMDocument getOwnerDocument(OMNode oMNode) {
        while (true) {
            OMContainer oMContainer;
            if ((oMContainer = oMNode.getParent()) == null) {
                OMFactory oMFactory = oMNode.getOMFactory();
                OMDocument oMDocument = oMFactory.createOMDocument();
                oMDocument.addChild(oMNode);
                return oMDocument;
            }
            if (oMContainer instanceof OMDocument) {
                return (OMDocument)oMContainer;
            }
            oMNode = (OMNode)((Object)oMContainer);
        }
    }
}

