/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.verify.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerifyPart;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.AlgorithmParameterData;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.dec.impl.WSSDecryptionImpl;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSVerifyPartImpl
implements WSSVerifyPart {
    private static final TraceComponent tc = Tr.register(WSSDecryptionImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSVerifyPartImpl.class.getName();
    private static final long serialVersionUID = 3678122071571862249L;
    private static final Map<Integer, String> partMap = new HashMap<Integer, String>();
    private List<String> digestMethods = new ArrayList<String>();
    private List<AlgorithmParameterData> transforms = new ArrayList<AlgorithmParameterData>();
    private String dialect = Constants.DIALECT_WAS;
    private String keyword;

    @Override
    public void addAllowedDigestMethod(String string) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getDigestAlgorithms().contains(string)) {
            String string2 = "security.wssecurity.PrivateConsumerConfig.s11";
            WSSException wSSException = WSSException.format(string2, string);
            Tr.processException((Throwable)wSSException, clsName + ".addAllowedDigestMethod", "102", this);
            Tr.error(tc, string2, new Object[]{wSSException});
            throw wSSException;
        }
        this.digestMethods.add(string);
    }

    @Override
    public void addAllowedTransform(String string) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getTransformAlgorithms().contains(string)) {
            String string2 = "security.wssecurity.PrivateConsumerConfig.s12";
            WSSException wSSException = WSSException.format(string2, string);
            Tr.processException((Throwable)wSSException, clsName + ".addAllowedTransform", "116", this);
            Tr.error(tc, string2, new Object[]{wSSException});
            throw wSSException;
        }
        AlgorithmParameterData algorithmParameterData = new AlgorithmParameterData(string);
        this.transforms.add(algorithmParameterData);
    }

    @Override
    public void setRequiredVerifyPart(int n) throws WSSException {
        this.keyword = this.getKeyword(n);
    }

    @Override
    public void setRequiredVerifyHeader(QName qName) {
        this.dialect = Constants.DIALECT_XPATH;
        this.keyword = "//*[namespace-uri()='" + qName.getNamespaceURI() + "' and local-name()='" + qName.getLocalPart() + "']";
    }

    @Override
    public void setRequiredVerifyPartByXPath(String string) {
        this.dialect = Constants.DIALECT_XPATH;
        this.keyword = string;
    }

    public List<String> getDigestMethods() {
        return this.digestMethods;
    }

    public List<AlgorithmParameterData> getTransforms() {
        return this.transforms;
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getKeyword(int n) throws WSSException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyword (" + n + ")");
        }
        if ((string = partMap.get(n)) == null) {
            String string2 = "security.wssecurity.WSEC7010E";
            WSSException wSSException = WSSException.format(string2);
            Tr.processException((Throwable)wSSException, clsName + ".getKeyword", "163", this);
            Tr.error(tc, string2, new Object[]{wSSException});
            throw wSSException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyword (" + n + ")");
        }
        return string;
    }

    static {
        partMap.put(41, IntegralDialectElementSelector.WASDIALECTS[0]);
        partMap.put(42, IntegralDialectElementSelector.WASDIALECTS[13]);
        partMap.put(43, IntegralDialectElementSelector.WASDIALECTS[1]);
    }
}

