/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.verify.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerifyPart;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.token.impl.Consumable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.verify.impl.WSSVerifyPartImpl;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSVerificationImpl
implements WSSVerification,
Consumable {
    private static final TraceComponent tc = Tr.register(WSSVerificationImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSVerificationImpl.class.getName();
    private static final long serialVersionUID = 5487399524209531395L;
    private SecurityToken token;
    private List<WSSVerifyPart> verifyParts = new ArrayList<WSSVerifyPart>();
    private List<String> canonicalizationMethods = new ArrayList<String>();
    private List<String> signatureMethods = new ArrayList<String>();
    private boolean signatureConfirmation;
    private boolean requriredSignatureConfirmation;
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSVerificationImpl(SecurityTokenManagerImpl securityTokenManagerImpl) {
        this.securityTokenManager = securityTokenManagerImpl;
    }

    public WSSVerificationImpl(Class clazz, CallbackHandler callbackHandler, String string, SecurityTokenManagerImpl securityTokenManagerImpl) throws WSSException {
        this.securityTokenManager = securityTokenManagerImpl;
        this.addToken(clazz, callbackHandler, string);
    }

    @Override
    public void addRequiredVerifyPart(int n) throws WSSException {
        WSSVerifyPartImpl wSSVerifyPartImpl = new WSSVerifyPartImpl();
        wSSVerifyPartImpl.setRequiredVerifyPart(n);
        this.verifyParts.add(wSSVerifyPartImpl);
    }

    @Override
    public void addRequiredVerifyPartByXPath(String string) {
        WSSVerifyPartImpl wSSVerifyPartImpl = new WSSVerifyPartImpl();
        wSSVerifyPartImpl.setRequiredVerifyPartByXPath(string);
        this.verifyParts.add(wSSVerifyPartImpl);
    }

    @Override
    public void addRequiredVerifyPart(WSSVerifyPart wSSVerifyPart) {
        this.verifyParts.add(wSSVerifyPart);
    }

    @Override
    public void addAllowedCanonicalizationMethod(String string) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getCanonicalizationAlgorithms().contains(string)) {
            WSSException wSSException = WSSException.format("security.wssecurity.PrivateConsumerConfig.s08", string);
        }
        this.canonicalizationMethods.add(string);
    }

    @Override
    public void addAllowedSignatureMethod(String string) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getSignatureAlgorithms().contains(string)) {
            String string2 = "security.wssecurity.PrivateConsumerConfig.s09";
            WSSException wSSException = WSSException.format(string2, string);
            Tr.processException((Throwable)wSSException, clsName + ".addAllowedSignatureMethod", "153", this);
            Tr.error(tc, string2, new Object[]{wSSException});
            throw wSSException;
        }
        this.signatureMethods.add(string);
    }

    @Override
    public void addRequiredVerifyHeader(QName qName) {
        WSSVerifyPartImpl wSSVerifyPartImpl = new WSSVerifyPartImpl();
        wSSVerifyPartImpl.setRequiredVerifyHeader(qName);
        this.verifyParts.add(wSSVerifyPartImpl);
    }

    public List<WSSVerifyPart> getVerifyParts() {
        return this.verifyParts;
    }

    public List<String> getCanonicalizationMethods() {
        return this.canonicalizationMethods;
    }

    public List<String> getSignatureMethods() {
        return this.signatureMethods;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    @Override
    public void addToken(Class clazz, CallbackHandler callbackHandler, String string) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToken(Class tokenClass, CallbackHandler callbackHandler, String loginConfigName )");
        }
        this.token = WSSUtil.newSecurityTokenForConsumer(clazz, callbackHandler, string, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToken(Qname valueType, CallbackHandler callbackHandler, String loginConfigName )");
        }
    }

    @Override
    public void addToken(Class clazz, CallbackHandler callbackHandler) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToken(Class tokenClass, CallbackHandler callbackHandler )");
        }
        this.token = WSSUtil.newSecurityTokenForConsumer(clazz, callbackHandler, null, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToken(Class tokenClass, CallbackHandler callbackHandler )");
        }
    }

    @Override
    public void requireSignatureConfirmation() {
        this.signatureConfirmation = true;
    }

    public boolean isRequriredSignatureConfirmation() {
        return this.requriredSignatureConfirmation;
    }

    public boolean isSignatureConfirmation() {
        return this.signatureConfirmation;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[WSSVerificationImpl:");
        stringBuffer.append(" canonicalizationMethods: ");
        stringBuffer.append(this.canonicalizationMethods);
        stringBuffer.append(", signatureMethods: ");
        stringBuffer.append(this.signatureMethods);
        stringBuffer.append(", verifyParts: ");
        stringBuffer.append(this.verifyParts);
        stringBuffer.append(", token: ");
        stringBuffer.append(this.token);
        stringBuffer.append(", signatureConfirmation: ");
        stringBuffer.append(this.signatureConfirmation);
        stringBuffer.append(", requriredSignatureConfirmation: ");
        stringBuffer.append(this.requriredSignatureConfirmation);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

