/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.CertificateUtil;
import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.wssapi.token.impl.BinarySecurityTokenImpl;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecurityPermission;
import java.security.cert.X509Certificate;
import org.apache.axis2.util.ObjectStateUtils;

public class X509TokenImpl
extends BinarySecurityTokenImpl
implements X509Token {
    private static final TraceComponent tc = Tr.register(X509TokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = 3166835820878605529L;
    private static final String VERSION_NUMBER = "1.0";
    private static final SecurityPermission SETCERT_PERM = new SecurityPermission("wssapi.X509Token.setCertificate");
    private X509Certificate certificate;
    private String issuerName;
    private String issuerSerial;
    protected int hashcode = 0;

    public X509TokenImpl() {
        this.keyIdentifierValueType = Constants.X509_SKI_OLD;
        this.keyIdentifierEncodingType = Constants.BASE64_BINARY;
        this.valueType = X509Token.ValueType;
        this.tokenQName = X509Token.TokenQname;
        this.hashcode = SecurityUIDGenerator.createUID().hashCode();
    }

    public void setTokenToErrata10() {
        if (!this.readOnly) {
            this.keyIdentifierValueType = Constants.X509_SKI;
            this.valueType = Constants.X509V3;
        }
    }

    public String getId() {
        if (this.id == null || this.id.length() == 0) {
            int n = 0;
            n = SecurityUIDGenerator.createUID().hashCode();
            this.id = "x509_" + String.valueOf(n);
        }
        return this.id;
    }

    public X509Certificate getCertificate() {
        X509Certificate x509Certificate = this.certificate;
        if (this.readOnly && this.certificate != null) {
            try {
                x509Certificate = CertificateUtil.generateX509Certificate(this.certificate.getEncoded(), null);
            }
            catch (Exception exception) {
                x509Certificate = null;
            }
        }
        return x509Certificate;
    }

    public void setCertificate(X509Certificate x509Certificate) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETCERT_PERM.toString());
            }
            securityManager.checkPermission(SETCERT_PERM);
        }
        if (!this.readOnly) {
            this.certificate = x509Certificate;
            if (x509Certificate == null) {
                this.principal = null;
            } else {
                this.principal = x509Certificate.getSubjectDN().getName();
                String string = KeyInfo.X509Data.encodeDName(this.principal);
                if (string != null && string.length() > 0) {
                    this.principal = string;
                }
            }
        }
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public void setIssuerName(String string) {
        if (!this.readOnly) {
            this.issuerName = string;
        }
    }

    public String getIssuerSerial() {
        return this.issuerSerial;
    }

    public void setIssuerSerial(String string) {
        if (!this.readOnly) {
            this.issuerSerial = string;
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.id;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof X509TokenImpl)) {
            return false;
        }
        return ((X509TokenImpl)object).hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getId() != null) {
                stringBuffer.append(this.getId());
            }
            if (this.getCertificate() != null) {
                stringBuffer.append(this.getCertificate().getSerialNumber());
            }
            this.hashcode = stringBuffer.length() > 0 ? stringBuffer.hashCode() : SecurityUIDGenerator.createUID().hashCode();
        }
        return this.hashcode;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        String string = ObjectStateUtils.readString(objectInput, "X509Token.version");
        if (VERSION_NUMBER.equals(string)) {
            Object object = ObjectStateUtils.readObject(objectInput, "X509Token.certificate");
            if (object != null) {
                this.certificate = (X509Certificate)object;
            }
            this.issuerName = ObjectStateUtils.readString(objectInput, "X509Token.issuerName");
            this.issuerSerial = ObjectStateUtils.readString(objectInput, "X509Token.issuerSerial");
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        ObjectStateUtils.writeString(objectOutput, VERSION_NUMBER, "UsernameToken.version");
        ObjectStateUtils.writeObject(objectOutput, this.certificate, "X509Token.certificate");
        ObjectStateUtils.writeString(objectOutput, this.issuerName, "X509Token.issuerName");
        ObjectStateUtils.writeString(objectOutput, this.issuerSerial, "X509Token.issuerSerial");
    }
}

