/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.X509GenerateCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactoryFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509TokenImpl;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509GenerateLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(X509GenerateLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509GenerateLoginModule.class.getName();
    private static final String VALUE_TYPE = "ValueType".intern();
    private static final String ENCODING_TYPE = "EncodingType".intern();
    private static String _factoryKey = (String)WSSecurityFactoryBuilder.getImplClassName("com.ibm.ws.wssecurity.platform.X509Token");
    private static TokenFactory _tokenFactory = TokenFactoryFactory.getTokenFactory(_factoryKey);
    CallbackHandler _handler;
    List<SecurityToken> _processedTokens;
    List<SecurityToken> _insertedTokens;
    SecurityTokenManager _securityTokenManager;
    Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = callbackHandler;
        this._processedTokens = new ArrayList<SecurityToken>();
        this._insertedTokens = new ArrayList<SecurityToken>();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        Object object;
        Serializable serializable;
        String string;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        X509GenerateCallback x509GenerateCallback = new X509GenerateCallback();
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbackArray = new Callback[]{x509GenerateCallback, propertyCallback};
        try {
            this._handler.handle(callbackArray);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".login", "138", this);
            Tr.error(tc, "security.wssecurity.BSTokenLoginModule.s01", exception);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{exception.toString()}));
        }
        this._context = propertyCallback.getProperties();
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        KeyStoreManager keyStoreManager = KeyStoreManager.getInstance();
        KeyStoreManager.KeyInformation keyInformation = null;
        if (x509GenerateCallback.isUsedIdentityAssertion()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking the certificate of initial sender...");
            }
            if (messageContext == null) {
                String string2 = ConfigUtil.getMessage("security.wssecurity.WSEC6836E");
                throw new LoginException(string2);
            }
            object6 = messageContext.getProperty("com.ibm.wsspi.wssecurity.username.initialSenderCert");
            if (object6 == null || !(object6 instanceof X509Certificate)) {
                String string3 = ConfigUtil.getMessage("security.wssecurity.WSEC6836E");
                throw new LoginException(string3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The certificate of initial sender is used.");
            }
            object5 = (X509Certificate)object6;
            try {
                keyInformation = keyStoreManager.getKeyInformation((X509Certificate)object5);
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".login", "182", this);
                throw new LoginException(soapSecurityException.toString());
            }
        }
        if (x509GenerateCallback.isUsedRequestorCertificate()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking the certificate of requestor...");
            }
            if (messageContext == null) {
                String string4 = ConfigUtil.getMessage("security.wssecurity.WSEC6808E");
                throw new LoginException(string4);
            }
            object6 = Axis2Util.getProperty(messageContext, "com.ibm.xml.soapsec.RequestCert");
            if (object6 == null || !(object6 instanceof X509Certificate)) {
                String string5 = ConfigUtil.getMessage("security.wssecurity.WSEC6808E");
                throw new LoginException(string5);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The certificate of requestor is used.");
            }
            object5 = (X509Certificate)object6;
            try {
                keyInformation = keyStoreManager.getKeyInformation((X509Certificate)object5);
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".login", "206", this);
                throw new LoginException(soapSecurityException.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting the key information using the configuration...");
        }
        try {
            keyInformation = keyStoreManager.getKeyInformation(x509GenerateCallback.getKeyStorePath(), x509GenerateCallback.getKeyStoreType(), x509GenerateCallback.getKeyStorePassword(), x509GenerateCallback.getKeyStoreReference(), x509GenerateCallback.getAlias(), x509GenerateCallback.getKeyPassword(), x509GenerateCallback.getKeyName());
        }
        catch (SoapSecurityException soapSecurityException) {
            Tr.processException((Throwable)soapSecurityException, clsName + ".login", "222", this);
            throw new LoginException(soapSecurityException.toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The key information got with the configuration is used.");
        }
        object6 = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        object5 = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        Boolean bl7 = false;
        OperationContext operationContext = messageContext.getOperationContext();
        if (operationContext == null) {
            operationContext = (OperationContext)messageContext.getProperty("unverifiedOperationContext");
        }
        if (operationContext != null) {
            MessageContext messageContext2;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Valid operation context to look for USE_X509ERRATA_10 property");
            }
            object4 = operationContext.getMessageContexts();
            object3 = ((HashMap)object4).entrySet();
            object2 = object3.iterator();
            string = null;
            serializable = null;
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                messageContext2 = (MessageContext)object.getValue();
                serializable = (HashMap)messageContext2.getProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP");
                if (serializable == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found the WSS_PROPERTYMAP in the msg ctx with key: " + object.getKey());
                }
                if ((string = ((HashMap)serializable).get("com.ibm.ws.wssecurity.generateX509Errata10Token")) != null) {
                    bl7 = (boolean)((Boolean)((Object)string));
                    messageContext2.setProperty("com.ibm.ws.wssecurity.WSS_PROPERTYMAP", serializable);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Did NOT find USE_X509ERRATA_10 in WSS_PROPERTYMAP property map.");
            }
            if (string == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did not find USE_X509ERRATA_10 or the WSS_PROPERTYMAP in any message context.Try to find WSS_RAMP_PROPERTYMAP. ");
                }
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    messageContext2 = (MessageContext)object.getValue();
                    serializable = (HashMap)messageContext2.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                    if (serializable == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found the WSS_RAMP_PROPERTYMAP in the msg ctx with key: " + object.getKey());
                    }
                    if ((string = ((HashMap)serializable).get("com.ibm.ws.wssecurity.generateX509Errata10Token")) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Found USE_X509ERRATA_10 in WSS_RAMP_PROPERTYMAP property map.");
                        }
                        bl7 = (boolean)((Boolean)((Object)string));
                        messageContext2.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", serializable);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Did NOT find USE_X509ERRATA_10 in WSS_RAMP_PROPERTYMAP property map.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OperationContext was null, cannot look for USE_X509ERRATA_10 in WSS_PROPERTYMAP.");
            }
        }
        object4 = (String)object6.getProperties().get("com.ibm.ws.wssecurity.generateX509Errata10Token");
        object3 = object6.getType();
        if (bl7.booleanValue()) {
            object3 = com.ibm.ws.wssecurity.common.Constants.X509V3;
        } else if (object4 != null && ((String)object4).equals("true")) {
            object3 = com.ibm.ws.wssecurity.common.Constants.X509V3;
            bl7 = true;
        }
        object2 = null;
        string = null;
        try {
            serializable = (X509Certificate)keyInformation.getCertificate();
            string = keyInformation.getSubjectDN();
            object2 = X509GenerateLoginModule.getToken((TokenGeneratorConfig)object6, (String)object5, (Certificate)serializable, this._securityTokenManager);
        }
        catch (SoapSecurityException soapSecurityException) {
            Tr.processException((Throwable)soapSecurityException, clsName + ".login", "242", this);
            throw new LoginException(soapSecurityException.toString());
        }
        boolean bl8 = true;
        object = (String)object6.getProperties().get("com.ibm.ws.wssecurity.token.forwardable");
        if (object != null && ((String)object).equalsIgnoreCase("false")) {
            bl8 = false;
        }
        boolean bl9 = object6.isStandAlone();
        if (object5 == null) {
            bl6 = false;
            bl5 = false;
            bl4 = false;
            bl3 = false;
            bl2 = false;
            bl = false;
        } else {
            bl = ConfigUtil.isKeyInfoKeyname((String)object5);
            bl2 = ConfigUtil.isKeyInfoKeyid((String)object5);
            bl3 = ConfigUtil.isKeyInfoStrref((String)object5);
            bl4 = ConfigUtil.isKeyInfoEmb((String)object5);
            bl5 = ConfigUtil.isKeyInfoX509issuer((String)object5);
            bl6 = ConfigUtil.isKeyInfoThumbprint((String)object5);
        }
        if (object2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no token [" + string + "] stored in the Subject.");
            }
            OMElement oMElement = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
            X509TokenImpl x509TokenImpl = (X509TokenImpl)_tokenFactory.getToken(bl8);
            if (bl7.booleanValue()) {
                x509TokenImpl.setTokenToErrata10();
            }
            try {
                Object object7;
                Object object8;
                string = null;
                if (bl9) {
                    string = IdUtils.getInstance().makeUniqueId("x509bst_");
                    x509TokenImpl.setId(string);
                    X509GenerateLoginModule.createTokenElement(oMElement.getOMFactory(), oMElement, (QName)object3, keyInformation, x509TokenImpl, true, this._context);
                    this._processedTokens.add(x509TokenImpl);
                    this._insertedTokens.add(x509TokenImpl);
                } else if (bl3) {
                    string = IdUtils.getInstance().makeUniqueId("x509bst_");
                    x509TokenImpl.setId(string);
                    x509TokenImpl.setReferenceURI("#" + string);
                    X509GenerateLoginModule.createTokenElement(oMElement.getOMFactory(), oMElement, (QName)object3, keyInformation, x509TokenImpl, true, this._context);
                    this._processedTokens.add(x509TokenImpl);
                    this._insertedTokens.add(x509TokenImpl);
                } else if (bl4) {
                    string = IdUtils.getInstance().makeUniqueId("x509bst_");
                    x509TokenImpl.setId(string);
                    X509GenerateLoginModule.createTokenElement(oMElement.getOMFactory(), oMElement, (QName)object3, keyInformation, x509TokenImpl, false, this._context);
                    this._processedTokens.add(x509TokenImpl);
                    this._insertedTokens.add(x509TokenImpl);
                } else if (bl2) {
                    object8 = (QName)this._context.get(Constants.WSSECURITY_KEY_ENCODING);
                    object7 = (QName)this._context.get(Constants.WSSECURITY_KEY_IDTYPE);
                    string = X509GenerateLoginModule.getKeyIdentifier(keyInformation, (QName)object8, (QName)object7);
                    x509TokenImpl.setId(string);
                    x509TokenImpl.setKeyIdentifier(string);
                    x509TokenImpl.setKeyIdentifierEncodingType((QName)object8);
                    this._processedTokens.add(x509TokenImpl);
                } else if (bl6) {
                    object8 = (QName)this._context.get(Constants.WSSECURITY_KEY_ENCODING);
                    if (object8 == null) {
                        object8 = com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY;
                    }
                    string = X509GenerateLoginModule.getThumbprint(keyInformation, (QName)object8);
                    x509TokenImpl.setId(string);
                    x509TokenImpl.setThumbprint(string);
                    x509TokenImpl.setThumbprintEncodingType((QName)object8);
                    x509TokenImpl.setThumbprintValueType(com.ibm.ws.wssecurity.common.Constants.THUMBPRINTSHA1);
                    this._processedTokens.add(x509TokenImpl);
                } else if (bl) {
                    string = keyInformation.getSubjectDN();
                    x509TokenImpl.setId(string);
                    x509TokenImpl.setKeyName(string);
                    this._processedTokens.add(x509TokenImpl);
                } else if (bl5) {
                    object8 = keyInformation.getIssuerDN();
                    object7 = keyInformation.getIssuerSerial();
                    string = (String)object8 + ":" + (String)object7;
                    x509TokenImpl.setId(string);
                    x509TokenImpl.setIssuerName((String)object8);
                    x509TokenImpl.setIssuerSerial((String)object7);
                    this._processedTokens.add(x509TokenImpl);
                }
                object8 = x509TokenImpl;
                object7 = (X509Certificate)keyInformation.getCertificate();
                byte[] byArray = keyInformation.getBinary();
                AccessController.doPrivileged(new PrivilegedAction<Object>((X509TokenImpl)object8, (X509Certificate)object7, byArray){
                    final /* synthetic */ X509TokenImpl val$tempToken;
                    final /* synthetic */ X509Certificate val$tempx509;
                    final /* synthetic */ byte[] val$tempbinary;
                    {
                        this.val$tempToken = x509TokenImpl;
                        this.val$tempx509 = x509Certificate;
                        this.val$tempbinary = byArray;
                    }

                    @Override
                    public Object run() {
                        this.val$tempToken.setCertificate(this.val$tempx509);
                        this.val$tempToken.setBinary(this.val$tempbinary);
                        return null;
                    }
                });
                x509TokenImpl.setKey(62, keyInformation.getPublicOrSecretKey());
                x509TokenImpl.setKey(61, keyInformation.getPrivateOrSecretKey());
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".login", "368", this);
                throw new LoginException(soapSecurityException.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "There is the token [" + object2.getId() + "] stored in the Subject.");
        }
        if (bl9) {
            this._processedTokens.add((SecurityToken)object2);
        } else if (bl3) {
            this._processedTokens.add((SecurityToken)object2);
        } else if (bl4) {
            X509TokenImpl x509TokenImpl = (X509TokenImpl)_tokenFactory.getToken(bl8);
            if (bl7.booleanValue()) {
                x509TokenImpl.setTokenToErrata10();
            }
            try {
                x509TokenImpl.setId(IdUtils.getInstance().makeUniqueId("x509bst_"));
                final X509TokenImpl x509TokenImpl2 = x509TokenImpl;
                final X509Certificate x509Certificate = (X509Certificate)keyInformation.getCertificate();
                final byte[] byArray = keyInformation.getBinary();
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        x509TokenImpl2.setCertificate(x509Certificate);
                        x509TokenImpl2.setBinary(byArray);
                        return null;
                    }
                });
                x509TokenImpl.setKey(62, keyInformation.getPublicOrSecretKey());
                x509TokenImpl.setKey(61, keyInformation.getPrivateOrSecretKey());
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".login", "399", this);
                throw new LoginException(soapSecurityException.toString());
            }
            this._processedTokens.add(x509TokenImpl);
            this._insertedTokens.add(x509TokenImpl);
        } else if (bl2) {
            this._processedTokens.add((SecurityToken)object2);
        } else if (bl6) {
            this._processedTokens.add((SecurityToken)object2);
        } else if (bl) {
            this._processedTokens.add((SecurityToken)object2);
        } else if (bl5) {
            this._processedTokens.add((SecurityToken)object2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        int n = this._processedTokens.size();
        for (int i = 0; i < n; ++i) {
            SecurityToken securityToken = this._processedTokens.get(i);
            this._securityTokenManager.addToken(securityToken);
        }
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        this._context.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private static final SecurityToken getToken(TokenGeneratorConfig tokenGeneratorConfig, String string, Certificate certificate, SecurityTokenManager securityTokenManager) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getToken(");
            ((StringBuffer)object).append("TokenGeneratorConfig config, ");
            ((StringBuffer)object).append("String keyInfoType[").append(string).append("], ");
            ((StringBuffer)object).append("Certificate cert, SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        Collection<SecurityToken> collection = securityTokenManager.getTokens(tokenGeneratorConfig, string);
        if (collection != null && collection.size() > 0) {
            for (SecurityToken securityToken : collection) {
                if (!(securityToken instanceof X509Token) || !((X509Token)securityToken).getCertificate().equals(certificate)) continue;
                object = securityToken;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getToken(");
            stringBuffer.append("Map, TokenGeneratorConfig, String, Certificate)");
            stringBuffer.append(" returns SecurityToken[").append(object).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final String getKeyIdentifier(KeyStoreManager.KeyInformation keyInformation, QName qName, QName qName2) throws LoginException {
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("getKeyIdentifier(");
            ((StringBuffer)charSequence).append("KeyInformation keyInformation, ");
            ((StringBuffer)charSequence).append("QName etype[").append(qName).append("], ");
            ((StringBuffer)charSequence).append("QName idtype[").append(qName2).append("])");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        charSequence = null;
        if (qName == null || NamespaceUtil.equals(qName, com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY)) {
            if (qName2 == null || NamespaceUtil.equals(qName2, com.ibm.ws.wssecurity.common.Constants.ITSHA1)) {
                try {
                    charSequence = keyInformation.getB64KeyId();
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.processException(soapSecurityException, clsName + ".getKeyIdentifier", "555");
                    throw new LoginException(soapSecurityException.toString());
                }
            } else {
                if (!NamespaceUtil.equals(qName2, com.ibm.ws.wssecurity.common.Constants.IT60SHA1)) {
                    String string = ConfigUtil.getMessage("security.wssecurity.WSEC6804E", new String[]{qName2.toString()});
                    throw new LoginException(string);
                }
                try {
                    charSequence = keyInformation.getB64KeyId60();
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.processException(soapSecurityException, clsName + ".getKeyIdentifier", "563");
                    throw new LoginException(soapSecurityException.toString());
                }
            }
        } else {
            if (!NamespaceUtil.equals(qName, com.ibm.ws.wssecurity.common.Constants.HEX_BINARY)) {
                String string = ConfigUtil.getMessage("security.wssecurity.BinaryTokenReceiver.token15", new String[]{qName.toString()});
                throw new LoginException(string);
            }
            if (qName2 == null || NamespaceUtil.equals(qName2, com.ibm.ws.wssecurity.common.Constants.ITSHA1)) {
                try {
                    charSequence = keyInformation.getHexKeyId();
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.processException(soapSecurityException, clsName + ".getKeyIdentifier", "579");
                    throw new LoginException(soapSecurityException.toString());
                }
            }
            if (!NamespaceUtil.equals(qName2, com.ibm.ws.wssecurity.common.Constants.IT60SHA1)) {
                String string = ConfigUtil.getMessage("security.wssecurity.WSEC6804E", new String[]{qName2.toString()});
                throw new LoginException(string);
            }
            try {
                charSequence = keyInformation.getHexKeyId60();
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException(soapSecurityException, clsName + ".getKeyIdentifier", "508");
                throw new LoginException(soapSecurityException.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getKeyIdentifier(");
            stringBuffer.append("KeyInformation, QName, QName)");
            stringBuffer.append(" returns String[").append((String)charSequence).append("]");
            Tr.entry(tc, stringBuffer.toString());
        }
        return charSequence;
    }

    private static final String getThumbprint(KeyStoreManager.KeyInformation keyInformation, QName qName) throws LoginException {
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("getThumbprint(");
            ((StringBuffer)charSequence).append("KeyInformation keyInformation, ");
            ((StringBuffer)charSequence).append("QName etype[").append(qName).append("])");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        charSequence = null;
        if (NamespaceUtil.equals(qName, com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY)) {
            try {
                charSequence = keyInformation.getB64Thumbprint();
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException(soapSecurityException, clsName + ".getThumbprint", "628");
                throw new LoginException(soapSecurityException.toString());
            }
        } else if (NamespaceUtil.equals(qName, com.ibm.ws.wssecurity.common.Constants.HEX_BINARY)) {
            try {
                charSequence = keyInformation.getHexThumbprint();
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException(soapSecurityException, clsName + ".getThumbprint", "636");
                throw new LoginException(soapSecurityException.toString());
            }
        } else {
            String string = ConfigUtil.getMessage("security.wssecurity.BinaryTokenReceiver.token15", new String[]{qName.toString()});
            throw new LoginException(string);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getThumbprint(");
            stringBuffer.append("KeyInformation, QName)");
            stringBuffer.append(" returns String[").append((String)charSequence).append("]");
            Tr.entry(tc, stringBuffer.toString());
        }
        return charSequence;
    }

    static final void createTokenElement(OMFactory oMFactory, OMElement oMElement, QName qName, KeyStoreManager.KeyInformation keyInformation, X509TokenImpl x509TokenImpl, boolean bl, Map<Object, Object> map) throws LoginException {
        CharSequence charSequence;
        String string;
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("createTokenElement(");
            stringBuffer.append("OMFactory factory, ");
            stringBuffer.append("OMElement parent[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            stringBuffer.append("QName valueType[").append(qName).append("], ");
            stringBuffer.append("KeyInformation keyInformation, X509TokenImpl token, ");
            stringBuffer.append("boolean insertId[").append(bl).append("], ");
            stringBuffer.append("Map context)");
            Tr.entry(tc, stringBuffer.toString());
        }
        int n = 0;
        Object object = map.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (object != null && object instanceof Integer) {
            n = (Integer)object;
        }
        String string2 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][n];
        String string3 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][n];
        boolean bl2 = false;
        String string4 = null;
        if (oMElement != null) {
            string4 = DOMUtils.getNamespacePrefix(oMElement, string2);
        }
        if (string4 == null) {
            bl2 = true;
            string4 = "wsse";
        }
        OMElement oMElement2 = oMFactory.createOMElement("BinarySecurityToken", string2, string4);
        if (bl2) {
            oMElement2.declareNamespace(string2, string4);
        }
        if (bl && (string = x509TokenImpl.getId()) != null) {
            bl2 = false;
            charSequence = DOMUtils.getNamespacePrefix(oMElement, string3);
            if (charSequence == null) {
                bl2 = true;
                charSequence = "wsu";
            }
            if (bl2) {
                oMElement2.declareNamespace(string3, (String)charSequence);
            }
            oMElement2.addAttribute("Id", string, oMElement2.getOMFactory().createOMNamespace(string3, (String)charSequence));
        }
        DOMUtils.setQNameAttr(oMElement2, null, ENCODING_TYPE, com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY, n);
        DOMUtils.setQNameAttr(oMElement2, null, VALUE_TYPE, qName, n);
        string = null;
        try {
            string = keyInformation.getEncodedBinary();
        }
        catch (SoapSecurityException soapSecurityException) {
            Tr.processException(soapSecurityException, clsName + ".login", "720");
            throw new LoginException(soapSecurityException.toString());
        }
        if (string != null) {
            oMElement2.addChild(oMFactory.createOMText(string));
        }
        x509TokenImpl.setXML(new OMStructure(oMElement2));
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("createTokenElement(");
            ((StringBuffer)charSequence).append("OMFactory, OMElement, QName, KeyInformation, ");
            ((StringBuffer)charSequence).append("X509TokenImpl, boolean, Map)");
            ((StringBuffer)charSequence).append(" returns OMElement [").append(oMElement2).append("]");
            Tr.exit(tc, ((StringBuffer)charSequence).toString());
        }
    }
}

