/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.X509ConsumeCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.token.CertCacheManager;
import com.ibm.ws.wssecurity.util.CertificateUtil;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactoryFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509TokenImpl;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509ConsumeLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(X509ConsumeLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509ConsumeLoginModule.class.getName();
    private static final String _factoryKey = (String)WSSecurityFactoryBuilder.getImplClassName("com.ibm.ws.wssecurity.platform.X509Token");
    private static final TokenFactory _tokenFactory = TokenFactoryFactory.getTokenFactory(_factoryKey);
    private CallbackHandler _handler;
    private SecurityToken _token;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = callbackHandler;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        X509ConsumeCallback x509ConsumeCallback = new X509ConsumeCallback();
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbackArray = new Callback[]{x509ConsumeCallback, propertyCallback};
        try {
            this._handler.handle(callbackArray);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".login", "143", this);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{exception.toString()}));
        }
        this._context = propertyCallback.getProperties();
        TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
        boolean bl8 = true;
        String string = (String)tokenConsumerConfig.getProperties().get("com.ibm.ws.wssecurity.token.forwardable");
        if (string != null && string.equalsIgnoreCase("false")) {
            bl8 = false;
        }
        X509TokenImpl x509TokenImpl = (X509TokenImpl)_tokenFactory.getToken(bl8);
        this._context.put(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING, x509TokenImpl);
        QName qName = tokenConsumerConfig.getType();
        if (!(com.ibm.ws.wssecurity.common.Constants.X509V3.equals(qName) || com.ibm.ws.wssecurity.common.Constants.X509V3_OLD.equals(qName) || com.ibm.ws.wssecurity.common.Constants.X509V3_11_V3.equals(qName))) {
            String string2 = ConfigUtil.getMessage("security.wssecurity.PrivateConsumerConfig.s30", new String[]{qName.toString(), com.ibm.ws.wssecurity.common.Constants.X509V3.toString() + " or " + com.ibm.ws.wssecurity.common.Constants.X509V3_OLD.toString() + " or " + com.ibm.ws.wssecurity.common.Constants.X509V3_11_V3.toString()});
            throw new LoginException(string2);
        }
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        CertCacheManager certCacheManager = (CertCacheManager)this._context.get(CertCacheManager.class);
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        String string3 = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        OMElement oMElement = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        if (string3 == null) {
            bl7 = true;
            bl6 = false;
            bl5 = false;
            bl4 = false;
            bl3 = false;
            bl2 = false;
            bl = false;
        } else {
            bl7 = false;
            bl = ConfigUtil.isKeyInfoKeyname(string3);
            bl2 = ConfigUtil.isKeyInfoKeyid(string3);
            bl3 = ConfigUtil.isKeyInfoStrref(string3);
            bl4 = ConfigUtil.isKeyInfoEmb(string3);
            bl5 = ConfigUtil.isKeyInfoX509issuer(string3);
            bl6 = ConfigUtil.isKeyInfoThumbprint(string3);
        }
        this._token = bl7 || bl4 ? X509ConsumeLoginModule.processElement(x509TokenImpl, x509ConsumeCallback, oMElement, tokenConsumerConfig, certCacheManager, messageContext, bl7, bl4, this._context) : X509ConsumeLoginModule.resolveKeyInfo(x509TokenImpl, x509ConsumeCallback, tokenConsumerConfig, certCacheManager, messageContext, string3, bl, bl2, bl3, bl5, bl6, this._securityTokenManager, this._context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        this._securityTokenManager.addToken(this._token);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The token hash value = " + this._token.hashCode());
        }
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._token);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final SecurityToken resolveKeyInfo(X509TokenImpl x509TokenImpl, X509ConsumeCallback x509ConsumeCallback, TokenConsumerConfig tokenConsumerConfig, CertCacheManager certCacheManager, MessageContext messageContext, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, SecurityTokenManager securityTokenManager, Map<Object, Object> map) throws LoginException {
        CharSequence charSequence;
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("resolveKeyInfo(");
            ((StringBuffer)object).append("X509TokenImpl x509Token, X509ConsumeCallback x509Callback, ");
            ((StringBuffer)object).append("TokenConsumerConfig config, CertCacheManager cmanager, ");
            ((StringBuffer)object).append("SOAPMessageContext messageContext, ");
            ((StringBuffer)object).append("String keyInfoType[").append(string).append("], ");
            ((StringBuffer)object).append("boolean isKeyName[").append(bl).append("], ");
            ((StringBuffer)object).append("boolean isKeyId[").append(bl2).append("], ");
            ((StringBuffer)object).append("boolean isStrref[").append(bl3).append("], ");
            ((StringBuffer)object).append("boolean isX509[").append(bl4).append("], ");
            ((StringBuffer)object).append("boolean isThumbprint[").append(bl5).append("], ");
            ((StringBuffer)object).append("SecurityTokenManager securityTokenManager, Map context)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        if (bl3) {
            SecurityToken securityToken;
            charSequence = (String)map.get(Constants.WSSECURITY_KEY_REFERENCE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Token identifier is [" + (String)charSequence + "]");
            }
            if ((securityToken = securityTokenManager.getToken(tokenConsumerConfig, (String)charSequence)) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WARNING: SecurityToken whose identifier is \"" + (String)charSequence + "\" was not found in the Subject.");
                }
                object = x509TokenImpl;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is the token [" + (String)charSequence + "] stored in the Subject.");
                }
                object = securityToken;
            }
        } else {
            charSequence = null;
            String string2 = null;
            String string3 = null;
            if (bl2) {
                charSequence = (String)map.get(Constants.WSSECURITY_KEY_ID);
            } else if (bl5) {
                charSequence = (String)map.get(Constants.WSSECURITY_KEY_THUMBPRINT_REFERENCE);
            } else if (bl) {
                charSequence = (String)map.get(Constants.WSSECURITY_KEY_NAME);
            } else if (bl4) {
                string2 = (String)map.get(Constants.WSSECURITY_KEY_ISSUERNAME);
                string3 = (String)map.get(Constants.WSSECURITY_KEY_ISSUERSERIAL);
                if (string2 != null && string3 != null) {
                    charSequence = string2 + ":" + string3;
                }
            }
            SecurityToken securityToken = securityTokenManager.getToken(tokenConsumerConfig, (String)charSequence);
            if (securityToken == null) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                X509Certificate x509Certificate;
                block76: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There is no token [" + (String)charSequence + "] stored in the Subject.");
                    }
                    x509TokenImpl.setId((String)charSequence);
                    if (!x509ConsumeCallback.existKeyStore()) {
                        String string4 = ConfigUtil.getMessage("security.wssecurity.WSEC6810E", new String[]{charSequence});
                        throw new LoginException(string4);
                    }
                    x509Certificate = null;
                    if (certCacheManager != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking the cached X509Certificate object with the key[" + (String)charSequence + "].");
                        }
                        try {
                            object5 = certCacheManager.getCachedCert((String)charSequence);
                        }
                        catch (SoapSecurityException soapSecurityException) {
                            Tr.processException(soapSecurityException, clsName + ".resolveKeyInfo", "410");
                            throw new LoginException(soapSecurityException.toString());
                        }
                        if (object5 == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "There is no cached certificiate.");
                            }
                        } else if (object5 instanceof X509Certificate) {
                            x509Certificate = (X509Certificate)object5;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The X509Certificate [" + x509Certificate.getSubjectDN().getName() + "] was found.");
                            }
                        } else if (tc.isDebugEnabled()) {
                            object4 = new StringBuffer("The certificate [");
                            ((StringBuffer)object4).append(object5.getClass().getName());
                            ((StringBuffer)object4).append("] was found, but it's not the X509Certificate object.");
                            Tr.debug(tc, ((StringBuffer)object4).toString());
                        }
                    }
                    object5 = null;
                    try {
                        object4 = KeyStoreManager.getInstance();
                        object5 = ((KeyStoreManager)object4).getKeyInformation(x509ConsumeCallback.getKeyStorePath(), x509ConsumeCallback.getKeyStoreType(), x509ConsumeCallback.getKeyStorePassword(), x509ConsumeCallback.getKeyStoreReference(), x509ConsumeCallback.getAlias(), x509ConsumeCallback.getKeyPassword(), x509ConsumeCallback.getKeyName());
                    }
                    catch (SoapSecurityException soapSecurityException) {
                        Tr.processException(soapSecurityException, clsName + ".resolveKeyInfo", "443");
                        throw new LoginException(soapSecurityException.toString());
                    }
                    if (x509Certificate == null) {
                        try {
                            if (bl2) {
                                object4 = (QName)map.get(Constants.WSSECURITY_KEY_VALUETYPE);
                                if (object4 == null) {
                                    String string5 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier02");
                                    throw new LoginException(string5);
                                }
                                if (!com.ibm.ws.wssecurity.common.Constants.X509_SKI.equals(object4) && !com.ibm.ws.wssecurity.common.Constants.X509_SKI_OLD.equals(object4)) {
                                    String string6 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier03", new String[]{com.ibm.ws.wssecurity.common.Constants.X509_SKI.toString() + " or " + com.ibm.ws.wssecurity.common.Constants.X509_SKI_OLD.toString(), ((QName)object4).toString()});
                                    throw new LoginException(string6);
                                }
                                object3 = (QName)map.get(Constants.WSSECURITY_KEY_IDTYPE);
                                object2 = (QName)map.get(Constants.WSSECURITY_KEY_ENCODING);
                                String string7 = null;
                                if (object2 == null || NamespaceUtil.equals((QName)object2, com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY)) {
                                    if (object3 == null || NamespaceUtil.equals((QName)object3, com.ibm.ws.wssecurity.common.Constants.ITSHA1)) {
                                        string7 = ((KeyStoreManager.KeyInformation)object5).getB64KeyId();
                                    } else {
                                        if (!NamespaceUtil.equals((QName)object3, com.ibm.ws.wssecurity.common.Constants.IT60SHA1)) {
                                            String string8 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01");
                                            string8 = string8 + ": " + object3;
                                            throw new LoginException(string8);
                                        }
                                        string7 = ((KeyStoreManager.KeyInformation)object5).getB64KeyId60();
                                    }
                                } else {
                                    if (!NamespaceUtil.equals((QName)object2, com.ibm.ws.wssecurity.common.Constants.HEX_BINARY)) {
                                        String string9 = ConfigUtil.getMessage("security.wssecurity.BinaryTokenReceiver.token15", new String[]{((QName)object2).toString()});
                                        throw new LoginException(string9);
                                    }
                                    if (object3 == null || NamespaceUtil.equals((QName)object3, com.ibm.ws.wssecurity.common.Constants.ITSHA1)) {
                                        string7 = ((KeyStoreManager.KeyInformation)object5).getHexKeyId();
                                    } else {
                                        if (!NamespaceUtil.equals((QName)object3, com.ibm.ws.wssecurity.common.Constants.IT60SHA1)) {
                                            String string10 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01");
                                            string10 = string10 + ": " + object3;
                                            throw new LoginException(string10);
                                        }
                                        string7 = ((KeyStoreManager.KeyInformation)object5).getHexKeyId60();
                                    }
                                }
                                if (!((String)charSequence).equals(string7)) {
                                    String string11 = ConfigUtil.getMessage("security.wssecurity.WSEC6811E", new String[]{charSequence, string7, x509ConsumeCallback.getKeyStorePath()});
                                    throw new LoginException(string11);
                                }
                            } else if (bl5) {
                                object4 = (QName)map.get(Constants.WSSECURITY_KEY_VALUETYPE);
                                if (object4 == null) {
                                    String string12 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier02");
                                    throw new LoginException(string12);
                                }
                                if (!com.ibm.ws.wssecurity.common.Constants.THUMBPRINTSHA1.equals(object4)) {
                                    String string13 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier03", new String[]{com.ibm.ws.wssecurity.common.Constants.THUMBPRINTSHA1.toString(), ((QName)object4).toString()});
                                    throw new LoginException(string13);
                                }
                                object3 = (QName)map.get(Constants.WSSECURITY_KEY_ENCODING);
                                object2 = null;
                                if (object3 == null || NamespaceUtil.equals((QName)object3, com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY)) {
                                    object2 = ((KeyStoreManager.KeyInformation)object5).getB64Thumbprint();
                                } else {
                                    if (!NamespaceUtil.equals((QName)object3, com.ibm.ws.wssecurity.common.Constants.HEX_BINARY)) {
                                        String string14 = ConfigUtil.getMessage("security.wssecurity.BinaryTokenReceiver.token15", new String[]{((QName)object3).toString()});
                                        throw new LoginException(string14);
                                    }
                                    object2 = ((KeyStoreManager.KeyInformation)object5).getHexThumbprint();
                                }
                                if (!((String)charSequence).equals(object2)) {
                                    String string15 = ConfigUtil.getMessage("security.wssecurity.WSEC6811E", new String[]{charSequence, object2, x509ConsumeCallback.getKeyStorePath()});
                                    throw new LoginException(string15);
                                }
                            } else if (bl) {
                                object4 = KeyInfo.X509Data.encodeDName((String)charSequence);
                                if (object4 == null) {
                                    object4 = charSequence;
                                }
                                if (!((String)object4).equals(object3 = ((KeyStoreManager.KeyInformation)object5).getSubjectDN())) {
                                    String string16 = ConfigUtil.getMessage("security.wssecurity.WSEC6812E", new String[]{object4, object3, x509ConsumeCallback.getKeyStorePath()});
                                    throw new LoginException(string16);
                                }
                            } else if (bl4) {
                                object4 = KeyInfo.X509Data.encodeDName(string2);
                                if (object4 == null) {
                                    object4 = string2;
                                }
                                if (!((String)object4).equals(object3 = ((KeyStoreManager.KeyInformation)object5).getIssuerDN())) {
                                    String string17 = ConfigUtil.getMessage("security.wssecurity.WSEC6813E", new String[]{object4, object3, x509ConsumeCallback.getKeyStorePath()});
                                    throw new LoginException(string17);
                                }
                                object2 = ((KeyStoreManager.KeyInformation)object5).getIssuerSerial();
                                if (!string3.equals(object2)) {
                                    String string18 = ConfigUtil.getMessage("security.wssecurity.WSEC6813E", new String[]{string3, object2, x509ConsumeCallback.getKeyStorePath()});
                                    throw new LoginException(string18);
                                }
                            }
                            x509Certificate = (X509Certificate)((KeyStoreManager.KeyInformation)object5).getCertificate();
                            if (!x509ConsumeCallback.isTrustAnyCertificate()) {
                                X509ConsumeLoginModule.validateX509(x509Certificate, x509ConsumeCallback);
                            }
                            if (certCacheManager == null) break block76;
                            try {
                                certCacheManager.cacheCert((String)charSequence, x509Certificate);
                            }
                            catch (SoapSecurityException soapSecurityException) {
                                Tr.processException(soapSecurityException, clsName + ".resolveKeyInfo", "615");
                                throw new LoginException(soapSecurityException.toString());
                            }
                        }
                        catch (SoapSecurityException soapSecurityException) {
                            Tr.processException(soapSecurityException, clsName + ".resolveKeyInfo", "620");
                            throw new LoginException(soapSecurityException.toString());
                        }
                    }
                }
                try {
                    object4 = x509TokenImpl;
                    object3 = x509Certificate;
                    object2 = ((KeyStoreManager.KeyInformation)object5).getBinary();
                    AccessController.doPrivileged(new PrivilegedAction<Object>((X509TokenImpl)object4, (X509Certificate)object3, (byte[])object2){
                        final /* synthetic */ X509TokenImpl val$tempToken;
                        final /* synthetic */ X509Certificate val$tempx509;
                        final /* synthetic */ byte[] val$tempbinary;
                        {
                            this.val$tempToken = x509TokenImpl;
                            this.val$tempx509 = x509Certificate;
                            this.val$tempbinary = byArray;
                        }

                        @Override
                        public Object run() {
                            this.val$tempToken.setCertificate(this.val$tempx509);
                            this.val$tempToken.setBinary(this.val$tempbinary);
                            return null;
                        }
                    });
                    x509TokenImpl.setKey(63, ((KeyStoreManager.KeyInformation)object5).getPublicOrSecretKey());
                    x509TokenImpl.setKey(64, ((KeyStoreManager.KeyInformation)object5).getPrivateOrSecretKey());
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.processException(soapSecurityException, clsName + ".resolveKeyInfo", "636");
                    throw new LoginException(soapSecurityException.toString());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resolveKeyInfo, The X509Token hash value = " + x509TokenImpl.hashCode());
                }
                object = x509TokenImpl;
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is the token [" + (String)charSequence + "] stored in the Subject.");
                }
                object = securityToken;
            }
        }
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("resolveKeyInfo(");
            ((StringBuffer)charSequence).append("X509TokenImpl, X509ConsumeCallback, TokenConsumerConfig, ");
            ((StringBuffer)charSequence).append("CertCacheManager, SOAPMessageContext, String, boolean, boolean, ");
            ((StringBuffer)charSequence).append("boolean, boolean, Map)");
            ((StringBuffer)charSequence).append(" returns SecurityToken[").append(object).append("]");
            Tr.exit(tc, ((StringBuffer)charSequence).toString());
        }
        return object;
    }

    private static final SecurityToken processElement(X509TokenImpl x509TokenImpl, X509ConsumeCallback x509ConsumeCallback, OMElement oMElement, TokenConsumerConfig tokenConsumerConfig, CertCacheManager certCacheManager, MessageContext messageContext, boolean bl, boolean bl2, Map<Object, Object> map) throws LoginException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("processElement(");
            ((StringBuffer)charSequence).append("X509TokenImpl x509Token, X509ConsumeCallback x509Callback, ");
            ((StringBuffer)charSequence).append("OMElement target[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)charSequence).append("TokenConsumerConfig config, CertCacheManager cmanager, ");
            ((StringBuffer)charSequence).append("SOAPMessageContext messageContext, ");
            ((StringBuffer)charSequence).append("boolean isNone[").append(bl).append("], ");
            ((StringBuffer)charSequence).append("boolean isEmb[").append(bl2).append("], ");
            ((StringBuffer)charSequence).append("Map context)");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        x509TokenImpl.setXML(new OMStructure(oMElement));
        charSequence = null;
        if (bl) {
            object5 = IdUtils.getInstance().getIdAttributeName(oMElement);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The identifier attribute of the target element is [" + object5 + "].");
            }
            if (object5 != null) {
                charSequence = oMElement.getAttributeValue((QName)object5);
            }
        } else if (bl2) {
            charSequence = (String)map.get(Constants.WSSECURITY_KEY_EMBID);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The identifier of the token is [" + (String)charSequence + "]");
        }
        x509TokenImpl.setId((String)charSequence);
        object5 = DOMUtils.getStringValue(oMElement);
        X509Certificate x509Certificate = null;
        byte[] byArray = null;
        String string = null;
        if (tokenConsumerConfig != null) {
            string = Integer.valueOf(tokenConsumerConfig.hashCode()).toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Hash code of the token config object = " + string);
            }
        }
        if (certCacheManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking the cached X509Certificate object with the key[" + (String)object5 + "].");
            }
            try {
                object4 = certCacheManager.getCachedCert((String)object5 + string);
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException(soapSecurityException, clsName + ".processElement", "723");
                throw new LoginException(soapSecurityException.toString());
            }
            if (object4 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no cached certificiate.");
                }
            } else if (object4 instanceof X509Certificate) {
                x509Certificate = (X509Certificate)object4;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The X509Certificate [" + x509Certificate.getSubjectDN().getName() + "] was found.");
                }
                try {
                    byArray = x509Certificate.getEncoded();
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    Tr.processException(certificateEncodingException, clsName + ".processElement", "738");
                    Tr.error(tc, "security.wssecurity.WSEC0155E", certificateEncodingException);
                    String string2 = ConfigUtil.getMessage("security.wssecurity.WSEC0155E", new String[]{certificateEncodingException.toString()});
                    throw new LoginException(string2);
                }
            } else if (tc.isDebugEnabled()) {
                object3 = new StringBuffer("The certificate [");
                ((StringBuffer)object3).append(object4.getClass().getName());
                ((StringBuffer)object3).append("] was found, but it's not the X509Certificate object.");
                Tr.debug(tc, ((StringBuffer)object3).toString());
            }
        }
        if (x509Certificate == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the X509Certificate object through the LoginModule.");
            }
            if (object5 != null) {
                byArray = Base64.decode((String)object5);
            }
            if (byArray == null) {
                object4 = ConfigUtil.getMessage("security.wssecurity.PkiPathCallbackHandler.s02");
                throw new LoginException((String)object4);
            }
            try {
                x509Certificate = CertificateUtil.generateX509Certificate(byArray, null);
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + ".processElement", "772");
                Tr.error(tc, "security.wssecurity.X509LoginModule.s01", exception);
                object3 = ConfigUtil.getMessage("security.wssecurity.X509LoginModule.s01", new String[]{exception.toString()});
                throw new LoginException((String)object3);
            }
            if (!x509ConsumeCallback.isTrustAnyCertificate()) {
                X509ConsumeLoginModule.validateX509(x509Certificate, x509ConsumeCallback);
            }
            if (certCacheManager != null) {
                try {
                    certCacheManager.cacheCert((String)object5 + string, x509Certificate);
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.processException(soapSecurityException, clsName + ".processElement", "787");
                    throw new LoginException(soapSecurityException.toString());
                }
            }
        }
        object4 = x509TokenImpl;
        object3 = x509Certificate;
        byte[] byArray2 = byArray;
        AccessController.doPrivileged(new PrivilegedAction<Object>((X509TokenImpl)object4, (X509Certificate)object3, byArray2){
            final /* synthetic */ X509TokenImpl val$tempToken;
            final /* synthetic */ X509Certificate val$tempx509;
            final /* synthetic */ byte[] val$tempbinary;
            {
                this.val$tempToken = x509TokenImpl;
                this.val$tempx509 = x509Certificate;
                this.val$tempbinary = byArray;
            }

            @Override
            public Object run() {
                this.val$tempToken.setCertificate(this.val$tempx509);
                this.val$tempToken.setBinary(this.val$tempbinary);
                return null;
            }
        });
        if (x509ConsumeCallback.existKeyStore()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is a keystore in the configuration.");
            }
            try {
                object2 = KeyStoreManager.getInstance();
                object = ((KeyStoreManager)object2).getKeyInformation(x509ConsumeCallback.getKeyStorePath(), x509ConsumeCallback.getKeyStoreType(), x509ConsumeCallback.getKeyStorePassword(), x509ConsumeCallback.getKeyStoreReference(), x509ConsumeCallback.getAlias(), x509ConsumeCallback.getKeyPassword(), x509ConsumeCallback.getKeyName());
                X509Certificate x509Certificate2 = (X509Certificate)((KeyStoreManager.KeyInformation)object).getCertificate();
                if (!x509Certificate.equals(x509Certificate2)) {
                    String string3 = x509Certificate == null ? null : x509Certificate.getSubjectDN().getName();
                    String string4 = x509Certificate2 == null ? null : x509Certificate2.getSubjectDN().getName();
                    String string5 = ConfigUtil.getMessage("security.wssecurity.WSEC6809E", new String[]{string3, string4, x509ConsumeCallback.getKeyStorePath()});
                    throw new LoginException(string5);
                }
                x509TokenImpl.setKey(63, ((KeyStoreManager.KeyInformation)object).getPublicOrSecretKey());
                x509TokenImpl.setKey(64, ((KeyStoreManager.KeyInformation)object).getPrivateOrSecretKey());
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException(soapSecurityException, clsName + ".processElement", "826");
                throw new LoginException(soapSecurityException.toString());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is NO keystore in the configuration.");
            }
            x509TokenImpl.setKey(63, x509Certificate.getPublicKey());
        }
        object2 = x509TokenImpl;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The X509Token hash value = " + x509TokenImpl.hashCode());
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("processElement(");
            ((StringBuffer)object).append("X509TokenImpl, OMElement, TokenConsumerConfig, CertCacheManager, ");
            ((StringBuffer)object).append("SOAPMessageContext, boolean, boolean, SecurityTokenManager, Map)");
            ((StringBuffer)object).append(" returns X509TokenImpl[").append(object2).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void validateX509(X509Certificate x509Certificate, X509ConsumeCallback x509ConsumeCallback) throws LoginException {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            object3 = new StringBuffer("validateX509(");
            ((StringBuffer)object3).append("X509Certificate x509[");
            ((StringBuffer)object3).append(x509Certificate == null ? null : x509Certificate.getSubjectDN().getName()).append("], ");
            ((StringBuffer)object3).append("X509ConsumeCallback x509Callback)");
            Tr.entry(tc, ((StringBuffer)object3).toString());
        }
        if ((object3 = x509ConsumeCallback.getCertPathParameter()) == null) {
            Object object4;
            object2 = KeyStoreManager.getInstance();
            object = null;
            try {
                object = ((KeyStoreManager)object2).getKeyStore(x509ConsumeCallback.getTrustAnchorPath(), x509ConsumeCallback.getTrustAnchorType(), x509ConsumeCallback.getTrustAnchorPassword(), null);
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException(soapSecurityException, clsName + ".validateX509", "873");
                throw new LoginException(soapSecurityException.toString());
            }
            try {
                object4 = new X509CertSelector();
                object3 = new PKIXBuilderParameters((KeyStore)object, (CertSelector)object4);
                ((PKIXParameters)object3).setDate(null);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                Tr.processException(invalidAlgorithmParameterException, clsName + ".validateX509", "881");
                Tr.error(tc, "security.wssecurity.CommonReceiverConfig.s12", new String[]{invalidAlgorithmParameterException.getMessage()});
                String string = ConfigUtil.getMessage("security.wssecurity.CommonReceiverConfig.s12", new String[]{invalidAlgorithmParameterException.getMessage()});
                throw new LoginException(string);
            }
            catch (KeyStoreException keyStoreException) {
                Tr.processException(keyStoreException, clsName + ".validateX509", "889");
                Tr.error(tc, ".CommonReceiverConfig.s12", new String[]{keyStoreException.getMessage()});
                String string = ConfigUtil.getMessage("security.wssecurity.CommonReceiverConfig.s12", new String[]{keyStoreException.getMessage()});
                throw new LoginException(string);
            }
            object4 = x509ConsumeCallback.getCertStores();
            if (object4 != null) {
                Iterator iterator = object4.iterator();
                while (iterator.hasNext()) {
                    CertStore certStore = (CertStore)iterator.next();
                    ((PKIXParameters)object3).addCertStore(certStore);
                }
            }
        } else {
            object2 = object3;
            synchronized (object2) {
                object3 = (PKIXBuilderParameters)((PKIXParameters)object3).clone();
            }
        }
        object2 = x509ConsumeCallback.getProvider();
        try {
            CertificateUtil.validateX509Certificate(x509Certificate, (Provider)object2, (PKIXParameters)object3);
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".validateX509", "916");
            throw new LoginException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("validateX509(");
            ((StringBuffer)object).append("X509Certificate, X509ConsumeCallback)");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
    }
}

