/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecurityPermission;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.axis2.util.ObjectStateUtils;

public class UsernameTokenImpl
extends SecurityTokenImpl
implements UsernameToken {
    private static final TraceComponent tc = Tr.register(UsernameTokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = 993421755380734658L;
    private static final String VERSION_NUMBER = "1.0";
    private static final SecurityPermission GETPASSWORD_PERM = new SecurityPermission("wssapi.UsernameToken.getPassword");
    private static final SecurityPermission GETXML_PERM = new SecurityPermission("wssapi.UsernameToken.getXML");
    private static final SecurityPermission SETUSERNAME_PERM = new SecurityPermission("wssapi.UsernameToken.setUsername");
    private static final SecurityPermission SETPASSWORD_PERM = new SecurityPermission("wssapi.UsernameToken.setPassword");
    private static final SecurityPermission SETCREATED_PERM = new SecurityPermission("wssapi.UsernameToken.setCreated");
    private static final SecurityPermission SETNONCE_PERM = new SecurityPermission("wssapi.UsernameToken.setNonce");
    protected String username;
    protected char[] password;
    protected int hashcode = 0;
    private Date created;
    private byte[] nonce;

    public UsernameTokenImpl() {
        this.tokenQName = UsernameToken.TokenQname;
        this.valueType = UsernameToken.ValueType;
        this.hashcode = SecurityUIDGenerator.createUID().hashCode();
    }

    public void setValueType(QName qName) {
        this.valueType = qName;
    }

    public String getId() {
        if (this.id == null || this.id.length() == 0) {
            int n = 0;
            n = SecurityUIDGenerator.createUID().hashCode();
            this.id = "unt_" + String.valueOf(n);
        }
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETUSERNAME_PERM.toString());
            }
            securityManager.checkPermission(SETUSERNAME_PERM);
        }
        if (!this.readOnly) {
            this.username = string;
            this.principal = string;
        }
    }

    public char[] getPassword() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETPASSWORD_PERM.toString());
            }
            securityManager.checkPermission(GETPASSWORD_PERM);
        }
        char[] cArray = this.password;
        if (this.readOnly && cArray != null) {
            int n = this.password.length;
            cArray = new char[n];
            System.arraycopy(this.password, 0, cArray, 0, n);
        }
        return cArray;
    }

    public void setPassword(char[] cArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETPASSWORD_PERM.toString());
            }
            securityManager.checkPermission(SETPASSWORD_PERM);
        }
        if (!this.readOnly) {
            this.password = cArray;
        }
    }

    public Date getCreatedTime() {
        Date date = this.created;
        if (this.readOnly && date != null) {
            date = (Date)this.created.clone();
        }
        return date;
    }

    public void setCreatedTime(Date date) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETCREATED_PERM.toString());
            }
            securityManager.checkPermission(SETCREATED_PERM);
        }
        if (!this.readOnly) {
            this.created = date;
        }
    }

    public byte[] getNonce() {
        byte[] byArray = this.nonce;
        if (this.readOnly && this.nonce != null) {
            int n = this.nonce.length;
            byArray = new byte[n];
            System.arraycopy(this.nonce, 0, byArray, 0, n);
        }
        return byArray;
    }

    public void setNonce(byte[] byArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETNONCE_PERM.toString());
            }
            securityManager.checkPermission(SETNONCE_PERM);
        }
        if (!this.readOnly) {
            this.nonce = byArray;
        }
    }

    public int getIteration() {
        return 0;
    }

    public String getSalt() {
        return null;
    }

    public XMLStructure getXML() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETXML_PERM.toString());
            }
            securityManager.checkPermission(GETXML_PERM);
        }
        XMLStructure xMLStructure = this.xml;
        if (this.readOnly && xMLStructure != null) {
            xMLStructure = new OMStructure(((OMStructure)xMLStructure).getNode().cloneOMElement());
        }
        return xMLStructure;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.principal;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof UsernameToken)) {
            return false;
        }
        return object.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.getId() != null) {
                stringBuffer.append(this.getId());
            }
            if (this.username != null) {
                stringBuffer.append(this.username);
            }
            if (this.password != null) {
                stringBuffer.append(new String(this.password));
            }
            this.hashcode = stringBuffer.length() > 0 ? stringBuffer.hashCode() : SecurityUIDGenerator.createUID().hashCode();
        }
        return this.hashcode;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        String string = ObjectStateUtils.readString(objectInput, "UsernameToken.version");
        if (VERSION_NUMBER.equals(string)) {
            this.username = ObjectStateUtils.readString(objectInput, "UsernameToken.username");
            Object object = ObjectStateUtils.readObject(objectInput, "UsernameToken.password");
            if (object != null) {
                this.password = (char[])object;
            }
            if ((object = ObjectStateUtils.readObject(objectInput, "UsernameToken.created")) != null) {
                this.created = (Date)object;
            }
            if ((object = ObjectStateUtils.readObject(objectInput, "UsernameToken.nonce")) != null) {
                this.nonce = (byte[])object;
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        ObjectStateUtils.writeString(objectOutput, VERSION_NUMBER, "UsernameToken.version");
        ObjectStateUtils.writeString(objectOutput, this.username, "UsernameToken.username");
        ObjectStateUtils.writeObject(objectOutput, this.password, "UsernameToken.password");
        ObjectStateUtils.writeObject(objectOutput, this.created, "UsernameToken.created");
        ObjectStateUtils.writeObject(objectOutput, this.nonce, "UsernameToken.nonce");
    }
}

