/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.UNTGenerateCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.ws.wssecurity.core.WSSGenerator;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactoryFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.UsernameTokenImpl;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.MessageContext;

public class UNTGenerateLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(UNTGenerateLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = UNTGenerateLoginModule.class.getName();
    private static String _factoryKey = (String)WSSecurityFactoryBuilder.getImplClassName("com.ibm.ws.wssecurity.platform.UsernameToken");
    private static TokenFactory _tokenFactory = TokenFactoryFactory.getTokenFactory(_factoryKey);
    private CallbackHandler _handler;
    private List<SecurityToken> _processedTokens;
    private List<SecurityToken> _insertedTokens;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;
    private boolean shouldCacheUsernameTokens = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = callbackHandler;
        this._processedTokens = new ArrayList<SecurityToken>();
        this._insertedTokens = new ArrayList<SecurityToken>();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        NameCallback nameCallback = new NameCallback("username: ");
        PasswordCallback passwordCallback = new PasswordCallback("password: ", false);
        UNTGenerateCallback uNTGenerateCallback = new UNTGenerateCallback();
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbackArray = new Callback[]{nameCallback, passwordCallback, uNTGenerateCallback, propertyCallback};
        try {
            this._handler.handle(callbackArray);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".login", "112", this);
            Tr.error(tc, "security.wssecurity.BSTokenLoginModule.s01", exception);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{exception.toString()}));
        }
        this._context = propertyCallback.getProperties();
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        NonceManager nonceManager = (NonceManager)this._context.get(NonceManager.class);
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        String string = null;
        char[] cArray = null;
        boolean bl = uNTGenerateCallback.isNonce();
        boolean bl2 = uNTGenerateCallback.isCreatedTimestamp();
        if (uNTGenerateCallback.isUsedRunAsSubject()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the RunAs identity...");
            }
            if (messageContext != null) {
                string = SecurityTokenManagerImpl.getRunAsIdentity(messageContext);
            }
        }
        if (string == null) {
            UsernameToken usernameToken;
            if (uNTGenerateCallback.isUsedIdentityAssertion()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking the identifier of initial sender...");
                }
                if (messageContext != null && (object2 = messageContext.getProperty("com.ibm.wsspi.wssecurity.username.initialSenderId")) != null && object2 instanceof UsernameToken) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The identifier of initial sender is used.");
                    }
                    usernameToken = (UsernameToken)object2;
                    string = usernameToken.getUsername();
                }
            } else if (messageContext != null) {
                if (this._context != null && this._context.get("com.ibm.ws.wssecurity.UNTGUIPromptCallbackHandler.cacheTokens") != null) {
                    this.shouldCacheUsernameTokens = true;
                }
                if (this.shouldCacheUsernameTokens) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking the cached username token...");
                    }
                    if ((object2 = messageContext.getProperty("com.ibm.wsspi.wssecurity.username.basicAuthToken")) != null && object2 instanceof UsernameToken) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The cached username token is used.");
                        }
                        usernameToken = (UsernameToken)object2;
                        string = usernameToken.getUsername();
                        object = usernameToken;
                        cArray = (char[])AccessController.doPrivileged(new PrivilegedAction<Object>((UsernameToken)object){
                            final /* synthetic */ UsernameToken val$tokenPriv;
                            {
                                this.val$tokenPriv = usernameToken;
                            }

                            @Override
                            public Object run() {
                                return this.val$tokenPriv.getPassword();
                            }
                        });
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No username token in the cache.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The cache will not be checked");
                }
            }
        }
        if (string == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Use username and password set by callbach handler [" + this._handler + "].");
            }
            string = nameCallback.getName();
            cArray = passwordCallback.getPassword();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Acquired username is [" + string + "].");
            Tr.debug(tc, "Acuqired password is [" + (cArray == null ? "null" : "XXXXXXXX") + "].");
        }
        object2 = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        boolean bl3 = true;
        object = (String)object2.getProperties().get("com.ibm.ws.wssecurity.token.forwardable");
        if (object != null && ((String)object).equalsIgnoreCase("false")) {
            bl3 = false;
        }
        SecurityToken securityToken = null;
        String string2 = string;
        try {
            securityToken = UNTGenerateLoginModule.getToken((TokenGeneratorConfig)object2, string, cArray, this._securityTokenManager);
        }
        catch (SoapSecurityException soapSecurityException) {
            Tr.processException((Throwable)soapSecurityException, clsName + ".login", "209", this);
            throw new LoginException(soapSecurityException.toString());
        }
        if (securityToken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no token [" + string2 + "] stored in the Subject.");
            }
            UsernameTokenImpl usernameTokenImpl = (UsernameTokenImpl)_tokenFactory.getToken(bl3);
            usernameTokenImpl.setUsername(string);
            usernameTokenImpl.setPassword(cArray);
            usernameTokenImpl.setKey(61, null);
            usernameTokenImpl.setKey(62, null);
            int n = 0;
            Object object3 = null;
            object3 = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
            if (object3 != null && object3 instanceof Integer) {
                n = (Integer)object3;
            }
            OMElement oMElement = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
            OMElement oMElement2 = UNTGenerateLoginModule.createTokenElement(oMElement.getOMFactory(), oMElement, string, cArray, string2, bl, bl2, n, nonceManager);
            usernameTokenImpl.setXML(new OMStructure(oMElement2));
            this._processedTokens.add(usernameTokenImpl);
            this._insertedTokens.add(usernameTokenImpl);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is the token [" + securityToken.getId() + "] stored in the Subject.");
            }
            this._processedTokens.add(securityToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        int n = this._processedTokens.size();
        for (int i = 0; i < n; ++i) {
            SecurityToken securityToken = this._processedTokens.get(i);
            this._securityTokenManager.addToken(securityToken);
            if (!this.shouldCacheUsernameTokens) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Caching the UsernameToken from the UNTGUIPromptCallbackHandler: " + ((UsernameToken)securityToken).getUsername());
            }
            WSSGenerator.addClientCacheUsernameTokenKeyToMessage(messageContext, (UsernameToken)securityToken);
        }
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        this._context.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private static final SecurityToken getToken(TokenGeneratorConfig tokenGeneratorConfig, String string, char[] cArray, SecurityTokenManager securityTokenManager) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getToken(");
            ((StringBuffer)object).append("TokenGeneratorConfig config, ");
            ((StringBuffer)object).append("String username[").append(string).append("], ");
            ((StringBuffer)object).append("char[] password[");
            ((StringBuffer)object).append(cArray == null ? "null" : "not null");
            ((StringBuffer)object).append("], SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        Collection<SecurityToken> collection = securityTokenManager.getTokens(tokenGeneratorConfig);
        if (collection != null && collection.size() > 0) {
            for (SecurityToken securityToken : collection) {
                UsernameToken usernameToken;
                if (!(securityToken instanceof UsernameToken) || !(usernameToken = (UsernameToken)securityToken).getUsername().equals(string) || !UNTGenerateLoginModule.equalsCharArray(((UsernameToken)securityToken).getPassword(), cArray)) continue;
                object = securityToken;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getToken(");
            stringBuffer.append("TokenGeneratorConfig, String, char[], SecurityTokenManager)");
            stringBuffer.append(" returns SecurityToken[").append(object).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    private static final OMElement createTokenElement(OMFactory oMFactory, OMElement oMElement, String string, char[] cArray, String string2, boolean bl, boolean bl2, int n, NonceManager nonceManager) throws LoginException {
        Object object;
        Object object2;
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("createTokenElement(");
            ((StringBuffer)charSequence).append("OMFactory factory, ");
            ((StringBuffer)charSequence).append("OMElement parent[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)charSequence).append("String username[").append(string).append("], ");
            ((StringBuffer)charSequence).append("char[] password [");
            ((StringBuffer)charSequence).append(cArray == null ? "null" : "not null").append("], ");
            ((StringBuffer)charSequence).append("String id[").append(string2).append("], ");
            ((StringBuffer)charSequence).append("boolean setNonce[").append(bl).append("], ");
            ((StringBuffer)charSequence).append("boolean setCreatedTimestamp[").append(bl2).append("], ");
            ((StringBuffer)charSequence).append("int wssVersion[").append(n).append("], ");
            ((StringBuffer)charSequence).append("NonceManager nmanager)");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        charSequence = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][n];
        String string3 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][n];
        boolean bl3 = false;
        String string4 = null;
        if (oMElement != null) {
            string4 = DOMUtils.getNamespacePrefix(oMElement, (String)charSequence);
        }
        if (string4 == null) {
            bl3 = true;
            string4 = "wsse";
        }
        OMElement oMElement2 = oMFactory.createOMElement("UsernameToken", (String)charSequence, string4);
        if (bl3) {
            oMElement2.declareNamespace((String)charSequence, string4);
        }
        if (string2 != null) {
            bl3 = false;
            object2 = DOMUtils.getNamespacePrefix(oMElement, string3);
            if (object2 == null) {
                bl3 = true;
                object2 = "wsu";
            }
            if (bl3) {
                oMElement2.declareNamespace(string3, (String)object2);
            }
            oMElement2.addAttribute("Id", string2, oMElement2.getOMFactory().createOMNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSU, (String)object2));
        }
        object2 = oMFactory.createOMElement("Username", com.ibm.ws.wssecurity.common.Constants.NS_WSSE, string4);
        object2.addChild(oMFactory.createOMText(string));
        oMElement2.addChild((OMNode)object2);
        if (cArray != null && cArray.length > 0) {
            object = oMFactory.createOMElement("Password", com.ibm.ws.wssecurity.common.Constants.NS_WSSE, string4);
            DOMUtils.setQNameAttr((OMElement)object, null, "Type", com.ibm.ws.wssecurity.common.Constants.PASSWORD_TEXT, n);
            object.addChild(oMFactory.createOMText(new String(cArray)));
            oMElement2.addChild((OMNode)object);
        }
        if (bl2) {
            try {
                NonceUtil.addCreated(oMFactory, oMElement2, string3);
            }
            catch (SoapSecurityException soapSecurityException) {
                throw new LoginException(soapSecurityException.toString());
            }
        }
        if (bl) {
            try {
                NonceUtil.addNonce(oMFactory, oMElement2, (String)charSequence, nonceManager, null);
            }
            catch (SoapSecurityException soapSecurityException) {
                throw new LoginException(soapSecurityException.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("createTokenElement(");
            ((StringBuffer)object).append("OMFactory, OMElement, String, char[], String, boolean, boolean, int)");
            ((StringBuffer)object).append(" returns OMElement [").append(oMElement2).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return oMElement2;
    }

    private static final boolean equalsCharArray(char[] cArray, char[] cArray2) {
        boolean bl;
        block6: {
            block5: {
                bl = true;
                if (cArray != null) break block5;
                if (cArray2 == null) break block6;
                bl = false;
                break block6;
            }
            if (cArray2 == null) {
                bl = false;
            } else {
                int n = cArray.length;
                int n2 = cArray2.length;
                if (n != n2) {
                    bl = false;
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (cArray[i] == cArray2[i]) continue;
                        bl = false;
                        break;
                    }
                }
            }
        }
        return bl;
    }
}

