/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.UNTConsumeCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Constants0;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.token.WSSUserRegistryProcessor;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.util.WSSecurityFactoryBuilder;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.TokenFactoryFactory;
import com.ibm.ws.wssecurity.wssapi.token.impl.UsernameTokenImpl;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.util.Date;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class UNTConsumeLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(UNTConsumeLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = UNTConsumeLoginModule.class.getName();
    private static final QName TYPE_Q = new QName("", "Type");
    private static String _factoryKey = (String)WSSecurityFactoryBuilder.getImplClassName("com.ibm.ws.wssecurity.platform.UsernameToken");
    private static TokenFactory _tokenFactory = TokenFactoryFactory.getTokenFactory(_factoryKey);
    private CallbackHandler _handler;
    private SecurityToken _token;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;
    public static final QName PASSWORD_TEXT_PRE_ERRATA_RCVR = new QName(com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "PasswordText");
    public static final QName PASSWORD_TEXT_PRE_ERRATA = new QName("", com.ibm.ws.wssecurity.common.Constants.NS_WSSE + "#PasswordText");

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = callbackHandler;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        UNTConsumeCallback uNTConsumeCallback = new UNTConsumeCallback();
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbackArray = new Callback[]{uNTConsumeCallback, propertyCallback};
        try {
            this._handler.handle(callbackArray);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".login", "126", this);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{exception.toString()}));
        }
        this._context = propertyCallback.getProperties();
        TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
        boolean bl = true;
        String string = (String)tokenConsumerConfig.getProperties().get("com.ibm.ws.wssecurity.token.forwardable");
        if (string != null && string.equalsIgnoreCase("false")) {
            bl = false;
        }
        UsernameTokenImpl usernameTokenImpl = (UsernameTokenImpl)_tokenFactory.getToken(bl);
        this._context.put(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING, usernameTokenImpl);
        QName qName = tokenConsumerConfig.getType();
        if (!com.ibm.ws.wssecurity.common.Constants.UNTOKEN.equals(qName) && !com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.equals(qName)) {
            String string2 = ConfigUtil.getMessage("security.wssecurity.PrivateConsumerConfig.s30", new String[]{qName.toString(), com.ibm.ws.wssecurity.common.Constants.UNTOKEN.toString() + " or " + com.ibm.ws.wssecurity.common.Constants.UNTOKEN_11.toString()});
            throw new LoginException(string2);
        }
        usernameTokenImpl.setValueType(qName);
        OMElement oMElement = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        String string3 = null;
        QName qName2 = IdUtils.getInstance().getIdAttributeName(oMElement);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The identifier attribute of the target element is [" + qName2 + "].");
        }
        if (qName2 != null) {
            string3 = oMElement.getAttributeValue(qName2);
        }
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        SecurityToken securityToken = null;
        boolean bl2 = true;
        SecurityToken securityToken2 = this._securityTokenManager.getToken(tokenConsumerConfig, string3);
        if (securityToken2 == null) {
            Object object;
            Object object2;
            Object object3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no token [" + string3 + "] stored in the Subject.");
            }
            usernameTokenImpl.setId(string3);
            usernameTokenImpl.setXML(new OMStructure(oMElement));
            int n = 0;
            Object object4 = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
            if (object4 != null && object4 instanceof Integer) {
                n = (Integer)object4;
            }
            String string4 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][n];
            String string5 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][n];
            String string6 = null;
            try {
                object3 = DOMUtils.getOneElement(oMElement, string4, "Username");
                string6 = DOMUtils.getStringValue((OMNode)object3);
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".login", "208", this);
                throw new LoginException(soapSecurityException.toString());
            }
            object3 = null;
            try {
                OMElement oMElement2 = DOMUtils.getZeroOrOneElement(oMElement, string4, "Password");
                if (oMElement2 != null) {
                    String string7 = oMElement2.getAttributeValue(TYPE_Q);
                    if (!(!ConfigUtil.hasValue(string7) || com.ibm.ws.wssecurity.common.Constants.PASSWORD_TEXT.equals(object2 = DOMUtils.getQName(oMElement2, string7, n)) || DOMUtils.equals(Constants0.PASSWORD_TEXT_RCVR, object2) || PASSWORD_TEXT_PRE_ERRATA.equals(object2) || DOMUtils.equals(PASSWORD_TEXT_PRE_ERRATA_RCVR, object2))) {
                        String string8 = object2 + " was supplied, but only " + com.ibm.ws.wssecurity.common.Constants.PASSWORD_TEXT + " is supported.";
                        throw new LoginException(string8);
                    }
                    object2 = DOMUtils.getStringValue(oMElement2);
                    if (object2 != null) {
                        object3 = ((String)object2).toCharArray();
                    }
                }
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".login", "239", this);
                throw new LoginException(soapSecurityException.toString());
            }
            boolean bl3 = uNTConsumeCallback.isNonce();
            boolean bl4 = uNTConsumeCallback.isCreatedTimestamp();
            object2 = null;
            try {
                object = (NonceManager)this._context.get(NonceManager.class);
                object2 = this.checkNonce(oMElement, tokenConsumerConfig, string4, string5, bl3, bl4, (NonceManager)object);
            }
            catch (SoapSecurityException soapSecurityException) {
                throw new LoginException(soapSecurityException.getMessage());
            }
            usernameTokenImpl.setCreatedTime((Date)object2);
            if (string6 != null && string6.length() > 0) {
                if (object3 != null && ((Object)object3).length > 0) {
                    boolean bl5 = WSSUserRegistryProcessor.checkRegistry(string6, (char[])object3);
                    if (!bl5) {
                        String string9 = ConfigUtil.getMessage("security.wssecurity.WSSUserRegistryProcessor.s01", new String[]{string6, "WSSUserRegistryProcessor.checkRegistry()=" + bl5});
                        throw new LoginException(string9);
                    }
                } else {
                    if (!ConfigUtil.isTrue((String)tokenConsumerConfig.getCallbackHandler().getProperties().get(Constants.WSSECURITY_USE_IDASSERTION))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No password, not UNT Identity Assertion Consumer");
                        }
                        object = ConfigUtil.getMessage("security.wssecurity.WSSUserRegistryProcessor.s01", new String[]{string6, "password is null"});
                        throw new LoginException((String)object);
                    }
                    boolean bl6 = WSSUserRegistryProcessor.checkUsername(string6);
                    if (!bl6) {
                        throw new LoginException(ConfigUtil.getMessage("security.wssecurity.WSSUserRegistryProcessor.s02", new String[]{string6, "WSSUserRegistryProcessor.checkUsername()=" + bl6}));
                    }
                }
                usernameTokenImpl.setUsername(string6);
                usernameTokenImpl.setPassword((char[])object3);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no username...");
                }
                bl2 = false;
            }
            securityToken = usernameTokenImpl;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is the token [" + string3 + "] stored in the Subject.");
            }
            securityToken = securityToken2;
        }
        this._token = securityToken;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return bl2;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        this._securityTokenManager.addToken(this._token);
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._token);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private Date checkNonce(OMElement oMElement, TokenConsumerConfig tokenConsumerConfig, String string, String string2, boolean bl, boolean bl2, NonceManager nonceManager) throws SoapSecurityException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            object2 = new StringBuffer("checkNonce(");
            ((StringBuffer)object2).append("Element target[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)object2).append("TokenConsumerConfig config, ");
            ((StringBuffer)object2).append("String nsWsse[").append(string).append("], ");
            ((StringBuffer)object2).append("String nsWsu[").append(string2).append("], ");
            ((StringBuffer)object2).append("boolean requiredNonce[").append(bl).append("], ");
            ((StringBuffer)object2).append("boolean requiredCreatedTimestamp[").append(bl2).append("], ");
            ((StringBuffer)object2).append("NonceManager nmanager)");
            Tr.entry(tc, ((StringBuffer)object2).toString());
        }
        object2 = tokenConsumerConfig.getProperties();
        int n = -1;
        Object v = object2.get(Constants.WSSECURITY_NONCE_MAX_AGE);
        if (v != null && v instanceof Integer) {
            n = (Integer)v;
        }
        int n2 = -1;
        v = object2.get(Constants.WSSECURITY_NONCE_CLOCK_SKEW);
        if (v != null && v instanceof Long) {
            n2 = (Integer)v;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "nonceMaxAge is [" + n + "].");
            Tr.debug(tc, "nonceClockSkew is [" + n2 + "].");
        }
        Date date = null;
        if (bl2) {
            object = DOMUtils.getChildElement(oMElement, string2, "Created");
            date = NonceUtil.checkNonceTimestamp((OMElement)object, string2, n, n2);
        }
        if (bl) {
            object = DOMUtils.getChildElement(oMElement, string, "Nonce");
            NonceUtil.checkNonce((OMElement)object, string, nonceManager);
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("checkNonce(");
            ((StringBuffer)object).append("Element, TokenConsumerConfig, String, String, ");
            ((StringBuffer)object).append("boolean, boolean, NonceManager nmanager)");
            ((StringBuffer)object).append(" returns Date [").append(date).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return date;
    }
}

