/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.TokenMapping;
import com.ibm.ws.wssecurity.wssapi.token.impl.Consumable;
import com.ibm.ws.wssecurity.wssapi.token.impl.Generatable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.Key;
import java.security.SecurityPermission;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.axis2.util.ObjectStateUtils;

public class SecurityTokenWrapper
implements SecurityToken,
Consumable,
Generatable,
Externalizable {
    private static final TraceComponent tc = Tr.register(SecurityTokenWrapper.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = 6615415757895974041L;
    private static final String VERSION_NUMBER = "1.0";
    private static final SecurityPermission SETKEYINFOTYPE_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setKeyInfoType");
    private static final SecurityPermission SETUSEDTOKENCONSUMER_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setUsedTokenConsumer");
    private static final SecurityPermission SETUSEDTOKENGENERATOR_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setUsedTokenGenerator");
    private static final SecurityPermission SETREADONLY_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setReadOnly");
    private static final SecurityPermission SETREFERENCED_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setReferenced");
    private static final SecurityPermission SETPROCESSED_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setProcessed");
    private static final SecurityPermission SETERROR_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setError");
    private static final SecurityPermission SETUSEDTOLOGIN_PERM = new SecurityPermission("wssapi.SecurityTokenWrapper.setUsedToLogin");
    private static Map<Integer, String> referenceMap = new HashMap<Integer, String>();
    private String wssapiLoginConfigName;
    private CallbackHandler wssapiCallbackHandler;
    private int wssapiReferenceType;
    private SecurityToken securityToken;
    private String keyInfoType;
    private SoapSecurityException error;
    private int usedTokenGeneratorHash;
    private int usedTokenConsumerHash;
    private int usedTokenConsumerClass;
    private boolean referenced;
    private boolean processed;
    private boolean usedToLogin;
    private boolean defaultImpl = false;
    private boolean readOnly = false;

    public SecurityTokenWrapper(SecurityToken securityToken) {
        if (securityToken instanceof SecurityTokenImpl) {
            this.defaultImpl = true;
        }
        this.securityToken = securityToken;
    }

    public SecurityTokenWrapper(SecurityToken securityToken, CallbackHandler callbackHandler, String string) {
        if (securityToken instanceof SecurityTokenImpl) {
            this.defaultImpl = true;
        }
        this.securityToken = securityToken;
        this.wssapiCallbackHandler = callbackHandler;
        this.wssapiLoginConfigName = string;
    }

    public SecurityTokenWrapper(SecurityToken securityToken, CallbackHandler callbackHandler, boolean bl) {
        if (securityToken instanceof SecurityTokenImpl) {
            this.defaultImpl = true;
        }
        this.securityToken = securityToken;
        this.wssapiCallbackHandler = callbackHandler;
        Map<QName, TokenMapping> map = DefaultValueManager.getInstance().getTokenMapping();
        TokenMapping tokenMapping = map.get(securityToken.getValueType());
        String string = bl ? tokenMapping.getJaasLoginConfigNameForGenerator() : tokenMapping.getJaasLoginConfigNameForConsumer();
        this.wssapiLoginConfigName = string;
    }

    public Key getKey(int n) throws WSSException {
        return this.securityToken.getKey(n);
    }

    public XMLStructure getXML() {
        XMLStructure xMLStructure = this.securityToken.getXML();
        if (!this.defaultImpl && this.readOnly && xMLStructure != null) {
            xMLStructure = new OMStructure(((OMStructure)xMLStructure).getNode().cloneOMElement());
        }
        return xMLStructure;
    }

    public String getId() {
        return this.securityToken.getId();
    }

    public String getReferenceURI() {
        return this.securityToken.getReferenceURI();
    }

    public String getKeyIdentifier() {
        return this.securityToken.getKeyIdentifier();
    }

    public QName getKeyIdentifierEncodingType() {
        return this.securityToken.getKeyIdentifierEncodingType();
    }

    public QName getKeyIdentifierValueType() {
        return this.securityToken.getKeyIdentifierEncodingType();
    }

    public String getKeyName() {
        return this.securityToken.getKeyName();
    }

    public QName getValueType() {
        return this.securityToken.getValueType();
    }

    public QName getTokenQname() {
        return this.securityToken.getTokenQname();
    }

    public String getThumbprint() {
        return this.securityToken.getThumbprint();
    }

    public QName getThumbprintValueType() {
        return this.securityToken.getThumbprintValueType();
    }

    public QName getThumbprintEncodingType() {
        return this.securityToken.getThumbprintEncodingType();
    }

    public String getPrincipal() {
        return this.securityToken.getPrincipal();
    }

    public CallbackHandler getWssapiCallbackHandler() {
        return this.wssapiCallbackHandler;
    }

    public String getWssapiLoginConfigName() {
        return this.wssapiLoginConfigName;
    }

    public int getWssapiReferenceType() {
        return this.wssapiReferenceType;
    }

    public String getWssapiReferenceTypeByStr() {
        return referenceMap.get(this.wssapiReferenceType);
    }

    public void setWssapiReferenceType(int n) {
        this.wssapiReferenceType = n;
    }

    public SecurityToken getSecurityToken() {
        return this.securityToken;
    }

    public String getKeyInfoType() {
        return this.keyInfoType;
    }

    public void setKeyInfoType(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETKEYINFOTYPE_PERM.toString());
            }
            securityManager.checkPermission(SETKEYINFOTYPE_PERM);
        }
        if (!this.readOnly) {
            this.keyInfoType = string;
        }
    }

    public int getUsedTokenGeneratorHash() {
        return this.usedTokenGeneratorHash;
    }

    public void setUsedTokenGenerator(int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETUSEDTOKENGENERATOR_PERM.toString());
            }
            securityManager.checkPermission(SETUSEDTOKENGENERATOR_PERM);
        }
        if (!this.readOnly) {
            this.usedTokenGeneratorHash = n;
        }
    }

    public int getUsedTokenConsumerClass() {
        return this.usedTokenConsumerClass;
    }

    public int getUsedTokenConsumerHash() {
        return this.usedTokenConsumerHash;
    }

    public void setUsedTokenConsumer(int n, int n2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETUSEDTOKENCONSUMER_PERM.toString());
            }
            securityManager.checkPermission(SETUSEDTOKENCONSUMER_PERM);
        }
        if (!this.readOnly) {
            this.usedTokenConsumerHash = n;
            this.usedTokenConsumerClass = n2;
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETREADONLY_PERM.toString());
            }
            securityManager.checkPermission(SETREADONLY_PERM);
        }
        if (this.defaultImpl) {
            ((SecurityTokenImpl)this.securityToken).readOnly = true;
        }
        this.readOnly = true;
    }

    public boolean isReferenced() {
        return this.referenced;
    }

    public void setReferenced(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETREFERENCED_PERM.toString());
            }
            securityManager.checkPermission(SETREFERENCED_PERM);
        }
        if (!this.readOnly) {
            this.referenced = bl;
        }
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETPROCESSED_PERM.toString());
            }
            securityManager.checkPermission(SETPROCESSED_PERM);
        }
        if (!this.readOnly) {
            this.processed = bl;
        }
    }

    public SoapSecurityException getError() {
        return this.error;
    }

    public void setError(SoapSecurityException soapSecurityException) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETERROR_PERM.toString());
            }
            securityManager.checkPermission(SETERROR_PERM);
        }
        if (!this.readOnly) {
            this.error = soapSecurityException;
        }
    }

    public boolean isUsedToLogin() {
        return this.usedToLogin;
    }

    public void setUsedToLogin(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETUSEDTOLOGIN_PERM.toString());
            }
            securityManager.checkPermission(SETUSEDTOLOGIN_PERM);
        }
        if (!this.readOnly) {
            this.usedToLogin = bl;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = ObjectStateUtils.readString(objectInput, "SecurityTokenWrapper.version");
        if (VERSION_NUMBER.equals(string)) {
            this.wssapiLoginConfigName = ObjectStateUtils.readString(objectInput, "SecurityTokenWrapper.wssapiLoginConfigName");
            Object object = ObjectStateUtils.readObject(objectInput, "SecurityTokenWrapper.wssapiCallBackHandler");
            if (object != null) {
                this.wssapiCallbackHandler = (CallbackHandler)object;
            }
            this.wssapiReferenceType = objectInput.readInt();
            object = ObjectStateUtils.readObject(objectInput, "SecurityTokenWrapper.securityToken");
            if (object != null) {
                this.securityToken = (SecurityToken)object;
            }
            this.keyInfoType = ObjectStateUtils.readString(objectInput, "SecurityTokenWrapper.keyInfoType");
            object = ObjectStateUtils.readObject(objectInput, "SecurityTokenWrapper.error");
            if (object != null) {
                this.error = (SoapSecurityException)object;
            }
            this.usedTokenGeneratorHash = objectInput.readInt();
            this.usedTokenConsumerHash = objectInput.readInt();
            this.usedTokenConsumerClass = objectInput.readInt();
            this.referenced = objectInput.readBoolean();
            this.processed = objectInput.readBoolean();
            this.usedToLogin = objectInput.readBoolean();
            this.defaultImpl = objectInput.readBoolean();
            this.readOnly = objectInput.readBoolean();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ObjectStateUtils.writeString(objectOutput, VERSION_NUMBER, "SecurityTokenWrapper.version");
        ObjectStateUtils.writeString(objectOutput, this.wssapiLoginConfigName, "SecurityTokenWrapper.wssapiLoginConfigName");
        ObjectStateUtils.writeObject(objectOutput, this.wssapiCallbackHandler, "SecurityTokenWrapper.wssapiCallBackHandler");
        objectOutput.writeInt(this.wssapiReferenceType);
        ObjectStateUtils.writeObject(objectOutput, this.securityToken, "SecurityTokenWrapper.securityToken");
        ObjectStateUtils.writeString(objectOutput, this.keyInfoType, "SecurityTokenWrapper.keyInfoType");
        ObjectStateUtils.writeObject(objectOutput, this.error, "SecurityTokenWrapper.error");
        objectOutput.writeInt(this.usedTokenGeneratorHash);
        objectOutput.writeInt(this.usedTokenConsumerHash);
        objectOutput.writeInt(this.usedTokenConsumerClass);
        objectOutput.writeBoolean(this.referenced);
        objectOutput.writeBoolean(this.processed);
        objectOutput.writeBoolean(this.usedToLogin);
        objectOutput.writeBoolean(this.defaultImpl);
        objectOutput.writeBoolean(this.readOnly);
    }

    static {
        referenceMap.put(65, "STRREF");
        referenceMap.put(66, "KEYID");
        referenceMap.put(67, "EMB");
        referenceMap.put(68, "THUMBPRINT");
        referenceMap.put(71, "X509ISSUER");
    }
}

