/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.wsspi.security.context.Context;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityTokenManagerImpl
implements SecurityTokenManager {
    private static final TraceComponent tc = Tr.register(SecurityTokenManagerImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SecurityTokenManagerImpl.class.getName();
    private final Map<Object, Object> _context;
    private final Map<SecurityToken, SecurityTokenWrapper> _tokenMapping;

    public SecurityTokenManagerImpl(Map<Object, Object> map) {
        this._context = map;
        this._tokenMapping = new HashMap<SecurityToken, SecurityTokenWrapper>();
        this.initializeSubject();
    }

    public Map<Object, Object> getContext() {
        return this._context;
    }

    private final void initializeSubject() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeSubject()");
        }
        this._context.put("com.ibm.wsspi.wssecurity.core.securityTokenManager", this);
        Object object = this._context.get("com.ibm.wsspi.wssecurity.core.subject");
        if (object == null || !(object instanceof Subject)) {
            Subject subject = new Subject();
            this._context.put("com.ibm.wsspi.wssecurity.core.subject", subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeSubject()");
        }
    }

    public final void integrateSubject() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "integrateSubject()");
        }
        if (this._context != null) {
            MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
            Subject subject = (Subject)this._context.get("com.ibm.wsspi.wssecurity.core.subject");
            boolean bl = Axis2Util.isServiceProvider(messageContext);
            if (bl) {
                String string;
                Context context = (Context)messageContext.getProperty("com.ibm.wsspi.websphere.security.SecurityContext");
                Subject subject2 = null;
                try {
                    subject2 = context.getCallerSubject();
                }
                catch (Exception exception) {
                    throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject02", exception);
                }
                if (subject2 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The caller subject is null.");
                    }
                } else {
                    messageContext.setProperty("com.ibm.ws.wssecurity.constants.callerSubject", subject2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Stored the caller subject.");
                    }
                }
                Subject subject3 = null;
                try {
                    subject3 = context.getRunAsSubject();
                }
                catch (Exception exception) {
                    Tr.processException(exception, clsName + ".finalizeSubject", "153");
                    throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject03", exception);
                }
                if (subject3 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The invocation subject is null.");
                    }
                } else {
                    messageContext.setProperty("com.ibm.ws.wssecurity.constants.invocationSubject", subject3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Stored the invocation subject.");
                    }
                }
                try {
                    context.setCallerSubject(subject);
                }
                catch (Exception exception) {
                    throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject04", exception);
                }
                if (tc.isDebugEnabled()) {
                    string = subject == null ? "null" : "not null";
                    Tr.debug(tc, "Replaced the caller subject [" + string + "]");
                }
                try {
                    context.setRunAsSubject(subject);
                }
                catch (Exception exception) {
                    throw SoapSecurityException.format("security.wssecurity.TokenManager.finalizeSubject05", exception);
                }
                if (tc.isDebugEnabled()) {
                    string = subject == null ? "null" : "not null";
                    Tr.debug(tc, "Replaced the invocation subject [" + string + "]");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "integrateSubject()");
        }
    }

    public final void finalizeSubject() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "finalizeSubject()");
        }
        if (this._context != null) {
            this._context.remove("com.ibm.wsspi.wssecurity.core.subject");
            this._context.remove("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        }
        this._tokenMapping.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finalizeSubject()");
        }
    }

    @Override
    public final void addToken(SecurityToken securityToken) {
        SecurityToken securityToken2;
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("addToken(");
            ((StringBuffer)object).append("SecurityToken token[").append(securityToken).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        if (securityToken != null && !(object = this.getTokens()).contains(securityToken2 = securityToken)) {
            final Subject subject = (Subject)this._context.get("com.ibm.wsspi.wssecurity.core.subject");
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    subject.getPrivateCredentials().add(securityToken2);
                    return null;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToken(SecurityToken)");
        }
    }

    @Override
    public final SecurityToken getToken(TokenConsumerConfig tokenConsumerConfig, String string) {
        Object object;
        Object object2;
        block6: {
            block5: {
                if (tc.isEntryEnabled()) {
                    object2 = new StringBuffer("getToken(");
                    ((StringBuffer)object2).append("TokenConsumerConfig tconfig, ");
                    ((StringBuffer)object2).append("String id[").append(string).append("])");
                    Tr.entry(tc, ((StringBuffer)object2).toString());
                }
                object2 = null;
                if (tokenConsumerConfig != null) break block5;
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "Since TokenConsumerConfig is null, the runtime can't identify a token.");
                break block6;
            }
            object = this.getTokens();
            Iterator<SecurityToken> iterator = object.iterator();
            while (iterator.hasNext()) {
                SecurityToken securityToken = iterator.next();
                String string2 = securityToken.getId();
                if (string2 == null || !string2.equals(string)) continue;
                SecurityTokenWrapper securityTokenWrapper = this._tokenMapping.get(securityToken);
                if (securityTokenWrapper == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "One candidate (tokenId=\"" + string2 + "\" found.");
                        Tr.debug(tc, "But since there is no TokenConsumerConfig corresponding to the token. the runtime just returns the token.");
                    }
                    object2 = securityToken;
                    break;
                }
                if (tokenConsumerConfig.hashCode() != securityTokenWrapper.getUsedTokenConsumerHash()) continue;
                object2 = securityToken;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getToken(");
            ((StringBuffer)object).append("TokenConsumerConfig, String)");
            ((StringBuffer)object).append(" returns SecurityToken [").append(object2).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return object2;
    }

    @Override
    public final SecurityToken getToken(String string) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getToken(");
            ((StringBuffer)object).append("String id[").append(string).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        Collection<SecurityToken> collection = this.getTokens();
        for (SecurityToken object2 : collection) {
            String string2 = object2.getId();
            if (string2 == null || !string2.equals(string)) continue;
            object = object2;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getToken(String)");
            stringBuffer.append(" returns SecurityToken [").append(object).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    @Override
    public final void addTokens(Collection<SecurityToken> collection) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("addTokens(");
            ((StringBuffer)object).append("Collection tokens[").append(collection).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        if (collection != null) {
            object = collection;
            AccessController.doPrivileged(new PrivilegedAction<Object>((Collection)object){
                final /* synthetic */ Collection val$tws;
                {
                    this.val$tws = collection;
                }

                @Override
                public Object run() {
                    Subject subject = (Subject)SecurityTokenManagerImpl.this._context.get("com.ibm.wsspi.wssecurity.core.subject");
                    if (subject == null) {
                        Tr.error(tc, "security.wssecurity.TokenManager.subjectIsNull");
                    } else {
                        subject.getPrivateCredentials().addAll(this.val$tws);
                    }
                    return null;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTokens(Collection)");
        }
    }

    @Override
    public final Collection<SecurityToken> getTokens() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokens()");
        }
        Collection<SecurityToken> collection = null;
        final Subject subject = (Subject)this._context.get("com.ibm.wsspi.wssecurity.core.subject");
        if (subject == null) {
            Tr.error(tc, "security.wssecurity.TokenManager.subjectIsNull");
        } else {
            collection = AccessController.doPrivileged(new PrivilegedAction<Collection<SecurityToken>>(){

                @Override
                public Collection<SecurityToken> run() {
                    Set<SecurityToken> set = subject.getPrivateCredentials(SecurityToken.class);
                    return set;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getTokens()");
            stringBuffer.append(" returns Collection [").append(collection).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return collection;
    }

    @Override
    public Collection<SecurityToken> getTokens(TokenGeneratorConfig tokenGeneratorConfig) {
        Object object;
        Iterator<SecurityTokenWrapper> iterator;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getTokens(");
            ((StringBuffer)serializable).append("TokenGeneratorConfig tconfig[").append(tokenGeneratorConfig).append("])");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = null;
        if (tokenGeneratorConfig != null && (iterator = (object = this.getTokenWrappers()).iterator()).hasNext()) {
            serializable = new HashSet();
            while (iterator.hasNext()) {
                SecurityTokenWrapper securityTokenWrapper = iterator.next();
                if (securityTokenWrapper.getUsedTokenGeneratorHash() != tokenGeneratorConfig.hashCode()) continue;
                serializable.add(securityTokenWrapper.getSecurityToken());
            }
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getTokens(TokenGeneratorConfig)");
            ((StringBuffer)object).append(" returns Collection [").append(serializable).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return serializable;
    }

    @Override
    public Collection<SecurityToken> getTokens(TokenGeneratorConfig tokenGeneratorConfig, String string) {
        Object object;
        Iterator<SecurityTokenWrapper> iterator;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getTokens(");
            ((StringBuffer)serializable).append("TokenGeneratorConfig tconfig[").append(tokenGeneratorConfig).append("], ");
            ((StringBuffer)serializable).append("String keyInfoType[").append(string).append("])");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = null;
        if (tokenGeneratorConfig != null && (iterator = (object = this.getTokenWrappers()).iterator()).hasNext()) {
            serializable = new HashSet();
            while (iterator.hasNext()) {
                SecurityTokenWrapper securityTokenWrapper = iterator.next();
                if (securityTokenWrapper.getUsedTokenGeneratorHash() != tokenGeneratorConfig.hashCode() || !securityTokenWrapper.getKeyInfoType().equals(string)) continue;
                serializable.add(securityTokenWrapper.getSecurityToken());
            }
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getTokens(TokenGeneratorConfig, String)");
            ((StringBuffer)object).append(" returns Collection [").append(serializable).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return serializable;
    }

    @Override
    public Collection<SecurityToken> getTokens(TokenConsumerConfig tokenConsumerConfig) {
        Object object;
        Iterator<SecurityTokenWrapper> iterator;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getTokens(");
            ((StringBuffer)serializable).append("TokenConsumerConfig tconfig[").append(tokenConsumerConfig).append("])");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = null;
        if (tokenConsumerConfig != null && (iterator = (object = this.getTokenWrappers()).iterator()).hasNext()) {
            serializable = new HashSet();
            while (iterator.hasNext()) {
                SecurityTokenWrapper securityTokenWrapper = iterator.next();
                if (securityTokenWrapper.getUsedTokenConsumerHash() != tokenConsumerConfig.hashCode()) continue;
                serializable.add(securityTokenWrapper.getSecurityToken());
            }
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getTokens(TokenConsumerConfig)");
            ((StringBuffer)object).append(" returns Collection [").append(serializable).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return serializable;
    }

    @Override
    public final Collection<SecurityToken> getTokens(String string) {
        Object object;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getTokens(");
            ((StringBuffer)serializable).append("String id[").append(string).append("])");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = null;
        Collection<SecurityToken> collection = this.getTokens();
        Iterator<SecurityToken> iterator = collection.iterator();
        if (iterator.hasNext()) {
            serializable = new HashSet();
            while (iterator.hasNext()) {
                object = iterator.next();
                String string2 = object.getId();
                if (string2 == null || !string2.equals(string)) continue;
                serializable.add(object);
            }
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getTokens(String)");
            ((StringBuffer)object).append(" returns Collection [").append(serializable).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return serializable;
    }

    @Override
    public final void removeToken(SecurityToken securityToken) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("removeToken(");
            ((StringBuffer)object).append("SecurityToken token[").append(securityToken).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        if (securityToken != null) {
            object = securityToken;
            AccessController.doPrivileged(new PrivilegedAction<Object>((SecurityToken)object){
                final /* synthetic */ SecurityToken val$t;
                {
                    this.val$t = securityToken;
                }

                @Override
                public Object run() {
                    Subject subject = (Subject)SecurityTokenManagerImpl.this._context.get("com.ibm.wsspi.wssecurity.core.subject");
                    if (subject == null) {
                        Tr.error(tc, "security.wssecurity.TokenManager.subjectIsNull");
                    } else {
                        subject.getPrivateCredentials().remove(this.val$t);
                    }
                    return null;
                }
            });
            this._tokenMapping.remove(object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeToken(SecurityToken)");
        }
    }

    @Override
    public final void removeTokens(Collection<SecurityToken> collection) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("removeTokens(");
            ((StringBuffer)object).append("Set tokens[").append(collection).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        if (collection != null) {
            object = collection;
            AccessController.doPrivileged(new PrivilegedAction<Object>((Collection)object){
                final /* synthetic */ Collection val$ts;
                {
                    this.val$ts = collection;
                }

                @Override
                public Object run() {
                    Subject subject = (Subject)SecurityTokenManagerImpl.this._context.get("com.ibm.wsspi.wssecurity.core.subject");
                    if (subject == null) {
                        Tr.error(tc, "security.wssecurity.TokenManager.subjectIsNull");
                    } else {
                        subject.getPrivateCredentials().removeAll(this.val$ts);
                    }
                    return null;
                }
            });
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                this._tokenMapping.remove(iterator.next());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeTokens(Collection)");
        }
    }

    @Override
    public final void removeAllTokens() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllTokens()");
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Subject subject = (Subject)SecurityTokenManagerImpl.this._context.get("com.ibm.wsspi.wssecurity.core.subject");
                if (subject == null) {
                    Tr.error(tc, "security.wssecurity.TokenManager.subjectIsNull");
                } else {
                    Set<SecurityToken> set = subject.getPrivateCredentials(SecurityToken.class);
                    subject.getPrivateCredentials().removeAll(set);
                }
                return null;
            }
        });
        this._tokenMapping.clear();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllTokens()");
        }
    }

    public final void addTokenWrapper(SecurityTokenWrapper securityTokenWrapper) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("addTokenWrapper(");
            ((StringBuffer)object).append("SecurityTokenWrapper tokenWrapper[").append(securityTokenWrapper).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = securityTokenWrapper.getSecurityToken();
        this._tokenMapping.put((SecurityToken)object, securityTokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTokenWrapper(SecurityTokenWrapper)");
        }
    }

    public final SecurityTokenWrapper getTokenWrapper(SecurityToken securityToken) {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getTokenWrapper(");
            ((StringBuffer)serializable).append("SecurityToken token[").append(securityToken).append("])");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = this._tokenMapping.get(securityToken);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getTokenWrapper(");
            stringBuffer.append("SecurityToken)");
            stringBuffer.append(" returns SecurityTokenWrapper [").append(serializable).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return serializable;
    }

    public final SecurityTokenWrapper getUnprocessedTokenWrapper() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnprocessedTokenWrapper()");
        }
        SecurityTokenWrapper securityTokenWrapper = null;
        Collection<SecurityTokenWrapper> collection = this._tokenMapping.values();
        for (SecurityTokenWrapper serializable : collection) {
            if (serializable.isProcessed()) continue;
            securityTokenWrapper = serializable;
            break;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getUnprocessedTokenWrapper()");
            stringBuffer.append(" returns SecurityTokenWrapper [").append(securityTokenWrapper).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return securityTokenWrapper;
    }

    public final Collection<SecurityTokenWrapper> getTokenWrappers() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenWrappers()");
        }
        Collection<SecurityTokenWrapper> collection = this._tokenMapping.values();
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getTokenWrappers()");
            stringBuffer.append(" returns Collection[").append(collection).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return collection;
    }

    public final Collection<SecurityTokenWrapper> getTokenWrappers(Collection<SecurityToken> collection) {
        Object object;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getTokenWrappers(");
            ((StringBuffer)serializable).append("Collection tokens[").append(collection).append("])");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = null;
        if (collection != null && (object = collection.iterator()).hasNext()) {
            serializable = new HashSet();
            while (object.hasNext()) {
                SecurityToken securityToken = (SecurityToken)object.next();
                SecurityTokenWrapper securityTokenWrapper = this._tokenMapping.get(securityToken);
                if (securityTokenWrapper == null) continue;
                serializable.add(securityTokenWrapper);
            }
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getTokenWrappers(Collection)");
            ((StringBuffer)object).append(" returns Collection [").append(serializable).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return serializable;
    }

    public final void addTokenWrappers(Collection<SecurityTokenWrapper> collection) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("addTokenWrappers(");
            ((StringBuffer)object).append("Collection tokenWrappers[").append(collection).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        if (collection != null) {
            object = collection;
            Map<SecurityToken, SecurityTokenWrapper> map = this._tokenMapping;
            AccessController.doPrivileged(new PrivilegedAction<Object>((Collection)object, map){
                final /* synthetic */ Collection val$tws;
                final /* synthetic */ Map val$tms;
                {
                    this.val$tws = collection;
                    this.val$tms = map;
                }

                @Override
                public Object run() {
                    Subject subject = (Subject)SecurityTokenManagerImpl.this._context.get("com.ibm.wsspi.wssecurity.core.subject");
                    if (subject == null) {
                        Tr.error(tc, "security.wssecurity.TokenManager.subjectIsNull");
                    } else {
                        Set<Object> set = subject.getPrivateCredentials();
                        for (SecurityTokenWrapper securityTokenWrapper : this.val$tws) {
                            SecurityToken securityToken = securityTokenWrapper.getSecurityToken();
                            set.add(securityToken);
                            this.val$tms.put(securityToken, securityTokenWrapper);
                        }
                    }
                    return null;
                }
            });
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTokenWrappers(Collection)");
        }
    }

    public static final String getRunAsIdentity(final MessageContext messageContext) {
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("getRunAsIdentity(");
            ((StringBuffer)charSequence).append("MessageContext messageContext[").append(messageContext.getMessageID()).append("])");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        charSequence = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Iterator iterator;
                Object object;
                Subject subject = null;
                String string = null;
                try {
                    object = (Context)messageContext.getProperty("com.ibm.wsspi.websphere.security.SecurityContext");
                    subject = object.getRunAsSubject();
                    if (subject == null) {
                        Tr.error(tc, "security.wssecurity.TokenManager.finalizeSubject03");
                    }
                }
                catch (Exception exception) {
                    Tr.processException(exception, clsName + ".getRunAsIdentity", "919");
                    Tr.error(tc, "security.wssecurity.TokenManager.finalizeSubject03");
                }
                if (subject != null && (object = subject.getPrincipals()) != null && (iterator = object.iterator()).hasNext()) {
                    Principal principal = (Principal)iterator.next();
                    string = principal.getName();
                }
                return string;
            }
        });
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getRunAsIdentity(boolean)");
            stringBuffer.append(" returns String[").append((String)charSequence).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return charSequence;
    }

    public final void addToSubject(final Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToSubject(Subject)");
        }
        final Subject subject2 = (Subject)this._context.get("com.ibm.wsspi.wssecurity.core.subject");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (Object iterator : subject.getPublicCredentials()) {
                    if (iterator == null) continue;
                    if (!subject2.getPublicCredentials().contains(iterator)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding public object to Subject: " + iterator);
                        }
                        subject2.getPublicCredentials().add(iterator);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Public object already in Subject: " + iterator);
                }
                for (Object object : subject.getPrivateCredentials()) {
                    if (object == null) continue;
                    if (!subject2.getPrivateCredentials().contains(object)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding private object to Subject: " + object);
                        }
                        subject2.getPrivateCredentials().add(object);
                        continue;
                    }
                    if (object instanceof SecurityToken) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "ws-sec Token private object already in Subject: " + object);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Private object already in Subject: " + object);
                }
                for (Principal principal : subject.getPrincipals()) {
                    if (principal == null) continue;
                    if (!subject2.getPrincipals().contains(principal)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Adding principal object to Subject: " + principal);
                        }
                        subject2.getPrincipals().add(principal);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Principal object already in Subject: " + principal);
                }
                return null;
            }
        });
        this._context.put("com.ibm.wsspi.wssecurity.core.subject", subject2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToSubject(Subject)");
        }
    }
}

