/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.Consumable;
import com.ibm.ws.wssecurity.wssapi.token.impl.Generatable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.Key;
import java.security.SecurityPermission;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis2.util.ObjectStateUtils;

public abstract class SecurityTokenImpl
implements SecurityToken,
Generatable,
Consumable,
Externalizable {
    private static final String VERSION_NUMBER = "1.0";
    private static final TraceComponent tc = Tr.register(SecurityTokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    protected String id;
    protected String principal;
    protected QName valueType;
    protected QName tokenQName;
    private Map<Integer, Key> keyMap = new HashMap<Integer, Key>();
    protected XMLStructure xml;
    protected String referenceURI;
    private String keyIdentifier;
    protected QName keyIdentifierEncodingType;
    protected QName keyIdentifierValueType;
    private String keyName;
    private String thumbprint;
    private QName thumbprintValueType;
    private QName thumbprintEncodingType;
    private static final SecurityPermission GETKEY_SIG_PERM = new SecurityPermission("wssapi.SecurityTokenImpl.getKey.signingKey");
    private static final SecurityPermission GETKEY_ENC_PERM = new SecurityPermission("wssapi.SecurityTokenImpl.getKey.encryptingKey");
    private static final SecurityPermission GETKEY_VER_PERM = new SecurityPermission("wssapi.SecurityTokenImpl.getKey.verifingKey");
    private static final SecurityPermission GETKEY_DEC_PERM = new SecurityPermission("wssapi.SecurityTokenImpl.getKey.decryptingKey");
    protected boolean readOnly;

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        if (!this.readOnly) {
            this.id = string;
        }
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String string) {
        if (!this.readOnly) {
            this.principal = string;
        }
    }

    public QName getValueType() {
        return this.valueType;
    }

    public QName getTokenQname() {
        return this.tokenQName;
    }

    public Key getKey(int n) throws WSSException {
        SecurityManager securityManager;
        if (n == 61) {
            SecurityManager securityManager2 = System.getSecurityManager();
            if (securityManager2 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + GETKEY_SIG_PERM.toString());
                }
                securityManager2.checkPermission(GETKEY_SIG_PERM);
            }
        } else if (n == 62) {
            SecurityManager securityManager3 = System.getSecurityManager();
            if (securityManager3 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + GETKEY_ENC_PERM.toString());
                }
                securityManager3.checkPermission(GETKEY_ENC_PERM);
            }
        } else if (n == 63) {
            SecurityManager securityManager4 = System.getSecurityManager();
            if (securityManager4 != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + GETKEY_VER_PERM.toString());
                }
                securityManager4.checkPermission(GETKEY_VER_PERM);
            }
        } else if (n == 64 && (securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETKEY_DEC_PERM.toString());
            }
            securityManager.checkPermission(GETKEY_DEC_PERM);
        }
        return this.keyMap.get(n);
    }

    public void setKey(int n, Key key) {
        if (!this.readOnly) {
            this.keyMap.put(n, key);
        }
    }

    public XMLStructure getXML() {
        XMLStructure xMLStructure = this.xml;
        if (this.readOnly && xMLStructure != null) {
            xMLStructure = new OMStructure(((OMStructure)xMLStructure).getNode().cloneOMElement());
        }
        return xMLStructure;
    }

    public void setXML(XMLStructure xMLStructure) {
        if (!this.readOnly) {
            this.xml = xMLStructure;
        }
    }

    public String getReferenceURI() {
        return this.referenceURI;
    }

    public void setReferenceURI(String string) {
        if (!this.readOnly) {
            this.referenceURI = string;
        }
    }

    public String getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public void setKeyIdentifier(String string) {
        if (!this.readOnly) {
            this.keyIdentifier = string;
        }
    }

    public QName getKeyIdentifierEncodingType() {
        return this.keyIdentifierEncodingType;
    }

    public void setKeyIdentifierEncodingType(QName qName) {
        if (!this.readOnly && qName != null) {
            this.keyIdentifierEncodingType = qName;
        }
    }

    public QName getKeyIdentifierValueType() {
        return this.keyIdentifierValueType;
    }

    public void setKeyIdentifierValueType(QName qName) {
        if (!this.readOnly && qName != null) {
            this.keyIdentifierValueType = qName;
        }
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String string) {
        if (!this.readOnly) {
            this.keyName = string;
        }
    }

    public String getThumbprint() {
        return this.thumbprint;
    }

    public void setThumbprint(String string) {
        if (!this.readOnly) {
            this.thumbprint = string;
        }
    }

    public QName getThumbprintEncodingType() {
        return this.thumbprintEncodingType;
    }

    public void setThumbprintEncodingType(QName qName) {
        if (!this.readOnly) {
            this.thumbprintEncodingType = qName;
        }
    }

    public QName getThumbprintValueType() {
        return this.thumbprintValueType;
    }

    public void setThumbprintValueType(QName qName) {
        if (!this.readOnly) {
            this.thumbprintValueType = qName;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = ObjectStateUtils.readString(objectInput, "SecurityToken.version");
        if (VERSION_NUMBER.equals(string)) {
            HashMap hashMap;
            this.id = ObjectStateUtils.readString(objectInput, "SecurityToken.id");
            this.principal = ObjectStateUtils.readString(objectInput, "SecurityToken.principal");
            Object object = ObjectStateUtils.readObject(objectInput, "SecurityToken.valueType");
            if (object != null) {
                this.valueType = (QName)object;
            }
            if ((object = ObjectStateUtils.readObject(objectInput, "SecurityToken.tokenQName")) != null) {
                this.tokenQName = (QName)object;
            }
            this.keyMap = (hashMap = ObjectStateUtils.readHashMap(objectInput, "SecurityToken.keyMap")) != null ? new HashMap<Integer, Key>(hashMap) : new HashMap<Integer, Key>();
            this.xml = null;
            object = ObjectStateUtils.readObject(objectInput, "SecurityToken.xml");
            if (object != null) {
                this.xml = (XMLStructure)object;
            }
            this.referenceURI = ObjectStateUtils.readString(objectInput, "SecurityToken.referenceURI");
            this.keyIdentifier = ObjectStateUtils.readString(objectInput, "SecurityToken.keyIdentifier");
            object = ObjectStateUtils.readObject(objectInput, "SecurityToken.keyIdentifierEncodingType");
            if (object != null) {
                this.keyIdentifierEncodingType = (QName)object;
            }
            if ((object = ObjectStateUtils.readObject(objectInput, "SecurityToken.keyIdentifierValueType")) != null) {
                this.keyIdentifierValueType = (QName)object;
            }
            this.keyName = ObjectStateUtils.readString(objectInput, "SecurityToken.keyName");
            this.thumbprint = ObjectStateUtils.readString(objectInput, "SecurityToken.thumbprint");
            object = ObjectStateUtils.readObject(objectInput, "SecurityToken.thumbprintValueType");
            if (object != null) {
                this.thumbprintValueType = (QName)object;
            }
            if ((object = ObjectStateUtils.readObject(objectInput, "SecurityToken.thumbprintEncodingType")) != null) {
                this.thumbprintEncodingType = (QName)object;
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ObjectStateUtils.writeString(objectOutput, VERSION_NUMBER, "SecurityToken.version");
        ObjectStateUtils.writeString(objectOutput, this.id, "SecurityToken.id");
        ObjectStateUtils.writeObject(objectOutput, this.principal, "SecurityToken.principal");
        ObjectStateUtils.writeObject(objectOutput, this.valueType, "SecurityToken.valueType");
        ObjectStateUtils.writeObject(objectOutput, this.tokenQName, "SecurityToken.tokenQName");
        ObjectStateUtils.writeHashMap(objectOutput, (HashMap)this.keyMap, "SecurityToken.keyMap");
        ObjectStateUtils.writeObject(objectOutput, this.xml, "SecurityToken.xml");
        ObjectStateUtils.writeString(objectOutput, this.referenceURI, "SecurityToken.referenceURI");
        ObjectStateUtils.writeString(objectOutput, this.keyIdentifier, "SecurityToken.keyIdentifier");
        ObjectStateUtils.writeObject(objectOutput, this.keyIdentifierEncodingType, "SecurityToken.keyIdentifierEncodingType");
        ObjectStateUtils.writeObject(objectOutput, this.keyIdentifierValueType, "SecurityToken.keyIdentifierValueType");
        ObjectStateUtils.writeString(objectOutput, this.keyName, "SecurityToken.keyName");
        ObjectStateUtils.writeString(objectOutput, this.thumbprint, "SecurityToken.thumbprint");
        ObjectStateUtils.writeObject(objectOutput, this.thumbprintValueType, "SecurityToken.thumbprintValueType");
        ObjectStateUtils.writeObject(objectOutput, this.thumbprintEncodingType, "SecurityToken.thumbprintEncodingType");
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.id;
    }
}

