/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.security.trust10.TrustException;
import com.ibm.security.trust10.client.STSRequestorFactory;
import com.ibm.security.trust10.types.IRSTTemplate;
import com.ibm.security.trust10.types.IRequestSecurityTokenResponse;
import com.ibm.security.trust10.types.IRequestSecurityTokenResponseCollection;
import com.ibm.security.trust10.types.IRequestedSecurityToken;
import com.ibm.security.trust10.types.ISTSConfiguration;
import com.ibm.websphere.wssecurity.callbackhandler.SCTGenerateCallbackHandler;
import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSGenerationContext;
import com.ibm.websphere.wssecurity.wssapi.token.DerivedKeyToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheHelper;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.spi.BindingProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCTWrapper
extends SCT {
    private static final TraceComponent tc = Tr.register(SCTWrapper.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String clsName = SCTWrapper.class.getName();
    private static final long serialVersionUID = -3367052060192133610L;
    private SCT sctReference = null;
    private String currentInstance = null;
    private BindingProvider bindingProvider = null;
    private static final String comp = "security.wssecurity";
    private SecurityTokenManagerImpl securityTokenManager = null;

    public SCTWrapper() {
    }

    public SCTWrapper(String string, SCT.KeyHistoryEntry[] keyHistoryEntryArray, String string2, String string3) {
        super(string, keyHistoryEntryArray);
        this.id = string2;
        this.currentInstance = string3;
    }

    public SCT getSCT() {
        return this.sctReference;
    }

    public void setSCT(SCT sCT) {
        if (!this.readOnly) {
            this.sctReference = sCT;
        }
    }

    public String getCurrentInstance() {
        return this.currentInstance;
    }

    public void setCurrentInstance(String string) {
        if (!this.readOnly) {
            this.currentInstance = string;
        }
    }

    @Override
    public void renew() throws WSSException {
        this.renew(this.getSCT().getWssGenerationContext(), this.getSCT().getWssConsumingContext());
    }

    @Override
    public void renew(WSSGenerationContext wSSGenerationContext, WSSConsumingContext wSSConsumingContext) throws WSSException {
        String[] stringArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "renew in SCTWrapper (WSSGenerateionContext gencont, WSSConsumingContext concont)");
        }
        SCT sCT = this.getSCT();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT config map = " + sCT.getMap());
            Tr.debug(tc, "Current SCT information, SCT UUID = " + sCT.getUUID());
            Tr.debug(tc, "SCTWrapper, Current Instance = " + this.currentInstance);
            Tr.debug(tc, "SCT ID = " + this.id);
            Tr.debug(tc, "SCT element = " + DOMUtils.toString(((OMStructure)this.xml).getNode()));
            stringArray = this.getInstances();
            for (int i = 0; i < stringArray.length; ++i) {
                Tr.debug(tc, "SCT Instance [" + i + "]" + " = " + stringArray[i]);
            }
        }
        if (!sCT.isValid(this.currentInstance, 0L) && !sCT.isRenewableAfterExpiration()) {
            throw WSSException.format("security.wssecurity.WSEC7072E");
        }
        sCT.setWssGenerationContext(wSSGenerationContext);
        sCT.setWssConsumingContext(wSSConsumingContext);
        stringArray = sCT.getMap();
        STSRequestorFactory sTSRequestorFactory = new STSRequestorFactory();
        ISTSConfiguration iSTSConfiguration = (ISTSConfiguration)sCT.getMap().get("STS_Conf");
        ServiceClient serviceClient = null;
        try {
            iSTSConfiguration.set("MESSAGE_ACTION", "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Renew");
            stringArray.put("STS_Conf", iSTSConfiguration);
            IRSTTemplate iRSTTemplate = (IRSTTemplate)stringArray.get("RSTTemplate");
            iRSTTemplate.set("RequestType", "http://schemas.xmlsoap.org/ws/2005/02/trust/Renew");
            iRSTTemplate.setRenewTarget(((OMStructure)this.xml).getNode());
            stringArray.put("RSTTemplate", iRSTTemplate);
            serviceClient = (ServiceClient)sTSRequestorFactory.init((Map)stringArray);
            if (serviceClient != null && serviceClient.getAxisService() != null) {
                serviceClient.getAxisService().addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
            }
            byte[] byArray = sTSRequestorFactory.getEntropyKey();
            wSSGenerationContext.process(serviceClient);
            wSSConsumingContext.process(serviceClient);
            IRequestSecurityTokenResponseCollection iRequestSecurityTokenResponseCollection = null;
            iRequestSecurityTokenResponseCollection = sTSRequestorFactory.renew(serviceClient);
            String string = null;
            Date date = null;
            Date date2 = null;
            String string2 = sCT.getUUID();
            Iterator<IRequestSecurityTokenResponse> iterator = iRequestSecurityTokenResponseCollection.getRSTRCollection();
            if (iterator.hasNext()) {
                String[] stringArray2;
                Object object;
                String string3;
                IRequestSecurityTokenResponse iRequestSecurityTokenResponse = iterator.next();
                byte[] byArray2 = iRequestSecurityTokenResponse.getSecret();
                String string4 = "Lifetime";
                IRequestedSecurityToken iRequestedSecurityToken = iRequestSecurityTokenResponse.getRequestedSecurityToken();
                String string5 = iRequestSecurityTokenResponse.getTokenCreated();
                String string6 = iRequestSecurityTokenResponse.getTokenExpires();
                if (string5 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error in getting SCT creation time. It was null");
                    }
                    Tr.error(tc, "security.wssecurity.WSEC7069E");
                    throw WSSException.format("security.wssecurity.WSEC7069E");
                }
                date = SCTWrapper.parseDateTime(string5);
                if (string6 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error in getting SCT expires time. It was null.");
                    }
                    Tr.error(tc, "security.wssecurity.WSEC7069E");
                    throw WSSException.format("security.wssecurity.WSEC7069E");
                }
                date2 = SCTWrapper.parseDateTime(string6);
                string4 = "KeySize";
                OMElement oMElement = (OMElement)iRequestSecurityTokenResponse.getTokenElement(string4);
                int n = 0;
                if (oMElement != null) {
                    string3 = oMElement.getText();
                    n = new Integer(string3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key Size from the RSTR = " + n);
                    }
                }
                string3 = "true";
                String string7 = "false";
                string4 = "Renewing";
                oMElement = (OMElement)iRequestSecurityTokenResponse.getTokenElement(string4);
                if (oMElement != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Renewing element from the RSTR looks like: " + DOMUtils.toString(oMElement));
                    }
                    string7 = oMElement.getAttributeValue(new QName("", "OK"));
                    string3 = oMElement.getAttributeValue(new QName("", "Allow"));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Renew properties of the token, isRenewable =  " + string3 + ", renewableAfterExpiration = " + string7);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Renewing information in the RSTR element. ");
                    Tr.debug(tc, "Renew properties of the token, isRenewable =  " + string3 + ", renewableAfterExpiration = " + string7);
                }
                string4 = "SecurityContextToken";
                OMElement oMElement2 = null;
                OMElement oMElement3 = (OMElement)iRequestedSecurityToken.getTokenElement(string4);
                if (oMElement3 != null) {
                    oMElement2 = oMElement3;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "sct element from the RSTR looks like: " + DOMUtils.toString(oMElement2));
                }
                String string8 = null;
                if (oMElement2 != null) {
                    object = DOMUtils.getChildElement(oMElement2, Constants.NS_WSC_SC, "Identifier");
                    string8 = DOMUtils.getStringValue((OMNode)object);
                    stringArray2 = IdUtils.getInstance().getIdAttributeName(oMElement2);
                    if (stringArray2 != null) {
                        this.id = oMElement2.getAttributeValue((QName)stringArray2);
                    }
                    if ((object = DOMUtils.getChildElement(oMElement2, Constants.NS_WSC_SC, "Instance")) != null) {
                        string = DOMUtils.getStringValue((OMNode)object);
                    }
                }
                object = new SCT.KeyHistoryEntry(string, byArray, byArray2, date, date2, SCT.SCTState.RENEWED);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RSTR returns with Requested Security Token: uuid = " + string8 + ", id = " + this.id + ", created = " + date.toString() + ", expires = " + date2.toString() + ", and instance = " + string + ", serverSecret = " + Base64.encode(byArray2) + ", clientEntropy = " + Base64.encode(byArray));
                }
                sCT = new SCT(string8);
                sCT.setUUID(string8);
                sCT.setId(this.id);
                if (this.getSCT() != null) {
                    stringArray2 = this.getSCT().getInstances();
                    for (int i = 0; i < stringArray2.length; ++i) {
                        sCT.setKeyHistoryEntry(this.getSCT().getKeyHistoryEntry(stringArray2[i]));
                    }
                }
                sCT.setKeyHistoryEntry((SCT.KeyHistoryEntry)object);
                sCT.setTokenID(this.id);
                sCT.setReferenceURI("#" + this.id);
                sCT.setClientID(string8);
                sCT.setMap((Map)stringArray);
                sCT.setUsedForSigAndEnc(true);
                sCT.setWssConsumingContext(wSSConsumingContext);
                sCT.setWssGenerationContext(wSSGenerationContext);
                sCT.setKeySize(n);
                sCT.setXML(new OMStructure(oMElement2));
                sCT.setRenewable(Boolean.valueOf(string3));
                sCT.setRenewableAfterExpiration(Boolean.valueOf(string7));
                this.setUUID(string8);
                this.setKeyHistoryEntry((SCT.KeyHistoryEntry)object);
                this.xml = new OMStructure(oMElement2);
                this.currentInstance = string;
                this.setSCT(sCT);
                this.setWssGenerationContext(wSSGenerationContext);
                this.setWssConsumingContext(wSSConsumingContext);
                this.setMap((Map)stringArray);
                SecureConversationCacheHelper.invalidateCache(string2);
                SecureConversationCacheHelper.setSecurityContextTokenToCache(string8, null, sCT, null);
            }
        }
        catch (TrustException trustException) {
            Tr.processException((Throwable)trustException, clsName + ".renew", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7070E", trustException);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".renew", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7070E", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, renew(WSSGenerateionContext gencont, WSSConsumingContext concont) return");
        }
    }

    public DerivedKeyToken getDerivedKeyToken() throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SCTWrapper, getDerivedKeyToken()");
        }
        SCT sCT = this.getSCT();
        Map<String, Object> map = this.getKeyAlgorithm(DefaultValueManager.getInstance().getDefaultSignatureAlgorithm());
        Map<String, Object> map2 = this.getKeyAlgorithm(DefaultValueManager.getInstance().getDefaultEncryptionAlgorithm());
        SCTGenerateCallbackHandler sCTGenerateCallbackHandler = new SCTGenerateCallbackHandler(this, sCT.getWssGenerationContext(), sCT.getWssConsumingContext(), (String)map.get("algorithm"), (Integer)map.get("keyLength"), (String)map2.get("algorithm"), (Integer)map2.get("keyLength"), "Default", "Default");
        DKToken dKToken = new DKToken();
        SecurityTokenWrapper securityTokenWrapper = new SecurityTokenWrapper((SecurityToken)dKToken, (CallbackHandler)sCTGenerateCallbackHandler, "system.wss.generate.sct");
        this.securityTokenManager.addTokenWrapper(securityTokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, getDerivedKeyToken() return");
        }
        return dKToken;
    }

    public DerivedKeyToken getDerivedKeyToken(String string) throws WSSException {
        return this.getDerivedKeyToken(string, "Default", "Default");
    }

    @Override
    public DerivedKeyToken getDerivedKeyToken(String string, String string2, String string3) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SCTWrapper, getDerivedKeyToken( " + string + ", " + string2 + ", " + string3 + ")");
        }
        if (string2 == null) {
            string2 = "Default";
        }
        if (string3 == null) {
            string3 = "Default";
        }
        SCT sCT = this.getSCT();
        Map<String, Object> map = this.getKeyAlgorithm(string);
        SCTGenerateCallbackHandler sCTGenerateCallbackHandler = null;
        sCTGenerateCallbackHandler = (Boolean)map.get("isSignature") != false ? new SCTGenerateCallbackHandler(this, sCT.getWssGenerationContext(), sCT.getWssConsumingContext(), (String)map.get("algorithm"), (Integer)map.get("keyLength"), null, 0, string2, string3) : new SCTGenerateCallbackHandler(this, sCT.getWssGenerationContext(), sCT.getWssConsumingContext(), null, 0, (String)map.get("algorithm"), (Integer)map.get("keyLength"), string2, string3);
        DKToken dKToken = new DKToken();
        SecurityTokenWrapper securityTokenWrapper = new SecurityTokenWrapper((SecurityToken)dKToken, (CallbackHandler)sCTGenerateCallbackHandler, "system.wss.generate.sct");
        this.securityTokenManager.addTokenWrapper(securityTokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, getDerivedKeyToken(String, String )");
        }
        return dKToken;
    }

    public DerivedKeyToken getDerivedKeyToken(String string, int n) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SCTWrapper, getDerivedKeyToken( " + string + ", " + n + ")");
        }
        Map<String, Object> map = this.getKeyAlgorithm(string);
        SCTGenerateCallbackHandler sCTGenerateCallbackHandler = null;
        SCT sCT = this.getSCT();
        sCTGenerateCallbackHandler = (Boolean)map.get("isSignature") != false ? new SCTGenerateCallbackHandler(this, sCT.getWssGenerationContext(), sCT.getWssConsumingContext(), (String)map.get("algorithm"), n, null, 0, "Default", "Defalut") : new SCTGenerateCallbackHandler(this, sCT.getWssGenerationContext(), sCT.getWssConsumingContext(), null, 0, (String)map.get("algorithm"), n, "Default", "Defalut");
        DKToken dKToken = new DKToken();
        SecurityTokenWrapper securityTokenWrapper = new SecurityTokenWrapper((SecurityToken)dKToken, (CallbackHandler)sCTGenerateCallbackHandler, "system.wss.generate.sct");
        this.securityTokenManager.addTokenWrapper(securityTokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, getDerivedKeyToken(String, int)");
        }
        return dKToken;
    }

    @Override
    public DerivedKeyToken getDerivedKeyToken(String string, int n, String string2, String string3) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SCTWrapper, getDerivedKeyToken( " + string + ", " + n + " , " + string2 + " , " + string3 + ")");
        }
        if (string2 == null) {
            string2 = "Default";
        }
        if (string3 == null) {
            string3 = "Default";
        }
        SCT sCT = this.getSCT();
        Map<String, Object> map = this.getKeyAlgorithm(string);
        SCTGenerateCallbackHandler sCTGenerateCallbackHandler = null;
        sCTGenerateCallbackHandler = (Boolean)map.get("isSignature") != false ? new SCTGenerateCallbackHandler(this, sCT.getWssGenerationContext(), sCT.getWssConsumingContext(), (String)map.get("algorithm"), n, null, 0, string2, string3) : new SCTGenerateCallbackHandler(this, sCT.getWssGenerationContext(), sCT.getWssConsumingContext(), null, 0, (String)map.get("algorithm"), n, string2, string3);
        DKToken dKToken = new DKToken();
        SecurityTokenWrapper securityTokenWrapper = new SecurityTokenWrapper((SecurityToken)dKToken, (CallbackHandler)sCTGenerateCallbackHandler, "system.wss.generate.sct");
        this.securityTokenManager.addTokenWrapper(securityTokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, getDerivedKeyToken(String, int, String)");
        }
        return dKToken;
    }

    private Map<String, Object> getKeyAlgorithm(String string) {
        Map map;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SCTWrapper, getKeyAlgorithm(String algName): algName=" + string);
        }
        if ((map = DefaultValueManager.getInstance().getSignatureAlgorithmMap().get(string)) != null) {
            map.put("isSignature", Boolean.TRUE);
        }
        if (map == null && (map = DefaultValueManager.getInstance().getEncryptionAlgorithmMap().get(string)) != null) {
            map.put("isSignature", Boolean.FALSE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, getKeyAlgorithm(String algName, int keyBytesLength) returns map" + map);
        }
        return map;
    }

    @Override
    public void cancel() throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SCTWrapper, cancel()");
        }
        final SCT sCT = this.getSCT();
        final BindingProvider bindingProvider = this.getBindingProvider();
        if (bindingProvider != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws WSSException {
                        sCT.cancel(bindingProvider);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (WSSException)privilegedActionException.getException();
            }
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws WSSException {
                    sCT.cancel();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (WSSException)privilegedActionException.getException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, cancel()");
        }
    }

    @Override
    public void cancel(WSSGenerationContext wSSGenerationContext, WSSConsumingContext wSSConsumingContext) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SCTWrapper, cancelSCT(WSSGenerationContext gencont, WSSConsumingContext concont)");
        }
        final SCT sCT = this.getSCT();
        final WSSGenerationContext wSSGenerationContext2 = wSSGenerationContext;
        final WSSConsumingContext wSSConsumingContext2 = wSSConsumingContext;
        final BindingProvider bindingProvider = this.getBindingProvider();
        if (bindingProvider != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws WSSException {
                        sCT.cancel(bindingProvider);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (WSSException)privilegedActionException.getException();
            }
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws WSSException {
                    sCT.cancel(wSSGenerationContext2, wSSConsumingContext2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (WSSException)privilegedActionException.getException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SCTWrapper, cancelSCT(WSSGenerationContext gencont, WSSConsumingContext concont) return");
        }
    }

    public void setBindingProvider(BindingProvider bindingProvider) {
        this.bindingProvider = bindingProvider;
    }

    public BindingProvider getBindingProvider() {
        return this.bindingProvider;
    }

    @Override
    public void setSecurityTokenManagerImpl(SecurityTokenManagerImpl securityTokenManagerImpl) {
        this.securityTokenManager = securityTokenManagerImpl;
    }
}

