/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.security.trust10.client.STSRequestorFactory;
import com.ibm.security.trust10.client.om.RSTTemplateImpl;
import com.ibm.security.trust10.client.om.STSConfigImpl;
import com.ibm.security.trust10.types.IRequestSecurityTokenResponse;
import com.ibm.security.trust10.types.IRequestSecurityTokenResponseCollection;
import com.ibm.security.trust10.types.IRequestedSecurityToken;
import com.ibm.security.trust10.util.DerivedKeyGenerator;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.SCTGenerateCallback;
import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSGenerationContext;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.wssecurity.handler.PolicyConfigUtil;
import com.ibm.ws.wssecurity.handler.PolicyOutboundConfig;
import com.ibm.ws.wssecurity.impl.auth.callback.SCTCallback;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheHelper;
import com.ibm.ws.wssecurity.sc.SecureConversationImpl;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NonceUtil;
import com.ibm.ws.wssecurity.util.SecurityUIDGenerator;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTWrapper;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecureConversationToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenImpl;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.io.Serializable;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.jaxws.ClientConfigurationFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCTGenerateLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(SCTGenerateLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SCTGenerateLoginModule.class.getName();
    public static final String XMLDSIG_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    public static final String XMLENC_NS = "http://www.w3.org/2001/04/xmlenc#";
    public static final String TRIPLEDES_CBC = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
    public static final String AES128_CBC = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    public static final String AES192_CBC = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
    public static final String AES256_CBC = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
    public static final String HMAC = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    public static final String RSA_1_5 = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
    public static final String KW_TRIPLEDES = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
    public static final String KWAES128 = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
    public static final String KWAES192 = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
    public static final String KWAES256 = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
    public static final String RSA = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String DSA = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private CallbackHandler _handler;
    private List<SecurityToken> _processedTokens;
    private List<SecurityToken> _insertedTokens;
    private OMNode _referencedTokenElement;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = callbackHandler;
        this._processedTokens = new ArrayList<SecurityToken>();
        this._insertedTokens = new ArrayList<SecurityToken>();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        PropertyCallback propertyCallback = new PropertyCallback(null);
        SCTCallback sCTCallback = new SCTCallback();
        SCTGenerateCallback sCTGenerateCallback = new SCTGenerateCallback();
        Callback[] callbackArray = new Callback[]{sCTCallback, sCTGenerateCallback, propertyCallback};
        try {
            this._handler.handle(callbackArray);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".login", "243", this);
            Tr.error(tc, "security.wssecurity.BSTokenLoginModule.s01", exception);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{exception.toString()}));
        }
        this._context = propertyCallback.getProperties();
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        boolean bl2 = bl = !sCTCallback.isExist();
        if (bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSAPI for WS-SC enables.");
            }
            this.loginForWSSAPI(sCTGenerateCallback, this._securityTokenManager);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The policy set for WS-SC enables.");
            }
            this.loginForPolicyset(sCTCallback, this._securityTokenManager);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login() returns.");
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final void loginForWSSAPI(SCTGenerateCallback var1_1, SecurityTokenManager var2_2) throws LoginException {
        if (SCTGenerateLoginModule.tc.isEntryEnabled()) {
            var3_3 = new StringBuffer("loginForWSSAPI(");
            var3_3.append("SCTGenerateCallback sctGenerateCallback, ");
            var3_3.append("SecurityTokenManager securityTokenManager)");
            Tr.entry(SCTGenerateLoginModule.tc, var3_3.toString());
        }
        var3_3 = null;
        var4_4 = null;
        var5_5 = SCTGenerateLoginModule.isExistedBootstrapPolicy(var1_1.getBindingProvider());
        if (var5_5) {
            if (SCTGenerateLoginModule.tc.isEntryEnabled()) {
                var6_6 = new StringBuffer("loginForWSSAPI(");
                var6_6.append("SCTCallback, SCTGenerateCallback)");
                Tr.exit(SCTGenerateLoginModule.tc, var6_6.toString());
            }
            return;
        }
        var6_7 = (SCT)var1_1.getToken();
        if (var6_7 == null) {
            var7_8 = var1_1.getWSSGenerationContext();
            var8_10 = var1_1.getWSSConsumingContext();
            var9_12 = var1_1.getServiceEndpointAddress();
            var3_3 = this.requestSCTusingWSSAPI(var7_8, var8_10, var9_12, var1_1);
            var1_1.setToken((SecurityContextToken)var3_3);
            this._processedTokens.add((SecurityToken)var3_3);
            if (SCTGenerateLoginModule.tc.isEntryEnabled()) {
                var10_14 = new StringBuffer("loginForWSSAPI(");
                var10_14.append("SCTCallback, SCTGenerateCallback)");
                Tr.exit(SCTGenerateLoginModule.tc, var10_14.toString());
            }
            return;
        }
        var7_9 = null;
        if (var6_7 instanceof SCTWrapper) {
            var3_3 = (SCTWrapper)var6_7;
            var6_7 = var3_3.getSCT();
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "SCT Generate callback getToken returns SCTWrapper");
                Tr.debug(SCTGenerateLoginModule.tc, "SCT configuration map = " + var3_3.getSCT().getMap().toString());
                Tr.debug(SCTGenerateLoginModule.tc, "Instance=" + var6_7.getInstances());
            }
        } else if (var6_7 instanceof SCT) {
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "SCT Generate callback getToken returns SCT");
                Tr.debug(SCTGenerateLoginModule.tc, "SCT configuration map = " + var6_7.getMap().toString());
            }
            var8_11 = null;
            var8_11 = var6_7.getInstances();
            if (var8_11 != null && ((String[])var8_11).length > 0) {
                var7_9 = var8_11[((String[])var8_11).length - 1];
            }
            var3_3 = SCTGenerateLoginModule.createSCTWrapper(var6_7, var7_9);
            var3_3.setSCT(var6_7);
        }
        var7_9 = var3_3.getCurrentInstance();
        if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
            Tr.debug(SCTGenerateLoginModule.tc, "SCT uuid = " + var6_7.getUUID() + " and SCT instance = " + var7_9);
        }
        if (var6_7 != null && var6_7.isValid(var7_9, 0L)) {
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "Security context token is a valid token");
            }
        } else {
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.invalidSCT"));
        }
        var8_11 = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        var9_13 = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        var10_15 = var9_13 == null ? false : ConfigUtil.isKeyInfoStrref(var9_13);
        var11_16 = 0;
        var12_17 = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (var12_17 != null && var12_17 instanceof Integer) {
            var11_16 = (Integer)var12_17;
        }
        var13_18 = false;
        try {
            var13_18 = SCTGenerateLoginModule.checkToken((TokenGeneratorConfig)var8_11, var9_13, (SecurityToken)var3_3, this._securityTokenManager);
        }
        catch (SoapSecurityException var14_19) {
            Tr.processException(var14_19, SCTGenerateLoginModule.clsName + ".login", "384");
            throw new LoginException(var14_19.toString());
        }
        var14_20 = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
            Tr.debug(SCTGenerateLoginModule.tc, " Looking for the SCT element in the message.. ");
        }
        var15_21 = false;
        var16_22 = null;
        var17_23 = DOMUtils.getChildElement(var14_20, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "SecurityContextToken");
        if (var17_23 != null) {
            var18_24 = DOMUtils.getChildElement(var17_23, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Identifier");
            if (var18_24 != null && (var19_25 = DOMUtils.getStringValue((OMNode)var18_24)).equals(var6_7.getUUID())) {
                this._referencedTokenElement = var17_23;
                var15_21 = true;
            }
            var19_25 = IdUtils.getInstance().getIdAttributeName(var17_23);
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "The identifier attribute of the target element is [" + var19_25 + "].");
            }
            if (var19_25 != null) {
                var16_22 = var17_23.getAttributeValue((QName)var19_25);
            }
        } else {
            this._processedTokens.add((SecurityToken)var3_3);
            this._insertedTokens.add((SecurityToken)var3_3);
        }
        if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
            Tr.debug(SCTGenerateLoginModule.tc, "SCT element exists in the message: " + var15_21);
        }
        if (!var13_18) {
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "SCT doesn't exist in the subject. ");
            }
            var18_24 = null;
            if (!var15_21) {
                var19_25 = null;
                if (var6_7.getInstances() != null && var6_7.getInstances().length > 1) {
                    if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(SCTGenerateLoginModule.tc, "SCT has more than one instance,instance should be included in the message. ");
                    }
                    var19_25 = var3_3.getCurrentInstance();
                }
                var16_22 = IdUtils.getInstance().makeUniqueId("sct_");
                if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(SCTGenerateLoginModule.tc, "Using SCT id = " + var16_22 + ", to create SCT token.");
                }
                var18_24 = SCTGenerateLoginModule.createTokenElement(var14_20.getOMFactory(), var14_20, var8_11.getType(), var16_22, var6_7.getIdentifier(), (String)var19_25, var11_16);
            } else {
                var18_24 = var17_23;
            }
            var3_3.setXML(new OMStructure((OMElement)var18_24));
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "security context token element looks like = " + DOMUtils.toString((OMNode)var18_24));
            }
        } else if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
            Tr.debug(SCTGenerateLoginModule.tc, "Found SCT in the subject. ");
        }
        var18_24 = (String)this._context.get(Constants.WSSECURITY_KEY_TYPE);
        if (var18_24 == null) {
            var20_27 = false;
            var19_26 = false;
        } else {
            var19_26 = "SigningKey".equals(var18_24);
            var20_27 = "EncryptingKey".equals(var18_24);
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                if (var19_26) {
                    Tr.debug(SCTGenerateLoginModule.tc, "Signing key type");
                } else if (var20_27) {
                    Tr.debug(SCTGenerateLoginModule.tc, " Encrypting key type");
                }
            }
        }
        try {
            var4_4 = SCTGenerateLoginModule.checkDKToken((TokenGeneratorConfig)var8_11, var9_13, (SCTWrapper)var3_3, var2_2);
        }
        catch (SoapSecurityException var21_28) {
            throw new LoginException(var21_28.getMessage());
        }
        if (var4_4 != null) {
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "DKT exists in the subject. id = " + var4_4.getId());
            }
            try {
                if (var20_27) {
                    if (var4_4.getKey(62) == null) ** GOTO lbl257
                    this._processedTokens.add(var4_4);
                    if (!SCTGenerateLoginModule.tc.isDebugEnabled()) ** GOTO lbl257
                    Tr.debug(SCTGenerateLoginModule.tc, "Found the encryption key in the DKT ");
                }
                if (!var19_26 || var4_4.getKey(61) == null) ** GOTO lbl257
                this._processedTokens.add(var4_4);
                if (!SCTGenerateLoginModule.tc.isDebugEnabled()) ** GOTO lbl257
                Tr.debug(SCTGenerateLoginModule.tc, "Found the signing key in the DKT ");
            }
            catch (WSSException var21_29) {
                throw new LoginException(var21_29.getMessage());
            }
        } else {
            var21_30 = var1_1.getSignatureAlgorithm();
            var22_31 = var1_1.getEncyptionAlgorithm();
            var23_32 = var1_1.getSignatureKeyBytesLength();
            var24_33 = var1_1.getEncyptionKeyBytesLength();
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "WSSAPI, Signature Algorithm = " + (String)var21_30);
                Tr.debug(SCTGenerateLoginModule.tc, "WSSAPI, Encryption Algorithm = " + var22_31);
                Tr.debug(SCTGenerateLoginModule.tc, "WSSAPI, Signature Key Length (in bytes) = " + var23_32);
                Tr.debug(SCTGenerateLoginModule.tc, "WSSAPI, Encryption Key Length (in bytes) = " + var24_33);
            }
            var25_34 = (String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm");
            var26_35 = (NonceManager)this._context.get(NonceManager.class);
            if (var26_35 == null) {
                try {
                    try {
                        var26_35 = (NonceManager)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws SoapSecurityException {
                                return NonceManagerFactory.getInstance();
                            }
                        });
                    }
                    catch (PrivilegedActionException var27_36) {
                        var28_39 = var27_36.getCause();
                        if (var28_39 instanceof SoapSecurityException) {
                            throw (SoapSecurityException)var28_39;
                        }
                        throw new SoapSecurityException(var28_39.getMessage());
                    }
                }
                catch (SoapSecurityException var27_37) {
                    throw new LoginException(var27_37.getMessage());
                }
            }
            if (!var19_26 && !var20_27) {
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.getKey02", new String[]{var18_24}));
            }
            var27_38 = SCTGenerateLoginModule.getKeyAlgorithm((String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm"), false, false, var19_26, var20_27);
            var25_34 = (String)var27_38.get("algorithm");
            var28_40 = 32;
            var29_41 = var27_38.get("keylength");
            if (var29_41 != null) {
                var28_40 = (Integer)var29_41;
            }
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "The supplied algorithm: " + (String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm") + "Key algorithm and key length are = " + var25_34 + ", " + var28_40);
            }
            if (var25_34 == null) {
                throw new LoginException("Missing Algorithm info in the config");
            }
            var30_42 = new DKTContent();
            if (var21_30 != null && var22_31 != null) {
                var28_40 = var23_32 = var24_33;
            } else {
                v0 = var28_40 = var23_32 != 0 ? var23_32 : var24_33;
            }
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "Using WSSAPI, key length to use = " + var28_40);
            }
            DKTContent.access$100(var30_42, var6_7, (TokenGeneratorConfig)var8_11, var28_40, var1_1.getServiceLabel(), var1_1.getClientLabel(), var3_3.getCurrentInstance(), var16_22);
            var31_43 = null;
            var32_44 = null;
            var31_43 = IdUtils.getInstance().makeUniqueId("dkt_");
            if (var10_15) {
                var32_44 = "#" + var31_43;
            }
            var33_45 = null;
            var34_46 = true;
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "Using DKT id = " + var31_43 + ", to create DKToken.");
            }
            try {
                var4_4 = SCTGenerateLoginModule.createDKTokenAndElement(var14_20.getOMFactory(), var14_20, var30_42, var31_43, var15_21, var34_46, var11_16, var26_35);
            }
            catch (SoapSecurityException var35_47) {
                Tr.processException((Throwable)var35_47, SCTGenerateLoginModule.clsName + ".login", "586", this);
                throw new LoginException(var35_47.toString());
            }
            if (var4_4 == null) {
                if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                    Tr.error(SCTGenerateLoginModule.tc, "DKToken cannot be obtained!");
                }
                throw new LoginException("Invalid derived key token");
            }
            if (var32_44 != null) {
                var4_4.setReferenceURI(var32_44);
                if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(SCTGenerateLoginModule.tc, "Setting the token's Reference URI = " + var32_44);
                }
            }
            try {
                if (var21_30 != null) {
                    var33_45 = this.createDerivedKey((SCTWrapper)var3_3, var4_4, (String)var21_30, var23_32);
                    if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(SCTGenerateLoginModule.tc, "Derived key algorithm = " + var33_45.getAlgorithm() + ", and key = " + Base64.encode(var33_45.getEncoded()) + ", and key length = " + var33_45.getEncoded().length);
                    }
                } else if (var22_31 != null) {
                    var33_45 = this.createDerivedKey((SCTWrapper)var3_3, var4_4, var22_31, var24_33);
                    if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(SCTGenerateLoginModule.tc, "Derived key algorithm =    " + var33_45.getAlgorithm() + ", and key = " + Base64.encode(var33_45.getEncoded()) + ", and key length = " + var33_45.getEncoded().length);
                    }
                }
                if (var33_45 == null) {
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG02"));
                }
                if (var19_26) {
                    var4_4.setKey(61, var33_45);
                    if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(SCTGenerateLoginModule.tc, "Sets the signing key in the DKT");
                    }
                } else if (var20_27) {
                    var4_4.setKey(62, var33_45);
                    if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(SCTGenerateLoginModule.tc, "Sets the Encryption key in the DKT");
                    }
                }
            }
            catch (NoSuchAlgorithmException var35_48) {
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG", new String[]{var35_48.toString()}));
            }
            catch (InvalidKeyException var35_49) {
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG", new String[]{var35_49.toString()}));
            }
            var4_4.setSecurityContextToken((SecurityContextToken)var3_3);
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "Setting the dktoken in the subject. dktoken id = " + var4_4.getId());
                Tr.debug(SCTGenerateLoginModule.tc, "dktoken = " + var4_4.getKeyIdentifier() + ", dktoken.byte = " + Base64.encode(var4_4.getBytes()) + ", dktoken.getAlgorithm =" + var4_4.getAlgorithm() + ", dktoken.getuniqueID=" + var4_4.getSecurityContextTokenTokenUUID());
            }
            this._processedTokens.add(var4_4);
            this._insertedTokens.add(var4_4);
        }
lbl257:
        // 7 sources

        if (SCTGenerateLoginModule.tc.isEntryEnabled()) {
            var21_30 = new StringBuffer("loginForWSSAPI(");
            var21_30.append("SCTGenerateCallback, SecurityTokenManager)");
            Tr.exit(SCTGenerateLoginModule.tc, var21_30.toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void loginForPolicyset(SCTCallback var1_1, SecurityTokenManager var2_2) throws LoginException {
        if (SCTGenerateLoginModule.tc.isEntryEnabled()) {
            var3_3 = new StringBuffer("loginForPolicyset(");
            var3_3.append("SCTCallback sctCallback, ");
            var3_3.append("SecurityTokenManager securityTokenManager)");
            Tr.entry(SCTGenerateLoginModule.tc, var3_3.toString());
        }
        var3_3 = null;
        var4_4 = var1_1.getToken();
        var5_5 = var1_1.getWrapperToken();
        var6_6 = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        var7_7 = false;
        try {
            var7_7 = Axis2Util.isServiceProvider(var6_6);
        }
        catch (Exception var8_8) {
            throw new LoginException(var8_8.getMessage());
        }
        var8_9 = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        var9_10 = (WSSGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.config.wssGenerator.configKey");
        var10_11 = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        var11_12 = var10_11 == null ? false : ConfigUtil.isKeyInfoStrref(var10_11);
        var12_13 = 0;
        var13_14 = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (var13_14 != null && var13_14 instanceof Integer) {
            var12_13 = (Integer)var13_14;
        }
        var14_15 = false;
        try {
            var14_15 = SCTGenerateLoginModule.checkToken(var8_9, var10_11, var5_5, var2_2);
        }
        catch (SoapSecurityException var15_16) {
            Tr.processException((Throwable)var15_16, SCTGenerateLoginModule.clsName + ".login", "717", this);
            throw new LoginException(var15_16.toString());
        }
        var15_17 = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
            Tr.debug(SCTGenerateLoginModule.tc, " Looking for the SCT element in the message.. ");
        }
        var16_18 = false;
        var17_19 = false;
        var18_20 = null;
        var19_21 = DOMUtils.getChildElement(var15_17, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "SecurityContextToken");
        if (var19_21 != null) {
            var20_22 = DOMUtils.getChildElement(var19_21, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Identifier");
            if (var20_22 != null && (var21_23 = DOMUtils.getStringValue((OMNode)var20_22)).equals(var4_4.getUUID())) {
                var16_18 = true;
                this._referencedTokenElement = var19_21;
                var17_19 = true;
            }
            var21_23 = IdUtils.getInstance().getIdAttributeName(var19_21);
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "The identifier attribute of the target element is [" + var21_23 + "].");
            }
            if (var21_23 != null) {
                var18_20 = var19_21.getAttributeValue((QName)var21_23);
            }
        } else {
            this._processedTokens.add(var5_5);
            if (!var7_7) {
                var20_22 = (String)var8_9.getProperties().get(Constants.INCLUDE_SCT_IN_REQUEST);
                if (var20_22 != null && var20_22.equalsIgnoreCase("false")) {
                    var17_19 = false;
                    if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(SCTGenerateLoginModule.tc, "Do not include SCT in request message.");
                    }
                } else {
                    this._insertedTokens.add(var5_5);
                    var17_19 = true;
                    if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(SCTGenerateLoginModule.tc, "Include SCT in request message.");
                    }
                }
            } else {
                var20_22 = (String)var8_9.getProperties().get(Constants.INCLUDE_SCT_IN_RESPONSE);
                if (var20_22 != null && var20_22.equalsIgnoreCase("true")) {
                    this._insertedTokens.add(var5_5);
                    var17_19 = true;
                    if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(SCTGenerateLoginModule.tc, "Do not include SCT in response message.");
                    }
                } else {
                    var17_19 = false;
                    if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(SCTGenerateLoginModule.tc, "Include SCT in response message.");
                    }
                }
            }
        }
        if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
            Tr.debug(SCTGenerateLoginModule.tc, "SCT element exists in the message: " + var16_18);
        }
        if (!var14_15) {
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "SCT doesn't exist in the subject. ");
            }
            var20_22 = null;
            if (!var16_18) {
                var21_23 = null;
                if (var4_4.getInstances() != null && var4_4.getInstances().length > 1) {
                    if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(SCTGenerateLoginModule.tc, "SCT has more than one instance,instance should be included in the message. ");
                    }
                    var21_23 = var5_5.getCurrentInstance();
                }
                var18_20 = IdUtils.getInstance().makeUniqueId("sct_");
                if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(SCTGenerateLoginModule.tc, "Using SCT id = " + var18_20 + ", to create SCT token.");
                }
                var20_22 = SCTGenerateLoginModule.createTokenElement(var15_17.getOMFactory(), var15_17, var8_9.getType(), var18_20, var4_4.getIdentifier(), (String)var21_23, var12_13);
            } else {
                var20_22 = var19_21;
            }
            var5_5.setXML(new OMStructure((OMElement)var20_22));
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "security context token element looks like =    " + DOMUtils.toString((OMNode)var20_22));
            }
        } else if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
            Tr.debug(SCTGenerateLoginModule.tc, "Found SCT in the subject. ");
        }
        var20_22 = (String)this._context.get(Constants.WSSECURITY_KEY_TYPE);
        if (var20_22 == null) {
            var22_25 = false;
            var21_24 = false;
        } else {
            var21_24 = "SigningKey".equals(var20_22);
            var22_25 = "EncryptingKey".equals(var20_22);
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                if (var21_24) {
                    Tr.debug(SCTGenerateLoginModule.tc, "Signing key type");
                } else if (var22_25) {
                    Tr.debug(SCTGenerateLoginModule.tc, " Encrypting key type");
                }
            }
        }
        try {
            var3_3 = SCTGenerateLoginModule.checkDKToken(var8_9, var10_11, var5_5, var2_2);
        }
        catch (SoapSecurityException var23_26) {
            throw new LoginException(var23_26.getMessage());
        }
        if (var3_3 != null) {
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "DKT exists in the subject. id = " + var3_3.getId());
            }
            try {
                if (var22_25) {
                    if (var3_3.getKey(62) == null) ** GOTO lbl241
                    this._processedTokens.add((SecurityToken)var3_3);
                    if (!SCTGenerateLoginModule.tc.isDebugEnabled()) ** GOTO lbl241
                    Tr.debug(SCTGenerateLoginModule.tc, "Found the encryption key in the DKT ");
                }
                if (!var21_24 || var3_3.getKey(61) == null) ** GOTO lbl241
                this._processedTokens.add((SecurityToken)var3_3);
                if (!SCTGenerateLoginModule.tc.isDebugEnabled()) ** GOTO lbl241
                Tr.debug(SCTGenerateLoginModule.tc, "Found the signing key in the DKT ");
            }
            catch (WSSException var23_27) {
                var24_29 = new LoginException(var23_27.toString());
                var24_29.initCause(var23_27);
                throw var24_29;
            }
        } else {
            var23_28 = (NonceManager)this._context.get(NonceManager.class);
            if (var23_28 == null) {
                try {
                    try {
                        var23_28 = (NonceManager)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws SoapSecurityException {
                                return NonceManagerFactory.getInstance();
                            }
                        });
                    }
                    catch (PrivilegedActionException var24_30) {
                        var25_33 = var24_30.getCause();
                        if (var25_33 instanceof SoapSecurityException) {
                            throw (SoapSecurityException)var25_33;
                        }
                        throw new SoapSecurityException(var25_33.getMessage());
                    }
                }
                catch (SoapSecurityException var24_31) {
                    throw new LoginException(var24_31.getMessage());
                }
            }
            if (!var21_24 && !var22_25) {
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.getKey02", new String[]{var20_22}));
            }
            var24_32 = true;
            var25_34 = ((PolicyOutboundConfig)var9_10).getEncryptionAlgorithm();
            var26_35 = ((PolicyOutboundConfig)var9_10).getSymmetricSignatureAlgorithm();
            var27_36 = var9_10.getTokenGenerators().size();
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "The supplied algorithms from algorithm suite, Encryption Algorithm: " + var25_34 + " and Signature Algorithm: = " + var26_35);
                Tr.debug(SCTGenerateLoginModule.tc, "Number of token generators in the configuration = " + var27_36);
            }
            if ((var28_37 = var8_9.getProperties()) != null && var28_37.get("com.ibm.ws.wssecurity.config.TokenGeneratorConfig.usedForEncryption") != null && ((Boolean)var28_37.get("com.ibm.ws.wssecurity.config.TokenGeneratorConfig.usedForEncryption")).booleanValue() && var28_37.get("com.ibm.ws.wssecurity.config.TokenGeneratorConfig.usedForSignature") != null && ((Boolean)var28_37.get("com.ibm.ws.wssecurity.config.TokenGeneratorConfig.usedForSignature")).booleanValue()) {
                var24_32 = false;
                if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(SCTGenerateLoginModule.tc, "Same Token Generator Config is being used for Signing and Encryption");
                }
            }
            var29_38 = SCTGenerateLoginModule.getKeyAlgorithm(var25_34, false, false, false, true);
            var25_34 = (String)var29_38.get("algorithm");
            var30_39 = SCTGenerateLoginModule.getKeyLength(false, var9_10, var8_9);
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "Encryption algorithm (JCE mapping) and key length are = " + var25_34 + ", " + var30_39);
            }
            var29_38 = SCTGenerateLoginModule.getKeyAlgorithm(var26_35, false, false, true, false);
            var26_35 = (String)var29_38.get("algorithm");
            var31_40 = SCTGenerateLoginModule.getKeyLength(true, var9_10, var8_9);
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "Signature algorithm (JCE mapping)and key length are = " + var26_35 + ", " + var31_40);
            }
            if (var22_25 && var25_34 == null) {
                throw new LoginException("Missing Algorithm info in the config");
            }
            if (var21_24 && var26_35 == null) {
                throw new LoginException("Missing Algorithm info in the config");
            }
            var32_41 = new DKTContent();
            if (var22_25) {
                DKTContent.access$100(var32_41, var4_4, var8_9, var30_39, null, null, var5_5.getCurrentInstance(), var18_20);
            } else {
                DKTContent.access$100(var32_41, var4_4, var8_9, var31_40, null, null, var5_5.getCurrentInstance(), var18_20);
            }
            var33_42 = null;
            var34_43 = null;
            var33_42 = IdUtils.getInstance().makeUniqueId("dkt_");
            if (var11_12) {
                var34_43 = "#" + var33_42;
            }
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "Using DKT id = " + var33_42 + ", to create DKToken.");
            }
            try {
                var3_3 = SCTGenerateLoginModule.createDKTokenAndElement(var15_17.getOMFactory(), var15_17, var32_41, var33_42, var17_19, var24_32, var12_13, (NonceManager)var23_28);
            }
            catch (SoapSecurityException var35_44) {
                Tr.processException((Throwable)var35_44, SCTGenerateLoginModule.clsName + ".login", "942", this);
                throw new LoginException(var35_44.toString());
            }
            if (var3_3 == null) {
                if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                    Tr.error(SCTGenerateLoginModule.tc, "DKToken cannot be created!");
                }
                throw new LoginException("Invalid derived key token");
            }
            if (var34_43 != null) {
                var3_3.setReferenceURI(var34_43);
                if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(SCTGenerateLoginModule.tc, "Setting the token's Reference URI = " + var34_43);
                }
            }
            var35_45 = null;
            var36_46 = null;
            try {
                var35_45 = this.createDerivedKey(var5_5, (DKToken)var3_3, var25_34, var30_39);
                var36_46 = this.createDerivedKey(var5_5, (DKToken)var3_3, var26_35, var31_40);
                if (var22_25 && var35_45 == null) {
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG02"));
                }
                if (var21_24 && var36_46 == null) {
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG02"));
                }
                if (var35_45 != null && SCTGenerateLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(SCTGenerateLoginModule.tc, "Derived key (for encryption) algorithm = " + var35_45.getAlgorithm() + ", and key = " + Base64.encode(var35_45.getEncoded()));
                }
                if (var36_46 != null && SCTGenerateLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(SCTGenerateLoginModule.tc, "Derived key (for signing) algorithm = " + var36_46.getAlgorithm() + ", and key = " + var36_46.getEncoded());
                }
                var3_3.setKey(61, var36_46);
                var3_3.setKey(62, var35_45);
            }
            catch (NoSuchAlgorithmException var37_47) {
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG", new String[]{var37_47.toString()}));
            }
            catch (InvalidKeyException var37_48) {
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG", new String[]{var37_48.toString()}));
            }
            var3_3.setSecurityContextToken(var5_5);
            if (var28_37.get("RequiredImpliedDerivedKeys") != null && ((Boolean)var28_37.get("RequiredImpliedDerivedKeys")).booleanValue()) {
                if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(SCTGenerateLoginModule.tc, "Implied Derived Keys property is = TRUE");
                }
                var3_3.setXML(null);
            }
            if (SCTGenerateLoginModule.tc.isDebugEnabled()) {
                Tr.debug(SCTGenerateLoginModule.tc, "Setting the dktoken in the subject. dktoken id = " + var3_3.getId());
                Tr.debug(SCTGenerateLoginModule.tc, "dktoken = " + var3_3.getKeyIdentifier() + ", dktoken.byte = " + ", dktoken.getAlgorithm =" + var3_3.getAlgorithm() + ", dktoken.getuniqueID=" + var3_3.getSecurityContextTokenTokenUUID());
            }
            this._processedTokens.add((SecurityToken)var3_3);
            this._insertedTokens.add((SecurityToken)var3_3);
        }
lbl241:
        // 7 sources

        if (SCTGenerateLoginModule.tc.isEntryEnabled()) {
            var23_28 = new StringBuffer("loginForPolicyset(");
            var23_28.append("SCTCallback, SCTGenerateCallback, SecurirityTokenManager)");
            Tr.exit(SCTGenerateLoginModule.tc, var23_28.toString());
        }
    }

    private final SCTWrapper requestSCTusingWSSAPI(WSSGenerationContext wSSGenerationContext, WSSConsumingContext wSSConsumingContext, String string, SCTGenerateCallback sCTGenerateCallback) throws LoginException {
        Object object;
        Object object2;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("requestSCTusingWSSAPI(");
            ((StringBuffer)serializable).append("WSSGenerationContext gencont, WSSConsumingContext concont, ");
            ((StringBuffer)serializable).append("String serviceEndpointAddress[").append(string).append("], ");
            ((StringBuffer)serializable).append("SCTGenerateCallback sctGenerateCallback)");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = null;
        SCTWrapper sCTWrapper = null;
        RSTTemplateImpl rSTTemplateImpl = new RSTTemplateImpl();
        String string2 = com.ibm.ws.wssecurity.common.Constants.NS_SOAP;
        String string3 = "http://www.w3.org/2005/08/addressing/anonymous";
        int n = 32;
        String string4 = null;
        string4 = sCTGenerateCallback.getEncyptionAlgorithm();
        if (string4 != null) {
            object2 = SCTGenerateLoginModule.getKeyAlgorithm(string4, false, false, false, true);
            string4 = (String)object2.get("algorithm");
            object = object2.get("keylength");
            if (object != null) {
                n = (Integer)object;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Encryption algorithm (JCE mapping) and key length are = " + string4 + ", " + n);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using WSSAPI, key length to use = " + n);
        }
        object2 = Integer.toString(n * 8);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Using WSSAPI, key size in bits = " + (String)object2);
        }
        rSTTemplateImpl.set("TokenType", "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
        rSTTemplateImpl.set("RequestType", "http://schemas.xmlsoap.org/ws/2005/02/trust/Issue");
        rSTTemplateImpl.set("Entropy", "BinarySecret");
        rSTTemplateImpl.set("BinarySecret", "/Nonce");
        rSTTemplateImpl.set("AppliesTo", string);
        rSTTemplateImpl.set("EntropyLength", (String)object2);
        rSTTemplateImpl.setKeySize((String)object2);
        object = null;
        STSRequestorFactory sTSRequestorFactory = null;
        ServiceClient serviceClient = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "initialize stsConfigImpl ");
        }
        String string5 = com.ibm.ws.wssecurity.common.Constants.NS_WSADDRS[0];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting final WS-Addressing level in the trust service request." + string5);
        }
        try {
            Iterator<IRequestSecurityTokenResponse> iterator;
            Object object3;
            object = new STSConfigImpl();
            String string6 = SecurityUIDGenerator.createUID();
            object.set("MESSAGE_ID", string6);
            object.set("MESSAGE_REPLYTO", string3);
            object.set("MESSAGE_TO", string);
            object.set("MESSAGE_ACTION", "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/SCT");
            object.set("soap_level", string2);
            object.set("addressing_level", string5);
            object.set("CONTEXT_URI", "http://www.ibm.com/login/");
            object.set("STS_NAME", "SSI");
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("STS_Conf", object);
            hashMap.put("RSTTemplate", rSTTemplateImpl);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serviceEndpointAddress: " + string);
            }
            ConfigurationContext configurationContext = null;
            ClientConfigurationFactory clientConfigurationFactory = ClientConfigurationFactory.newInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ClientConfigurationFactory.newInstance(): " + clientConfigurationFactory);
            }
            if (clientConfigurationFactory == null) {
                Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getClientConfigurationFactory");
                throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getClientConfigurationFactory");
            }
            configurationContext = clientConfigurationFactory.getClientConfigurationContext();
            if (configurationContext == null) {
                Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getConfigurationContext");
                throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getConfigurationContext");
            }
            Object object4 = configurationContext.getAxisConfiguration();
            if (object4 == null) {
                Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getAxisConfiguration");
                throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getAxisConfiguration");
            }
            Object object5 = ((AxisConfiguration)object4).getService(string);
            if (object5 == null) {
                object3 = new AxisService(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AxisService: " + object3);
                }
                if (object3 == null) {
                    Tr.warning(tc, "security.wssecurity.SCTGenerateLoginModule.getAxisService", new Object[]{string});
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "creating an empty AxisService.");
                    }
                    if ((object3 = new AxisService()) == null) {
                        Tr.error(tc, "UNABLE TO CREATE EMPTY AxisService");
                    }
                }
                ((AxisConfiguration)object4).addService((AxisService)object3);
                clientConfigurationFactory.completeAxis2Configuration((AxisService)object3);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ccf.completeAxis2Configuration(): " + clientConfigurationFactory);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found Target axisService from AxisConfiguration.");
            }
            hashMap.put("CONFIG_CONTEXT", configurationContext);
            object4 = new HashMap();
            object4.put("Sandesha2UnreliableMessage", "true");
            hashMap.put("axis2_messagecontext_propertymap", object4);
            sTSRequestorFactory = new STSRequestorFactory();
            object5 = new HashMap();
            object5.putAll(hashMap);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stsfactory.init");
            }
            if ((serviceClient = (ServiceClient)sTSRequestorFactory.init(hashMap)).getAxisService() != null) {
                serviceClient.getAxisService().addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
            }
            wSSGenerationContext.process(serviceClient);
            wSSConsumingContext.process(serviceClient);
            object3 = sTSRequestorFactory.getEntropyKey();
            byte[] byArray = null;
            String string7 = null;
            String string8 = null;
            String string9 = null;
            String string10 = null;
            String string11 = null;
            String string12 = "128";
            Date date = null;
            Date date2 = null;
            OMElement oMElement = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "About to call Trust client with Issue request.");
            }
            IRequestSecurityTokenResponseCollection iRequestSecurityTokenResponseCollection = sTSRequestorFactory.issue(serviceClient);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust client Issue is successful.");
            }
            if ((iterator = iRequestSecurityTokenResponseCollection.getRSTRCollection()).hasNext()) {
                Object object6;
                OMElement oMElement2;
                IRequestSecurityTokenResponse iRequestSecurityTokenResponse = iterator.next();
                byArray = iRequestSecurityTokenResponse.getSecret();
                String string13 = "Lifetime";
                IRequestedSecurityToken iRequestedSecurityToken = iRequestSecurityTokenResponse.getRequestedSecurityToken();
                string10 = iRequestSecurityTokenResponse.getTokenCreated();
                string11 = iRequestSecurityTokenResponse.getTokenExpires();
                if (string10 == null) {
                    Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getSCTLifetime");
                    throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getSCTLifetime");
                }
                date = SCTGenerateLoginModule.parseDateTime(string10);
                if (string11 == null) {
                    Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.getSCTLifetime");
                    throw SoapSecurityException.format("security.wssecurity.SCTGenerateLoginModule.getSCTLifetime");
                }
                date2 = SCTGenerateLoginModule.parseDateTime(string11);
                string13 = "KeySize";
                OMElement oMElement3 = (OMElement)iRequestSecurityTokenResponse.getTokenElement(string13);
                int n2 = 0;
                if (oMElement3 != null) {
                    string12 = oMElement3.getText();
                    n2 = new Integer(string12);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key Size from the RSTR = " + n2);
                    }
                }
                String string14 = "true";
                String string15 = "false";
                string13 = "Renewing";
                oMElement3 = (OMElement)iRequestSecurityTokenResponse.getTokenElement(string13);
                if (oMElement3 != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Renewing element from the RSTR looks like: " + DOMUtils.toString(oMElement3));
                    }
                    string15 = oMElement3.getAttributeValue(new QName("", "OK"));
                    string14 = oMElement3.getAttributeValue(new QName("", "Allow"));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Renew properties of the token, isRenewable =    " + string14 + ", renewableAfterExpiration = " + string15);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No Renewing information in the RSTR element. ");
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Renew properties of the token, isRenewable =    " + string14 + ", renewableAfterExpiration = " + string15);
                    }
                }
                if ((oMElement2 = (OMElement)iRequestedSecurityToken.getTokenElement(string13 = "SecurityContextToken")) != null) {
                    oMElement = oMElement2;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "sct element from the RSTR looks like: " + DOMUtils.toString(oMElement));
                }
                if (oMElement != null) {
                    object6 = DOMUtils.getChildElement(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Identifier");
                    string7 = DOMUtils.getStringValue((OMNode)object6);
                    QName qName = IdUtils.getInstance().getIdAttributeName(oMElement);
                    if (qName != null) {
                        string8 = oMElement.getAttributeValue(qName);
                    }
                    if ((object6 = DOMUtils.getChildElement(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Instance")) != null) {
                        string9 = DOMUtils.getStringValue((OMNode)object6);
                    }
                }
                object6 = new SCT.KeyHistoryEntry(string9, (byte[])object3, byArray, date, date2, SCT.SCTState.ISSUED);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RSTR returns with Requested Security Token: uuid = " + string7 + ", id = " + string8 + ", created = " + date.toString() + ", expires = " + date2.toString() + ", and instance = " + string9 + ", serverSecret = " + Base64.encode(byArray) + ", clientEntropy = " + Base64.encode((byte[])object3));
                }
                serializable = new SCT(string7);
                ((SCT)serializable).setKeyHistoryEntry((SCT.KeyHistoryEntry)object6);
                ((SecurityTokenImpl)serializable).setId(string8);
                ((SCT)serializable).setTokenID(string8);
                ((SecurityTokenImpl)serializable).setReferenceURI("#" + string8);
                ((SCT)serializable).setClientID(string7);
                ((SecurityTokenImpl)serializable).setXML(new OMStructure(oMElement));
                ((SCT)serializable).setMap((Map)object5);
                ((SCT)serializable).setWssConsumingContext(wSSConsumingContext);
                ((SCT)serializable).setWssGenerationContext(wSSGenerationContext);
                ((SecureConversationToken)serializable).setUsedForSigAndEnc(true);
                ((SCT)serializable).setKeySize(n2);
                ((SCT)serializable).setRenewable(Boolean.valueOf(string14));
                ((SCT)serializable).setRenewableAfterExpiration(Boolean.valueOf(string15));
                sCTWrapper = SCTGenerateLoginModule.createSCTWrapper((SCT)serializable, string9);
                sCTWrapper.setSCT((SCT)serializable);
                sCTWrapper.setXML(new OMStructure(oMElement));
                sCTWrapper.setWssGenerationContext(wSSGenerationContext);
                sCTWrapper.setWssConsumingContext(wSSConsumingContext);
                sCTWrapper.setMap((Map)object5);
                SecureConversationCacheHelper.setSecurityContextTokenToCache(string7, null, serializable, null);
            }
            serviceClient.cleanup();
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName, ".requestSCTusingWSSAPI", "1326");
            Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.issueSCT", new Object[]{exception});
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.issueSCT", new String[]{exception.toString()}));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestSCTusingWSSAPI(WSSGenerationContext gencont, WSSConsumingContext concont, String serviceEndpointAddress)");
        }
        return sCTWrapper;
    }

    public static final Date parseDateTime(String string) {
        if (string == null) {
            return null;
        }
        try {
            Date date = UTC.parse(string);
            return date;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        int n = this._processedTokens.size();
        for (int i = 0; i < n; ++i) {
            SecurityToken securityToken = this._processedTokens.get(i);
            this._securityTokenManager.addToken(securityToken);
        }
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        this._context.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
        this._context.put(Constants.WSSECURITY_TOKENELEMENT_REFERENCED, this._referencedTokenElement);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private static final boolean checkToken(TokenGeneratorConfig tokenGeneratorConfig, String string, SecurityToken securityToken, SecurityTokenManager securityTokenManager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("checkToken(");
            stringBuffer.append("TokenGenratorConfig config, ");
            stringBuffer.append("String keyInfoType[").append(string).append("], ");
            stringBuffer.append("SecurityToken token, SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        if (securityToken instanceof SCTWrapper) {
            string2 = ((SCTWrapper)securityToken).getSCT().getUUID();
            string3 = ((SCTWrapper)securityToken).getCurrentInstance();
        } else {
            string2 = ((SCT)securityToken).getUUID();
        }
        Collection<SecurityToken> collection = securityTokenManager.getTokens(tokenGeneratorConfig, string);
        if (collection != null && collection.size() > 0) {
            for (SecurityToken securityToken2 : collection) {
                String string4;
                SCT sCT;
                if (securityToken2 instanceof SCTWrapper) {
                    sCT = (SCTWrapper)securityToken2;
                    string4 = sCT.getUUID();
                    String string5 = ((SCTWrapper)sCT).getCurrentInstance();
                    if (!string4.equals(string2) || !string5.equals(string3)) continue;
                    bl = true;
                    break;
                }
                if (!(securityToken2 instanceof SCT) || !(string4 = (sCT = (SCT)securityToken2).getUUID()).equals(string2)) continue;
                bl = true;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("checkToken(");
            stringBuffer.append("TokenGenratorConfig, String, SecurityToken, SecurityTokenManager)");
            stringBuffer.append(" return boolean[").append(bl).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return bl;
    }

    private static final DKToken checkDKToken(TokenGeneratorConfig tokenGeneratorConfig, String string, SCTWrapper sCTWrapper, SecurityTokenManager securityTokenManager) throws SoapSecurityException {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("checkDKToken(");
            serializable.append("TokenGenratorConfig config, ");
            serializable.append("String keyInfoType[").append(string).append("], ");
            serializable.append("SCTWrapper sctoken, SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, serializable.toString());
        }
        serializable = null;
        String string2 = sCTWrapper.getSCT().getUUID();
        String string3 = sCTWrapper.getCurrentInstance();
        Collection<SecurityToken> collection = securityTokenManager.getTokens(tokenGeneratorConfig, string);
        if (collection != null && collection.size() > 0) {
            for (SecurityToken securityToken : collection) {
                if (!(securityToken instanceof DKToken)) continue;
                SCTWrapper sCTWrapper2 = (SCTWrapper)((DKToken)securityToken).getSecurityContextToken();
                SCT sCT = sCTWrapper2.getSCT();
                String string4 = sCT.getUUID();
                String string5 = sCTWrapper2.getCurrentInstance();
                if (!string4.equals(string2) || !string5.equals(string3)) continue;
                serializable = (DKToken)securityToken;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("checkDKToken(");
            stringBuffer.append("TokenGenratorConfig, String, SCTWrapper, SecurityTokenManager)");
            stringBuffer.append(" returns DKToken[").append(serializable).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return serializable;
    }

    public static final OMElement createTokenElement(OMFactory oMFactory, OMElement oMElement, QName qName, String string, String string2, String string3, int n) {
        Object object;
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("createTokenElement(");
            ((StringBuffer)charSequence).append("OMFactory factory, ");
            ((StringBuffer)charSequence).append("OMElement parent[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)charSequence).append("QName valueType[").append(qName).append("], ");
            ((StringBuffer)charSequence).append("SCT sct, ");
            ((StringBuffer)charSequence).append("String curInstance[").append(string3).append("], ");
            ((StringBuffer)charSequence).append("int wssVersion[").append(n).append("])");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        charSequence = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC;
        String string4 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][n];
        boolean bl = false;
        String string5 = null;
        if (oMElement != null) {
            string5 = DOMUtils.getNamespacePrefix(oMElement, (String)charSequence);
        }
        if (string5 == null) {
            bl = true;
            string5 = "wsc";
        }
        OMElement oMElement2 = oMFactory.createOMElement("SecurityContextToken", (String)charSequence, string5);
        if (bl) {
            oMElement2.declareNamespace((String)charSequence, "wsc");
        }
        bl = false;
        String string6 = null;
        if (oMElement != null) {
            string6 = DOMUtils.getNamespacePrefix(oMElement, string4);
        }
        if (string6 == null) {
            bl = true;
            string6 = "wsu";
        }
        if (bl) {
            oMElement2.declareNamespace(string4, "wsu");
        }
        oMElement2.addAttribute("Id", string, oMElement2.getOMFactory().createOMNamespace(string4, string6));
        OMElement oMElement3 = oMFactory.createOMElement("Identifier", (String)charSequence, string5);
        oMElement3.addChild(oMFactory.createOMText(string2));
        oMElement2.addChild(oMElement3);
        if (string3 != null) {
            object = oMFactory.createOMElement("Instance", (String)charSequence, string5);
            object.addChild(oMFactory.createOMText(string3));
            oMElement2.addChild((OMNode)object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding instance = " + string3);
                Tr.debug(tc, "After adding instance, = " + DOMUtils.toString(oMElement2));
            }
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("createTokenElement(");
            ((StringBuffer)object).append("OMFactory, OMElement, QName, SCT, String, int)");
            ((StringBuffer)object).append(" returns OMElement [").append(oMElement2).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return oMElement2;
    }

    private static final DKToken createDKTokenAndElement(OMFactory oMFactory, OMElement oMElement, DKTContent dKTContent, String string, boolean bl, boolean bl2, int n, NonceManager nonceManager) throws SoapSecurityException {
        StringBuffer stringBuffer;
        String string2;
        Object object;
        int n2;
        String string3;
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("createDKTokenAndElement(");
            ((StringBuffer)charSequence).append("OMFactory factory, ");
            ((StringBuffer)charSequence).append("OMElement parent[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)charSequence).append("DKTContent content, ");
            ((StringBuffer)charSequence).append("String refid[").append(string).append("], ");
            ((StringBuffer)charSequence).append("boolean sctin[").append(bl).append("], ");
            ((StringBuffer)charSequence).append("boolean lengthin[").append(bl2).append("], ");
            ((StringBuffer)charSequence).append("int wssVersion[").append(n).append("], ");
            ((StringBuffer)charSequence).append("NonceManager nmanager)");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        charSequence = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][n];
        String string4 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][n];
        boolean bl3 = false;
        final DKToken dKToken = new DKToken();
        byte[] byArray = null;
        OMElement oMElement2 = oMFactory.createOMElement("DerivedKeyToken", com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "wsc");
        oMElement2.declareNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "wsc");
        if (string != null) {
            bl3 = false;
            string3 = DOMUtils.getNamespacePrefix(oMElement, (String)charSequence);
            if (string3 == null) {
                bl3 = true;
                string3 = "wsu";
            }
            if (bl3) {
                oMElement2.declareNamespace((String)charSequence, "wsu");
            }
            oMElement2.addAttribute("Id", string, oMElement2.getOMFactory().createOMNamespace((String)charSequence, string3));
        }
        bl3 = false;
        string3 = null;
        if (oMElement != null) {
            string3 = DOMUtils.getNamespacePrefix(oMElement, string4);
        }
        if (string3 == null) {
            bl3 = true;
            string3 = "wsse";
        }
        OMElement oMElement3 = oMFactory.createOMElement("SecurityTokenReference", com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "wsse");
        if (bl3) {
            oMElement3.declareNamespace(string4, "wsse");
        }
        OMElement oMElement4 = oMFactory.createOMElement("Reference", com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "wsse");
        String string5 = null;
        string5 = bl ? "#" + dKTContent.getRefTokenId() : dKTContent.getRefTokenUUID();
        oMElement4.addAttribute("URI", string5, null);
        oMElement4.addAttribute("ValueType", com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT, null);
        if (!bl && (n2 = ((SCT)(object = dKTContent.getSCT())).getInstances().length) > 1) {
            string5 = dKTContent.getRefInstanceUUID();
            oMElement4.addAttribute("Instance", string5, oMElement2.getOMFactory().createOMNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "wsc"));
        }
        oMElement3.addChild(oMElement4);
        oMElement2.addChild(oMElement3);
        if (bl2) {
            object = oMFactory.createOMElement("Length", com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "wsc");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The key length to be added to the message = " + dKTContent.getKeyLength());
            }
            String string6 = new Long(dKTContent.getKeyLength()).toString();
            object.setText(string6);
            oMElement2.addChild((OMNode)object);
        }
        object = null;
        try {
            object = SCTGenerateLoginModule.createNonce(oMFactory, oMElement2, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, nonceManager);
        }
        catch (Exception exception) {
            throw new SoapSecurityException(exception.getMessage());
        }
        dKToken.setXML(new OMStructure(oMElement2));
        if (object != null && (string2 = DOMUtils.getStringValue((OMNode)object)) != null) {
            byArray = Base64.decode(string2);
        }
        dKToken.setNonce(byArray);
        dKToken.setrefTokenType(dKTContent.getRefTokenType());
        dKToken.setrefTokenId(dKTContent.getRefTokenId());
        dKToken.setType(dKTContent.getType());
        dKToken.setId(string);
        dKToken.setLength((int)dKTContent.getKeyLength());
        final String string7 = dKTContent.getRefTokenUUID();
        final String string8 = dKTContent.getClientLabel() == null ? "WS-SecureConversation" : dKTContent.getClientLabel();
        final String string9 = dKTContent.getServiceLabel() == null ? "WS-SecureConversation" : dKTContent.getServiceLabel();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                dKToken.setSecurityContextTokenUUID(string7);
                dKToken.setClientLabel(string8);
                dKToken.setServiceLabel(string9);
                return null;
            }
        });
        if (tc.isDebugEnabled()) {
            stringBuffer = new StringBuffer("createDKTokenAndElement creates a DKToken and element. ");
            stringBuffer.append(" Identifier is = ").append(dKToken.getId());
            stringBuffer.append(", Key lengtk is = ").append(dKTContent.getKeyLength());
            stringBuffer.append(", Nonce is = ").append(Base64.encode(dKToken.getNonce()));
            stringBuffer.append(", Reference token type is = ").append(dKTContent.getRefTokenType());
            stringBuffer.append(", Reference Token uuid is = ").append(dKTContent.getRefTokenUUID());
            stringBuffer.append(", Reference Token id is = ").append(dKTContent.getRefTokenId());
            stringBuffer.append(", Type is = ").append(dKTContent.getType());
            stringBuffer.append(", Reference identifier is = ").append(string);
            stringBuffer.append(", Client label is = ").append(dKToken.getClientLabel());
            stringBuffer.append(", Service label is = ").append(dKToken.getServiceLabel());
            Tr.debug(tc, stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            stringBuffer = new StringBuffer("createDKTokenAndElement(");
            stringBuffer.append("OMFactory, OMElement, DKTContent, String, boolean, ");
            stringBuffer.append("boolean, int, NonceManager)");
            stringBuffer.append(" returns DKToken [").append(dKToken).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return dKToken;
    }

    private static final int getKeyLength(boolean bl, WSSGeneratorConfig wSSGeneratorConfig, TokenGeneratorConfig tokenGeneratorConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "(boolean sig, String algorithmSuite, TokenGeneratorConfig config)");
        }
        String string = ((PolicyOutboundConfig)wSSGeneratorConfig).getAlgorithmSuite();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The Algorithm Suite = " + string);
        }
        String string2 = (String)tokenGeneratorConfig.getProperties().get(Constants.DERIVED_KEY_LENGTH);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The specified Dervived Key Length is " + string2);
        }
        return SCTGenerateLoginModule.getKeyLength(bl, string, string2);
    }

    public static final int getKeyLength(boolean bl, String string, String string2) {
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("getKeyLength(boolean sig [");
            ((StringBuffer)charSequence).append(bl).append("], String algorithmSuite [").append(string).append("], String keyLengthInBinding [");
            ((StringBuffer)charSequence).append(string2).append("])");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        charSequence = PolicyConfigUtil.getMinimumSymmetricKeyLength(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Minimum Dervived Key Length for " + string + " is " + (String)charSequence);
        }
        int n = Integer.parseInt((String)charSequence) / 8;
        int n2 = 32;
        int n3 = n;
        if (string2 != null && string2.length() > 0) {
            n3 = Integer.parseInt(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The specified Dervived Key Length is " + n3);
            }
            if (n3 < n) {
                n3 = n;
            }
            if (n3 > n2) {
                n3 = n2;
            }
        } else if (n3 == 16 && bl) {
            n3 = 20;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "The resulted Dervived Key Length is " + n3);
        }
        return n3;
    }

    public static final Map<String, Object> getKeyAlgorithm(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("getKeyAlgorithm(");
            ((StringBuffer)charSequence).append("String algName[").append(string).append("], ");
            ((StringBuffer)charSequence).append("boolean isV[").append(bl).append("], ");
            ((StringBuffer)charSequence).append("boolean isD[").append(bl2).append("], ");
            ((StringBuffer)charSequence).append("boolean isS[").append(bl3).append("], ");
            ((StringBuffer)charSequence).append("boolean isE[").append(bl4).append("])");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        charSequence = null;
        int n = 0;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (bl || bl3) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "isV: " + bl + ", " + "isS: " + bl3 + ".");
            }
            if (HMAC.equals(string)) {
                hashMap.put("algorithm", "HmacSHA1");
                n = 20;
                hashMap.put("keylength", new Integer(n));
            } else if (RSA.equals(string)) {
                hashMap.put("algorithm", "SHA1withRSA");
                n = 20;
                hashMap.put("keylength", new Integer(n));
            } else if (DSA.equals(string)) {
                hashMap.put("algorithm", "SHA1withDSA");
                n = 20;
                hashMap.put("keylength", new Integer(n));
            }
        } else if (bl2 || bl4) {
            if (TRIPLEDES_CBC.equals(string)) {
                charSequence = "DESede";
                n = 24;
                hashMap.put("algorithm", charSequence);
                hashMap.put("keylength", new Integer(n));
            } else if (AES128_CBC.equals(string)) {
                charSequence = "AES";
                n = 16;
                hashMap.put("algorithm", charSequence);
                hashMap.put("keylength", new Integer(n));
            } else if (AES192_CBC.equals(string)) {
                charSequence = "AES";
                n = 24;
                hashMap.put("algorithm", charSequence);
                hashMap.put("keylength", new Integer(n));
            } else if (AES256_CBC.equals(string)) {
                charSequence = "AES";
                n = 32;
                hashMap.put("algorithm", charSequence);
                hashMap.put("keylength", new Integer(n));
            } else if (RSA_1_5.equalsIgnoreCase(string)) {
                charSequence = "RSA";
                n = 16;
                hashMap.put("algorithm", charSequence);
                hashMap.put("keylength", new Integer(n));
            } else if (KWAES128.equalsIgnoreCase(string)) {
                charSequence = "DESede/CBC/NoPadding";
                n = 16;
                hashMap.put("algorithm", charSequence);
                hashMap.put("keylength", new Integer(n));
            } else if (KWAES192.equalsIgnoreCase(string)) {
                charSequence = "DESede/CBC/NoPadding";
                n = 24;
                hashMap.put("algorithm", charSequence);
                hashMap.put("keylength", new Integer(n));
            } else if (KWAES256.equalsIgnoreCase(string)) {
                charSequence = "DESede/CBC/NoPadding";
                n = 32;
                hashMap.put("algorithm", charSequence);
                hashMap.put("keylength", new Integer(n));
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getKeyAlgorithm(");
            stringBuffer.append("String, boolean, boolean, boolean, boolean)");
            stringBuffer.append(" returns Map [").append(hashMap).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return hashMap;
    }

    private static final OMElement createNonce(OMFactory oMFactory, OMElement oMElement, String string, NonceManager nonceManager) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("createNonce(");
            stringBuffer.append("OMFactory factory, ");
            stringBuffer.append("OMElement parent[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            stringBuffer.append("String ns[").append(string).append("], ");
            stringBuffer.append("NonceManager nmnager)");
            Tr.entry(tc, stringBuffer.toString());
        }
        boolean bl = false;
        String string2 = DOMUtils.getNamespacePrefix(oMElement, string);
        if (string2 == null) {
            bl = true;
            string2 = com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC.equals(string) ? "wsc" : "wsse";
        }
        OMElement oMElement2 = oMFactory.createOMElement("Nonce", string, string2);
        if (bl) {
            oMElement2.declareNamespace(string, string2);
        }
        oMElement2.addChild(oMFactory.createOMText(NonceUtil.generateNonce(nonceManager)));
        oMElement.addChild(oMElement2);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("createNonce(");
            stringBuffer.append("OMFactory, OMElement, String, NonceManager)");
            stringBuffer.append(" returns OMElement [").append(DOMUtils.getDisplayName(oMElement2)).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return oMElement2;
    }

    private static final boolean isExistedBootstrapPolicy(BindingProvider bindingProvider) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isExistedBootstrapPolicy(BindingProvider bp)");
        }
        if (bindingProvider == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "bp is null. The bootstrap policy does not exist.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isExistedBootstrapPolicy(BindingPolicy) returns false");
            }
            return false;
        }
        EndpointDescription endpointDescription = null;
        if (bindingProvider instanceof org.apache.axis2.jaxws.spi.BindingProvider) {
            endpointDescription = ((org.apache.axis2.jaxws.spi.BindingProvider)bindingProvider).getEndpointDescription();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "BindingProvider not an instance of org.apache.axis2.jaxws.spi.BindingProvider, is instance of " + bindingProvider.getClass().getName());
        }
        AxisService axisService = null;
        if (endpointDescription != null) {
            axisService = endpointDescription.getAxisService();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AxisService from the binding provider = " + axisService);
            }
        }
        PrivateGeneratorConfig privateGeneratorConfig = SecureConversationImpl.getGeneratorConfigFromService(axisService);
        PrivateConsumerConfig privateConsumerConfig = SecureConversationImpl.getConsumerConfigFromService(axisService);
        if (privateGeneratorConfig != null && privateConsumerConfig != null && tc.isDebugEnabled()) {
            Tr.debug(tc, "bootstrap policy exists.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isExistedBootstrapPolicy(BindingPolicy) returns true");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Key createDerivedKey(SCTWrapper sCTWrapper, DKToken dKToken, String string, int n) throws NoSuchAlgorithmException, InvalidKeyException {
        CharSequence charSequence;
        Serializable serializable;
        block14: {
            if (tc.isEntryEnabled()) {
                serializable = new StringBuffer("createDerivedKey(");
                serializable.append("SCTWrapper sctWrapper, DKToken dktoken, ");
                serializable.append("String keyalgo[").append(string).append("], ");
                serializable.append("int keylength[").append(n).append("])");
                Tr.entry(tc, serializable.toString());
            }
            serializable = null;
            SCT sCT = sCTWrapper.getSCT();
            try {
                Serializable serializable2;
                Serializable serializable3;
                charSequence = null;
                charSequence = sCTWrapper.getCurrentInstance();
                if (tc.isDebugEnabled()) {
                    serializable3 = new StringBuffer("keyInstance = ").append((String)charSequence);
                    ((StringBuffer)serializable3).append(", SCT uuid = ").append(sCT.getUUID());
                    ((StringBuffer)serializable3).append(", ServerSecret = ").append(Base64.encode(sCT.getServerSecret((String)charSequence)));
                    ((StringBuffer)serializable3).append(", ClientSecret = ").append(Base64.encode(sCT.getClientSecret((String)charSequence)));
                    ((StringBuffer)serializable3).append(", entropy Key Size (in bits) based on Algorithm Suite = ").append(sCT.getKeySize());
                    Tr.debug(tc, ((StringBuffer)serializable3).toString());
                }
                if ((serializable3 = sCT.getDerivedKeyGenerator((String)charSequence + new Integer(n).toString())) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found cached DerivedKeyGenerator");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating DerivedKeyGenerator, key length = " + new Integer(n).toString());
                    }
                    serializable2 = new DerivedKeyGenerator(sCT.getClientSecret((String)charSequence), "", "", "AES", "HmacSHA1", sCT.getKeySize() / 8);
                    byte[] byArray = ((DerivedKeyGenerator)serializable2).createKeyBytes(sCT.getServerSecret((String)charSequence), sCT.getKeySize() / 8);
                    if (string != null && n != 0) {
                        serializable3 = new DerivedKeyGenerator(byArray, dKToken.getClientLabel(), dKToken.getServiceLabel(), "AES", "HmacSHA1", n);
                        sCT.setDerivedKeyGenerator((String)charSequence + new Integer(n).toString(), (DerivedKeyGenerator)serializable3);
                    }
                }
                if (serializable3 == null) break block14;
                serializable2 = serializable3;
                synchronized (serializable2) {
                    serializable = ((DerivedKeyGenerator)serializable3).createKey(dKToken.getNonce(), n);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.DKG", new Object[]{noSuchAlgorithmException});
                throw noSuchAlgorithmException;
            }
            catch (InvalidKeyException invalidKeyException) {
                Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.DKG", new Object[]{invalidKeyException});
                throw invalidKeyException;
            }
        }
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("createDerivedKey(SCT, DKT, String, int)");
            ((StringBuffer)charSequence).append(" returns key [").append(serializable).append("])");
            Tr.exit(tc, ((StringBuffer)charSequence).toString());
        }
        return serializable;
    }

    public static final SCTWrapper createSCTWrapper(SCT sCT, String string) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("createSCTWrapper(");
            ((StringBuffer)object).append("SCT sctoken, String instance)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = sCT.getInstances();
        SCT.KeyHistoryEntry[] keyHistoryEntryArray = new SCT.KeyHistoryEntry[((String[])object).length];
        SCTWrapper sCTWrapper = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Instances in the list = " + ((Object)object).length);
        }
        for (int i = 0; i < ((Object)object).length; ++i) {
            keyHistoryEntryArray[i] = sCT.getKeyHistoryEntry((String)object[i]);
        }
        sCTWrapper = new SCTWrapper(sCT.getUUID(), keyHistoryEntryArray, sCT.getId(), string);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("createSCTWrapper(SCT, String)");
            stringBuffer.append(" returns SCTWrapper [");
            stringBuffer.append(sCTWrapper == null ? null : sCTWrapper.getCurrentInstance());
            stringBuffer.append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return sCTWrapper;
    }

    private static class DKTContent {
        String sLabel = null;
        String cLabel = null;
        String refTokenUUID = null;
        String refTokenId = null;
        QName refTokenType = null;
        QName tokenType = new QName("", com.ibm.ws.wssecurity.common.Constants.NS_WSC_DKT);
        long keyLength = 0L;
        String refInstance = null;
        SCT sct = null;

        private DKTContent() {
        }

        private void set(SCT sCT, TokenGeneratorConfig tokenGeneratorConfig, long l, String string, String string2, String string3, String string4) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DKTContent.set(" + sCT + ", " + tokenGeneratorConfig + ", " + l + "," + string + ", " + string2 + "," + string3 + ")");
            }
            this.sLabel = string == null ? (String)tokenGeneratorConfig.getProperties().get("com.ibm.ws.wssecurity.sc.dkt.ServiceLabel") : string;
            this.cLabel = string2 == null ? (String)tokenGeneratorConfig.getProperties().get("com.ibm.ws.wssecurity.sc.dkt.ClientLabel") : string2;
            this.refTokenUUID = sCT.getUUID();
            this.refTokenId = string4;
            this.refTokenType = sCT.getValueType();
            this.keyLength = l;
            this.refInstance = string3;
            this.sct = sCT;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The labels are set via properties, service label = " + this.sLabel + " and client label = " + this.cLabel);
                Tr.debug(tc, "The key length is = " + this.keyLength);
                Tr.debug(tc, "The key instance is = " + string3);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "set(" + sCT + ", " + tokenGeneratorConfig + ", " + l + "," + string + ", " + string2 + ") return");
            }
        }

        public long getKeyLength() {
            return this.keyLength;
        }

        public QName getRefTokenType() {
            return this.refTokenType;
        }

        public String getRefTokenUUID() {
            return this.refTokenUUID;
        }

        public String getRefTokenId() {
            return this.refTokenId;
        }

        public QName getType() {
            return this.tokenType;
        }

        public String getServiceLabel() {
            return this.sLabel;
        }

        public String getClientLabel() {
            return this.cLabel;
        }

        public String getRefInstanceUUID() {
            return this.refInstance;
        }

        public SCT getSCT() {
            return this.sct;
        }

        static /* synthetic */ void access$100(DKTContent dKTContent, SCT sCT, TokenGeneratorConfig tokenGeneratorConfig, long l, String string, String string2, String string3, String string4) {
            dKTContent.set(sCT, tokenGeneratorConfig, l, string, string2, string3, string4);
        }
    }
}

