/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.security.trust10.util.DerivedKeyGenerator;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.SCTConsumeCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.handler.PolicyConfigUtil;
import com.ibm.ws.wssecurity.handler.PolicyInboundConfig;
import com.ibm.ws.wssecurity.impl.auth.callback.SCTCallback;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheHelper;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSTokenUtil;
import com.ibm.ws.wssecurity.trust.server.sts.ext.sct.SCTHelper;
import com.ibm.ws.wssecurity.util.Axis2Util;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtil;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.TokenHolder;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCT;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTGenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTWrapper;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.xml.xss4j.domutil.DOMUtil;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.io.Serializable;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCTConsumeLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(SCTConsumeLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = SCTConsumeLoginModule.class.getName();
    private CallbackHandler _handler;
    private SecurityToken _token;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = callbackHandler;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        PropertyCallback propertyCallback = new PropertyCallback(null);
        SCTCallback sCTCallback = new SCTCallback();
        SCTConsumeCallback sCTConsumeCallback = new SCTConsumeCallback();
        Callback[] callbackArray = new Callback[]{sCTCallback, sCTConsumeCallback, propertyCallback};
        try {
            this._handler.handle(callbackArray);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".login", "160", this);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{exception.toString()}));
        }
        this._context = propertyCallback.getProperties();
        TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
        DKToken dKToken = new DKToken();
        this._context.put(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING, dKToken);
        QName qName = tokenConsumerConfig.getType();
        if (!com.ibm.ws.wssecurity.common.Constants.SCT.equals(qName)) {
            String string = ConfigUtil.getMessage("security.wssecurity.PrivateConsumerConfig.s30", new String[]{qName.toString(), com.ibm.ws.wssecurity.common.Constants.SCT.toString()});
            throw new LoginException(string);
        }
        boolean bl5 = bl4 = !sCTCallback.isExist();
        if (tc.isDebugEnabled()) {
            if (bl4) {
                Tr.debug(tc, "WSSAPI in SCTConsumeLoginModule.");
            } else {
                Tr.debug(tc, "PolicySet in SCTConsumeLoginModule");
            }
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        if (bl4) {
            string = sCTConsumeCallback.getServiceLabel();
            string2 = sCTConsumeCallback.getClientLabel();
            string3 = sCTConsumeCallback.getEncryptionAlgorithm();
        }
        this._securityTokenManager = (SecurityTokenManagerImpl)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        String string4 = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        OMElement oMElement = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        if (string4 == null) {
            bl3 = true;
            bl2 = false;
            bl = false;
        } else {
            bl3 = false;
            bl = ConfigUtil.isKeyInfoStrref(string4);
            bl2 = ConfigUtil.isKeyInfoEmb(string4);
        }
        if (bl3 || bl2) {
            this._token = this.processElement(dKToken, oMElement, tokenConsumerConfig, bl4, bl3, bl2, this._securityTokenManager, this._context, string3);
        } else if (bl) {
            this._token = this.deriveKey(dKToken, tokenConsumerConfig, bl4, string, string2, bl, this._securityTokenManager);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        this._securityTokenManager.addToken(this._token);
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._token);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final SecurityToken deriveKey(DKToken dKToken, TokenConsumerConfig tokenConsumerConfig, boolean bl, String string, String string2, boolean bl2, SecurityTokenManager securityTokenManager) throws LoginException {
        Object object;
        void var13_18;
        boolean bl3;
        Object object2;
        Object object3;
        block58: {
            Object object4;
            Object object5;
            Map<String, Object> map;
            Object object6;
            String string3;
            Object object7;
            String string4;
            if (tc.isEntryEnabled()) {
                object3 = new StringBuffer("deriveKey(");
                ((StringBuffer)object3).append("DKToken dkToken, TokenConsumerConfig config, ");
                ((StringBuffer)object3).append("boolean isWSSAPI[").append(bl).append("], ");
                ((StringBuffer)object3).append("String serverLabel[").append(string).append("], ");
                ((StringBuffer)object3).append("String clientLabel[").append(string2).append("], ");
                ((StringBuffer)object3).append("boolean isStrref[").append(bl2).append("])");
                Tr.entry(tc, ((StringBuffer)object3).toString());
            }
            object3 = null;
            SCTWrapper sCTWrapper = null;
            final DKToken dKToken2 = new DKToken();
            if (bl2) {
                Object object8;
                if (this._context.get("ImpliedDerivedKeys_Nonce_Prop") != null) {
                    int n;
                    string4 = null;
                    object8 = null;
                    int bl4 = 32;
                    object7 = null;
                    string4 = (String)this._context.get("ImpliedDerivedKeys_Nonce_Prop");
                    object8 = (String)this._context.get("ImpliedDerivedKeys_Length_Prop");
                    if (object8 != null) {
                        n = new Integer((String)object8);
                    }
                    if (string4 != null) {
                        object7 = Base64.decode(string4);
                    }
                    string3 = (String)this._context.get(Constants.WSSECURITY_KEY_REFERENCE);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Implied derived keys are used");
                        Tr.debug(tc, "Token identifier is [" + string3 + "]");
                    }
                    if ((object6 = securityTokenManager.getToken(tokenConsumerConfig, string3)) == null) {
                        Tr.error(tc, "security.wssecurity.SCTConsumeLoginModule.missingDKT", new Object[]{string3});
                        throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.missingDKT", new String[]{string3}));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There was the token [" + string3 + "] in the Subject.");
                    }
                    sCTWrapper = (SCTWrapper)object6;
                    dKToken2.setrefTokenId(sCTWrapper.getSCT().getId());
                    dKToken2.setrefTokenType("", com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT);
                    dKToken2.setLength(n);
                    dKToken2.setNonce((byte[])object7);
                    dKToken2.setSecurityContextToken(sCTWrapper);
                    String string5 = (String)tokenConsumerConfig.getProperties().get("com.ibm.ws.wssecurity.sc.dkt.ClientLabel");
                    map = (String)tokenConsumerConfig.getProperties().get("com.ibm.ws.wssecurity.sc.dkt.ServiceLabel");
                    if (string5 == null) {
                        string5 = "WS-SecureConversation";
                    }
                    if (map == null) {
                        map = "WS-SecureConversation";
                    }
                    if (bl && string != null) {
                        map = string;
                        string5 = string2;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Server label = " + string + ", Client label = " + string2);
                        }
                    }
                    String string6 = string5;
                    Map<String, Object> map2 = map;
                    object2 = sCTWrapper.getSCT().getUUID();
                    AccessController.doPrivileged(new PrivilegedAction<Object>((String)object2, string6, (String)((Object)map2)){
                        final /* synthetic */ String val$uuid;
                        final /* synthetic */ String val$cL;
                        final /* synthetic */ String val$sL;
                        {
                            this.val$uuid = string;
                            this.val$cL = string2;
                            this.val$sL = string3;
                        }

                        @Override
                        public Object run() {
                            dKToken2.setSecurityContextTokenUUID(this.val$uuid);
                            dKToken2.setClientLabel(this.val$cL);
                            dKToken2.setServiceLabel(this.val$sL);
                            return null;
                        }
                    });
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Labels via properties, service label = " + (String)((Object)map) + " and client label = " + string5);
                    }
                    dKToken = dKToken2;
                    object3 = dKToken;
                } else {
                    string4 = (String)this._context.get(Constants.WSSECURITY_KEY_REFERENCE);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Token identifier is [" + string4 + "]");
                    }
                    if ((object8 = securityTokenManager.getToken(tokenConsumerConfig, string4)) == null) {
                        Tr.error(tc, "security.wssecurity.SCTConsumeLoginModule.missingDKT", new Object[]{string4});
                        throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.missingDKT", new String[]{string4}));
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There was the token [" + string4 + "] in the Subject.");
                    }
                    dKToken = (DKToken)object8;
                    object3 = object8;
                }
            }
            if ((string4 = (String)this._context.get(Constants.WSSECURITY_KEY_TYPE)) == null) {
                boolean bl4 = false;
                bl3 = false;
            } else {
                bl3 = "VerifyingKey".equals(string4);
                boolean bl5 = "DecryptingKey".equals(string4);
                if (tc.isDebugEnabled()) {
                    if (bl3) {
                        Tr.debug(tc, "Verifying key type");
                    } else if (bl5) {
                        Tr.debug(tc, "Decrypting key type");
                    }
                }
            }
            if (!bl3 && var13_18 == false) {
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.getKey02", new String[]{string4}));
            }
            sCTWrapper = (SCTWrapper)dKToken.getSecurityContextToken();
            object7 = sCTWrapper.getSCT();
            if (object7 == null) {
                throw new LoginException("Cannot get SCT info to derive key");
            }
            string3 = sCTWrapper.getCurrentInstance();
            object6 = null;
            int n = 0;
            if ((String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm") != null) {
                map = SCTGenerateLoginModule.getKeyAlgorithm((String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm"), bl3, (boolean)var13_18, false, false);
                object6 = (String)map.get("algorithm");
                if (object6 == null) {
                    throw new LoginException("Missing Algorithm info in the config");
                }
                n = (Integer)map.get("keylength");
            }
            int n2 = dKToken.getLength();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "About to derive the Key..The instance is = " + string3);
                Tr.debug(tc, "The supplied algorithm: " + (String)this._context.get("com.ibm.ws.wssecurity.keyinfo.keyAlgorithm") + "Key algorithm and key length based on algorithm are = " + (String)object6 + ", " + n);
                Tr.debug(tc, "The key Length from the message = " + n2);
            }
            int n3 = 16;
            int n4 = 32;
            if (!bl) {
                object2 = (WSSConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
                object = ((PolicyInboundConfig)object2).getAlgorithmSuite();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The Algorithm Suite = " + (String)object);
                }
                object5 = PolicyConfigUtil.getMinimumSymmetricKeyLength((String)object);
                n3 = Integer.parseInt((String)object5) / 8;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The min Dervived Key Length is " + n3);
                }
                object4 = (String)tokenConsumerConfig.getProperties().get(Constants.DERIVED_KEY_LENGTH);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The specified Dervived Key Length is " + (String)object4);
                }
                if (object != null) {
                    n = SCTGenerateLoginModule.getKeyLength(bl3, (String)object, (String)object4);
                }
            }
            if (n2 == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Missing Length information in the message. Using the key Length based on the algorithm = " + n);
                }
            } else {
                if (n2 > 0 && n2 < n3 || n2 > n4) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The key Length from the message = " + n + " is incorrect.");
                    }
                    throw new LoginException("DerivedKey Length in the message doesn't match with the algorithm's");
                }
                n = n2;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using the key Length from the message = " + n);
                }
            }
            object2 = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Key Size (in bits) based on Algorithm Suite = " + ((SCT)object7).getKeySize());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keyInstance = " + string3 + ", ServerSecret = " + Base64.encode(((SCT)object7).getServerSecret(string3)) + ", ClientSecret = " + Base64.encode(((SCT)object7).getClientSecret(string3)) + ", entropy Key Size (in bits) based on Algorithm Suite = " + ((SCT)object7).getKeySize());
                }
                if ((object = ((SCT)object7).getDerivedKeyGenerator(string3 + new Integer(n).toString())) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found cached DerivedKeyGenerator");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Creating DerivedKeyGenerator, key length = " + new Integer(n).toString());
                    }
                    object5 = new DerivedKeyGenerator(((SCT)object7).getClientSecret(string3), "", "", "AES", "HmacSHA1", ((SCT)object7).getKeySize() / 8);
                    object4 = ((DerivedKeyGenerator)object5).createKeyBytes(((SCT)object7).getServerSecret(string3), ((SCT)object7).getKeySize() / 8);
                    if (object6 != null && n != 0) {
                        object = new DerivedKeyGenerator((byte[])object4, dKToken.getClientLabel(), dKToken.getServiceLabel(), "AES", "HmacSHA1", n);
                        ((SCT)object7).setDerivedKeyGenerator(string3 + new Integer(n).toString(), (DerivedKeyGenerator)object);
                    }
                }
                if (object == null) break block58;
                object5 = object;
                synchronized (object5) {
                    object2 = ((DerivedKeyGenerator)object).createKey(dKToken.getNonce(), n);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.DKG", new Object[]{noSuchAlgorithmException});
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG", new String[]{noSuchAlgorithmException.toString()}));
            }
            catch (InvalidKeyException invalidKeyException) {
                Tr.error(tc, "security.wssecurity.SCTGenerateLoginModule.DKG", new Object[]{invalidKeyException});
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG", new String[]{invalidKeyException.toString()}));
            }
        }
        if (object2 == null) {
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.DKG02"));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Derived key algorithm =  " + object2.getAlgorithm() + ", and key = " + Base64.encode(object2.getEncoded()) + ", key length = " + object2.getEncoded().length);
        }
        if (bl3) {
            dKToken.setKey(63, (Key)object2);
        } else if (var13_18 != false) {
            dKToken.setKey(64, (Key)object2);
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("deriveKey(");
            ((StringBuffer)object).append("DKToken, TokenConsumerConfig, ");
            ((StringBuffer)object).append("boolean, String, String, boolean, ");
            ((StringBuffer)object).append("SecurityTokenManager)");
            ((StringBuffer)object).append(" returns SecurityToken[").append(object3).append("]");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return object3;
    }

    private final SecurityToken processElement(final DKToken dKToken, OMElement oMElement, TokenConsumerConfig tokenConsumerConfig, boolean bl, boolean bl2, boolean bl3, SecurityTokenManager securityTokenManager, Map<Object, Object> map, String string) throws LoginException {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("processElement(");
            ((StringBuffer)serializable).append("DKToken dkToken, ");
            ((StringBuffer)serializable).append("OMElement target[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)serializable).append("TokenConsumerConfig config, ");
            ((StringBuffer)serializable).append("boolean isWSSAPI[").append(bl).append("], ");
            ((StringBuffer)serializable).append("boolean isNone[").append(bl2).append("], ");
            ((StringBuffer)serializable).append("boolean isEmb[").append(bl3).append("], ");
            ((StringBuffer)serializable).append("SecurityTokenManager securityTokenManager, Map context, String encAlg)");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        Object object = null;
        if (oMElement.getNamespace().getNamespaceURI().equals(com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC) && oMElement.getLocalName().equals("SecurityContextToken")) {
            Object object2;
            Object object3;
            OMElement oMElement2 = DOMUtils.getChildElement(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Identifier");
            String string2 = DOMUtils.getStringValue(oMElement2);
            QName qName = IdUtils.getInstance().getIdAttributeName(oMElement);
            String string3 = oMElement.getAttributeValue(qName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT id = " + string3);
            }
            OMElement oMElement3 = DOMUtils.getChildElement(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Instance");
            String string4 = null;
            if (oMElement3 != null) {
                string4 = DOMUtils.getStringValue(oMElement3);
                if (string4 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "instance is null " + DOMUtils.toString(oMElement3));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "instance is = " + string4);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "instance element is null");
            }
            SCT sCT = new SCT(string2);
            sCT.setXML(new OMStructure(oMElement));
            if (string3 != null) {
                sCT.setId(string3);
                sCT.setReferenceURI("#" + string3);
            }
            if ((oMElement2 = DOMUtils.getChildElement(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSU, "Created")) != null) {
                try {
                    object3 = UTC.parse(DOMUtils.getStringValue(oMElement2));
                    sCT.setCreation(string4, (Date)object3);
                }
                catch (ParseException parseException) {
                    throw new LoginException("Parsing of createtion date failed!");
                }
            }
            if ((oMElement2 = DOMUtils.getChildElement(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSU, "Expires")) != null) {
                try {
                    object3 = UTC.parse(DOMUtils.getStringValue(oMElement2));
                    sCT.setExpiration(string4, (Date)object3);
                }
                catch (ParseException parseException) {
                    throw new LoginException("Parsing of createtion date failed!");
                }
            }
            object3 = null;
            String string5 = "256";
            int n = 256;
            if (!bl) {
                object2 = (WSSConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
                object3 = ((PolicyInboundConfig)object2).getAlgorithmSuite();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The Algorithm Suite = " + (String)object3);
                }
                string5 = PolicyConfigUtil.getMinimumSymmetricKeyLength((String)object3);
                n = Integer.parseInt(string5);
            } else if (string != null) {
                object2 = SCTGenerateLoginModule.getKeyAlgorithm(string, false, true, false, false);
                n = (Integer)object2.get("keylength");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Key Size (in bits) based on the algorihthm Suite = " + n);
            }
            sCT.setKeySize(n);
            object2 = SCTConsumeLoginModule.verifySCT(sCT, string4, bl, (MessageContext)serializable);
            if (object2 != null) {
                String string6;
                SecurityToken securityToken;
                ((SecurityTokenImpl)object2).setXML(new OMStructure(oMElement));
                if (string3 != null) {
                    ((SecurityTokenImpl)object2).setId(string3);
                    ((SecurityTokenImpl)object2).setReferenceURI("#" + string3);
                }
                object = (securityToken = securityTokenManager.getToken(tokenConsumerConfig, string6 = ((SecurityTokenImpl)object2).getId())) == null ? object2 : securityToken;
            }
        } else {
            String string7;
            Object object4;
            Object object5;
            boolean bl4 = false;
            SCTWrapper sCTWrapper = null;
            String string8 = null;
            if (bl2) {
                object5 = IdUtils.getInstance().getIdAttributeName(oMElement);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The identifier attribute of the dktoken target element is [" + object5 + "].");
                }
                if (object5 != null) {
                    string8 = oMElement.getAttributeValue((QName)object5);
                }
            }
            dKToken.setId(string8);
            SCTConsumeLoginModule.consumeDKTokenElement(dKToken, oMElement, (MessageContext)serializable, map);
            object5 = dKToken.getSecurityContextTokenTokenUUID();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "dktoken id = " + dKToken.getId());
                Tr.debug(tc, "dktoken's reference token Id = " + dKToken.getrefTokenId());
                Tr.debug(tc, "dktoken's reference token uuid = " + (String)object5);
            }
            if (object5 != null) {
                boolean bl5 = false;
                try {
                    bl5 = Axis2Util.isServiceProvider(serializable);
                }
                catch (Exception exception) {
                    throw new LoginException(exception.getMessage());
                }
                object4 = null;
                string7 = null;
                if (bl5) {
                    block47: {
                        if (SCTHelper.getCache() != null) {
                            object4 = (SCT)SCTHelper.getCache().getToken((String)object5);
                        }
                        if (object4 == null) {
                            try {
                                object4 = (SCT)STSTokenUtil.getToken((String)object5, "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
                            }
                            catch (Exception exception) {
                                if (!tc.isDebugEnabled()) break block47;
                                Tr.debug(tc, "Exception from trust service:" + exception.getMessage());
                            }
                        }
                    }
                    string7 = (String)((MessageContext)serializable).getProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage");
                } else {
                    object4 = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID((String)object5);
                    string7 = (String)((MessageContext)serializable).getProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found SCT in the global cache.");
                        Tr.debug(tc, "instance info should be there in the message context, instance = " + string7);
                    }
                }
                if (string7 == null) {
                    string7 = SCTConsumeLoginModule.searchFirstInstance((SCT)object4);
                }
                if (object4 != null) {
                    bl4 = true;
                    sCTWrapper = SCTGenerateLoginModule.createSCTWrapper((SCT)object4, string7);
                    sCTWrapper.setSCT((SCT)object4);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found SCT in the global cache. Verification of DKtoken is successful!!");
                    }
                }
            }
            if (!bl4) {
                Tr.error(tc, "Can't find SCToken using the reference info from the Derived Key Token Element. ");
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.verifyDKT"));
            }
            dKToken.setSecurityContextToken(sCTWrapper);
            String string9 = (String)tokenConsumerConfig.getProperties().get("com.ibm.ws.wssecurity.sc.dkt.ClientLabel");
            object4 = (String)tokenConsumerConfig.getProperties().get("com.ibm.ws.wssecurity.sc.dkt.ServiceLabel");
            if (string9 == null) {
                string9 = "WS-SecureConversation";
            }
            if (object4 == null) {
                object4 = "WS-SecureConversation";
            }
            string7 = string9;
            Object object6 = object4;
            AccessController.doPrivileged(new PrivilegedAction<Object>((String)object6){
                final /* synthetic */ String val$sL;
                {
                    this.val$sL = string2;
                }

                @Override
                public Object run() {
                    dKToken.setClientLabel(string7);
                    dKToken.setServiceLabel(this.val$sL);
                    return null;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Labels via properties, service label = " + (String)object4 + " and client label = " + string9);
                Tr.debug(tc, "Adding DKT to the subject using id: " + dKToken.getId());
            }
            object = dKToken;
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("processElement(");
            stringBuffer.append("DKToken, OMElement, TokenConsumerConfig, ");
            stringBuffer.append("boolean, boolean, boolean, securityTokenManager, Map)");
            stringBuffer.append(" returns SecurityToken[").append(object).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final SCTWrapper verifySCT(SCT sCT, String string, boolean bl, MessageContext messageContext) throws LoginException {
        Serializable serializable;
        SCTWrapper sCTWrapper;
        block31: {
            block30: {
                block29: {
                    if (tc.isEntryEnabled()) {
                        StringBuffer stringBuffer = new StringBuffer("verifySCT(SCT sct, ");
                        stringBuffer.append("String keyInstance(").append(string).append("], ");
                        stringBuffer.append("boolean isWSSAPI(").append(bl).append("], ");
                        stringBuffer.append("MessageContext messageContext)");
                        Tr.entry(tc, stringBuffer.toString());
                    }
                    boolean bl2 = false;
                    try {
                        bl2 = Axis2Util.isServiceProvider(messageContext);
                    }
                    catch (Exception exception) {
                        throw new LoginException(exception.getMessage());
                    }
                    sCTWrapper = null;
                    if (!bl2) break block30;
                    serializable = null;
                    if (SCTHelper.getCache() != null) {
                        serializable = (SCT)SCTHelper.getCache().getToken(sCT.getUUID());
                    }
                    if (serializable == null) {
                        try {
                            serializable = (SCT)STSTokenUtil.getToken(sCT.getUUID(), "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block29;
                            Tr.debug(tc, "Exception while getting SCT from trust service:" + exception.getMessage());
                        }
                    }
                }
                if (serializable == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Can not find SCT from trust server cache.");
                    }
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT02"));
                }
                if (string == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No instance information in the message");
                    }
                    string = SCTConsumeLoginModule.searchFirstInstance((SCT)serializable);
                }
                if ((serializable = SCTConsumeLoginModule.checkKeyInstance((SCT)serializable, string)) != null && string != null && ((SCT)serializable).isValid(string, 0L)) {
                    HashMap hashMap;
                    try {
                        hashMap = messageContext.getTo().getAddress();
                        boolean bl3 = ((SCT)serializable).validateAppliesToURI((String)((Object)hashMap));
                        if (!bl3) {
                            throw new LoginException("SCT is not applicable to the end point specified!");
                        }
                        ((SecurityTokenImpl)serializable).setId(sCT.getId());
                        ((SecurityTokenImpl)serializable).setReferenceURI("#" + sCT.getId());
                        ((SCT)serializable).setKeySize(sCT.getKeySize());
                    }
                    catch (Exception exception) {
                        throw new LoginException(exception.getMessage());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server side, saving the token in message context context using the WSSECURITY_SECURECONVERSATION_IDENTIFIER as key and uuid = " + ((SCT)serializable).getUUID());
                        Tr.debug(tc, "Server side, saving the token in message context using INBOUND_SCTOKEN as key, token uuid = " + ((SCT)serializable).getUUID());
                        Tr.debug(tc, "Saving the instance in message context = " + string);
                    }
                    hashMap = null;
                    hashMap = (HashMap)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                    if (hashMap == null) {
                        hashMap = new HashMap();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Save the uuid and instance in the wss-ramp propertymap");
                        }
                    }
                    hashMap.put(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER, ((SCT)serializable).getUUID());
                    hashMap.put("com.ibm.ws.wssecurity.sc.InstanceFromMessage", string);
                    messageContext.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", hashMap);
                    messageContext.setProperty(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER, ((SCT)serializable).getUUID());
                    messageContext.setProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage", string);
                    TokenHolder.setInboundTokenToContext((SCT)serializable, messageContext);
                    sCTWrapper = SCTGenerateLoginModule.createSCTWrapper((SCT)serializable, string);
                    sCTWrapper.setXML(sCT.getXML());
                    sCTWrapper.setSCT((SCT)serializable);
                    break block31;
                } else {
                    if (serializable == null) {
                        throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT02"));
                    }
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.invalidSCT"));
                }
            }
            serializable = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(sCT.getUUID());
            if (string == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No instance information in the message");
                }
                if (((SCT)serializable).getInstances() != null) {
                    string = SCTConsumeLoginModule.searchFirstInstance((SCT)serializable);
                }
            }
            if (serializable != null && string != null && ((SCT)serializable).isValid(string, 0L)) {
                sCTWrapper = SCTGenerateLoginModule.createSCTWrapper((SCT)serializable, string);
                sCTWrapper.setXML(sCT.getXML());
                sCTWrapper.setKeySize(sCT.getKeySize());
                sCTWrapper.setSCT((SCT)serializable);
                messageContext.setProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage", string);
            } else {
                if (serializable == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Null SCT");
                    }
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT03"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid SCT");
                }
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT03"));
            }
        }
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("verifySCT(SCT, String, ");
            ((StringBuffer)serializable).append("boolean, MessageContext)");
            ((StringBuffer)serializable).append(" returns SCTWrapper[").append(sCTWrapper).append("]");
            Tr.exit(tc, ((StringBuffer)serializable).toString());
        }
        return sCTWrapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final SCTWrapper resolveSCT(String string, String string2, MessageContext messageContext) throws LoginException {
        Serializable serializable;
        SCTWrapper sCTWrapper;
        block31: {
            block30: {
                block29: {
                    if (tc.isEntryEnabled()) {
                        StringBuffer stringBuffer = new StringBuffer("resolveSCT(String uuid, ");
                        stringBuffer.append("String keyInstance(").append(string2).append("], ");
                        stringBuffer.append("MessageContext messageContext)");
                        Tr.entry(tc, stringBuffer.toString());
                    }
                    boolean bl = false;
                    try {
                        bl = Axis2Util.isServiceProvider(messageContext);
                    }
                    catch (Exception exception) {
                        throw new LoginException(exception.getMessage());
                    }
                    sCTWrapper = null;
                    if (!bl) break block30;
                    serializable = null;
                    if (SCTHelper.getCache() != null) {
                        serializable = (SCT)SCTHelper.getCache().getToken(string);
                    }
                    if (serializable == null) {
                        try {
                            serializable = (SCT)STSTokenUtil.getToken(string, "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
                        }
                        catch (Exception exception) {
                            if (!tc.isDebugEnabled()) break block29;
                            Tr.debug(tc, "Exception while getting SCT from trust service:" + exception.getMessage());
                        }
                    }
                }
                if (serializable == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Can not find SCT from trust server cache.");
                    }
                    throw new LoginException("SCT Not Found");
                }
                if (string2 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No instance information in the message");
                    }
                    string2 = SCTConsumeLoginModule.searchFirstInstance((SCT)serializable);
                }
                if ((serializable = SCTConsumeLoginModule.checkKeyInstance((SCT)serializable, string2)) != null && string2 != null && ((SCT)serializable).isValid(string2, 0L)) {
                    HashMap hashMap;
                    try {
                        hashMap = messageContext.getTo().getAddress();
                        boolean bl = ((SCT)serializable).validateAppliesToURI((String)((Object)hashMap));
                        if (!bl) {
                            throw new LoginException("SCT is not applicable to the end point specified!");
                        }
                    }
                    catch (Exception exception) {
                        throw new LoginException(exception.getMessage());
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Server side, saving the token in message context context using the WSSECURITY_SECURECONVERSATION_IDENTIFIER as key and uuid = " + ((SCT)serializable).getUUID());
                        Tr.debug(tc, "Server side, saving the token in message context using INBOUND_SCTOKEN as key, token uuid = " + ((SCT)serializable).getUUID());
                        Tr.debug(tc, "Saving the instance in message context = " + string2);
                    }
                    hashMap = null;
                    hashMap = (HashMap)messageContext.getProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP");
                    if (hashMap == null) {
                        hashMap = new HashMap();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Save the uuid and instance in the wss-ramp propertymap");
                        }
                    }
                    hashMap.put(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER, ((SCT)serializable).getUUID());
                    hashMap.put("com.ibm.ws.wssecurity.sc.InstanceFromMessage", string2);
                    messageContext.setProperty("com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP", hashMap);
                    messageContext.setProperty(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER, ((SCT)serializable).getUUID());
                    messageContext.setProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage", string2);
                    TokenHolder.setInboundTokenToContext((SCT)serializable, messageContext);
                    sCTWrapper = SCTGenerateLoginModule.createSCTWrapper((SCT)serializable, string2);
                    sCTWrapper.setXML(((SecurityTokenImpl)serializable).getXML());
                    sCTWrapper.setSCT((SCT)serializable);
                    break block31;
                } else {
                    if (serializable == null) {
                        throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT02"));
                    }
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTGenerateLoginModule.invalidSCT"));
                }
            }
            serializable = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(string);
            if (string2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No instance information in the message");
                }
                if (((SCT)serializable).getInstances() != null) {
                    string2 = SCTConsumeLoginModule.searchFirstInstance((SCT)serializable);
                }
            }
            if (serializable != null && string2 != null && ((SCT)serializable).isValid(string2, 0L)) {
                sCTWrapper = SCTGenerateLoginModule.createSCTWrapper((SCT)serializable, string2);
                sCTWrapper.setXML(((SecurityTokenImpl)serializable).getXML());
                sCTWrapper.setKeySize(((SCT)serializable).getKeySize());
                sCTWrapper.setSCT((SCT)serializable);
                messageContext.setProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage", string2);
            } else {
                if (serializable == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Null SCT");
                    }
                    throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT03"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid SCT");
                }
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.SCTConsumeLoginModule.invalidSCT03"));
            }
        }
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("resolveSCT(String, String, ");
            ((StringBuffer)serializable).append("boolean, MessageContext)");
            ((StringBuffer)serializable).append(" returns SCTWrapper[").append(sCTWrapper).append("]");
            Tr.exit(tc, ((StringBuffer)serializable).toString());
        }
        return sCTWrapper;
    }

    private static SCT checkKeyInstance(SCT sCT, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkKeyInstance");
        }
        String[] stringArray = sCT.getInstances();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found matching key instance in SCT.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkKeyInstance");
            }
            return sCT;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Not Found matching key instance in SCT due to replication. Retry from cache.");
        }
        SCT sCT2 = null;
        boolean bl = false;
        for (int i = 0; !bl && i < 10; ++i) {
            block15: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Found matching key instance in SCT. Retry from cache " + i + 1 + " times.");
                }
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    sCT2 = (SCT)STSTokenUtil.getToken(sCT.getUUID(), "http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
                    stringArray = sCT2.getInstances();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block15;
                    Tr.debug(tc, "Exception while getting SCT from trust service:" + exception.getMessage());
                }
            }
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].equalsIgnoreCase(string)) continue;
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found matching key instance in SCT during " + i + 1 + " retry.");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkKeyInstance");
                }
                return sCT2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkKeyInstance Fails.");
        }
        return sCT;
    }

    private static final void consumeDKTokenElement(final DKToken dKToken, OMElement oMElement, MessageContext messageContext, Map<Object, Object> map) throws LoginException {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("consumeDKTokenElement(");
            serializable.append("DKToken dkToken, ");
            serializable.append("OMElement target(").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            serializable.append("MessageContext messageContext, Map context)");
            Tr.entry(tc, serializable.toString());
        }
        if (oMElement != null && oMElement.getNamespace().getNamespaceURI().equals(com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC) && oMElement.getLocalName().equals("DerivedKeyToken")) {
            String string;
            Object object;
            String string2;
            String string3;
            dKToken.setXML(new OMStructure(oMElement));
            dKToken.setrefTokenType("", com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT);
            serializable = IdUtils.getInstance().getIdAttributeName(oMElement);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The identifier attribute of the target element is [" + serializable + "].");
            }
            if (serializable != null && (string3 = oMElement.getAttributeValue((QName)serializable)) != null) {
                dKToken.setId(string3);
            }
            string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            OMElement oMElement2 = DOMUtils.getChildElement(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "SecurityTokenReference");
            if (oMElement2 != null) {
                oMElement2 = DOMUtils.getChildElement(oMElement2, com.ibm.ws.wssecurity.common.Constants.NS_WSSE, "Reference");
                string2 = oMElement2.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.URI_Q);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Reference Token URI in DerivedKeyToken element: " + string2);
                }
                if (string2.startsWith("#")) {
                    string3 = string2.substring(1);
                    string4 = SCTConsumeLoginModule.getUUIDByRef(string3, messageContext, map);
                    string6 = (String)messageContext.getProperty("com.ibm.ws.wssecurity.sc.InstanceFromMessage");
                } else {
                    string4 = string2;
                    QName qName = new QName(com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Instance");
                    string6 = oMElement2.getAttributeValue(qName);
                    SCTConsumeLoginModule.resolveSCT(string4, string6, messageContext);
                }
                string5 = oMElement2.getAttributeValue(com.ibm.ws.wssecurity.common.Constants.VALUETYPE_Q);
            }
            dKToken.setrefTokenId(string3);
            string2 = string4;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    dKToken.setSecurityContextTokenUUID(string2);
                    return null;
                }
            });
            int n = 0;
            oMElement2 = DOMUtils.getChildElement(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Length");
            if (oMElement2 != null && (object = DOMUtils.getStringValue(oMElement2)) != null) {
                n = new Integer((String)object);
            }
            dKToken.setLength(n);
            oMElement2 = DOMUtils.getChildElement(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Nonce");
            object = null;
            if (oMElement2 != null && (string = DOMUtils.getStringValue(oMElement2)) != null) {
                object = Base64.decode(string);
            }
            dKToken.setNonce((byte[])object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "refTokenId = " + string3 + ", refTokenUUID = " + string4 + ", ttype = " + string5.toString());
                Tr.debug(tc, "Length = " + n);
                Tr.debug(tc, "nonce = " + (object != null ? "true" : "false"));
                if (string5.equals(com.ibm.ws.wssecurity.common.Constants.NS_WSC_SCT)) {
                    Tr.debug(tc, "Correct token value type: " + string5);
                }
                Tr.debug(tc, "Key instance = " + string6);
            }
        }
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("consumeDKTokenElement(DKToken, ");
            serializable.append("OMElement, MessageContext, Map)");
            Tr.exit(tc, serializable.toString());
        }
    }

    private static final String getUUIDByRef(String string, MessageContext messageContext, Map<Object, Object> map) {
        Serializable serializable;
        IdUtil idUtil;
        OMElement oMElement;
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("getUUIDByRef(");
            charSequence.append("String ref(").append(string).append("], ");
            charSequence.append("MessageContext messageContext, Map context)");
            Tr.entry(tc, charSequence.toString());
        }
        charSequence = null;
        SOAPEnvelope sOAPEnvelope = messageContext.getEnvelope();
        SOAPHeader sOAPHeader = sOAPEnvelope.getHeader();
        OMDocument oMDocument = DOMUtil.getOwnerDocument(sOAPHeader);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The original RM message to be processed : " + DOMUtils.toString(oMDocument.getOMDocumentElement()));
        }
        if ((oMElement = (idUtil = IdUtils.getInstance()).resolveID(oMDocument, string)) != null) {
            OMElement oMElement2;
            serializable = oMElement.getQName();
            if (new QName(com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "SecurityContextToken").equals(serializable) && (oMElement2 = DOMUtils.getChildElement(oMElement, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Identifier")) != null) {
                charSequence = DOMUtils.getStringValue(oMElement2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found the matching SCT(Attached reference) for wsu:Id = " + string + ", the uuid Identifier = " + (String)charSequence);
                }
            }
            if (charSequence == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "No SecurityContextToken element with the wsu:Id = " + string + " Found.");
            }
        }
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getUUIDByRef(String, ");
            ((StringBuffer)serializable).append("MessageContext, Map) returns String[").append((String)charSequence).append("]");
            Tr.exit(tc, ((StringBuffer)serializable).toString());
        }
        return charSequence;
    }

    private static String searchFirstInstance(SCT sCT) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchFirstInstance(SCT sctoken): No instance in Message, Use first issued instance.");
        }
        if (sCT == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "searchFirstInstanceList(SCT sctoken): no SCT.");
            }
            return null;
        }
        String string = null;
        Date date = new Date();
        String[] stringArray = sCT.getInstances();
        if (stringArray == null || stringArray.length == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "searchFirstInstance(SCT sctoken): no key instance.");
            }
            return null;
        }
        string = stringArray[0];
        if (tc.isDebugEnabled()) {
            if (sCT.getExpiration(string).after(date)) {
                Tr.debug(tc, "First Instance:" + string);
            } else {
                Tr.debug(tc, "First Instance expired:" + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchFirstInstanceList(SCT sctoken)");
        }
        return string;
    }
}

