/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.security.trust10.TrustException;
import com.ibm.security.trust10.client.STSRequestorFactory;
import com.ibm.security.trust10.types.IRSTTemplate;
import com.ibm.security.trust10.types.IRequestSecurityTokenResponse;
import com.ibm.security.trust10.types.IRequestSecurityTokenResponseCollection;
import com.ibm.security.trust10.types.IRequestedSecurityToken;
import com.ibm.security.trust10.types.ISTSConfiguration;
import com.ibm.security.trust10.util.DerivedKeyGenerator;
import com.ibm.websphere.wssecurity.callbackhandler.SCTGenerateCallbackHandler;
import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSGenerationContext;
import com.ibm.websphere.wssecurity.wssapi.token.DerivedKeyToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheConfig;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheConfigFactory;
import com.ibm.ws.wssecurity.platform.auth.SecureConversationCacheHelper;
import com.ibm.ws.wssecurity.sc.SecureConversationImpl;
import com.ibm.ws.wssecurity.token.UTC;
import com.ibm.ws.wssecurity.trust.server.sts.Util.STSUriUtil;
import com.ibm.ws.wssecurity.trust.server.sts.ext.ExternalizableToken;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.DKToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecureConversationToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecurityPermission;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.spi.BindingProvider;
import org.apache.axis2.util.ObjectStateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCT
extends SecureConversationToken
implements ExternalizableToken {
    private static final TraceComponent tc = Tr.register(SCT.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = 1710253288493106515L;
    private static final SecurityPermission RENEW_PERM = new SecurityPermission("wssapi.SCT.renew");
    private static final SecurityPermission CANCEL_PERM = new SecurityPermission("wssapi.SCT.cancel");
    private WSSGenerationContext wssGenerationContext;
    private WSSConsumingContext wssConsumingContext;
    private Map _map;
    private static final String comp = "security.wssecurity";
    private static final String clsName = SCT.class.getName();
    private SecurityTokenManagerImpl securityTokenManager = null;
    private Map dkgMap = null;
    public static final String SERIALIZATION_DESCRIPTION_UUID = "SCT.uuid";
    public static final String SERIALIZATION_DESCRIPTION_CLIENT_ID = "SCT.clientID";
    public static final String SERIALIZATION_DESCRIPTION_TOKEN_ID = "SCT.tokenID";
    public static final String SERIALIZATION_DESCRIPTION_CURRENT_INSTANCE = "SCT.currentInstance";
    public static final String SERIALIZATION_DESCRIPTION_KEY_MAP = "SCT.keyMap";
    public static final String SERIALIZATION_DESCRIPTION_APPLIES_TO = "SCT.appliesTo";
    public static final String SERIALIZATION_DESCRIPTION_ALGORITHM = "SCT.algorithm";
    public static final String SERIALIZATION_DESCRIPTION_PROVIDER = "SCT.provider";
    public static final String SERIALIZATION_DESCRIPTION_ISSUER = "SCT.issuer";
    public static final String SERIALIZATION_DESCRIPTION_INSTANCES = "SCT.instances";
    private String uuid = "";
    private String clientID = "";
    private String tokenID = "";
    private boolean isCancelled = false;
    private HashMap<String, KeyHistoryEntry> keyMap;
    private ArrayList appliesToList;
    private String issuer;
    private boolean renewable = false;
    private boolean renewableAfterExpiration = false;
    private ArrayList allKeyInstances = new ArrayList();
    private String algorithm = "";
    private String provider = "";
    private int keySize = 0;
    private byte[] serializedBytes = null;
    private static final String CLASS_NAME = SCT.class.getName();

    public SCT() {
        this.keyMap = new HashMap();
        this.appliesToList = new ArrayList();
    }

    public SCT(String string) {
        this();
        this.uuid = string;
    }

    public SCT(String string, KeyHistoryEntry[] keyHistoryEntryArray) {
        this(string);
        for (KeyHistoryEntry keyHistoryEntry : keyHistoryEntryArray) {
            String string2 = keyHistoryEntry.getInstance();
            this.addKeyInstance(string2, keyHistoryEntry);
        }
    }

    @Override
    public String getIdentifier() {
        return this.getUUID();
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getTokenID() {
        return this.tokenID;
    }

    @Override
    public String[] getInstances() {
        String[] stringArray = new String[this.allKeyInstances.size()];
        this.allKeyInstances.toArray(stringArray);
        return stringArray;
    }

    public KeyHistoryEntry getKeyHistoryEntry(String string) {
        return this.keyMap.get(string);
    }

    public byte[] getClientSecret(String string) {
        byte[] byArray;
        KeyHistoryEntry keyHistoryEntry = this.keyMap.get(string);
        byte[] byArray2 = byArray = keyHistoryEntry == null ? null : keyHistoryEntry.getClientSecret();
        if (this.readOnly && byArray != null) {
            int n = byArray.length;
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, 0, byArray3, 0, n);
            byArray = byArray3;
        }
        return byArray;
    }

    public byte[] getServerSecret(String string) {
        byte[] byArray;
        KeyHistoryEntry keyHistoryEntry = this.keyMap.get(string);
        byte[] byArray2 = byArray = keyHistoryEntry == null ? null : keyHistoryEntry.getServerSecret();
        if (this.readOnly && byArray != null) {
            int n = byArray.length;
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, 0, byArray3, 0, n);
            byArray = byArray3;
        }
        return byArray;
    }

    @Override
    public Date getCreation(String string) {
        Date date;
        KeyHistoryEntry keyHistoryEntry = this.keyMap.get(string);
        Date date2 = date = keyHistoryEntry == null ? null : keyHistoryEntry.getCreated();
        if (this.readOnly && date != null) {
            date = (Date)date.clone();
        }
        return date;
    }

    @Override
    public Date getExpiration(String string) {
        Date date;
        KeyHistoryEntry keyHistoryEntry = this.keyMap.get(string);
        Date date2 = date = keyHistoryEntry == null ? null : keyHistoryEntry.getExpires();
        if (this.readOnly && date != null) {
            date = (Date)date.clone();
        }
        return date;
    }

    public SCTState getState(String string) {
        KeyHistoryEntry keyHistoryEntry = this.keyMap.get(string);
        return keyHistoryEntry == null ? null : keyHistoryEntry.getState();
    }

    public ArrayList getAppliesToList() {
        return (ArrayList)this.appliesToList.clone();
    }

    public String getAppliesTo(int n) {
        return (String)this.appliesToList.get(n);
    }

    public boolean isRenewable() {
        return this.renewable;
    }

    public boolean isRenewableAfterExpiration() {
        return this.renewableAfterExpiration;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getProvider() {
        return this.provider;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setUUID(String string) {
        if (!this.readOnly) {
            this.uuid = string;
        }
    }

    public void setClientID(String string) {
        if (!this.readOnly) {
            this.clientID = string;
        }
    }

    public void setTokenID(String string) {
        if (!this.readOnly) {
            this.tokenID = string;
        }
    }

    public void setIssuer(String string) {
        if (!this.readOnly) {
            this.issuer = string;
        }
    }

    public void setKeyHistoryEntry(KeyHistoryEntry keyHistoryEntry) {
        if (!this.readOnly) {
            this.addKeyInstance(keyHistoryEntry.getInstance(), keyHistoryEntry);
        }
    }

    public void setClientSecret(String string, byte[] byArray) {
        KeyHistoryEntry keyHistoryEntry;
        if (!this.readOnly && (keyHistoryEntry = this.keyMap.get(string)) != null) {
            keyHistoryEntry.setClientSecret(byArray);
        }
    }

    public void setServerSecret(String string, byte[] byArray) {
        KeyHistoryEntry keyHistoryEntry;
        if (!this.readOnly && (keyHistoryEntry = this.keyMap.get(string)) != null) {
            keyHistoryEntry.setServerSecret(byArray);
        }
    }

    public void setCreation(String string, Date date) {
        KeyHistoryEntry keyHistoryEntry;
        if (!this.readOnly && (keyHistoryEntry = this.keyMap.get(string)) != null) {
            keyHistoryEntry.setCreated(date);
        }
    }

    public void setExpiration(String string, Date date) {
        KeyHistoryEntry keyHistoryEntry;
        if (!this.readOnly && (keyHistoryEntry = this.keyMap.get(string)) != null) {
            keyHistoryEntry.setExpires(date);
        }
    }

    public void setState(String string, SCTState sCTState) {
        KeyHistoryEntry keyHistoryEntry;
        if (!this.readOnly && (keyHistoryEntry = this.keyMap.get(string)) != null) {
            keyHistoryEntry.setState(sCTState);
        }
    }

    public void setRenewable(boolean bl) {
        if (!this.readOnly) {
            this.renewable = bl;
        }
    }

    public void setRenewableAfterExpiration(boolean bl) {
        if (!this.readOnly) {
            this.renewableAfterExpiration = bl;
        }
    }

    public void setAlgorithm(String string) {
        if (!this.readOnly) {
            this.algorithm = string;
        }
    }

    public void setProvider(String string) {
        if (!this.readOnly) {
            this.provider = string;
        }
    }

    public void setKeySize(int n) {
        if (!this.readOnly) {
            this.keySize = n;
        }
    }

    public void setAppliesTo(String string) {
        if (!this.readOnly) {
            this.appliesToList.clear();
            this.addAppliesTo(string);
        }
    }

    public void addAppliesTo(String string) {
        if (!this.readOnly) {
            try {
                URL uRL = new URL(string);
                if (uRL != null) {
                    String string2 = uRL.getProtocol() + "://" + uRL.getHost() + ":" + uRL.getPort() + uRL.getPath();
                    SCT.trDebug("setAppliesTo(" + string + ") stored as: " + string2);
                    this.appliesToList.add(string2);
                    if (uRL.getPort() == uRL.getDefaultPort()) {
                        String string3 = uRL.getProtocol() + "://" + uRL.getHost() + uRL.getPath();
                        SCT.trDebug("setAppliesTo(" + string + ") also stored as: " + string3);
                        this.appliesToList.add(string3);
                    }
                } else {
                    Tr.warning(tc, "url == null, invalid appliesTo: " + string);
                    this.appliesToList.add(string);
                }
            }
            catch (MalformedURLException malformedURLException) {
                Tr.warning(tc, "invalid appliesTo: " + string);
                this.appliesToList.add(string);
            }
        }
    }

    public void setAppliesTo(ArrayList arrayList) {
        if (!this.readOnly) {
            this.appliesToList = arrayList;
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelState() {
        if (!this.readOnly) {
            this.isCancelled = true;
        }
    }

    @Override
    public void cancel() throws WSSException {
        this.isCancelled = true;
        if (this.wssGenerationContext != null && this.wssConsumingContext != null) {
            this.cancel(this.wssGenerationContext, this.wssConsumingContext);
        }
    }

    protected void cancel(BindingProvider bindingProvider) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cancel(BindingProvider bp)");
        }
        EndpointDescription endpointDescription = bindingProvider.getEndpointDescription();
        AxisService axisService = null;
        if (endpointDescription != null) {
            axisService = endpointDescription.getAxisService();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AxisService from the binding provider = " + axisService);
            }
        }
        try {
            this.cancel(axisService);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SCT cancel is done");
            }
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".cancel", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7067E", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancel(BindingProvider bp)");
        }
    }

    @Override
    public void cancel(WSSGenerationContext wSSGenerationContext, WSSConsumingContext wSSConsumingContext) throws WSSException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cancelSCT(WSSGenerationContext gencont, WSSConsumingContext concont)");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + CANCEL_PERM.toString());
            }
            securityManager.checkPermission(CANCEL_PERM);
        }
        this.wssGenerationContext = wSSGenerationContext;
        this.wssConsumingContext = wSSConsumingContext;
        STSRequestorFactory sTSRequestorFactory = new STSRequestorFactory();
        ISTSConfiguration iSTSConfiguration = (ISTSConfiguration)this._map.get("STS_Conf");
        ServiceClient serviceClient = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            hashMap.put("Sandesha2UnreliableMessage", "true");
            hashMap.put("com.ibm.ws.wssecurity.sc.SCT.Cancel", new Boolean(true));
            iSTSConfiguration.set("MESSAGE_ACTION", "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Cancel");
            this._map.put("axis2_messagecontext_propertymap", hashMap);
            this._map.put("STS_Conf", iSTSConfiguration);
            IRSTTemplate iRSTTemplate = (IRSTTemplate)this._map.get("RSTTemplate");
            iRSTTemplate.set("RequestType", "http://schemas.xmlsoap.org/ws/2005/02/trust/Cancel");
            iRSTTemplate.setCancelTarget(((OMStructure)this.xml).getNode());
            this._map.put("RSTTemplate", iRSTTemplate);
            serviceClient = (ServiceClient)sTSRequestorFactory.init(this._map);
            if (serviceClient != null && serviceClient.getAxisService() != null) {
                serviceClient.getAxisService().addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
            }
            this.wssGenerationContext.process(serviceClient);
            this.wssConsumingContext.process(serviceClient);
            IRequestSecurityTokenResponseCollection iRequestSecurityTokenResponseCollection = null;
            iRequestSecurityTokenResponseCollection = sTSRequestorFactory.cancel(serviceClient);
            Iterator<IRequestSecurityTokenResponse> iterator = iRequestSecurityTokenResponseCollection.getRSTRCollection();
            while (iterator.hasNext()) {
                Boolean bl;
                IRequestSecurityTokenResponse iRequestSecurityTokenResponse = iterator.next();
                OMElement oMElement = (OMElement)iRequestSecurityTokenResponse.getTokenElement("RequestedTokenCancelled");
                if (oMElement != null && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cancel Element:" + ((Object)oMElement).toString());
                }
                if ((bl = iRequestSecurityTokenResponse.isTokenCancelled()) == null || !bl.booleanValue()) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Token Successfully Cancelled");
                }
                SecureConversationCacheHelper.invalidateCache(this.uuid);
                this.isCancelled = true;
            }
        }
        catch (TrustException trustException) {
            Tr.processException((Throwable)trustException, clsName + ".cancel", "%C", this);
            throw new WSSException(trustException.getMessage());
        }
        catch (WSSException wSSException) {
            Tr.processException((Throwable)wSSException, clsName + ".cancel", "%C", this);
            throw wSSException;
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".cancel", "%C", this);
            throw new WSSException(exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancelSCT(WSSGenerationContext gencont, WSSConsumingContext concont) return");
        }
    }

    private void cancel(AxisService axisService) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cancelSCT(AxisService aService)");
        }
        SCT sCT = null;
        Parameter parameter = axisService.getParameter(Constants.WSSECURITY_SECURECONVERSATION_IDENTIFIER);
        if (parameter != null) {
            String string = (String)parameter.getValue();
            sCT = (SCT)SecureConversationCacheHelper.getSecurityContextTokenFromCacheByUUID(string);
        }
        if (sCT.isCancelled) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SecurityContextToken is already cancelled.");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Cancel SCT using Policy Set");
        }
        try {
            SecureConversationImpl.cancelSCT(axisService);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".cancel", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7067E", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancelSCT(AxisService aService)");
        }
    }

    @Override
    public void renew() throws WSSException {
        this.renew(this.wssGenerationContext, this.wssConsumingContext);
    }

    @Override
    public void renew(WSSGenerationContext wSSGenerationContext, WSSConsumingContext wSSConsumingContext) throws WSSException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "renew(WSSGenerateionContext gencont, WSSConsumingContext concont)");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + RENEW_PERM.toString());
            }
            securityManager.checkPermission(RENEW_PERM);
        }
        String[] stringArray = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT config map = " + this._map);
            Tr.debug(tc, "SCT config map using getMap()= " + this.getMap());
            Tr.debug(tc, "Current SCT information, SCT UUID = " + this.uuid);
            Tr.debug(tc, "SCT ID = " + this.id);
            Tr.debug(tc, "SCT client id = " + this.clientID);
            Tr.debug(tc, "SCT element = " + DOMUtils.toString(((OMStructure)this.xml).getNode()));
            stringArray = this.getInstances();
            for (int i = 0; i < stringArray.length; ++i) {
                Tr.debug(tc, "SCT Instance [" + i + "]" + " = " + stringArray[i]);
            }
        }
        if (!this.isValid((String)stringArray[stringArray.length - 1], 0L) && !this.isRenewableAfterExpiration()) {
            throw WSSException.format("security.wssecurity.WSEC7068E");
        }
        this.wssGenerationContext = wSSGenerationContext;
        this.wssConsumingContext = wSSConsumingContext;
        STSRequestorFactory sTSRequestorFactory = new STSRequestorFactory();
        ISTSConfiguration iSTSConfiguration = (ISTSConfiguration)this._map.get("STS_Conf");
        ServiceClient serviceClient = null;
        try {
            iSTSConfiguration.set("MESSAGE_ACTION", "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Renew");
            this._map.put("STS_Conf", iSTSConfiguration);
            IRSTTemplate iRSTTemplate = (IRSTTemplate)this._map.get("RSTTemplate");
            iRSTTemplate.set("RequestType", "http://schemas.xmlsoap.org/ws/2005/02/trust/Renew");
            iRSTTemplate.setRenewTarget(((OMStructure)this.xml).getNode());
            this._map.put("RSTTemplate", iRSTTemplate);
            serviceClient = (ServiceClient)sTSRequestorFactory.init(this._map);
            if (serviceClient != null && serviceClient.getAxisService() != null) {
                serviceClient.getAxisService().addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
            }
            this.wssGenerationContext.process(serviceClient);
            this.wssConsumingContext.process(serviceClient);
            IRequestSecurityTokenResponseCollection iRequestSecurityTokenResponseCollection = null;
            iRequestSecurityTokenResponseCollection = sTSRequestorFactory.renew(serviceClient);
            String string = null;
            Date date = null;
            Date date2 = null;
            String string2 = this.uuid;
            Iterator<IRequestSecurityTokenResponse> iterator = iRequestSecurityTokenResponseCollection.getRSTRCollection();
            if (iterator.hasNext()) {
                Serializable serializable;
                Object object;
                String string3;
                IRequestSecurityTokenResponse iRequestSecurityTokenResponse = iterator.next();
                byte[] byArray = iRequestSecurityTokenResponse.getSecret();
                String string4 = "Lifetime";
                IRequestedSecurityToken iRequestedSecurityToken = iRequestSecurityTokenResponse.getRequestedSecurityToken();
                String string5 = iRequestSecurityTokenResponse.getTokenCreated();
                String string6 = iRequestSecurityTokenResponse.getTokenExpires();
                if (string5 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error in getting SCT creation time. It was null");
                    }
                    Tr.error(tc, "security.wssecurity.WSEC7069E");
                    throw WSSException.format("security.wssecurity.WSEC7069E");
                }
                date = SCT.parseDateTime(string5);
                if (string6 == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Error in getting SCT expires time. It was null");
                    }
                    Tr.error(tc, "security.wssecurity.WSEC7069E");
                    throw WSSException.format("security.wssecurity.WSEC7069E");
                }
                date2 = SCT.parseDateTime(string6);
                string4 = "KeySize";
                OMElement oMElement = (OMElement)iRequestSecurityTokenResponse.getTokenElement(string4);
                int n = 0;
                if (oMElement != null) {
                    string3 = oMElement.getText();
                    n = new Integer(string3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Key Size from the RSTR = " + n);
                    }
                }
                string3 = "true";
                String string7 = "false";
                string4 = "Renewing";
                oMElement = (OMElement)iRequestSecurityTokenResponse.getTokenElement(string4);
                if (oMElement != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Renewing element from the RSTR looks like: " + DOMUtils.toString(oMElement));
                    }
                    string7 = oMElement.getAttributeValue(new QName("", "OK"));
                    string3 = oMElement.getAttributeValue(new QName("", "Allow"));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Renew properties of the token, isRenewable =  " + string3 + ", renewableAfterExpiration = " + string7);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Renewing information in the RSTR element. ");
                    Tr.debug(tc, "Renew properties of the token, isRenewable =  " + string3 + ", renewableAfterExpiration = " + string7);
                }
                string4 = "SecurityContextToken";
                OMElement oMElement2 = null;
                OMElement oMElement3 = (OMElement)iRequestedSecurityToken.getTokenElement(string4);
                OMElement oMElement4 = (OMElement)((OMElement)iRequestedSecurityToken.getTokenElement(null)).getParent();
                if (oMElement3 != null) {
                    oMElement2 = oMElement3;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "sct element from the RSTR looks like: " + DOMUtils.toString(oMElement2));
                }
                if (oMElement2 != null) {
                    object = DOMUtils.getChildElement(oMElement2, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Identifier");
                    this.uuid = DOMUtils.getStringValue((OMNode)object);
                    serializable = IdUtils.getInstance().getIdAttributeName(oMElement2);
                    if (serializable != null) {
                        this.id = oMElement2.getAttributeValue((QName)serializable);
                    }
                    if ((object = (Object)DOMUtils.getChildElement(oMElement2, com.ibm.ws.wssecurity.common.Constants.NS_WSC_SC, "Instance")) != null) {
                        string = DOMUtils.getStringValue((OMNode)object);
                    }
                }
                object = sTSRequestorFactory.getEntropyKey();
                serializable = new KeyHistoryEntry(string, (byte[])object, byArray, date, date2, SCTState.RENEWED);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RSTR returns with Requested Security Token: uuid = " + this.uuid + ", id = " + this.id + ", created = " + date.toString() + ", expires = " + date2.toString() + ", and instance = " + string + ", serverSecret = " + Base64.encode(byArray) + ", clientEntropy = " + Base64.encode(object));
                }
                this.setKeyHistoryEntry((KeyHistoryEntry)serializable);
                this.tokenID = this.id;
                this.referenceURI = "#" + this.id;
                this.clientID = this.uuid;
                this.xml = new OMStructure(oMElement2);
                this.setKeySize(n);
                this.setRenewable(Boolean.valueOf(string3));
                this.setRenewableAfterExpiration(Boolean.valueOf(string7));
                SecureConversationCacheHelper.invalidateCache(string2);
                SecureConversationCacheHelper.setSecurityContextTokenToCache(this.uuid, null, this, null);
            }
        }
        catch (TrustException trustException) {
            Tr.processException((Throwable)trustException, clsName + ".renew", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7070E", trustException);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".renew", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7070E", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "renew(WSSGenerateionContext gencont, WSSConsumingContext concont) return");
        }
    }

    public static final Date parseDateTime(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseDateTime( " + string + " )");
        }
        if (string == null) {
            return null;
        }
        try {
            Date date = UTC.parse(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "parseDateTime( " + string + " )");
            }
            return date;
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "parseDateTime( " + string + " ) returns null");
            }
            return null;
        }
    }

    @Override
    public boolean validate() throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate()");
            Tr.exit(tc, "validate()");
        }
        return this.validate(this.wssGenerationContext, this.wssConsumingContext);
    }

    @Override
    public boolean validate(WSSGenerationContext wSSGenerationContext, WSSConsumingContext wSSConsumingContext) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate(WSSGenerateionContext gencont, WSSConsumingContext concont)");
        }
        this.wssGenerationContext = wSSGenerationContext;
        this.wssConsumingContext = wSSConsumingContext;
        STSRequestorFactory sTSRequestorFactory = new STSRequestorFactory();
        ISTSConfiguration iSTSConfiguration = (ISTSConfiguration)this._map.get("STS_Conf");
        ServiceClient serviceClient = null;
        try {
            iSTSConfiguration.set("MESSAGE_ACTION", "http://schemas.xmlsoap.org/ws/2005/02/trust/RST/Validate");
            this._map.put("STS_Conf", iSTSConfiguration);
            IRSTTemplate iRSTTemplate = (IRSTTemplate)this._map.get("RSTTemplate");
            iRSTTemplate.set("RequestType", "http://schemas.xmlsoap.org/ws/2005/02/trust/Validate");
            iRSTTemplate.setValidateTarget(((OMStructure)this.xml).getNode());
            this._map.put("RSTTemplate", iRSTTemplate);
            serviceClient = (ServiceClient)sTSRequestorFactory.init(this._map);
            if (serviceClient != null && serviceClient.getAxisService() != null) {
                serviceClient.getAxisService().addParameter(new Parameter("Sandesha2UnreliableMessage", "true"));
            }
            this.wssGenerationContext.process(serviceClient);
            this.wssConsumingContext.process(serviceClient);
            IRequestSecurityTokenResponseCollection iRequestSecurityTokenResponseCollection = null;
            iRequestSecurityTokenResponseCollection = sTSRequestorFactory.validate(serviceClient);
            Iterator<IRequestSecurityTokenResponse> iterator = iRequestSecurityTokenResponseCollection.getRSTRCollection();
            if (iterator.hasNext()) {
                IRequestSecurityTokenResponse iRequestSecurityTokenResponse = iterator.next();
                String string = iRequestSecurityTokenResponse.getStatusCode();
                String string2 = iRequestSecurityTokenResponse.getStatusReason();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Status Code=" + string);
                    Tr.debug(tc, "Status Reason=" + string2);
                }
                if (string.equals("http://schemas.xmlsoap.org/ws/2005/02/trust/status/invalid")) {
                    SecureConversationCacheHelper.invalidateCache(this.id);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "This sct is removed from cache.");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "validate(WSSGenerateionContext gencont, WSSConsumingContext concont) return false.");
                    }
                    return false;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "validate(WSSGenerateionContext gencont, WSSConsumingContext concont) return true.");
                }
                return true;
            }
        }
        catch (TrustException trustException) {
            Tr.processException((Throwable)trustException, clsName + ".validate", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7071E", trustException);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".validate", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7071E", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate(WSSGenerateionContext gencont, WSSConsumingContext concont) return");
        }
        return false;
    }

    public WSSConsumingContext getWssConsumingContext() {
        return this.wssConsumingContext;
    }

    public void setWssConsumingContext(WSSConsumingContext wSSConsumingContext) {
        this.wssConsumingContext = wSSConsumingContext;
    }

    public WSSGenerationContext getWssGenerationContext() {
        return this.wssGenerationContext;
    }

    public void setWssGenerationContext(WSSGenerationContext wSSGenerationContext) {
        this.wssGenerationContext = wSSGenerationContext;
    }

    public Map getMap() {
        return this._map;
    }

    public void setMap(Map map) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "saving the configuration needed for trust client APIs");
        }
        this._map = map;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SCT configuration map = " + this._map.toString());
        }
    }

    public void setSecurityTokenManagerImpl(SecurityTokenManagerImpl securityTokenManagerImpl) {
        this.securityTokenManager = securityTokenManagerImpl;
    }

    @Override
    public DerivedKeyToken getDerivedKeyToken(String string, String string2, String string3) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDerivedKeyToken( " + string + ", " + string2 + ", " + string3 + ")");
        }
        if (string2 == null) {
            string2 = "Default";
        }
        if (string3 == null) {
            string3 = "Default";
        }
        Map<String, Object> map = this.getKeyAlgorithm(string);
        SCTGenerateCallbackHandler sCTGenerateCallbackHandler = null;
        sCTGenerateCallbackHandler = (Boolean)map.get("isSignature") != false ? new SCTGenerateCallbackHandler(this, this.wssGenerationContext, this.wssConsumingContext, (String)map.get("algorithm"), (Integer)map.get("keyLength"), null, 0, string2, string3) : new SCTGenerateCallbackHandler(this, this.wssGenerationContext, this.wssConsumingContext, null, 0, (String)map.get("algorithm"), (Integer)map.get("keyLength"), string2, string3);
        DKToken dKToken = new DKToken();
        SecurityTokenWrapper securityTokenWrapper = new SecurityTokenWrapper((SecurityToken)dKToken, (CallbackHandler)sCTGenerateCallbackHandler, "system.wss.generate.sct");
        this.securityTokenManager.addTokenWrapper(securityTokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDerivedKeyToken(String, String )");
        }
        return dKToken;
    }

    public DerivedKeyToken getDerivedKeyToken(String string, int n, String string2, String string3) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDerivedKeyToken( " + string + ", " + n + " , " + string2 + " , " + string3 + ")");
        }
        Map<String, Object> map = this.getKeyAlgorithm(string);
        SCTGenerateCallbackHandler sCTGenerateCallbackHandler = null;
        if (string2 == null) {
            string2 = "Default";
        }
        if (string3 == null) {
            string3 = "Default";
        }
        sCTGenerateCallbackHandler = (Boolean)map.get("isSignature") != false ? new SCTGenerateCallbackHandler(this, this.wssGenerationContext, this.wssConsumingContext, (String)map.get("algorithm"), n, null, 0, string2, string3) : new SCTGenerateCallbackHandler(this, this.wssGenerationContext, this.wssConsumingContext, null, 0, (String)map.get("algorithm"), n, string2, string3);
        DKToken dKToken = new DKToken();
        SecurityTokenWrapper securityTokenWrapper = new SecurityTokenWrapper((SecurityToken)dKToken, (CallbackHandler)sCTGenerateCallbackHandler, "system.wss.generate.sct");
        this.securityTokenManager.addTokenWrapper(securityTokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDerivedKeyToken(String, int, String)");
        }
        return dKToken;
    }

    private Map<String, Object> getKeyAlgorithm(String string) {
        Map map;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyAlgorithm(String algName): algName=" + string);
        }
        if ((map = DefaultValueManager.getInstance().getSignatureAlgorithmMap().get(string)) != null) {
            map.put("isSignature", Boolean.TRUE);
        }
        if (map == null && (map = DefaultValueManager.getInstance().getEncryptionAlgorithmMap().get(string)) != null) {
            map.put("isSignature", Boolean.FALSE);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyAlgorithm(String algName, int keyBytesLength) returns map" + map);
        }
        return map;
    }

    public boolean isValid(String string, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Enter isValid()...");
        }
        if (this.keyMap.containsKey(string)) {
            SCT.trDebug("SCT instance = " + string + ", cushion = " + l);
            Date date = this.getCreation(string);
            Date date2 = this.getExpiration(string);
            Date date3 = new Date();
            boolean bl = true;
            SecureConversationCacheConfig secureConversationCacheConfig = SecureConversationCacheConfigFactory.getInstance();
            long l2 = secureConversationCacheConfig.getClockSkewToleranceMilliseconds();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Current time = " + date3.toString() + "(" + date3.getTime() + " ms), " + "SCT creation time = " + date.toString() + "(" + date.getTime() + " ms), " + "Expiration time =  " + date2.toString() + "(" + date2.getTime() + " ms), " + "Clock Skew tolerance = " + l2 + " ms.");
            }
            if (l2 != 0L) {
                if (date != null && date.getTime() > date3.getTime() && date.getTime() > date3.getTime() + l2) {
                    bl = false;
                }
                if (bl && date2 != null && date2.getTime() - l < date3.getTime() && date2.getTime() - l < date3.getTime() - l2) {
                    bl = false;
                }
            } else {
                if (date != null) {
                    boolean bl2 = bl = date.getTime() <= date3.getTime();
                }
                if (date2 != null) {
                    boolean bl3 = bl = bl && date3.getTime() < date2.getTime() - l;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Exit isValid()..., " + bl);
            }
            return bl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exit isValid()..., false");
        }
        return false;
    }

    public boolean validateAppliesToURI(String string) {
        SCT.trEntry("validateAppliesToURI(" + string + ")");
        boolean bl = false;
        if (string == null || this.appliesToList == null) {
            return false;
        }
        for (int i = 0; i < this.appliesToList.size() && !bl; ++i) {
            String string2 = (String)this.appliesToList.get(i);
            SCT.trDebug("appliesTo in SCT: " + string2);
            SCT.trDebug("appliesTo incoming: " + string);
            bl = STSUriUtil.URICompare(string2, string) == 0;
        }
        SCT.trExit("validateAppliesToURI(" + string + ") returns " + bl);
        return bl;
    }

    public byte[] getSerializationBytes() {
        String string;
        block2: {
            string = CLASS_NAME + ".getSerializationBytes()";
            SCT.trEntry(string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                this.writeExternal(objectOutputStream);
                objectOutputStream.close();
                byteArrayOutputStream.close();
                this.serializedBytes = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Fail to serialize SCT. ", exception.getStackTrace());
            }
        }
        SCT.trExit(string);
        return this.serializedBytes;
    }

    @Override
    public int getStatus(String string) {
        SCTState sCTState;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatus(" + string + ")");
        }
        if ((sCTState = this.getState(string)).equals((Object)SCTState.ISSUED)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatus(" + string + ")");
            }
            return 81;
        }
        if (sCTState.equals((Object)SCTState.CANCELLED)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatus(" + string + ")");
            }
            return 83;
        }
        if (sCTState.equals((Object)SCTState.RENEWED)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStatus(" + string + ")");
            }
            return 82;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatus(" + string + ")");
        }
        return -1;
    }

    public DerivedKeyGenerator getDerivedKeyGenerator(String string) {
        if (this.dkgMap != null) {
            return (DerivedKeyGenerator)this.dkgMap.get(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDerivedKeyGenerator(String string, DerivedKeyGenerator derivedKeyGenerator) {
        if (!this.readOnly) {
            if (this.dkgMap == null) {
                this.dkgMap = new HashMap();
            }
            Map map = this.dkgMap;
            synchronized (map) {
                this.dkgMap.put(string, derivedKeyGenerator);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        switch (n) {
            case 1: {
                this.readExternalVersion1(objectInput);
                break;
            }
            default: {
                String string = "Could not deserialize the SCT: wrong version number - " + n;
                SCT.trDebug(string);
                throw new IOException(string);
            }
        }
    }

    private void readExternalVersion1(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.uuid = ObjectStateUtils.readString(objectInput, SERIALIZATION_DESCRIPTION_UUID);
        this.clientID = ObjectStateUtils.readString(objectInput, SERIALIZATION_DESCRIPTION_CLIENT_ID);
        this.tokenID = ObjectStateUtils.readString(objectInput, SERIALIZATION_DESCRIPTION_TOKEN_ID);
        this.isCancelled = objectInput.readBoolean();
        this.keyMap = ObjectStateUtils.readHashMap(objectInput, SERIALIZATION_DESCRIPTION_KEY_MAP);
        this.appliesToList = ObjectStateUtils.readArrayList(objectInput, SERIALIZATION_DESCRIPTION_APPLIES_TO);
        this.renewable = objectInput.readBoolean();
        this.renewableAfterExpiration = objectInput.readBoolean();
        this.algorithm = ObjectStateUtils.readString(objectInput, SERIALIZATION_DESCRIPTION_ALGORITHM);
        this.provider = ObjectStateUtils.readString(objectInput, SERIALIZATION_DESCRIPTION_PROVIDER);
        this.keySize = objectInput.readInt();
        this.issuer = ObjectStateUtils.readString(objectInput, SERIALIZATION_DESCRIPTION_ISSUER);
        this.allKeyInstances = ObjectStateUtils.readArrayList(objectInput, SERIALIZATION_DESCRIPTION_INSTANCES);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(1);
        ObjectStateUtils.writeString(objectOutput, this.uuid, SERIALIZATION_DESCRIPTION_UUID);
        ObjectStateUtils.writeString(objectOutput, this.clientID, SERIALIZATION_DESCRIPTION_CLIENT_ID);
        ObjectStateUtils.writeString(objectOutput, this.tokenID, SERIALIZATION_DESCRIPTION_TOKEN_ID);
        objectOutput.writeBoolean(this.isCancelled);
        ObjectStateUtils.writeHashMap(objectOutput, this.keyMap, SERIALIZATION_DESCRIPTION_KEY_MAP);
        ObjectStateUtils.writeArrayList(objectOutput, this.appliesToList, SERIALIZATION_DESCRIPTION_APPLIES_TO);
        objectOutput.writeBoolean(this.renewable);
        objectOutput.writeBoolean(this.renewableAfterExpiration);
        ObjectStateUtils.writeString(objectOutput, this.algorithm, SERIALIZATION_DESCRIPTION_ALGORITHM);
        ObjectStateUtils.writeString(objectOutput, this.provider, SERIALIZATION_DESCRIPTION_PROVIDER);
        objectOutput.writeInt(this.keySize);
        ObjectStateUtils.writeString(objectOutput, this.issuer, SERIALIZATION_DESCRIPTION_ISSUER);
        ObjectStateUtils.writeArrayList(objectOutput, this.allKeyInstances, SERIALIZATION_DESCRIPTION_INSTANCES);
    }

    private static void trEntry(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, string);
        }
    }

    private static void trExit(String string) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, string);
        }
    }

    private static void trDebug(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }

    private synchronized void addKeyInstance(String string, KeyHistoryEntry keyHistoryEntry) {
        this.keyMap.put(string, keyHistoryEntry);
        this.allKeyInstances.add(string);
    }

    public static class KeyHistoryEntry
    implements Externalizable {
        public static final String SERIALIZATION_DESCRIPTION_INSTANCE = "KHE.instance";
        public static final String SERIALIZATION_DESCRIPTION_CLIENT_SECRET = "KHE.clientSecret";
        public static final String SERIALIZATION_DESCRIPTION_SERVER_SECRET = "KHE.serverSecret";
        public static final String SERIALIZATION_DESCRIPTION_VALID_TIME_START = "KHE.validTimeStart";
        public static final String SERIALIZATION_DESCRIPTION_VALID_TIME_END = "KHE.validTimeEnd";
        public static final String SERIALIZATION_DESCRIPTION_STATE = "KHE.state";
        private String instance;
        private byte[] clientSecret;
        private byte[] serverSecret;
        private Date validTimeStart;
        private Date validTimeEnd;
        private SCTState state;
        private static final long serialVersionUID = 4800424159027149133L;
        private static final TraceComponent tc = Tr.register(KeyHistoryEntry.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");

        public KeyHistoryEntry() {
            this.instance = "";
            this.clientSecret = new byte[0];
            this.serverSecret = new byte[0];
            this.validTimeStart = new Date(0L);
            this.validTimeEnd = new Date(0L);
            this.state = SCTState.NULL;
        }

        public KeyHistoryEntry(String string, byte[] byArray, byte[] byArray2, Date date, Date date2, SCTState sCTState) {
            this.instance = string;
            this.clientSecret = KeyHistoryEntry.copyOf(byArray);
            this.serverSecret = KeyHistoryEntry.copyOf(byArray2);
            this.validTimeStart = (Date)date.clone();
            this.validTimeEnd = (Date)date2.clone();
            this.state = sCTState;
        }

        public String getInstance() {
            return this.instance;
        }

        public byte[] getClientSecret() {
            return KeyHistoryEntry.copyOf(this.clientSecret);
        }

        public byte[] getServerSecret() {
            return KeyHistoryEntry.copyOf(this.serverSecret);
        }

        public Date getCreated() {
            return (Date)this.validTimeStart.clone();
        }

        public Date getExpires() {
            return (Date)this.validTimeEnd.clone();
        }

        public SCTState getState() {
            return this.state;
        }

        public void setInstance(String string) {
            this.instance = string;
        }

        public void setClientSecret(byte[] byArray) {
            this.clientSecret = KeyHistoryEntry.copyOf(byArray);
        }

        public void setServerSecret(byte[] byArray) {
            this.serverSecret = KeyHistoryEntry.copyOf(byArray);
        }

        public void setCreated(Date date) {
            this.validTimeStart = (Date)date.clone();
        }

        public void setExpires(Date date) {
            this.validTimeEnd = (Date)date.clone();
        }

        public void setState(SCTState sCTState) {
            this.state = sCTState;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            int n = objectInput.readInt();
            switch (n) {
                case 1: {
                    this.readExternalVersion1(objectInput);
                    break;
                }
                default: {
                    String string = "Could not deserialize the SCT: wrong version number - " + n;
                    KeyHistoryEntry.trDebug(string);
                    throw new IOException(string);
                }
            }
        }

        public void readExternalVersion1(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.instance = ObjectStateUtils.readString(objectInput, SERIALIZATION_DESCRIPTION_INSTANCE);
            Object object = ObjectStateUtils.readObject(objectInput, SERIALIZATION_DESCRIPTION_CLIENT_SECRET);
            if (object != null) {
                this.clientSecret = (byte[])object;
                object = null;
            }
            if ((object = ObjectStateUtils.readObject(objectInput, SERIALIZATION_DESCRIPTION_SERVER_SECRET)) != null) {
                this.serverSecret = (byte[])object;
                object = null;
            }
            if ((object = ObjectStateUtils.readObject(objectInput, SERIALIZATION_DESCRIPTION_VALID_TIME_START)) != null) {
                this.validTimeStart = (Date)object;
                object = null;
            }
            if ((object = ObjectStateUtils.readObject(objectInput, SERIALIZATION_DESCRIPTION_VALID_TIME_END)) != null) {
                this.validTimeEnd = (Date)object;
                object = null;
            }
            if ((object = ObjectStateUtils.readObject(objectInput, SERIALIZATION_DESCRIPTION_STATE)) != null) {
                this.state = (SCTState)((Object)object);
                object = null;
            }
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(1);
            ObjectStateUtils.writeString(objectOutput, this.instance, SERIALIZATION_DESCRIPTION_INSTANCE);
            ObjectStateUtils.writeObject(objectOutput, this.clientSecret, SERIALIZATION_DESCRIPTION_CLIENT_SECRET);
            ObjectStateUtils.writeObject(objectOutput, this.serverSecret, SERIALIZATION_DESCRIPTION_SERVER_SECRET);
            ObjectStateUtils.writeObject(objectOutput, this.validTimeStart, SERIALIZATION_DESCRIPTION_VALID_TIME_START);
            ObjectStateUtils.writeObject(objectOutput, this.validTimeEnd, SERIALIZATION_DESCRIPTION_VALID_TIME_END);
            ObjectStateUtils.writeObject(objectOutput, (Object)this.state, SERIALIZATION_DESCRIPTION_STATE);
        }

        private static byte[] copyOf(byte[] byArray) {
            byte[] byArray2 = null;
            if (byArray != null) {
                byArray2 = new byte[byArray.length];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            }
            return byArray2;
        }

        private static void trDebug(String string) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SCTState {
        NULL,
        ISSUED,
        CANCELLED,
        RENEWED,
        AMENDED;

    }
}

