/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.X509ConsumeCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.token.CertCacheManager;
import com.ibm.ws.wssecurity.util.CertificateUtil;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509PKIPathTokenImpl;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.io.Serializable;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.cert.CertPath;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PkiPathConsumeLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(PkiPathConsumeLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PkiPathConsumeLoginModule.class.getName();
    private CallbackHandler _handler;
    private SecurityToken _token;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = callbackHandler;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    @Override
    public boolean login() throws LoginException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        X509ConsumeCallback x509ConsumeCallback = new X509ConsumeCallback();
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbackArray = new Callback[]{x509ConsumeCallback, propertyCallback};
        try {
            this._handler.handle(callbackArray);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".login", "129", this);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{exception.toString()}));
        }
        this._context = propertyCallback.getProperties();
        TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
        X509PKIPathTokenImpl x509PKIPathTokenImpl = new X509PKIPathTokenImpl();
        this._context.put(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING, x509PKIPathTokenImpl);
        QName qName = tokenConsumerConfig.getType();
        if (!com.ibm.ws.wssecurity.common.Constants.PKI_PATH.equals(qName) && !com.ibm.ws.wssecurity.common.Constants.PKI_PATH11.equals(qName)) {
            String string = ConfigUtil.getMessage("security.wssecurity.PrivateConsumerConfig.s30", new String[]{qName.toString(), com.ibm.ws.wssecurity.common.Constants.PKI_PATH.toString() + " or " + com.ibm.ws.wssecurity.common.Constants.PKI_PATH11.toString()});
            throw new LoginException(string);
        }
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        CertCacheManager certCacheManager = (CertCacheManager)this._context.get(CertCacheManager.class);
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        String string = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        OMElement oMElement = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        if (string == null) {
            bl6 = true;
            bl5 = false;
            bl4 = false;
            bl3 = false;
            bl2 = false;
            bl = false;
        } else {
            bl6 = false;
            bl = ConfigUtil.isKeyInfoKeyname(string);
            bl2 = ConfigUtil.isKeyInfoKeyid(string);
            bl3 = ConfigUtil.isKeyInfoStrref(string);
            bl4 = ConfigUtil.isKeyInfoEmb(string);
            bl5 = ConfigUtil.isKeyInfoX509issuer(string);
        }
        this._token = bl6 || bl4 ? PkiPathConsumeLoginModule.processElement(x509PKIPathTokenImpl, x509ConsumeCallback, oMElement, tokenConsumerConfig, certCacheManager, messageContext, bl6, bl4, this._context) : PkiPathConsumeLoginModule.resolveKeyInfo(x509PKIPathTokenImpl, x509ConsumeCallback, tokenConsumerConfig, certCacheManager, messageContext, string, bl, bl2, bl3, bl5, this._securityTokenManager, this._context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        this._securityTokenManager.addToken(this._token);
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._token);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final SecurityToken resolveKeyInfo(X509PKIPathTokenImpl x509PKIPathTokenImpl, X509ConsumeCallback x509ConsumeCallback, TokenConsumerConfig tokenConsumerConfig, CertCacheManager certCacheManager, MessageContext messageContext, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, SecurityTokenManager securityTokenManager, Map<Object, Object> map) throws LoginException {
        CharSequence charSequence;
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("resolveKeyInfo(");
            ((StringBuffer)object).append("X509PKIPathTokenImpl pkiPathToken, X509ConsumeCallback x509Callback, ");
            ((StringBuffer)object).append("TokenConsumerConfig config, CertCacheManager cmanager, ");
            ((StringBuffer)object).append("SOAPMessageContext messageContext, ");
            ((StringBuffer)object).append("String keyInfoType[").append(string).append("], ");
            ((StringBuffer)object).append("boolean isKeyName[").append(bl).append("], ");
            ((StringBuffer)object).append("boolean isKeyId[").append(bl2).append("], ");
            ((StringBuffer)object).append("boolean isStrref[").append(bl3).append("], ");
            ((StringBuffer)object).append("boolean isX509[").append(bl4).append("], ");
            ((StringBuffer)object).append("SecurityTokenManager securityTokenManager, Map context)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        if (bl3) {
            SecurityToken securityToken;
            charSequence = (String)map.get(Constants.WSSECURITY_KEY_REFERENCE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Token identifier is [" + (String)charSequence + "]");
            }
            if ((securityToken = securityTokenManager.getToken(tokenConsumerConfig, (String)charSequence)) == null) {
                Tr.debug(tc, "WARNING: SecurityToken whose identifier is \"" + (String)charSequence + "\" was not found in the Subject.");
            } else {
                Tr.debug(tc, "There was the token [" + (String)charSequence + "] in the Subject.");
                object = securityToken;
            }
        } else {
            charSequence = null;
            String string2 = null;
            String string3 = null;
            if (bl2) {
                charSequence = (String)map.get(Constants.WSSECURITY_KEY_ID);
            } else if (bl) {
                charSequence = (String)map.get(Constants.WSSECURITY_KEY_NAME);
            } else if (bl4) {
                string2 = (String)map.get(Constants.WSSECURITY_KEY_ISSUERNAME);
                string3 = (String)map.get(Constants.WSSECURITY_KEY_ISSUERSERIAL);
                if (string2 != null && string3 != null) {
                    charSequence = string2 + ":" + string3;
                }
            }
            SecurityToken securityToken = securityTokenManager.getToken(tokenConsumerConfig, (String)charSequence);
            if (securityToken == null) {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                X509Certificate x509Certificate;
                block62: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "There is no token [" + (String)charSequence + "] stored in the Subject.");
                    }
                    x509PKIPathTokenImpl.setId((String)charSequence);
                    if (!x509ConsumeCallback.existKeyStore()) {
                        String string4 = ConfigUtil.getMessage("security.wssecurity.WSEC6810E", new String[]{charSequence});
                        throw new LoginException(string4);
                    }
                    x509Certificate = null;
                    if (certCacheManager != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Checking the cached X509Certificate object with the key[" + (String)charSequence + "].");
                        }
                        try {
                            object5 = certCacheManager.getCachedCert((String)charSequence);
                        }
                        catch (SoapSecurityException soapSecurityException) {
                            Tr.processException(soapSecurityException, clsName + ".resolveKeyInfo", "358");
                            throw new LoginException(soapSecurityException.toString());
                        }
                        if (object5 == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "There is no cached certificiate.");
                            }
                        } else if (object5 instanceof X509Certificate) {
                            x509Certificate = (X509Certificate)object5;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "The X509Certificate [" + x509Certificate.getSubjectDN().getName() + "] was found.");
                            }
                        } else if (tc.isDebugEnabled()) {
                            object4 = new StringBuffer("The certificate [");
                            ((StringBuffer)object4).append(object5.getClass().getName());
                            ((StringBuffer)object4).append("] was found, but it's not the X509Certificate object.");
                            Tr.debug(tc, ((StringBuffer)object4).toString());
                        }
                    }
                    object5 = null;
                    try {
                        object4 = KeyStoreManager.getInstance();
                        object5 = ((KeyStoreManager)object4).getKeyInformation(x509ConsumeCallback.getKeyStorePath(), x509ConsumeCallback.getKeyStoreType(), x509ConsumeCallback.getKeyStorePassword(), x509ConsumeCallback.getKeyStoreReference(), x509ConsumeCallback.getAlias(), x509ConsumeCallback.getKeyPassword(), x509ConsumeCallback.getKeyName());
                    }
                    catch (SoapSecurityException soapSecurityException) {
                        Tr.processException(soapSecurityException, clsName + ".processElement", "390");
                        throw new LoginException(soapSecurityException.toString());
                    }
                    if (x509Certificate == null) {
                        try {
                            if (bl2) {
                                object4 = (QName)map.get(Constants.WSSECURITY_KEY_VALUETYPE);
                                if (object4 == null) {
                                    String string5 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier02");
                                    throw new LoginException(string5);
                                }
                                if (!com.ibm.ws.wssecurity.common.Constants.X509_SKI.equals(object4) && !com.ibm.ws.wssecurity.common.Constants.X509_SKI_OLD.equals(object4)) {
                                    String string6 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier03", new String[]{com.ibm.ws.wssecurity.common.Constants.X509_SKI.toString() + " or " + com.ibm.ws.wssecurity.common.Constants.X509_SKI_OLD.toString(), ((QName)object4).toString()});
                                    throw new LoginException(string6);
                                }
                                object3 = (QName)map.get(Constants.WSSECURITY_KEY_IDTYPE);
                                object2 = (QName)map.get(Constants.WSSECURITY_KEY_ENCODING);
                                String string7 = null;
                                if (object2 == null || NamespaceUtil.equals((QName)object2, com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY)) {
                                    if (object3 == null || NamespaceUtil.equals((QName)object3, com.ibm.ws.wssecurity.common.Constants.ITSHA1)) {
                                        string7 = ((KeyStoreManager.KeyInformation)object5).getB64KeyId();
                                    } else {
                                        if (!NamespaceUtil.equals((QName)object3, com.ibm.ws.wssecurity.common.Constants.IT60SHA1)) {
                                            String string8 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01");
                                            string8 = string8 + ": " + object3;
                                            throw new LoginException(string8);
                                        }
                                        string7 = ((KeyStoreManager.KeyInformation)object5).getB64KeyId60();
                                    }
                                } else {
                                    if (!NamespaceUtil.equals((QName)object2, com.ibm.ws.wssecurity.common.Constants.HEX_BINARY)) {
                                        String string9 = ConfigUtil.getMessage("security.wssecurity.BinaryTokenReceiver.token15", new String[]{((QName)object2).toString()});
                                        throw new LoginException(string9);
                                    }
                                    if (object3 == null || NamespaceUtil.equals((QName)object3, com.ibm.ws.wssecurity.common.Constants.ITSHA1)) {
                                        string7 = ((KeyStoreManager.KeyInformation)object5).getHexKeyId();
                                    } else {
                                        if (!NamespaceUtil.equals((QName)object3, com.ibm.ws.wssecurity.common.Constants.IT60SHA1)) {
                                            String string10 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01");
                                            string10 = string10 + ": " + object3;
                                            throw new LoginException(string10);
                                        }
                                        string7 = ((KeyStoreManager.KeyInformation)object5).getHexKeyId60();
                                    }
                                }
                                if (!((String)charSequence).equals(string7)) {
                                    String string11 = ConfigUtil.getMessage("security.wssecurity.WSEC6811E", new String[]{charSequence, string7, x509ConsumeCallback.getKeyStorePath()});
                                    throw new LoginException(string11);
                                }
                            } else if (bl) {
                                object4 = KeyInfo.X509Data.encodeDName((String)charSequence);
                                if (object4 == null) {
                                    object4 = charSequence;
                                }
                                if (!((String)object4).equals(object3 = ((KeyStoreManager.KeyInformation)object5).getSubjectDN())) {
                                    String string12 = ConfigUtil.getMessage("security.wssecurity.WSEC6812E", new String[]{object4, object3, x509ConsumeCallback.getKeyStorePath()});
                                    throw new LoginException(string12);
                                }
                            } else if (bl4) {
                                object4 = KeyInfo.X509Data.encodeDName(string2);
                                if (object4 == null) {
                                    object4 = string2;
                                }
                                if (!((String)object4).equals(object3 = ((KeyStoreManager.KeyInformation)object5).getIssuerDN())) {
                                    String string13 = ConfigUtil.getMessage("security.wssecurity.WSEC6813E", new String[]{object4, object3, x509ConsumeCallback.getKeyStorePath()});
                                    throw new LoginException(string13);
                                }
                                object2 = ((KeyStoreManager.KeyInformation)object5).getIssuerSerial();
                                if (!string3.equals(object2)) {
                                    String string14 = ConfigUtil.getMessage("security.wssecurity.WSEC6813E", new String[]{string3, object2, x509ConsumeCallback.getKeyStorePath()});
                                    throw new LoginException(string14);
                                }
                            }
                            x509Certificate = (X509Certificate)((KeyStoreManager.KeyInformation)object5).getCertificate();
                            if (!x509ConsumeCallback.isTrustAnyCertificate()) {
                                PkiPathConsumeLoginModule.validateX509(x509Certificate, x509ConsumeCallback, null);
                            }
                            if (certCacheManager == null) break block62;
                            try {
                                certCacheManager.cacheCert((String)charSequence, x509Certificate);
                            }
                            catch (SoapSecurityException soapSecurityException) {
                                Tr.processException(soapSecurityException, clsName + ".processElement", "517");
                                throw new LoginException(soapSecurityException.toString());
                            }
                        }
                        catch (SoapSecurityException soapSecurityException) {
                            Tr.processException(soapSecurityException, clsName + ".processElement", "522");
                            throw new LoginException(soapSecurityException.toString());
                        }
                    }
                }
                try {
                    object4 = x509PKIPathTokenImpl;
                    object3 = x509Certificate;
                    object2 = ((KeyStoreManager.KeyInformation)object5).getBinary();
                    AccessController.doPrivileged(new PrivilegedAction<Object>((X509PKIPathTokenImpl)object4, (X509Certificate)object3, (byte[])object2){
                        final /* synthetic */ X509PKIPathTokenImpl val$tempToken;
                        final /* synthetic */ X509Certificate val$tempx509;
                        final /* synthetic */ byte[] val$tempbinary;
                        {
                            this.val$tempToken = x509PKIPathTokenImpl;
                            this.val$tempx509 = x509Certificate;
                            this.val$tempbinary = byArray;
                        }

                        @Override
                        public Object run() {
                            this.val$tempToken.setCertificate(this.val$tempx509);
                            this.val$tempToken.setBinary(this.val$tempbinary);
                            return null;
                        }
                    });
                    x509PKIPathTokenImpl.setKey(63, ((KeyStoreManager.KeyInformation)object5).getPublicOrSecretKey());
                    x509PKIPathTokenImpl.setKey(64, ((KeyStoreManager.KeyInformation)object5).getPrivateOrSecretKey());
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.processException(soapSecurityException, clsName + ".processElement", "534");
                    throw new LoginException(soapSecurityException.toString());
                }
                object = x509PKIPathTokenImpl;
            } else {
                Tr.debug(tc, "There is the token [" + (String)charSequence + "] stored in the Subject.");
                object = securityToken;
            }
        }
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("resolveKeyInfo(");
            ((StringBuffer)charSequence).append("X509PKIPathTokenImpl, X509ConsumeCallback, TokenConsumerConfig, ");
            ((StringBuffer)charSequence).append("CertCacheManager, SOAPMessageContext, String, boolean, boolean, ");
            ((StringBuffer)charSequence).append("boolean, boolean, SecurityTokenManager, Map)");
            ((StringBuffer)charSequence).append(" reutnrs SecurityToken[").append(object).append("]");
            Tr.exit(tc, ((StringBuffer)charSequence).toString());
        }
        return object;
    }

    private static final SecurityToken processElement(X509PKIPathTokenImpl x509PKIPathTokenImpl, X509ConsumeCallback x509ConsumeCallback, OMElement oMElement, TokenConsumerConfig tokenConsumerConfig, CertCacheManager certCacheManager, MessageContext messageContext, boolean bl, boolean bl2, Map<Object, Object> map) throws LoginException {
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("processElement(");
            ((StringBuffer)charSequence).append("X509PKIPathTokenImpl pkiPathToken, X509ConsumeCallback x509Callback, ");
            ((StringBuffer)charSequence).append("OMElement target[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)charSequence).append("TokenConsumerConfig config, CertCacheManager cmanager, ");
            ((StringBuffer)charSequence).append("SOAPMessageContext messageContext, ");
            ((StringBuffer)charSequence).append("boolean isNone[").append(bl).append("], ");
            ((StringBuffer)charSequence).append("boolean isEmb[").append(bl2).append("], ");
            ((StringBuffer)charSequence).append("Map context)");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        x509PKIPathTokenImpl.setXML(new OMStructure(oMElement));
        charSequence = null;
        if (bl) {
            object4 = IdUtils.getInstance().getIdAttributeName(oMElement);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The identifier attribute of the target element is [" + object4 + "].");
            }
            if (object4 != null) {
                charSequence = oMElement.getAttributeValue((QName)object4);
            }
        } else if (bl2) {
            charSequence = (String)map.get(Constants.WSSECURITY_KEY_EMBID);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The identifier of the token is [" + (String)charSequence + "]");
        }
        x509PKIPathTokenImpl.setId((String)charSequence);
        object4 = DOMUtils.getStringValue(oMElement);
        Serializable serializable2 = null;
        byte[] byArray = null;
        if (certCacheManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking the cached X509Certificate object with the key[" + (String)object4 + "].");
            }
            try {
                object3 = certCacheManager.getCachedCert((String)object4);
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException(soapSecurityException, clsName + ".processElement", "607");
                throw new LoginException(soapSecurityException.toString());
            }
            if (object3 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is no cached certificiate.");
                }
            } else if (object3 instanceof X509Certificate) {
                serializable2 = (X509Certificate)object3;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The X509Certificate [" + ((X509Certificate)serializable2).getSubjectDN().getName() + "] was found.");
                }
                try {
                    byArray = ((Certificate)serializable2).getEncoded();
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    Tr.processException(certificateEncodingException, clsName + ".processElement", "622");
                    Tr.error(tc, "security.wssecurity.WSEC0155E", certificateEncodingException);
                    String string = ConfigUtil.getMessage("security.wssecurity.WSEC0155E", new String[]{certificateEncodingException.toString()});
                    throw new LoginException(string);
                }
            } else if (tc.isDebugEnabled()) {
                serializable = new StringBuffer("The certificate [");
                ((StringBuffer)serializable).append(object3.getClass().getName());
                ((StringBuffer)serializable).append("] was found, but it's not the X509Certificate object.");
                Tr.debug(tc, ((StringBuffer)serializable).toString());
            }
        }
        if (serializable2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Getting the X509Certificate object through the LoginModule.");
            }
            if (object4 != null) {
                byArray = Base64.decode((String)object4);
            }
            if (byArray == null) {
                object3 = ConfigUtil.getMessage("security.wssecurity.PkiPathCallbackHandler.s02");
                throw new LoginException((String)object3);
            }
            object3 = null;
            serializable = x509ConsumeCallback.getProvider();
            try {
                object3 = CertificateUtil.generateCertPath(byArray, "X.509", "PkiPath", (Provider)serializable);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeeded to generate cert path.");
                }
                serializable2 = (X509Certificate)((CertPath)object3).getCertificates().get(0);
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + ".processElement", "663");
                Tr.error(tc, "security.wssecurity.X509LoginModule.s01", exception);
                String string = ConfigUtil.getMessage("security.wssecurity.X509LoginModule.s01", new String[]{exception.toString()});
                throw new LoginException(string);
            }
            if (!x509ConsumeCallback.isTrustAnyCertificate()) {
                PkiPathConsumeLoginModule.validateX509((X509Certificate)serializable2, x509ConsumeCallback, (CertPath)object3);
            }
            if (certCacheManager != null) {
                try {
                    certCacheManager.cacheCert((String)object4, (Certificate)serializable2);
                }
                catch (SoapSecurityException soapSecurityException) {
                    Tr.processException(soapSecurityException, clsName + ".processElement", "678");
                    throw new LoginException(soapSecurityException.toString());
                }
            }
        }
        object3 = x509PKIPathTokenImpl;
        serializable = serializable2;
        byte[] byArray2 = byArray;
        AccessController.doPrivileged(new PrivilegedAction<Object>((X509PKIPathTokenImpl)object3, (X509Certificate)serializable, byArray2){
            final /* synthetic */ X509PKIPathTokenImpl val$tempToken;
            final /* synthetic */ X509Certificate val$tempx509;
            final /* synthetic */ byte[] val$tempbinary;
            {
                this.val$tempToken = x509PKIPathTokenImpl;
                this.val$tempx509 = x509Certificate;
                this.val$tempbinary = byArray;
            }

            @Override
            public Object run() {
                this.val$tempToken.setCertificate(this.val$tempx509);
                this.val$tempToken.setBinary(this.val$tempbinary);
                return null;
            }
        });
        if (x509ConsumeCallback.existKeyStore()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is a keystore used for key locator.");
            }
            try {
                object2 = KeyStoreManager.getInstance();
                object = ((KeyStoreManager)object2).getKeyInformation(x509ConsumeCallback.getKeyStorePath(), x509ConsumeCallback.getKeyStoreType(), x509ConsumeCallback.getKeyStorePassword(), x509ConsumeCallback.getKeyStoreReference(), x509ConsumeCallback.getAlias(), x509ConsumeCallback.getKeyPassword(), x509ConsumeCallback.getKeyName());
                X509Certificate x509Certificate = (X509Certificate)((KeyStoreManager.KeyInformation)object).getCertificate();
                if (!((Certificate)serializable2).equals(x509Certificate)) {
                    String string = serializable2 == null ? null : ((X509Certificate)serializable2).getSubjectDN().getName();
                    String string2 = x509Certificate == null ? null : x509Certificate.getSubjectDN().getName();
                    String string3 = ConfigUtil.getMessage("security.wssecurity.WSEC6809E", new String[]{string, string2, x509ConsumeCallback.getKeyStorePath()});
                    throw new LoginException(string3);
                }
                x509PKIPathTokenImpl.setKey(63, ((KeyStoreManager.KeyInformation)object).getPublicOrSecretKey());
                x509PKIPathTokenImpl.setKey(64, ((KeyStoreManager.KeyInformation)object).getPrivateOrSecretKey());
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException(soapSecurityException, clsName + ".processElement", "714");
                throw new LoginException(soapSecurityException.toString());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is no keystore used for key locator.");
            }
            x509PKIPathTokenImpl.setKey(63, ((Certificate)serializable2).getPublicKey());
        }
        object2 = x509PKIPathTokenImpl;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("processElement(");
            ((StringBuffer)object).append("X509PKIPathTokenImpl, OMElement, TokenConsumerConfig, CertCacheManager, ");
            ((StringBuffer)object).append("SOAPMessageContext, boolean, boolean, Map)");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void validateX509(X509Certificate x509Certificate, X509ConsumeCallback x509ConsumeCallback, CertPath certPath) throws LoginException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            object2 = new StringBuffer("validateX509(");
            ((StringBuffer)object2).append("X509Certificate x509[");
            ((StringBuffer)object2).append(x509Certificate == null ? null : x509Certificate.getSubjectDN().getName()).append("], ");
            ((StringBuffer)object2).append("X509ConsumeCallback x509Callback)");
            Tr.entry(tc, ((StringBuffer)object2).toString());
        }
        if ((object2 = x509ConsumeCallback.getCertPathParameter()) == null) {
            Object object3;
            object = KeyStoreManager.getInstance();
            KeyStore keyStore = null;
            try {
                keyStore = ((KeyStoreManager)object).getKeyStore(x509ConsumeCallback.getTrustAnchorPath(), x509ConsumeCallback.getTrustAnchorType(), x509ConsumeCallback.getTrustAnchorPassword(), null);
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException(soapSecurityException, clsName + ".validateX509", "757");
                throw new LoginException(soapSecurityException.toString());
            }
            try {
                object3 = new X509CertSelector();
                object2 = new PKIXBuilderParameters(keyStore, (CertSelector)object3);
                ((PKIXParameters)object2).setRevocationEnabled(false);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                Tr.processException(invalidAlgorithmParameterException, clsName + ".validateX509", "765");
                Tr.error(tc, "security.wssecurity.CommonReceiverConfig.s12", new String[]{invalidAlgorithmParameterException.getMessage()});
                String string = ConfigUtil.getMessage("security.wssecurity.CommonReceiverConfig.s12", new String[]{invalidAlgorithmParameterException.getMessage()});
                throw new LoginException(string);
            }
            catch (KeyStoreException keyStoreException) {
                Tr.processException(keyStoreException, clsName + ".validateX509", "772");
                Tr.error(tc, ".CommonReceiverConfig.s12", new String[]{keyStoreException.getMessage()});
                String string = ConfigUtil.getMessage("security.wssecurity.CommonReceiverConfig.s12", new String[]{keyStoreException.getMessage()});
                throw new LoginException(string);
            }
            object3 = x509ConsumeCallback.getCertStores();
            if (object3 != null) {
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    CertStore certStore = (CertStore)iterator.next();
                    ((PKIXParameters)object2).addCertStore(certStore);
                }
            }
        } else {
            object = object2;
            synchronized (object) {
                object2 = (PKIXBuilderParameters)((PKIXParameters)object2).clone();
            }
        }
        try {
            if (certPath == null) {
                certPath = CertificateUtil.generateCertPath(x509Certificate.getEncoded(), "X.509", "PkiPath", x509ConsumeCallback.getProvider());
            }
            CertificateUtil.validateCertPath(certPath, (PKIXParameters)object2);
        }
        catch (Exception exception) {
            Tr.processException(exception, clsName + ".validateX509", "805");
            throw new LoginException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("validateX509(");
            ((StringBuffer)object).append("X509Certificate, X509ConsumeCallback)");
            Tr.exit(tc, ((StringBuffer)object).toString());
        }
    }
}

