/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.callbackhandler.X509GenerateCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509PKCS7Token;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.KeyStoreManager;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509GenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509PKCS7TokenImpl;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;

public class PKCS7GenerateLoginModule
extends X509GenerateLoginModule {
    private static final TraceComponent tc = Tr.register(PKCS7GenerateLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PKCS7GenerateLoginModule.class.getName();

    public boolean login() throws LoginException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        X509GenerateCallback x509GenerateCallback = new X509GenerateCallback();
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbackArray = new Callback[]{x509GenerateCallback, propertyCallback};
        try {
            this._handler.handle(callbackArray);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".login", "71", this);
            Tr.error(tc, "security.wssecurity.BSTokenLoginModule.s01", exception);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{exception.toString()}));
        }
        this._context = propertyCallback.getProperties();
        MessageContext messageContext = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        KeyStoreManager keyStoreManager = KeyStoreManager.getInstance();
        KeyStoreManager.KeyInformation keyInformation = null;
        if (x509GenerateCallback.isUsedRequestorCertificate()) {
            object2 = messageContext.getProperty("com.ibm.xml.soapsec.RequestCert");
            if (object2 == null || !(object2 instanceof X509Certificate)) {
                String string = ConfigUtil.getMessage("security.wssecurity.WSEC6808E");
                throw new LoginException(string);
            }
            object = (X509Certificate)object2;
            try {
                keyInformation = keyStoreManager.getKeyInformation((X509Certificate)object);
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".login", "104", this);
                throw new LoginException(soapSecurityException.toString());
            }
        }
        try {
            keyInformation = keyStoreManager.getKeyInformationInPKCS7(x509GenerateCallback.getKeyStorePath(), x509GenerateCallback.getKeyStoreType(), x509GenerateCallback.getKeyStorePassword(), x509GenerateCallback.getKeyStoreReference(), x509GenerateCallback.getAlias(), x509GenerateCallback.getKeyPassword(), x509GenerateCallback.getKeyName(), x509GenerateCallback.getCertStores());
        }
        catch (SoapSecurityException soapSecurityException) {
            Tr.processException((Throwable)soapSecurityException, clsName + ".login", "117", this);
            throw new LoginException(soapSecurityException.toString());
        }
        object2 = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        object = (String)this._context.get(Constants.WSSECURITY_KEYINFO_TYPE);
        SecurityToken securityToken = null;
        String string = null;
        try {
            Certificate certificate = keyInformation.getCertificate();
            string = keyInformation.getSubjectDN();
            securityToken = PKCS7GenerateLoginModule.getToken((TokenGeneratorConfig)object2, (String)object, certificate, this._securityTokenManager);
        }
        catch (SoapSecurityException soapSecurityException) {
            Tr.processException((Throwable)soapSecurityException, clsName + ".login", "134", this);
            throw new LoginException(soapSecurityException.toString());
        }
        boolean bl6 = object2.isStandAlone();
        if (object == null) {
            bl5 = false;
            bl4 = false;
            bl3 = false;
            bl2 = false;
            bl = false;
        } else {
            bl = ConfigUtil.isKeyInfoKeyname((String)object);
            bl2 = ConfigUtil.isKeyInfoKeyid((String)object);
            bl3 = ConfigUtil.isKeyInfoStrref((String)object);
            bl4 = ConfigUtil.isKeyInfoEmb((String)object);
            bl5 = ConfigUtil.isKeyInfoX509issuer((String)object);
        }
        if (securityToken == null) {
            OMElement oMElement = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
            X509PKCS7TokenImpl x509PKCS7TokenImpl = new X509PKCS7TokenImpl();
            try {
                Object object3;
                Object object4;
                string = null;
                if (bl6) {
                    string = IdUtils.getInstance().makeUniqueId("x509bst_");
                    x509PKCS7TokenImpl.setId(string);
                    PKCS7GenerateLoginModule.createTokenElement(oMElement.getOMFactory(), oMElement, object2.getType(), keyInformation, x509PKCS7TokenImpl, true, this._context);
                    this._processedTokens.add(x509PKCS7TokenImpl);
                    this._insertedTokens.add(x509PKCS7TokenImpl);
                } else if (bl3) {
                    string = IdUtils.getInstance().makeUniqueId("x509bst_");
                    x509PKCS7TokenImpl.setId(string);
                    x509PKCS7TokenImpl.setReferenceURI("#" + string);
                    PKCS7GenerateLoginModule.createTokenElement(oMElement.getOMFactory(), oMElement, object2.getType(), keyInformation, x509PKCS7TokenImpl, true, this._context);
                    this._processedTokens.add(x509PKCS7TokenImpl);
                    this._insertedTokens.add(x509PKCS7TokenImpl);
                } else if (bl4) {
                    string = IdUtils.getInstance().makeUniqueId("x509bst_");
                    x509PKCS7TokenImpl.setId(string);
                    PKCS7GenerateLoginModule.createTokenElement(oMElement.getOMFactory(), oMElement, object2.getType(), keyInformation, x509PKCS7TokenImpl, false, this._context);
                    this._processedTokens.add(x509PKCS7TokenImpl);
                    this._insertedTokens.add(x509PKCS7TokenImpl);
                } else if (bl2) {
                    object4 = (QName)this._context.get(Constants.WSSECURITY_KEY_ENCODING);
                    object3 = (QName)this._context.get(Constants.WSSECURITY_KEY_IDTYPE);
                    string = PKCS7GenerateLoginModule.getKeyIdentifier(keyInformation, (QName)object4, (QName)object3);
                    x509PKCS7TokenImpl.setId(string);
                    x509PKCS7TokenImpl.setKeyIdentifier(string);
                    this._processedTokens.add(x509PKCS7TokenImpl);
                } else if (bl) {
                    string = keyInformation.getSubjectDN();
                    x509PKCS7TokenImpl.setId(string);
                    x509PKCS7TokenImpl.setKeyName(string);
                    this._processedTokens.add(x509PKCS7TokenImpl);
                } else if (bl5) {
                    object4 = keyInformation.getIssuerDN();
                    object3 = keyInformation.getIssuerSerial();
                    string = (String)object4 + ":" + (String)object3;
                    x509PKCS7TokenImpl.setId(string);
                    x509PKCS7TokenImpl.setIssuerName((String)object4);
                    x509PKCS7TokenImpl.setIssuerSerial((String)object3);
                    this._processedTokens.add(x509PKCS7TokenImpl);
                }
                x509PKCS7TokenImpl.setId(string);
                object4 = x509PKCS7TokenImpl;
                object3 = (X509Certificate)keyInformation.getCertificate();
                byte[] byArray = keyInformation.getBinary();
                AccessController.doPrivileged(new PrivilegedAction<Object>((X509PKCS7TokenImpl)object4, (X509Certificate)object3, byArray){
                    final /* synthetic */ X509PKCS7TokenImpl val$temppkcs7Token;
                    final /* synthetic */ X509Certificate val$tempx509;
                    final /* synthetic */ byte[] val$tempbinary;
                    {
                        this.val$temppkcs7Token = x509PKCS7TokenImpl;
                        this.val$tempx509 = x509Certificate;
                        this.val$tempbinary = byArray;
                    }

                    @Override
                    public Object run() {
                        this.val$temppkcs7Token.setCertificate(this.val$tempx509);
                        this.val$temppkcs7Token.setBinary(this.val$tempbinary);
                        return null;
                    }
                });
                x509PKCS7TokenImpl.setKey(62, keyInformation.getPublicOrSecretKey());
                x509PKCS7TokenImpl.setKey(61, keyInformation.getPrivateOrSecretKey());
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".login", "231", this);
                throw new LoginException(soapSecurityException.toString());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "There is the token [" + securityToken.getId() + "] stored in the Subject.");
        }
        if (bl6) {
            this._processedTokens.add(securityToken);
        } else if (bl3) {
            this._processedTokens.add(securityToken);
        } else if (bl4) {
            X509PKCS7TokenImpl x509PKCS7TokenImpl = new X509PKCS7TokenImpl();
            try {
                x509PKCS7TokenImpl.setId(IdUtils.getInstance().makeUniqueId("x509bst_"));
                final X509PKCS7TokenImpl x509PKCS7TokenImpl2 = x509PKCS7TokenImpl;
                final X509Certificate x509Certificate = (X509Certificate)keyInformation.getCertificate();
                final byte[] byArray = keyInformation.getBinary();
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        x509PKCS7TokenImpl2.setCertificate(x509Certificate);
                        x509PKCS7TokenImpl2.setBinary(byArray);
                        return null;
                    }
                });
                x509PKCS7TokenImpl.setKey(62, keyInformation.getPublicOrSecretKey());
                x509PKCS7TokenImpl.setKey(61, keyInformation.getPrivateOrSecretKey());
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".login", "262", this);
                throw new LoginException(soapSecurityException.toString());
            }
            this._processedTokens.add(x509PKCS7TokenImpl);
            this._insertedTokens.add(x509PKCS7TokenImpl);
        } else if (bl2) {
            this._processedTokens.add(securityToken);
        } else if (bl) {
            this._processedTokens.add(securityToken);
        } else if (bl5) {
            this._processedTokens.add(securityToken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    private static final SecurityToken getToken(TokenGeneratorConfig tokenGeneratorConfig, String string, Certificate certificate, SecurityTokenManager securityTokenManager) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getToken(");
            ((StringBuffer)object).append("TokenGeneratorConfig config, ");
            ((StringBuffer)object).append("String keyInfoType[").append(string).append("], ");
            ((StringBuffer)object).append("Certificate cert, SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        Collection<SecurityToken> collection = securityTokenManager.getTokens(tokenGeneratorConfig, string);
        if (collection != null && collection.size() > 0) {
            for (SecurityToken securityToken : collection) {
                if (!(securityToken instanceof X509PKCS7Token) || !((X509PKCS7Token)securityToken).getCertificate().equals(certificate)) continue;
                object = securityToken;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getToken(");
            stringBuffer.append("TokenGeneratorConfig, String, Certificate, SecurityTokenManager)");
            stringBuffer.append(" returns SecurityToken[").append(object).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }
}

