/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.token.LTPAToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.token.impl.BinarySecurityTokenImpl;
import com.ibm.wsspi.security.token.AuthenticationToken;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecurityPermission;
import java.util.Enumeration;

public class LTPATokenImpl
extends BinarySecurityTokenImpl
implements LTPAToken,
AuthenticationToken {
    private static final TraceComponent tc = Tr.register(LTPATokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = -1474812800604914136L;
    private static final SecurityPermission SETBYTES_PERM = new SecurityPermission("wssapi.LTPATokenImpl.setBytes");
    private static final SecurityPermission GETBYTES_PERM = new SecurityPermission("wssapi.LTPATokenImpl.getBytes");
    private boolean isForwardable = true;
    private int hashCode = 0;
    private byte[] serializationBytes = null;
    public static final String authenticationTokenName = "security.wssecurity_http://www.ibm.com/websphere/appserver/tokentype/5.0.2#LTPA";

    public LTPATokenImpl() {
        this.valueType = LTPAToken.ValueType;
        this.tokenQName = LTPAToken.TokenQname;
    }

    public void initialize(byte[] byArray) {
        block2: {
            this.serializationBytes = byArray;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                this.readExternal(objectInputStream);
                objectInputStream.close();
                byteArrayInputStream.close();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Fail to deserialize Token. ", exception.getStackTrace());
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.isForwardable = objectInput.readBoolean();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeBoolean(this.isForwardable);
    }

    public boolean isForwardable() {
        return this.isForwardable;
    }

    public void setIsForwardable(boolean bl) {
        if (!this.readOnly) {
            this.isForwardable = bl;
        }
    }

    public String getUniqueID() {
        String string = null;
        final LTPATokenImpl lTPATokenImpl = this;
        byte[] byArray = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return lTPATokenImpl.getBinary();
            }
        });
        string = new String(byArray);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getUniqueID() = " + string);
        }
        return string;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            LTPATokenImpl lTPATokenImpl;
            byte[] byArray;
            int n = 0;
            if (this.getId() != null) {
                n = this.getId().hashCode();
            }
            if ((byArray = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(lTPATokenImpl = this){
                final /* synthetic */ LTPATokenImpl val$lt;
                {
                    this.val$lt = lTPATokenImpl2;
                }

                @Override
                public Object run() {
                    return this.val$lt.getBinary();
                }
            })) != null) {
                n += new String(byArray).hashCode();
            }
            this.hashCode = n;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LTPAToken)) {
            return false;
        }
        return object.hashCode() == this.hashCode();
    }

    public byte[] getBytes() {
        block7: {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + GETBYTES_PERM.toString());
                }
                securityManager.checkPermission(GETBYTES_PERM);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                this.writeExternal(objectOutputStream);
                objectOutputStream.close();
                byteArrayOutputStream.close();
                this.serializationBytes = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Fail to serialize Token. ", exception.getStackTrace());
            }
        }
        if (tc.isDebugEnabled()) {
            if (this.serializationBytes == null) {
                Tr.debug(tc, "The string value of ltpaToken.getBytes is NULL");
            } else {
                Tr.debug(tc, "The string value of ltpaToken.getBytes :: " + new String(this.serializationBytes));
            }
        }
        return this.serializationBytes;
    }

    public void setBytes(byte[] byArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETBYTES_PERM.toString());
            }
            securityManager.checkPermission(SETBYTES_PERM);
        }
        if (!this.readOnly) {
            this.serializationBytes = byArray;
        }
    }

    public String getName() {
        return authenticationTokenName;
    }

    public short getVersion() {
        return 1;
    }

    public boolean isBasicAuth() {
        return false;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public String[] getAttributes(String string) {
        return null;
    }

    public Enumeration getAttributeNames() {
        return null;
    }

    public String[] addAttribute(String string, String string2) {
        return null;
    }

    public boolean isValid() {
        return true;
    }

    public long getExpiration() {
        return -1L;
    }

    public Object clone() {
        return null;
    }
}

