/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAPropagationToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.token.WSSMarkerObject;
import com.ibm.ws.wssecurity.core.TokenCacheManagerFactory;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl.TokenPropagationCallbackHandler;
import com.ibm.ws.wssecurity.token.PropagationToken;
import com.ibm.ws.wssecurity.token.TokenCacheManager;
import com.ibm.ws.wssecurity.util.ConfigConstants;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPAGenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPAPropagationTokenImpl;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.security.context.Context;
import com.ibm.wsspi.security.csiv2.CSIv2PerformPolicy;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.context.MessageContext;

public class LTPAPropagationGenerateLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(LTPAPropagationGenerateLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LTPAPropagationGenerateLoginModule.class.getName();
    private CallbackHandler _handler;
    private List<SecurityToken> _processedTokens;
    private List<SecurityToken> _insertedTokens;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = callbackHandler;
        this._processedTokens = new ArrayList<SecurityToken>();
        this._insertedTokens = new ArrayList<SecurityToken>();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Subject subject;
        Object object6;
        TokenCacheManager tokenCacheManager;
        byte[] byArray;
        byte[] byArray2;
        WSPrincipal wSPrincipal;
        WSCredential wSCredential;
        Subject subject2;
        block54: {
            Object object7;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "login()");
            }
            NameCallback nameCallback = new NameCallback("username: ");
            PasswordCallback passwordCallback = new PasswordCallback("passowrd: ", false);
            PropertyCallback propertyCallback = new PropertyCallback(null);
            Callback[] callbackArray = new Callback[]{nameCallback, passwordCallback, propertyCallback};
            try {
                this._handler.handle(callbackArray);
            }
            catch (Exception exception) {
                LoginException loginException = new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{exception.toString()}));
                Tr.processException((Throwable)loginException, clsName + ".login", "147", this);
                throw loginException;
            }
            this._context = propertyCallback.getProperties();
            this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
            subject2 = null;
            wSCredential = null;
            wSPrincipal = null;
            byArray2 = null;
            byArray = null;
            try {
                if (!WSSContextManagerFactory.getInstance().getServerSecurityEnabled()) {
                    String string = ConfigConstants.getMessage("security.wssecurity.WSEC0166E");
                    LoginException loginException = new LoginException(string);
                    Tr.processException((Throwable)loginException, clsName + ".login", "171", this);
                    throw loginException;
                }
            }
            catch (SoapSecurityException soapSecurityException) {
                LoginException loginException = new LoginException(soapSecurityException.toString());
                Tr.processException((Throwable)loginException, clsName + ".login", "177", this);
                throw loginException;
            }
            try {
                tokenCacheManager = TokenCacheManagerFactory.getInstance();
            }
            catch (SoapSecurityException soapSecurityException) {
                LoginException loginException = new LoginException(soapSecurityException.getMessage());
                Tr.processException((Throwable)loginException, clsName + ".login", "186", this);
                throw loginException;
            }
            try {
                object7 = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                object6 = (Context)((MessageContext)object7).getProperty("com.ibm.wsspi.websphere.security.SecurityContext");
                subject = object6.getRunAsSubject();
            }
            catch (WSSecurityException wSSecurityException) {
                LoginException loginException = new LoginException(wSSecurityException.getMessage());
                Tr.processException((Throwable)loginException, clsName + ".login", "200", this);
                throw loginException;
            }
            object7 = null;
            object6 = null;
            try {
                object7 = _wsCredToken._wsCredTokenMapper;
                if (object7 != null && subject != null) {
                    object6 = object7.createSubjectUniqueID(subject);
                }
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, clsName + ".login", "213", this);
                if (!tc.isDebugEnabled()) break block54;
                Tr.debug(tc, "Caught exception while getting unique ID from subject.", new Object[]{exception});
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unique ID from tokens in contextSubject: " + (String)object6);
        }
        if (tokenCacheManager != null && object6 != null && ((String)object6).length() > 0) {
            object5 = null;
            try {
                object5 = tokenCacheManager.getCachedToken((String)object6);
            }
            catch (SoapSecurityException soapSecurityException) {
                LoginException loginException = new LoginException(soapSecurityException.getMessage());
                Tr.processException((Throwable)loginException, clsName + ".login", "227", this);
                throw loginException;
            }
            if (object5 != null) {
                byArray2 = ((PropagationToken)object5).getToken();
                long l = System.currentTimeMillis();
                if (((PropagationToken)object5).getExpiration() - l > 0L) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found cached token based on unique ID.");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found cached token, but it is expired.");
                    }
                    byArray2 = null;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find cached token based on unique ID.");
            }
        }
        if (byArray2 == null) {
            block55: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing login to obtain token.");
                }
                try {
                    subject2 = SubjectHelper.createNewSubjectFromExisting(subject);
                }
                catch (Exception exception) {
                    LoginException loginException = new LoginException(exception.getMessage());
                    Tr.processException((Throwable)loginException, clsName + ".login", "259", this);
                    throw loginException;
                }
                object5 = "system.WSS_OUTBOUND";
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using JAAS config: " + (String)object5);
                }
                WSSMarkerObject wSSMarkerObject = new WSSMarkerObject(Boolean.TRUE);
                LTPAPropagationGenerateLoginModule.addToSubject(subject2, wSSMarkerObject);
                CSIv2PerformPolicy cSIv2PerformPolicy = new CSIv2PerformPolicy((CSIv2EffectivePerformPolicy)null);
                object4 = new TokenPropagationCallbackHandler(this._context, cSIv2PerformPolicy);
                if (object4 == null) {
                    LoginException loginException = new LoginException("Unable to get instance of TokenPropagationCallbackHandler");
                    Tr.processException((Throwable)loginException, clsName + ".login", "276", this);
                    throw loginException;
                }
                object3 = new LoginContext((String)object5, subject2, (CallbackHandler)object4);
                ((LoginContext)object3).login();
                object2 = ((LoginContext)object3).getSubject();
                try {
                    wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)object2);
                    wSPrincipal = SubjectHelper.getPrincipalFromSubject((Subject)object2);
                    byArray = wSCredential.getCredentialToken();
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block55;
                    Tr.debug(tc, "Did not find Credential Token.");
                }
            }
            try {
                object = AccessController.doPrivileged(new PrivilegedExceptionAction<TokenHolder>((Subject)object2){
                    final /* synthetic */ Subject val$newSubject;
                    {
                        this.val$newSubject = subject;
                    }

                    @Override
                    public TokenHolder run() throws Exception {
                        WSOpaqueTokenHelper wSOpaqueTokenHelper = WSOpaqueTokenHelper.getInstance();
                        String string = wSOpaqueTokenHelper.getOpaqueTokenName();
                        int n = wSOpaqueTokenHelper.getOpaqueTokenVersion();
                        Iterator<TokenHolder> iterator = this.val$newSubject.getPrivateCredentials(TokenHolder.class).iterator();
                        while (iterator != null && iterator.hasNext()) {
                            TokenHolder tokenHolder = iterator.next();
                            if (!(tokenHolder instanceof TokenHolder) || !tokenHolder.getName().equals(string) || tokenHolder.getVersion() != n) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Found TokenHolder containing opaque authz token");
                            }
                            return tokenHolder;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Did not find TokenHolder containing opaque authz token");
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                LoginException loginException = new LoginException(privilegedActionException.getMessage());
                Tr.processException((Throwable)loginException, clsName + ".login", "324", this);
                throw loginException;
            }
            if (object != null) {
                byArray2 = ((TokenHolder)object).getBytes();
                if (tokenCacheManager != null) {
                    long l;
                    long l2 = 0L;
                    AuthenticationToken authenticationToken = SubjectHelper.getDefaultAuthTokenFromSubject((Subject)object2);
                    l2 = authenticationToken.getExpiration();
                    try {
                        l = tokenCacheManager.getCushion();
                    }
                    catch (SoapSecurityException soapSecurityException) {
                        LoginException loginException = new LoginException(soapSecurityException.getMessage());
                        Tr.processException((Throwable)loginException, clsName + ".login", "338", this);
                        throw loginException;
                    }
                    long l3 = System.currentTimeMillis();
                    long l4 = l2 - l3 - l;
                    if (l4 < 0L) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Token has expired. Do not cache.");
                        }
                    } else {
                        PropagationToken propagationToken = new PropagationToken(byArray2, l2 - l);
                        if (object6 != null && ((String)object6).length() > 0 && propagationToken != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Caching token.");
                            }
                            try {
                                tokenCacheManager.cacheToken((String)object6, propagationToken);
                            }
                            catch (SoapSecurityException soapSecurityException) {
                                LoginException loginException = new LoginException(soapSecurityException.getMessage());
                                Tr.processException((Throwable)loginException, clsName + ".login", "357", this);
                                throw loginException;
                            }
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find WSCredential in new Subject.");
            }
        }
        object5 = IdUtils.getInstance().makeUniqueId("ltpa_");
        TokenGeneratorConfig tokenGeneratorConfig = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
        int n = 0;
        object4 = null;
        object4 = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
        if (object4 != null && object4 instanceof Integer) {
            n = (Integer)object4;
        }
        object3 = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        try {
            object2 = LTPAPropagationGenerateLoginModule.getToken(tokenGeneratorConfig, byArray2, this._securityTokenManager);
        }
        catch (SoapSecurityException soapSecurityException) {
            LoginException loginException = new LoginException(soapSecurityException.toString());
            Tr.processException((Throwable)soapSecurityException, clsName + ".login", "387", this);
            throw loginException;
        }
        if (object2 == null) {
            object = LTPAPropagationGenerateLoginModule.createTokenElement(object3.getOMFactory(), (OMElement)object3, tokenGeneratorConfig, byArray2, (String)object5, n);
            LTPAPropagationTokenImpl lTPAPropagationTokenImpl = new LTPAPropagationTokenImpl();
            lTPAPropagationTokenImpl.setId((String)object5);
            lTPAPropagationTokenImpl.setWSCredential(wSCredential);
            lTPAPropagationTokenImpl.setWSPrincipal(wSPrincipal);
            lTPAPropagationTokenImpl.setPrincipal(wSPrincipal.getName());
            lTPAPropagationTokenImpl.setBinary(byArray);
            lTPAPropagationTokenImpl.setXML(new OMStructure((OMElement)object));
            lTPAPropagationTokenImpl.setKey(61, null);
            lTPAPropagationTokenImpl.setKey(62, null);
            this._processedTokens.add(lTPAPropagationTokenImpl);
            this._insertedTokens.add(lTPAPropagationTokenImpl);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "There is the token [" + object2.getId() + "] stored in the Subject.");
            }
            this._processedTokens.add((SecurityToken)object2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        int n = this._processedTokens.size();
        for (int i = 0; i < n; ++i) {
            SecurityToken securityToken = this._processedTokens.get(i);
            this._securityTokenManager.addToken(securityToken);
        }
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        this._context.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private static final OMElement createTokenElement(OMFactory oMFactory, OMElement oMElement, TokenGeneratorConfig tokenGeneratorConfig, byte[] byArray, String string, int n) {
        Object object;
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("createTokenElement(");
            ((StringBuffer)charSequence).append("OMFactory factory,");
            ((StringBuffer)charSequence).append("OMElement parent[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)charSequence).append("TokenGeneratorConfig config, ");
            ((StringBuffer)charSequence).append("byte[] credToken[");
            ((StringBuffer)charSequence).append(byArray == null ? "null" : "not null");
            ((StringBuffer)charSequence).append("], ");
            ((StringBuffer)charSequence).append("String id[").append(string).append("], ");
            ((StringBuffer)charSequence).append("int wssVersion[").append(n).append("])");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        charSequence = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][n];
        String string2 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][n];
        boolean bl = false;
        String string3 = null;
        if (oMElement != null) {
            string3 = DOMUtils.getNamespacePrefix(oMElement, (String)charSequence);
        }
        if (string3 == null) {
            bl = true;
            string3 = "wsse";
        }
        OMElement oMElement2 = oMFactory.createOMElement("BinarySecurityToken", (String)charSequence, string3);
        if (bl) {
            oMElement2.declareNamespace((String)charSequence, "wsse");
        }
        if (string != null) {
            bl = false;
            object = DOMUtils.getNamespacePrefix(oMElement, string2);
            if (object == null) {
                bl = true;
                object = "wsu";
            }
            if (bl) {
                oMElement2.declareNamespace(string2, "wsu");
            }
            oMElement2.addAttribute("Id", string, oMFactory.createOMNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSU, (String)object));
        }
        if ((object = tokenGeneratorConfig.getType()) == null) {
            object = com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN;
        }
        oMElement2.declareNamespace(((QName)object).getNamespaceURI(), "wsst");
        DOMUtils.setQNameAttr(oMElement2, null, "EncodingType", com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY, n);
        DOMUtils.setQNameAttr(oMElement2, null, "ValueType", (QName)object, n);
        String string4 = Base64.encode(byArray);
        oMElement2.addChild(oMFactory.createOMText(string4));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTokenElement(Document doc,Element parent,TokenGeneratorConfig config,byte[] credToken,String id,int wssVersion) returns Element[" + oMElement2 + "]");
        }
        return oMElement2;
    }

    private static final SecurityToken getToken(TokenGeneratorConfig tokenGeneratorConfig, byte[] byArray, SecurityTokenManager securityTokenManager) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getToken(");
            ((StringBuffer)object).append("TokenGeneratorConfig config, ");
            ((StringBuffer)object).append("byte[] binary[");
            ((StringBuffer)object).append(byArray == null ? "null" : "not null");
            ((StringBuffer)object).append("], SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        Collection<SecurityToken> collection = securityTokenManager.getTokens(tokenGeneratorConfig);
        if (collection != null && collection.size() > 0) {
            for (SecurityToken securityToken : collection) {
                LTPAPropagationToken lTPAPropagationToken;
                byte[] byArray2;
                if (!(securityToken instanceof LTPAPropagationToken) || !LTPAGenerateLoginModule.equalsByteArray(byArray2 = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(lTPAPropagationToken = (LTPAPropagationToken)securityToken){
                    final /* synthetic */ LTPAPropagationToken val$lt;
                    {
                        this.val$lt = lTPAPropagationToken;
                    }

                    @Override
                    public Object run() {
                        return this.val$lt.getBinary();
                    }
                }), byArray)) continue;
                object = securityToken;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getToken(");
            stringBuffer.append("TokenGeneratorConfig, byte[], SecurityTokenManager)");
            stringBuffer.append(" returns SecurityToken[").append(object).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    private static final void addToSubject(final Subject subject, final Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToSubject(Subject subject, Object marker)");
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (!subject.getPrivateCredentials().contains(object)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Adding marker to Subject: " + object);
                    }
                    subject.getPrivateCredentials().add(object);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject already contains marker: " + object);
                }
                return null;
            }
        });
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToSubject(Subject subject, Object marker)");
        }
    }

    private static class _wsCredToken {
        static WSCredentialTokenMapperInterface _wsCredTokenMapper = null;

        private _wsCredToken() {
        }

        static {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object obj = clazz.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got instance of WSCredTokenMapper.");
                }
                _wsCredTokenMapper = (WSCredentialTokenMapperInterface)obj;
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + "init", "543");
            }
        }
    }
}

