/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.wssecurity.platform.websphere.wssapi.token.impl.TokenPropagationCallbackHandler;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPAPropagationTokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;

public class LTPAPropagationConsumeLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(LTPAPropagationConsumeLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LTPAPropagationConsumeLoginModule.class.getName();
    private CallbackHandler _handler;
    private SecurityToken _token;
    private SecurityTokenManagerImpl _securityTokenManager;
    private Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = callbackHandler;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        int n;
        WSCredentialTokenMapperInterface wSCredentialTokenMapperInterface;
        ArrayList arrayList;
        SecurityCache securityCache;
        String string;
        Object[] objectArray;
        Subject subject;
        LTPAPropagationTokenImpl lTPAPropagationTokenImpl;
        block46: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "login()");
            }
            PropertyCallback propertyCallback = new PropertyCallback(null);
            Callback[] callbackArray = new Callback[]{propertyCallback};
            try {
                this._handler.handle(callbackArray);
            }
            catch (Exception exception) {
                Tr.processException((Throwable)exception, clsName + ".login", "126", this);
                throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{exception.toString()}));
            }
            this._context = propertyCallback.getProperties();
            TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
            lTPAPropagationTokenImpl = new LTPAPropagationTokenImpl();
            this._context.put(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING, lTPAPropagationTokenImpl);
            QName qName = tokenConsumerConfig.getType();
            if (!com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN_PROPAGATION.equals(qName)) {
                String string2 = ConfigUtil.getMessage("security.wssecurity.PrivateConsumerConfig.s30", new String[]{qName.toString(), com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN_PROPAGATION.toString()});
                throw new LoginException(string2);
            }
            OMElement oMElement = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
            lTPAPropagationTokenImpl.setXML(new OMStructure(oMElement));
            String string3 = null;
            QName qName2 = IdUtils.getInstance().getIdAttributeName(oMElement);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The identifier attribute of the target element is [" + qName2 + "].");
            }
            if (qName2 != null) {
                string3 = oMElement.getAttributeValue(qName2);
            }
            lTPAPropagationTokenImpl.setId(string3);
            String string4 = DOMUtils.getStringValue(oMElement);
            byte[] byArray = Base64.decode(string4);
            subject = null;
            objectArray = null;
            string = null;
            securityCache = null;
            arrayList = null;
            wSCredentialTokenMapperInterface = null;
            wSCredentialTokenMapperInterface = _wsCredToken._wsCredTokenMapper;
            securityCache = _authCacheClass._authCache;
            try {
                arrayList = WSOpaqueTokenHelper.getInstance().createTokenHolderListFromOpaqueToken(byArray);
                objectArray = this.getSubjectFromTokenHolderCacheKey(null, arrayList);
            }
            catch (WSSecurityException wSSecurityException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caught WSSecurityException trying to get cached Subject: " + wSSecurityException);
                }
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block46;
                Tr.debug(tc, "Caught Exception trying to get cached Subject: " + exception);
            }
        }
        if (objectArray != null) {
            subject = (Subject)objectArray[0];
            string = (String)objectArray[1];
        }
        WSCredential wSCredential = null;
        WSPrincipal wSPrincipal = null;
        if (subject != null) {
            wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            wSPrincipal = SubjectHelper.getPrincipalFromSubject(subject);
            if (wSCredential != null) {
                boolean bl = wSCredential.isDestroyed();
                n = 0;
                try {
                    n = wSCredential.isForwardable();
                }
                catch (Exception exception) {
                    bl = true;
                }
                boolean bl2 = false;
                if (securityCache != null && wSCredentialTokenMapperInterface != null) {
                    bl2 = wSCredentialTokenMapperInterface.checkCushionValidityOfAllTokens(subject, securityCache.getCushion());
                }
                if (tc.isDebugEnabled()) {
                    if (n != 0) {
                        Tr.debug(tc, "credential is forwardable, subject valid = " + bl2);
                    } else {
                        Tr.debug(tc, "non-forwardable Subject");
                    }
                }
                if (bl || n != 0 && !bl2) {
                    subject = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Credential has expired or is destroyed, logging in again.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cached subject is valid.");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSCredential in Subject, logging in again.");
                }
                subject = null;
            }
        }
        if (subject == null) {
            Object object;
            wSCredential = null;
            wSPrincipal = null;
            String string5 = "system.WSS_INBOUND";
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using JAAS config: " + string5);
            }
            n = 0;
            if (arrayList != null) {
                n = arrayList.size();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "tokenList size = " + n);
            }
            byte[] byArray = null;
            for (int i = 0; i < n; ++i) {
                object = arrayList.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "tokenList object [" + i + "] = " + object.getClass().getName());
                }
                if (!(object instanceof TokenHolder)) continue;
                TokenHolder tokenHolder = (TokenHolder)object;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "th[" + i + "].name = " + tokenHolder.getName());
                    Tr.debug(tc, "th[" + i + "].version = " + tokenHolder.getVersion());
                }
                if (!"com.ibm.ws.security.token.AuthorizationTokenImpl".equals(tokenHolder.getName())) continue;
                byArray = tokenHolder.getBytes();
                if (!tc.isDebugEnabled()) continue;
                if (byArray != null && byArray.length > 0) {
                    Tr.debug(tc, "Got cred bytes from authz TokenHolder");
                    continue;
                }
                Tr.debug(tc, "Cred bytes from authz TokenHolder was null or zero-length");
            }
            LoginContext loginContext = null;
            try {
                object = new TokenPropagationCallbackHandler(this._context, arrayList, byArray);
                loginContext = new LoginContext(string5, (CallbackHandler)object);
                loginContext.login();
            }
            catch (LoginException loginException) {
                Tr.processException((Throwable)loginException, clsName + ".login()", "295", this);
                throw new LoginException("Error logging in: " + loginException.getClass().getName() + ": " + loginException.getMessage());
            }
            subject = loginContext.getSubject();
            if (string == null || string.length() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No cache key string found in token list; will not cache new subject.");
                }
            } else if (securityCache != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Caching new subject with cache key string: " + string);
                }
                securityCache.insert(subject, new Object[]{string});
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not caching new subject because Securitycache instance is null.");
            }
            wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
            wSPrincipal = SubjectHelper.getPrincipalFromSubject(subject);
        }
        this._securityTokenManager = (SecurityTokenManagerImpl)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        if (subject != null) {
            this._securityTokenManager.addToSubject(subject);
        }
        lTPAPropagationTokenImpl.setWSCredential(wSCredential);
        lTPAPropagationTokenImpl.setWSPrincipal(wSPrincipal);
        try {
            lTPAPropagationTokenImpl.setBinary(wSCredential.getCredentialToken());
        }
        catch (CredentialDestroyedException credentialDestroyedException) {
            throw new LoginException(credentialDestroyedException.getMessage());
        }
        lTPAPropagationTokenImpl.setPrincipal(wSPrincipal.getName());
        this._token = lTPAPropagationTokenImpl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        this._securityTokenManager.addToken(this._token);
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._token);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private Object[] getSubjectFromTokenHolderCacheKey(byte[] byArray, List list) throws Exception {
        Serializable serializable;
        Serializable serializable2;
        if (tc.isEntryEnabled()) {
            serializable2 = new StringBuffer("getSubjectFromTokenHolderCacheKey(");
            serializable2.append("byte[] token[");
            serializable2.append(byArray == null ? "null" : "not null").append("], ");
            serializable2.append("List tokenHolderList)");
            Tr.entry(tc, serializable2.toString());
        }
        serializable2 = null;
        String string = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                boolean bl;
                Object object;
                serializable = (TokenHolder)list.get(i);
                if (!((TokenHolder)serializable).getName().equals("com.ibm.wsspi.security.cred.cacheKey")) continue;
                byte[] byArray2 = ((TokenHolder)serializable).getBytes();
                if (byArray2 != null) {
                    string = StringBytesConversion.getConvertedString((byte[])byArray2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Found cache key from token holder list: " + string);
                    }
                    object = _authCacheClass._authCache;
                    serializable2 = object.getSubject(string);
                }
                if (serializable2 == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found Subject using cacheKey from prop token.");
                }
                if (byArray == null) continue;
                object = SubjectHelper.getWSCredentialFromSubject((Subject)serializable2);
                SingleSignonToken singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject((Subject)serializable2);
                boolean bl2 = bl = object != null && Arrays.equals(byArray, object.getCredentialToken()) || singleSignonToken != null && Arrays.equals(byArray, singleSignonToken.getBytes());
                if (bl) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Subject found from cacheKey does not have matching LTPA token.");
                }
                serializable2 = null;
            }
        }
        Object[] objectArray = null;
        if (serializable2 != null || string != null) {
            objectArray = new Object[]{serializable2, string};
        }
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getSubjectFromTokenHolderCacheKey(");
            ((StringBuffer)serializable).append("byte[], List) returns Object[][");
            ((StringBuffer)serializable).append(objectArray == null ? "null" : "not null").append("]");
            Tr.exit(tc, ((StringBuffer)serializable).toString());
        }
        return objectArray;
    }

    private static class _authCacheClass {
        private static final TraceComponent tc = Tr.register(_authCacheClass.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        private static final String FACTORY_CLASS = "com.ibm.ws.security.auth.AuthCache";
        static SecurityCache _authCache = null;

        private _authCacheClass() {
        }

        private static Method getAuthCacheGetInstanceMethod() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAuthCacheGetInstanceMethod()");
            }
            Method method = null;
            Class clazz = _authCacheClass.getAuthCacheClass();
            if (clazz != null) {
                try {
                    method = clazz.getMethod("getInstance", null);
                }
                catch (Exception exception) {
                    Tr.processException(exception, clsName + ".getAuthCacheGetInstanceMethod", "697");
                    throw new UndeclaredThrowableException(exception);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAuthCacheGetInstanceMethod()");
            }
            return method;
        }

        private static Class getAuthCacheClass() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAuthCacheClass()");
            }
            Class<?> clazz = null;
            Class<?> clazz2 = null;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                clazz2 = classLoader != null ? classLoader.loadClass(FACTORY_CLASS) : Class.forName(FACTORY_CLASS);
                clazz = clazz2;
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + ".getAuthCacheClass", "555");
                throw new UndeclaredThrowableException(exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAuthCacheClass()");
            }
            return clazz;
        }

        static {
            try {
                Method method = _authCacheClass.getAuthCacheGetInstanceMethod();
                if (method != null) {
                    _authCache = (SecurityCache)method.invoke(null, (Object[])null);
                    if (tc.isDebugEnabled()) {
                        if (_authCache == null) {
                            Tr.debug(tc, "AuthCache.getInstance method returned null.");
                        } else {
                            Tr.debug(tc, "AuthCache.getInstance method returned an AuthCache instance.");
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get AuthCache.getInstance method.");
                }
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + "init", "681");
            }
        }
    }

    private static class _wsCredToken {
        static WSCredentialTokenMapperInterface _wsCredTokenMapper = null;

        private _wsCredToken() {
        }

        static {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object obj = clazz.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got instance of WSCredTokenMapper.");
                }
                _wsCredTokenMapper = (WSCredentialTokenMapperInterface)obj;
            }
            catch (Exception exception) {
                Tr.processException(exception, clsName + "init", "657");
            }
        }
    }
}

