/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManager;
import com.ibm.ws.wssecurity.platform.auth.WSSContextManagerFactory;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPATokenImpl;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.security.context.Context;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.context.MessageContext;

public class LTPAGenerateLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(LTPAGenerateLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LTPAGenerateLoginModule.class.getName();
    private CallbackHandler _handler;
    private List<SecurityToken> _processedTokens;
    private List<SecurityToken> _insertedTokens;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = callbackHandler;
        this._processedTokens = new ArrayList<SecurityToken>();
        this._insertedTokens = new ArrayList<SecurityToken>();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        NameCallback nameCallback = new NameCallback("username: ");
        PasswordCallback passwordCallback = new PasswordCallback("passowrd: ", false);
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbackArray = new Callback[]{nameCallback, passwordCallback, propertyCallback};
        try {
            this._handler.handle(callbackArray);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".login", "143", this);
            Tr.error(tc, "security.wssecurity.BSTokenLoginModule.s01", exception);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{exception.toString()}));
        }
        String string = nameCallback.getName();
        char[] cArray = passwordCallback.getPassword();
        this._context = propertyCallback.getProperties();
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        boolean bl = true;
        Subject subject = null;
        WSCredential wSCredential = null;
        byte[] byArray = null;
        if (string != null && string.length() > 0 && cArray != null && cArray.length > 0) {
            object2 = string;
            object = String.valueOf(cArray);
            try {
                subject = (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>((String)object2, (String)object){
                    final /* synthetic */ String val$un;
                    final /* synthetic */ String val$pwd;
                    {
                        this.val$un = string;
                        this.val$pwd = string2;
                    }

                    @Override
                    public Object run() throws LoginException {
                        Subject subject = null;
                        WSSContextManager wSSContextManager = WSSContextManagerFactory.getInstance();
                        if (wSSContextManager != null) {
                            subject = wSSContextManager.login(wSSContextManager.getDefaultRealm(), this.val$un, this.val$pwd);
                        }
                        return subject;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new LoginException(privilegedActionException.toString());
            }
            if (subject != null) {
                wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
                try {
                    if (wSCredential != null) {
                        byArray = wSCredential.getCredentialToken();
                    }
                }
                catch (CredentialDestroyedException credentialDestroyedException) {
                    throw new LoginException(credentialDestroyedException.toString());
                }
            }
        }
        if (byArray == null) {
            try {
                object2 = (MessageContext)this._context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                object = (Context)((MessageContext)object2).getProperty("com.ibm.wsspi.websphere.security.SecurityContext");
                if (object != null && (subject = object.getRunAsSubject()) != null && (wSCredential = SubjectHelper.getWSCredentialFromSubject(subject)) != null) {
                    byArray = wSCredential.getCredentialToken();
                }
            }
            catch (CredentialDestroyedException credentialDestroyedException) {
                throw new LoginException(credentialDestroyedException.toString());
            }
            catch (WSSecurityException wSSecurityException) {
                throw new LoginException(wSSecurityException.toString());
            }
        }
        if (byArray == null) {
            bl = false;
        }
        if (bl) {
            SecurityToken securityToken;
            object2 = IdUtils.getInstance().makeUniqueId("ltpa_");
            object = (TokenGeneratorConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
            int n = 0;
            Object object3 = null;
            object3 = this._context.get("com.ibm.ws.wssecurity.constants.wssVersion");
            if (object3 != null && object3 instanceof Integer) {
                n = (Integer)object3;
            }
            OMElement oMElement = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
            try {
                securityToken = LTPAGenerateLoginModule.getToken((TokenGeneratorConfig)object, byArray, this._securityTokenManager);
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, clsName + ".login", "172", this);
                throw new LoginException(soapSecurityException.toString());
            }
            if (securityToken == null) {
                OMElement oMElement2 = LTPAGenerateLoginModule.createTokenElement(oMElement.getOMFactory(), oMElement, (TokenGeneratorConfig)object, byArray, (String)object2, n);
                LTPATokenImpl lTPATokenImpl = new LTPATokenImpl();
                lTPATokenImpl.setId((String)object2);
                lTPATokenImpl.setPrincipal(string);
                lTPATokenImpl.setBinary(byArray);
                lTPATokenImpl.setXML(new OMStructure(oMElement2));
                lTPATokenImpl.setKey(61, null);
                lTPATokenImpl.setKey(62, null);
                String string2 = (String)object.getProperties().get("com.ibm.ws.wssecurity.token.forwardable");
                if (string2 != null && string2.equalsIgnoreCase("false")) {
                    lTPATokenImpl.setIsForwardable(false);
                } else {
                    lTPATokenImpl.setIsForwardable(true);
                }
                this._processedTokens.add(lTPATokenImpl);
                this._insertedTokens.add(lTPATokenImpl);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "There is the token [" + securityToken.getId() + "] stored in the Subject.");
                }
                this._processedTokens.add(securityToken);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return bl;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        int n = this._processedTokens.size();
        for (int i = 0; i < n; ++i) {
            SecurityToken securityToken = this._processedTokens.get(i);
            this._securityTokenManager.addToken(securityToken);
        }
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._processedTokens);
        this._context.put(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED, this._insertedTokens);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private static final OMElement createTokenElement(OMFactory oMFactory, OMElement oMElement, TokenGeneratorConfig tokenGeneratorConfig, byte[] byArray, String string, int n) {
        Object object;
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("createTokenElement(");
            ((StringBuffer)charSequence).append("OMFactory factory,");
            ((StringBuffer)charSequence).append("OMElement parent[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
            ((StringBuffer)charSequence).append("TokenGeneratorConfig config, ");
            ((StringBuffer)charSequence).append("byte[] credToken[");
            ((StringBuffer)charSequence).append(byArray == null ? "null" : "not null");
            ((StringBuffer)charSequence).append("], ");
            ((StringBuffer)charSequence).append("String id[").append(string).append("], ");
            ((StringBuffer)charSequence).append("int wssVersion[").append(n).append("])");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        charSequence = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[0][n];
        String string2 = com.ibm.ws.wssecurity.common.Constants.NAMESPACES[1][n];
        boolean bl = false;
        String string3 = null;
        if (oMElement != null) {
            string3 = DOMUtils.getNamespacePrefix(oMElement, (String)charSequence);
        }
        if (string3 == null) {
            bl = true;
            string3 = "wsse";
        }
        OMElement oMElement2 = oMFactory.createOMElement("BinarySecurityToken", (String)charSequence, string3);
        if (bl) {
            oMElement2.declareNamespace((String)charSequence, "wsse");
        }
        if (string != null) {
            bl = false;
            object = DOMUtils.getNamespacePrefix(oMElement, string2);
            if (object == null) {
                bl = true;
                object = "wsu";
            }
            if (bl) {
                oMElement2.declareNamespace(string2, "wsu");
            }
            oMElement2.addAttribute("Id", string, oMFactory.createOMNamespace(com.ibm.ws.wssecurity.common.Constants.NS_WSU, (String)object));
        }
        if ((object = tokenGeneratorConfig.getType()) == null) {
            object = com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN;
        }
        oMElement2.declareNamespace(((QName)object).getNamespaceURI(), "wsst");
        DOMUtils.setQNameAttr(oMElement2, null, "EncodingType", com.ibm.ws.wssecurity.common.Constants.BASE64_BINARY, n);
        DOMUtils.setQNameAttr(oMElement2, null, "ValueType", (QName)object, n);
        String string4 = Base64.encode(byArray);
        oMElement2.addChild(oMFactory.createOMText(string4));
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("createTokenElement(");
            stringBuffer.append("OMFactory, OMElement, TokenGeneratorConfig, byte[], String, int)");
            stringBuffer.append(" returns OMElement[").append(oMElement2).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return oMElement2;
    }

    private static final SecurityToken getToken(TokenGeneratorConfig tokenGeneratorConfig, byte[] byArray, SecurityTokenManager securityTokenManager) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getToken(");
            ((StringBuffer)object).append("TokenGeneratorConfig config, ");
            ((StringBuffer)object).append("byte[] binary[");
            ((StringBuffer)object).append(byArray == null ? "null" : "not null");
            ((StringBuffer)object).append("], SecurityTokenManager securityTokenManager)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        Collection<SecurityToken> collection = securityTokenManager.getTokens(tokenGeneratorConfig);
        if (collection != null && collection.size() > 0) {
            for (SecurityToken securityToken : collection) {
                LTPAToken lTPAToken;
                byte[] byArray2;
                if (!(securityToken instanceof LTPAToken) || !LTPAGenerateLoginModule.equalsByteArray(byArray2 = (byte[])AccessController.doPrivileged(new PrivilegedAction<Object>(lTPAToken = (LTPAToken)securityToken){
                    final /* synthetic */ LTPAToken val$lt;
                    {
                        this.val$lt = lTPAToken;
                    }

                    @Override
                    public Object run() {
                        return this.val$lt.getBinary();
                    }
                }), byArray)) continue;
                object = securityToken;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getToken(");
            stringBuffer.append("TokenGeneratorConfig, byte[], SecurityTokenManager)");
            stringBuffer.append(" returns SecurityToken[").append(object).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    static final boolean equalsByteArray(byte[] byArray, byte[] byArray2) {
        boolean bl;
        block6: {
            block5: {
                bl = true;
                if (byArray != null) break block5;
                if (byArray2 == null) break block6;
                bl = false;
                break block6;
            }
            if (byArray2 == null) {
                bl = false;
            } else {
                int n = byArray.length;
                int n2 = byArray2.length;
                if (n != n2) {
                    bl = false;
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (byArray[i] == byArray2[i]) continue;
                        bl = false;
                        break;
                    }
                }
            }
        }
        return bl;
    }
}

