/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.callbackhandler.PropertyCallback;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.config.CallerConfig;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.IdUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.LTPATokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509ConsumeLoginModule;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.core.token.SecurityTokenManager;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;

public class LTPAConsumeLoginModule
implements LoginModule {
    private static final TraceComponent tc = Tr.register(LTPAConsumeLoginModule.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509ConsumeLoginModule.class.getName();
    private CallbackHandler _handler;
    private SecurityToken _token;
    private SecurityTokenManager _securityTokenManager;
    private Map<Object, Object> _context;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options)");
        }
        this._handler = callbackHandler;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(Subject, CallbackHandler, Map, Map)");
        }
    }

    public boolean login() throws LoginException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        PropertyCallback propertyCallback = new PropertyCallback(null);
        Callback[] callbackArray = new Callback[]{propertyCallback};
        try {
            this._handler.handle(callbackArray);
        }
        catch (Exception exception) {
            Tr.processException((Throwable)exception, clsName + ".login", "113", this);
            throw new LoginException(ConfigUtil.getMessage("security.wssecurity.BSTokenLoginModule.s01", new String[]{exception.toString()}));
        }
        this._context = propertyCallback.getProperties();
        TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.impl.config.tokenConsumer.configKey");
        LTPATokenImpl lTPATokenImpl = new LTPATokenImpl();
        this._context.put(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING, lTPATokenImpl);
        QName qName = tokenConsumerConfig.getType();
        if (!com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.equals(qName)) {
            String string = ConfigUtil.getMessage("security.wssecurity.PrivateConsumerConfig.s30", new String[]{qName.toString(), com.ibm.ws.wssecurity.common.Constants.LTPA_TOKEN.toString()});
            throw new LoginException(string);
        }
        OMElement oMElement = (OMElement)this._context.get("com.ibm.ws.wssecurity.constants.processingElement");
        lTPATokenImpl.setXML(new OMStructure(oMElement));
        String string = null;
        QName qName2 = IdUtils.getInstance().getIdAttributeName(oMElement);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The identifier attribute of the target element is [" + qName2 + "].");
        }
        if (qName2 != null) {
            string = oMElement.getAttributeValue(qName2);
        }
        lTPATokenImpl.setId(string);
        String string2 = DOMUtils.getStringValue(oMElement);
        byte[] byArray = Base64.decode(string2);
        WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)this._context.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
        Set<CallerConfig> set = wSSConsumerConfig.getCallers();
        boolean bl = false;
        if (set != null) {
            for (CallerConfig object2 : set) {
                object = object2.getCallerIdentity();
                if (!((QName)object).equals(qName2)) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            Object object3 = null;
            try {
                Method exception = getLTPAMethod._validateLTPATokenMethod;
                object = getLTPAMethod._ltpaServerObject;
                if (exception != null && object != null) {
                    object3 = exception.invoke(object, new Object[]{byArray});
                }
            }
            catch (Exception exception) {
                throw new LoginException("security.wssecurityLTPA Token validation failed");
            }
            if (object3 == null) {
                throw new LoginException("security.wssecurityLTPA Token validation failed");
            }
        }
        lTPATokenImpl.setBinary(byArray);
        this._securityTokenManager = (SecurityTokenManager)this._context.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        this._token = lTPATokenImpl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        this._securityTokenManager.addToken(this._token);
        this._context.put(Constants.WSSECURITY_TOKEN_PROCESSED, this._token);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return false;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return false;
    }

    private static class getLTPAMethod {
        private static final String LTPA_SERVER_OBJECT_CLASS = "com.ibm.ws.security.ltpa.LTPAServerObject";
        private static Class _ltpaServerObjectClass = null;
        private static Method _validateLTPATokenMethod = null;
        private static Method _getLTPAServerMethod = null;
        private static Object _ltpaServerObject = null;

        private getLTPAMethod() {
        }

        static {
            if (_ltpaServerObjectClass == null) {
                Class<?> clazz = null;
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    clazz = classLoader != null ? classLoader.loadClass(LTPA_SERVER_OBJECT_CLASS) : Class.forName(LTPA_SERVER_OBJECT_CLASS);
                    _ltpaServerObjectClass = clazz;
                }
                catch (Exception exception) {
                    throw new UndeclaredThrowableException(exception);
                }
            }
            if (_getLTPAServerMethod == null && _ltpaServerObjectClass != null) {
                try {
                    _getLTPAServerMethod = _ltpaServerObjectClass.getMethod("getLTPAServer", new Class[0]);
                    if (_getLTPAServerMethod != null) {
                        _ltpaServerObject = _getLTPAServerMethod.invoke(null, new Object[0]);
                    }
                }
                catch (Exception exception) {
                    throw new UndeclaredThrowableException(exception);
                }
            }
            if (_validateLTPATokenMethod == null && _ltpaServerObjectClass != null) {
                try {
                    _validateLTPATokenMethod = _ltpaServerObjectClass.getMethod("validateToken", byte[].class);
                }
                catch (Exception exception) {
                    throw new UndeclaredThrowableException(exception);
                }
            }
        }
    }
}

