/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.CertificateUtil;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.Hex;
import com.ibm.ws.wssecurity.util.NamespaceUtil;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.KeyInfo;
import com.ibm.ws.wssecurity.xml.xss4j.dsig.util.Base64;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;

public class KeyStoreManager {
    private static final TraceComponent tc = Tr.register(KeyStoreManager.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyStoreManager.class.getName();
    private static final int ITSHA1_OCTETS = 20;
    private static final int IT60SHA1_OCTETS = 8;
    private static final String OID_SUBJECTKEYIDENTIFIER = "2.5.29.14";
    private static final byte BER_SEQUENCE = 48;
    private static final byte BER_BITSTRING = 3;
    private static final long DAYS_IN_MS = 86400000L;
    private static final long DAYS_IN_MS_BEFORE_EXPIRE_WARNING = 5184000000L;
    private static final String MESSAGE_DIGEST_SHA1 = "SHA";
    private static boolean initialized = false;
    private static KeyStoreManager instance = null;
    private static Stack<MessageDigest> sha1Pool;
    private final Map<String, KeyStore> keyStoreCache = new HashMap<String, KeyStore>();
    private final Map<Integer, KeyInformation> keyInformationCache = new HashMap<Integer, KeyInformation>();
    private static final int STATUS_OK = 0;
    private static final int STATUS_ENTRY_ERROR = 1;
    private static final int STATUS_CERT_ERROR = 2;
    private static final int STATUS_KEYID_ERROR = 4;
    private static final int STATUS_THUMBPRINT_ERROR = 8;

    private KeyStoreManager() {
    }

    private static final synchronized void init() {
        if (!initialized) {
            instance = new KeyStoreManager();
            sha1Pool = new Stack();
            initialized = true;
        }
    }

    public static final KeyStoreManager getInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance()");
        }
        if (!initialized) {
            KeyStoreManager.init();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance()");
        }
        return instance;
    }

    public final synchronized KeyInformation getKeyInformation(X509Certificate x509Certificate) throws SoapSecurityException {
        StringBuffer stringBuffer;
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getKeyInformation(");
            ((StringBuffer)object).append("X509Certificate x509[");
            ((StringBuffer)object).append(x509Certificate == null ? "null" : x509Certificate.getSubjectDN().getName());
            ((StringBuffer)object).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        int n = x509Certificate.hashCode();
        Integer n2 = new Integer(n);
        object = this.keyInformationCache.get(n2);
        if (object == null) {
            if (tc.isDebugEnabled()) {
                stringBuffer = new StringBuffer("There is no cached key information with the X509 certificate [");
                stringBuffer.append(x509Certificate == null ? "null" : x509Certificate.getSubjectDN().getName());
                stringBuffer.append("]. So a new key information is created.");
                Tr.debug(tc, stringBuffer.toString());
            }
            object = this.createKeyInformation(x509Certificate);
            this.keyInformationCache.put(n2, (KeyInformation)object);
        } else if (tc.isDebugEnabled()) {
            stringBuffer = new StringBuffer("There is the cached key information with the X509 certificate [");
            stringBuffer.append(x509Certificate == null ? "null" : x509Certificate.getSubjectDN().getName());
            stringBuffer.append("]. So the key information is used.");
            Tr.debug(tc, stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            stringBuffer = new StringBuffer("getKeyInformation(");
            stringBuffer.append("X509Certificate)");
            stringBuffer.append(" returns KeyInformation[").append(object).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    private final KeyInformation createKeyInformation(X509Certificate x509Certificate) throws SoapSecurityException {
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("createKeyInformation(");
            charSequence.append("X509Certificate x509[");
            charSequence.append(x509Certificate == null ? "null" : x509Certificate.getSubjectDN().getName());
            charSequence.append("])");
            Tr.entry(tc, charSequence.toString());
        }
        charSequence = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        byte[] byArray = null;
        PublicKey publicKey = null;
        Key key = null;
        int n = 0;
        long l = -1L;
        String string11 = null;
        charSequence = x509Certificate.getSubjectDN().getName();
        string = KeyInfo.X509Data.encodeDName((String)charSequence);
        string2 = x509Certificate.getIssuerDN().getName();
        string3 = KeyInfo.X509Data.encodeDName(string2);
        string4 = x509Certificate.getSerialNumber().toString();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "subjectDN[" + (String)charSequence + "], " + "encSubjectDN[" + string + "], " + "issuerDN[" + string2 + "], " + "encIssuerDN[" + string3 + "], " + "issuerSerial[" + string4 + "]");
        }
        try {
            byArray = x509Certificate.getEncoded();
            x509Certificate.checkValidity();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            n += 2;
            Tr.processException((Throwable)certificateEncodingException, clsName + ".createKeyInformation", "210", this);
            Tr.error(tc, "security.wssecurity.WSEC0155E", new Object[]{certificateEncodingException});
            string11 = ConfigUtil.getMessage("security.wssecurity.WSEC0155E", new String[]{certificateEncodingException.getClass().getName() + ": " + certificateEncodingException.getMessage()});
        }
        catch (CertificateExpiredException certificateExpiredException) {
            n += 2;
            Tr.processException((Throwable)certificateExpiredException, clsName + ".createKeyInformation", "218", this);
            Tr.error(tc, "security.wssecurity.WSEC6805E", new Object[]{charSequence, certificateExpiredException});
            string11 = ConfigUtil.getMessage("security.wssecurity.WSEC6805E", new String[]{charSequence, certificateExpiredException.getClass().getName() + ": " + certificateExpiredException.getMessage()});
        }
        catch (CertificateException certificateException) {
            n += 2;
            Tr.processException((Throwable)certificateException, clsName + ".createKeyInformation", "229", this);
            Tr.error(tc, "security.wssecurity.WSEC6806E", new Object[]{charSequence, certificateException});
            string11 = ConfigUtil.getMessage("security.wssecurity.WSEC6806E", new String[]{charSequence, certificateException.getClass().getName() + ": " + certificateException.getMessage()});
        }
        l = x509Certificate.getNotAfter().getTime();
        if (n == 0 && l - System.currentTimeMillis() < 5184000000L) {
            long l2 = l - System.currentTimeMillis();
            long l3 = l2 / 86400000L;
            Tr.warning(tc, "security.wssecurity.WSEC6807W", new Object[]{charSequence, new Long(l3)});
        }
        if (n == 0) {
            try {
                byte[] byArray2 = KeyStoreManager.makeSubjectKeyIdentifier(x509Certificate, null);
                string5 = Base64.encode(byArray2);
                string8 = Hex.encode(byArray2);
                byArray2 = KeyStoreManager.makeSubjectKeyIdentifier(x509Certificate, Constants.IT60SHA1);
                string6 = Base64.encode(byArray2);
                string9 = Hex.encode(byArray2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                n += 4;
                Tr.processException((Throwable)noSuchAlgorithmException, clsName + ".createKeyInformation", "260", this);
                Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", new Object[]{noSuchAlgorithmException});
                string11 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ": " + noSuchAlgorithmException.getClass().getName() + ": " + noSuchAlgorithmException.getMessage();
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                n += 4;
                Tr.processException((Throwable)invalidAlgorithmParameterException, clsName + ".createKeyInformation", "267", this);
                Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", new Object[]{invalidAlgorithmParameterException});
                string11 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ":" + invalidAlgorithmParameterException.getClass().getName() + ": " + invalidAlgorithmParameterException.getMessage();
            }
            catch (Exception exception) {
                n += 4;
                Tr.processException((Throwable)exception, clsName + ".createKeyInformation", "274", this);
                Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier04", new Object[]{exception});
                string11 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier04") + ":" + exception.getClass().getName() + ": " + exception.getMessage();
            }
            publicKey = x509Certificate.getPublicKey();
        }
        if (n == 0) {
            try {
                byte[] byArray3 = KeyStoreManager.makeThumbprint(byArray);
                string7 = Base64.encode(byArray3);
                string10 = Hex.encode(byArray3);
            }
            catch (Exception exception) {
                n += 8;
                Tr.processException((Throwable)exception, clsName + ".createKeyInformation", "289", this);
                Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier04", new Object[]{exception});
                string11 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier04") + ":" + exception.getClass().getName() + ": " + exception.getMessage();
            }
        }
        KeyInformation keyInformation = new KeyInformation(null, null, string, publicKey, key, x509Certificate, byArray, (String)charSequence, string, string3, string4, string5, string6, string7, string8, string9, string10, n, l, 5184000000L, string11);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("createKeyInformation(");
            stringBuffer.append("X509Certificate)");
            stringBuffer.append(" returns KeyInformation[").append(keyInformation).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return keyInformation;
    }

    public final synchronized KeyInformation getKeyInformation(String string, String string2, char[] cArray, String string3, String string4, char[] cArray2, String string5) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getKeyInformation(");
            ((StringBuffer)object).append("String storePath[").append(string).append("], ");
            ((StringBuffer)object).append("String storeType[").append(string2).append("], ");
            ((StringBuffer)object).append("char[] storePassword[");
            ((StringBuffer)object).append(cArray == null ? "null" : "not null");
            ((StringBuffer)object).append("], ");
            ((StringBuffer)object).append("String keyStoreRef[").append(string3).append("], ");
            ((StringBuffer)object).append("String alias[").append(string4).append("], ");
            ((StringBuffer)object).append("char[] keyPassword[");
            ((StringBuffer)object).append(cArray2 == null ? "null" : "not null");
            ((StringBuffer)object).append("], ");
            ((StringBuffer)object).append("String keyName[").append(string5).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        KeyStore keyStore = this.getKeyStore(string, string2, cArray, string3);
        if (keyStore != null) {
            int n = keyStore.hashCode();
            Integer n2 = new Integer(n += string4.hashCode());
            object = this.keyInformationCache.get(n2);
            if (object == null) {
                boolean bl = false;
                bl = ConfigUtil.isHWKeyStore(string3);
                if (tc.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("There is no cached key information with the keystore [");
                    stringBuffer.append(string);
                    stringBuffer.append("] and the alias [");
                    stringBuffer.append(string4);
                    stringBuffer.append("]. So a new key information is created.");
                    Tr.debug(tc, stringBuffer.toString());
                }
                object = this.createKeyInformation(keyStore, string, string4, cArray2, string5, bl);
                this.keyInformationCache.put(n2, (KeyInformation)object);
            } else if (tc.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("There is the cached key information with the keystore [");
                stringBuffer.append(string);
                stringBuffer.append("] and the alias [");
                stringBuffer.append(string4);
                stringBuffer.append("]. So the key information is used.");
                Tr.debug(tc, stringBuffer.toString());
            }
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("getKeyInformation(");
            stringBuffer.append("String, String, char[], String, String, char[], String)");
            stringBuffer.append(" returns KeyInformation[").append(object).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    private final KeyInformation createKeyInformation(KeyStore keyStore, String string, String string2, char[] cArray, String string3, boolean bl) throws SoapSecurityException {
        Serializable serializable;
        Object object;
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("createKeyInformation(");
            ((StringBuffer)charSequence).append("KeyStore keyStore, ");
            ((StringBuffer)charSequence).append("String alias[").append(string2).append("], ");
            ((StringBuffer)charSequence).append("char[] keyPassword[");
            ((StringBuffer)charSequence).append(cArray == null ? "null" : "not null");
            ((StringBuffer)charSequence).append("], ");
            ((StringBuffer)charSequence).append("String keyName[").append(string3).append("])");
            ((StringBuffer)charSequence).append("boolean isHWKeyStoreRef[").append(bl).append("])");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        if ((charSequence = KeyInfo.X509Data.encodeDName(string3)) == null || ((String)charSequence).length() == 0) {
            charSequence = string3;
        }
        String string4 = null;
        CharSequence charSequence2 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        X509Certificate x509Certificate = null;
        byte[] byArray = null;
        Key key = null;
        Key key2 = null;
        int n = 0;
        long l = -1L;
        String string14 = null;
        KeyStore.PasswordProtection passwordProtection = null;
        if (cArray != null && cArray.length > 0) {
            passwordProtection = new KeyStore.PasswordProtection(cArray);
        }
        KeyStore.Entry entry = null;
        try {
            entry = keyStore.getEntry(string2, passwordProtection);
        }
        catch (Exception exception) {
            ++n;
            Tr.processException((Throwable)exception, clsName + ".createKeyInformation", "427", this);
            Tr.error(tc, "security.wssecurity.WSEC6800E", new Object[]{string2, string, exception});
            string14 = ConfigUtil.getMessage("security.wssecurity.WSEC6800E", new String[]{string2, string, exception.getClass().getName() + ": " + exception.getMessage()});
        }
        if (entry == null) {
            object = "entry=null";
            ++n;
            Tr.error(tc, "security.wssecurity.WSEC6800E", new Object[]{string2, string, object});
            string14 = ConfigUtil.getMessage("security.wssecurity.WSEC6800E", new String[]{string2, string, object});
        }
        if (n == 0) {
            if (entry instanceof KeyStore.TrustedCertificateEntry) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Trusted Certificate Entry.");
                }
                if ((serializable = ((KeyStore.TrustedCertificateEntry)(object = (KeyStore.TrustedCertificateEntry)entry)).getTrustedCertificate()) != null && serializable instanceof X509Certificate) {
                    x509Certificate = (X509Certificate)serializable;
                    string4 = x509Certificate.getSubjectDN().getName();
                    charSequence2 = KeyInfo.X509Data.encodeDName(string4);
                    string5 = x509Certificate.getIssuerDN().getName();
                    string6 = KeyInfo.X509Data.encodeDName(string5);
                    string7 = x509Certificate.getSerialNumber().toString();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "subjectDN[" + string4 + "], " + "encSubjectDN[" + (String)charSequence2 + "], " + "issuerDN[" + string5 + "], " + "encIssuerDN[" + string6 + "], " + "issuerSerial[" + string7 + "]");
                    }
                    try {
                        byArray = ((Certificate)serializable).getEncoded();
                        x509Certificate.checkValidity();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        n += 2;
                        Tr.processException((Throwable)certificateEncodingException, clsName + ".createKeyInformation", "478", this);
                        Tr.error(tc, "security.wssecurity.WSEC0155E", new Object[]{certificateEncodingException});
                        string14 = ConfigUtil.getMessage("security.wssecurity.WSEC0155E", new String[]{certificateEncodingException.getClass().getName() + ": " + certificateEncodingException.getMessage()});
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        n += 2;
                        Tr.processException((Throwable)certificateExpiredException, clsName + ".createKeyInformation", "486", this);
                        Tr.error(tc, "security.wssecurity.WSEC5181E", new Object[]{string4, string2, string, certificateExpiredException});
                        string14 = ConfigUtil.getMessage("security.wssecurity.WSEC5181E", new String[]{string4, string2, string, certificateExpiredException.getClass().getName() + ": " + certificateExpiredException.getMessage()});
                    }
                    catch (CertificateException certificateException) {
                        n += 2;
                        Tr.processException((Throwable)certificateException, clsName + ".createKeyInformation", "497", this);
                        Tr.error(tc, "security.wssecurity.WSEC5182E", new Object[]{string4, string2, string, certificateException});
                        string14 = ConfigUtil.getMessage("security.wssecurity.WSEC5182E", new String[]{string4, string2, string, certificateException.getClass().getName() + ": " + certificateException.getMessage()});
                    }
                    l = x509Certificate.getNotAfter().getTime();
                    if (n == 0 && l - System.currentTimeMillis() < 5184000000L) {
                        long l2 = l - System.currentTimeMillis();
                        long l3 = l2 / 86400000L;
                        Tr.warning(tc, "security.wssecurity.WSEC5189W", new Object[]{string4, string2, string, new Long(l3)});
                    }
                    if (n == 0) {
                        try {
                            byte[] byArray2 = KeyStoreManager.makeSubjectKeyIdentifier((Certificate)serializable, null);
                            string8 = Base64.encode(byArray2);
                            string11 = Hex.encode(byArray2);
                            byArray2 = KeyStoreManager.makeSubjectKeyIdentifier((Certificate)serializable, Constants.IT60SHA1);
                            string9 = Base64.encode(byArray2);
                            string12 = Hex.encode(byArray2);
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            n += 4;
                            Tr.processException((Throwable)noSuchAlgorithmException, clsName + ".createKeyInformation", "528", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", new Object[]{noSuchAlgorithmException});
                            string14 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ": " + noSuchAlgorithmException.getClass().getName() + ": " + noSuchAlgorithmException.getMessage();
                        }
                        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                            n += 4;
                            Tr.processException((Throwable)invalidAlgorithmParameterException, clsName + ".createKeyInformation", "535", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", new Object[]{invalidAlgorithmParameterException});
                            string14 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ":" + invalidAlgorithmParameterException.getClass().getName() + ": " + invalidAlgorithmParameterException.getMessage();
                        }
                        catch (Exception exception) {
                            n += 4;
                            Tr.processException((Throwable)exception, clsName + ".createKeyInformation", "542", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier04", new Object[]{exception});
                            string14 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier04") + ":" + exception.getClass().getName() + ": " + exception.getMessage();
                        }
                        key = ((Certificate)serializable).getPublicKey();
                    }
                    if (n == 0) {
                        try {
                            byte[] byArray3 = KeyStoreManager.makeThumbprint(byArray);
                            string10 = Base64.encode(byArray3);
                            string13 = Hex.encode(byArray3);
                        }
                        catch (Exception exception) {
                            n += 8;
                            Tr.processException((Throwable)exception, clsName + ".createKeyInformation", "557", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier04", new Object[]{exception});
                            string14 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier04") + ":" + exception.getClass().getName() + ": " + exception.getMessage();
                        }
                    }
                }
            } else if (entry instanceof KeyStore.PrivateKeyEntry) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Private Key Entry.");
                }
                if ((serializable = ((KeyStore.PrivateKeyEntry)(object = (KeyStore.PrivateKeyEntry)entry)).getCertificate()) != null && serializable instanceof X509Certificate) {
                    x509Certificate = (X509Certificate)serializable;
                    string4 = x509Certificate.getSubjectDN().getName();
                    charSequence2 = KeyInfo.X509Data.encodeDName(string4);
                    string5 = x509Certificate.getIssuerDN().getName();
                    string6 = KeyInfo.X509Data.encodeDName(string5);
                    string7 = x509Certificate.getSerialNumber().toString();
                    try {
                        byArray = ((Certificate)serializable).getEncoded();
                        x509Certificate.checkValidity();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        n += 2;
                        Tr.processException((Throwable)certificateEncodingException, clsName + ".createKeyInformation", "615", this);
                        Tr.error(tc, "security.wssecurity.WSEC0155E", new Object[]{certificateEncodingException});
                        string14 = ConfigUtil.getMessage("security.wssecurity.WSEC0155E", new String[]{certificateEncodingException.getClass().getName() + ": " + certificateEncodingException.getMessage()});
                    }
                    catch (CertificateExpiredException certificateExpiredException) {
                        n += 2;
                        Tr.processException((Throwable)certificateExpiredException, clsName + ".createKeyInformation", "623", this);
                        Tr.error(tc, "security.wssecurity.WSEC5181E", new Object[]{string4, string2, string, certificateExpiredException});
                        string14 = ConfigUtil.getMessage("security.wssecurity.WSEC5181E", new String[]{string4, string2, string, certificateExpiredException.getClass().getName() + ": " + certificateExpiredException.getMessage()});
                    }
                    catch (CertificateException certificateException) {
                        n += 2;
                        Tr.processException((Throwable)certificateException, clsName + ".createKeyInformation", "634", this);
                        Tr.error(tc, "security.wssecurity.WSEC5182E", new Object[]{string4, string2, string, certificateException});
                        string14 = ConfigUtil.getMessage("security.wssecurity.WSEC5182E", new String[]{string4, string2, string, certificateException.getClass().getName() + ": " + certificateException.getMessage()});
                    }
                    l = x509Certificate.getNotAfter().getTime();
                    if (n == 0 && l - System.currentTimeMillis() < 5184000000L) {
                        long l4 = l - System.currentTimeMillis();
                        long l5 = l4 / 86400000L;
                        Tr.warning(tc, "security.wssecurity.WSEC5189W", new Object[]{string4, string2, string, new Long(l5)});
                    }
                    if (n == 0) {
                        try {
                            byte[] byArray4 = KeyStoreManager.makeSubjectKeyIdentifier((Certificate)serializable, null);
                            string8 = Base64.encode(byArray4);
                            string11 = Hex.encode(byArray4);
                            byArray4 = KeyStoreManager.makeSubjectKeyIdentifier((Certificate)serializable, Constants.IT60SHA1);
                            string9 = Base64.encode(byArray4);
                            string12 = Hex.encode(byArray4);
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            n += 4;
                            Tr.processException((Throwable)noSuchAlgorithmException, clsName + ".createKeyInformation", "665", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", new Object[]{noSuchAlgorithmException});
                            string14 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ": " + noSuchAlgorithmException.getClass().getName() + ": " + noSuchAlgorithmException.getMessage();
                        }
                        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                            n += 4;
                            Tr.processException((Throwable)invalidAlgorithmParameterException, clsName + ".createKeyInformation", "672", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier01", new Object[]{invalidAlgorithmParameterException});
                            string14 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier01") + ":" + invalidAlgorithmParameterException.getClass().getName() + ": " + invalidAlgorithmParameterException.getMessage();
                        }
                        catch (Exception exception) {
                            n += 4;
                            Tr.processException((Throwable)exception, clsName + ".createKeyInformation", "679", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier04", new Object[]{exception});
                            string14 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier04") + ":" + exception.getClass().getName() + ": " + exception.getMessage();
                        }
                        key = ((Certificate)serializable).getPublicKey();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "subjectDN[" + string4 + "], " + "encSubjectDN[" + (String)charSequence2 + "], " + "issuerDN[" + string5 + "], " + "encIssuerDN[" + string6 + "], " + "issuerSerial[" + string7 + "], " + "publickey[" + key + "]");
                        }
                    }
                    if (n == 0) {
                        try {
                            byte[] byArray5 = KeyStoreManager.makeThumbprint(byArray);
                            string10 = Base64.encode(byArray5);
                            string13 = Hex.encode(byArray5);
                        }
                        catch (Exception exception) {
                            n += 8;
                            Tr.processException((Throwable)exception, clsName + ".createKeyInformation", "704", this);
                            Tr.error(tc, "security.wssecurity.KeyStoreKeyLocator.generateIdentifier04", new Object[]{exception});
                            string14 = ConfigUtil.getMessage("security.wssecurity.KeyStoreKeyLocator.generateIdentifier04") + ":" + exception.getClass().getName() + ": " + exception.getMessage();
                        }
                    }
                }
                key2 = ((KeyStore.PrivateKeyEntry)object).getPrivateKey();
            } else if (entry instanceof KeyStore.SecretKeyEntry) {
                object = (KeyStore.SecretKeyEntry)entry;
                string4 = string3;
                charSequence2 = charSequence;
                key = ((KeyStore.SecretKeyEntry)object).getSecretKey();
                key2 = key;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "subjectDN[" + string4 + "], " + "encSubjectDN[" + (String)charSequence2 + "], " + "privatekey=publickey[" + key2 + "]");
                }
            }
        }
        object = new KeyInformation(string, string2, (String)charSequence, key, key2, x509Certificate, byArray, string4, (String)charSequence2, string6, string7, string8, string9, string10, string11, string12, string13, n, l, 5184000000L, string14);
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("createKeyInformation(");
            ((StringBuffer)serializable).append("KeyStore, String, char[], String)");
            ((StringBuffer)serializable).append(" returns KeyInformation[").append(object).append("]");
            Tr.exit(tc, ((StringBuffer)serializable).toString());
        }
        return object;
    }

    public final synchronized KeyInformation getKeyInformationInPkiPath(String string, String string2, char[] cArray, String string3, String string4, char[] cArray2, String string5, List list) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getKeyInformationInPkiPath(");
            ((StringBuffer)object).append("String storePath[").append(string).append("], ");
            ((StringBuffer)object).append("String storeType[").append(string2).append("], ");
            ((StringBuffer)object).append("char[] storePassword[");
            ((StringBuffer)object).append(cArray == null ? "null" : "not null");
            ((StringBuffer)object).append("], ");
            ((StringBuffer)object).append("String keyStoreRef[").append(string3).append("], ");
            ((StringBuffer)object).append("String alias[").append(string4).append("], ");
            ((StringBuffer)object).append("char[] keyPassword[");
            ((StringBuffer)object).append(cArray2 == null ? "null" : "not null");
            ((StringBuffer)object).append("], ");
            ((StringBuffer)object).append("String keyName[").append(string5).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = this.getKeyInformation(string, string2, cArray, string3, string4, cArray2, string5);
        KeyStore keyStore = this.getKeyStore(string, string2, cArray, string3);
        byte[] byArray = null;
        try {
            byArray = CertificateUtil.encodePkiPath(keyStore.getProvider(), list, keyStore, string4);
        }
        catch (Exception exception) {
            ((KeyInformation)object)._status += 2;
            Tr.processException((Throwable)exception, clsName + ".getKeyInformationInPkiPath", "777", this);
            Tr.error(tc, "security.wssecurity.PkiPathCallbackHandler.s01", new Object[]{exception});
            ((KeyInformation)object)._errorMes = ConfigUtil.getMessage("security.wssecurity.PkiPathCallbackHandler.s01") + ": " + exception.getClass().getName() + ": " + exception.getMessage();
        }
        KeyInformation.access$302((KeyInformation)object, byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyInformationInPkiPath( KeyStore keyStore, String storePath, String alias, char[] keyPassword,  String keyName)");
        }
        return object;
    }

    public final synchronized KeyInformation getKeyInformationInPKCS7(String string, String string2, char[] cArray, String string3, String string4, char[] cArray2, String string5, List list) throws SoapSecurityException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("getKeyInformationInPkiPath(");
            ((StringBuffer)object).append("String storePath[").append(string).append("], ");
            ((StringBuffer)object).append("String storeType[").append(string2).append("], ");
            ((StringBuffer)object).append("char[] storePassword[");
            ((StringBuffer)object).append(cArray == null ? "null" : "not null");
            ((StringBuffer)object).append("], ");
            ((StringBuffer)object).append("String keyStoreRef[").append(string3).append("], ");
            ((StringBuffer)object).append("String alias[").append(string4).append("], ");
            ((StringBuffer)object).append("char[] keyPassword[");
            ((StringBuffer)object).append(cArray2 == null ? "null" : "not null");
            ((StringBuffer)object).append("], ");
            ((StringBuffer)object).append("String keyName[").append(string5).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = this.getKeyInformation(string, string2, cArray, string3, string4, cArray2, string5);
        KeyStore keyStore = this.getKeyStore(string, string2, cArray, string3);
        byte[] byArray = null;
        try {
            byArray = CertificateUtil.encodePKCS7(null, list, keyStore, string4);
        }
        catch (Exception exception) {
            ((KeyInformation)object)._status += 2;
            Tr.processException((Throwable)exception, clsName + ".getKeyInformationInPKCS7", "824", this);
            Tr.error(tc, "security.wssecurity.PKCS7CallbackHandler.s01", new Object[]{exception});
            ((KeyInformation)object)._errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC6806E") + ": " + exception.getClass().getName() + ": " + exception.getMessage();
        }
        KeyInformation.access$302((KeyInformation)object, byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyInformationInPKCS7(String storePath, String storeType, +char[] storePassword, String keyStoreRef, String alias, char[] keyPassword, String keyName, List certStores)");
        }
        return object;
    }

    public final synchronized KeyStore getKeyStore(String string, String string2, char[] cArray, String string3) throws SoapSecurityException {
        StringBuffer stringBuffer;
        boolean bl;
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer2 = new StringBuffer("getKeyStore(");
            stringBuffer2.append("String storePath[").append(string).append("], ");
            stringBuffer2.append("String storeType[").append(string2).append("], ");
            stringBuffer2.append("char[] storePassword[");
            stringBuffer2.append(cArray == null ? "null" : "not null");
            stringBuffer2.append("], ");
            stringBuffer2.append("String keyStoreRef[").append(string3).append("])");
            Tr.entry(tc, stringBuffer2.toString());
        }
        boolean bl2 = string3 != null && string3.length() > 0;
        boolean bl3 = bl = string != null && string.length() > 0;
        if (!bl2 && !bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Both KeyStoreRef and StorePass are null or empty length");
            }
            String string4 = "security.wssecurity.KeyStoreManager.noKeyStoreRefAndStorePath";
            SoapSecurityException soapSecurityException = SoapSecurityException.format(string4);
            Tr.processException((Throwable)soapSecurityException, clsName + ".getKeyStore", "866", this);
            Tr.error(tc, string4, new Object[]{soapSecurityException});
            throw soapSecurityException;
        }
        KeyStore keyStore = null;
        if (bl2) {
            keyStore = ConfigUtil.getKeyStore(string3);
        }
        if (keyStore == null) {
            if (bl && (keyStore = this.keyStoreCache.get(string = ConfigUtil.expandInstallLocation(string))) == null) {
                if (tc.isDebugEnabled()) {
                    stringBuffer = new StringBuffer("There is no cached key store with the keystore [");
                    stringBuffer.append(string);
                    stringBuffer.append("]. So a new key store is loaded.");
                    Tr.debug(tc, stringBuffer.toString());
                }
                keyStore = ConfigUtil.getKeyStore(string2, string, cArray);
                this.keyStoreCache.put(string, keyStore);
            }
        } else if (tc.isDebugEnabled()) {
            stringBuffer = new StringBuffer("There is cached key store with the keystore reference [");
            stringBuffer.append(string3);
            stringBuffer.append("]. So the key store is used.");
            Tr.debug(tc, stringBuffer.toString());
        }
        if (tc.isEntryEnabled()) {
            stringBuffer = new StringBuffer("getKeyStore(");
            stringBuffer.append("String, String, char[], String)");
            stringBuffer.append(" returns KeyStore[").append(keyStore).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return keyStore;
    }

    private static final byte[] certToSubjectKeyIdentifier(Certificate certificate) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "certToSubjectKeyIdentifier(Certificate cert)");
        }
        if (!(certificate instanceof X509Certificate)) {
            return null;
        }
        byte[] byArray = null;
        byte[] byArray2 = ((X509Certificate)certificate).getExtensionValue(OID_SUBJECTKEYIDENTIFIER);
        if (byArray2 != null) {
            byArray = new byte[byArray2.length - 4];
            System.arraycopy(byArray2, 4, byArray, 0, byArray2.length - 4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "certToSubjectKeyIdentifier(Certificate)");
        }
        return byArray;
    }

    private static final byte[] pubkeyToSubjectKeyIdentifier(Certificate certificate, QName qName) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("pubkeyToSubjectKeyIdentifier(");
            ((StringBuffer)object).append("Certificate cert, ");
            ((StringBuffer)object).append("QName idty[").append(qName).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        if (certificate != null) {
            byte[] byArray = certificate.getPublicKey().getEncoded();
            if (byArray[0] != 48) {
                String string = ConfigUtil.getMessage("security.wssecurity.WSEC6801E", new String[]{Hex.encode(byArray)});
                RuntimeException runtimeException = new RuntimeException(string);
                Tr.processException(runtimeException, clsName + ".pubkeyToSubjectKeyIdentifier", "952");
                throw runtimeException;
            }
            int n = byArray[1] & 0xFF;
            int n2 = (n & 0x80) == 0 ? 2 : 2 + (n & 0x7F);
            n = byArray[n2 + 1] & 0xFF;
            if ((n & 0x80) == 0) {
                n2 += 2;
            } else {
                int n3 = n2 + 2;
                n2 += 2 + (n & 0x7F);
                switch (n & 0x7F) {
                    case 1: {
                        n = byArray[n3] & 0xFF;
                        break;
                    }
                    case 2: {
                        n = ((byArray[n3] & 0xFF) << 8) + (byArray[n3 + 1] & 0xFF);
                        break;
                    }
                    case 3: {
                        n = ((byArray[n3] & 0xFF) << 16) + ((byArray[n3 + 1] & 0xFF) << 8) + (byArray[n3 + 2] & 0xFF);
                        break;
                    }
                    case 4: {
                        n = ((byArray[n3] & 0xFF) << 24) + ((byArray[n3 + 1] & 0xFF) << 16) + ((byArray[n3 + 2] & 0xFF) << 8) + (byArray[n3 + 3] & 0xFF);
                        break;
                    }
                    default: {
                        String string = ConfigUtil.getMessage("security.wssecurity.WSEC6802E", new String[]{Hex.encode(byArray)});
                        RuntimeException runtimeException = new RuntimeException(string);
                        Tr.processException(runtimeException, clsName + ".pubkeyToSubjectKeyIdentifier", "987");
                        throw runtimeException;
                    }
                }
            }
            if (byArray[n2 += n] != 3) {
                String string = ConfigUtil.getMessage("security.wssecurity.WSEC6803E", new String[]{Integer.toString(byArray[n2] & 0xFF, 16)});
                RuntimeException runtimeException = new RuntimeException(string);
                Tr.processException(runtimeException, clsName + ".pubkeyToSubjectKeyIdentifier", "999");
                throw runtimeException;
            }
            n2 += ((n = byArray[n2 + 1] & 0xFF) & 0x80) == 0 ? 3 : 3 + (n & 0x7F);
            AlgorithmFactory algorithmFactory = AlgorithmFactory.getInstance();
            MessageDigest messageDigest = algorithmFactory.getMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", null);
            if (NamespaceUtil.equals(qName, Constants.ITSHA1) || qName == null) {
                messageDigest.update(byArray, n2, byArray.length - n2);
                object = messageDigest.digest();
                algorithmFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", messageDigest);
            } else if (NamespaceUtil.equals(qName, Constants.IT60SHA1)) {
                messageDigest.update(byArray, n2, byArray.length - n2);
                byte[] byArray2 = messageDigest.digest();
                algorithmFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", messageDigest);
                object = new byte[8];
                object[0] = (byte)(64 + (byArray2[byArray2.length - 8] & 0xF));
                System.arraycopy(byArray2, byArray2.length - 8 + 1, object, 1, ((Object)object).length - 1);
            } else {
                algorithmFactory.releaseMessageDigest("http://www.w3.org/2000/09/xmldsig#sha1", messageDigest);
                String string = ConfigUtil.getMessage("security.wssecurity.WSEC6804E", new String[]{qName.toString()});
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                Tr.processException(illegalArgumentException, clsName + ".pubkeyToSubjectKeyIdentifier", "1026");
                throw illegalArgumentException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pubkeyToSubjectKeyIdentifier(Certificate, QName)");
        }
        return object;
    }

    private static final byte[] makeSubjectKeyIdentifier(Certificate certificate, QName qName) throws Exception {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("makeSubjectKeyIdentifier(");
            ((StringBuffer)object).append("Certificate cert, ");
            ((StringBuffer)object).append("QName idty[").append(qName).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        if (certificate != null && ((object = (Object)KeyStoreManager.certToSubjectKeyIdentifier(certificate)) == null || qName != null)) {
            if (qName == null || NamespaceUtil.equals(qName, Constants.ITSHA1)) {
                if (object == null || ((Object)object).length != 20) {
                    object = KeyStoreManager.pubkeyToSubjectKeyIdentifier(certificate, qName);
                }
            } else if (NamespaceUtil.equals(qName, Constants.IT60SHA1)) {
                if (object == null || ((Object)object).length != 8) {
                    object = KeyStoreManager.pubkeyToSubjectKeyIdentifier(certificate, qName);
                }
            } else {
                String string = ConfigUtil.getMessage("security.wssecurity.WSEC6804E", new String[]{qName.toString()});
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                Tr.processException(illegalArgumentException, clsName + ".makeSubjectKeyIdentifier", "1066");
                throw illegalArgumentException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeIdentifier(Certificate, QName)");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MessageDigest getSHA1Digest() throws NoSuchAlgorithmException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSHA1Digest()");
        }
        MessageDigest messageDigest = null;
        Serializable serializable = sha1Pool;
        synchronized (serializable) {
            if (!sha1Pool.empty()) {
                messageDigest = sha1Pool.pop();
                messageDigest.reset();
            }
        }
        if (messageDigest == null) {
            messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST_SHA1);
        }
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("getSHA1Digest()");
            ((StringBuffer)serializable).append(" returns MessageDigest [").append(messageDigest).append("]");
            Tr.exit(tc, ((StringBuffer)serializable).toString());
        }
        return messageDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void releaseSHA1Digest(MessageDigest messageDigest) {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            serializable = new StringBuffer("releaseSHA1Digest(");
            ((StringBuffer)serializable).append("MessageDigest digest[").append(messageDigest).append("](");
            Tr.entry(tc, ((StringBuffer)serializable).toString());
        }
        serializable = sha1Pool;
        synchronized (serializable) {
            sha1Pool.push(messageDigest);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseSHA1Digest(MessageDigest)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] makeThumbprint(byte[] byArray) throws NoSuchAlgorithmException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("makeThumbprint(");
            ((StringBuffer)object).append("byte[] certBinary)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = null;
        if (byArray != null) {
            MessageDigest messageDigest = null;
            try {
                messageDigest = KeyStoreManager.getSHA1Digest();
                object = messageDigest.digest(byArray);
            }
            finally {
                if (messageDigest != null) {
                    KeyStoreManager.releaseSHA1Digest(messageDigest);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeThumbprint(Certificate cert, QName idty)");
        }
        return object;
    }

    public static class KeyInformation {
        private static final TraceComponent tc = Tr.register(KeyInformation.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
        private String _kspath;
        private String _alias;
        private String _name;
        private Key _publicOrSecretKey;
        private Key _privateOrSecretKey;
        private Certificate _certificate;
        private byte[] _binary;
        private String _encodedBinary;
        private String _subjectDN;
        private String _encSubjectDN;
        private String _encIssuerDN;
        private String _issuerSerial;
        private String _b64KeyId;
        private String _b64KeyId60;
        private String _b64Thumbprint;
        private String _hexKeyId;
        private String _hexKeyId60;
        private String _hexThumbprint;
        private int _status;
        private long _expiration;
        private long _daysInMSBeforeExpireWarning;
        private String _errorMes;

        private KeyInformation(String string, String string2, String string3, Key key, Key key2, X509Certificate x509Certificate, byte[] byArray, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, int n, long l, long l2, String string14) {
            this._kspath = string;
            this._alias = string2;
            this._name = string3;
            this._publicOrSecretKey = key;
            this._privateOrSecretKey = key2;
            this._certificate = x509Certificate;
            this._binary = byArray;
            this._subjectDN = string4;
            this._encSubjectDN = string5;
            this._encIssuerDN = string6;
            this._issuerSerial = string7;
            this._b64KeyId = string8;
            this._b64KeyId60 = string9;
            this._b64Thumbprint = string10;
            this._hexKeyId = string11;
            this._hexKeyId60 = string12;
            this._hexThumbprint = string13;
            this._status = n;
            this._expiration = l;
            this._daysInMSBeforeExpireWarning = l2;
            this._errorMes = string14;
        }

        public String getName() {
            return this._name;
        }

        public Key getPublicOrSecretKey() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException soapSecurityException = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)soapSecurityException, clsName + ".getPublicOrSecretKey", "1219", this);
                throw soapSecurityException;
            }
            this.checkExpiration();
            return this._publicOrSecretKey;
        }

        public Key getPrivateOrSecretKey() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException soapSecurityException = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)soapSecurityException, clsName + ".getPrivateOrSecretKey", "1229", this);
                throw soapSecurityException;
            }
            this.checkExpiration();
            return this._privateOrSecretKey;
        }

        public Certificate getCertificate() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException soapSecurityException = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)soapSecurityException, clsName + ".getCertificate", "1239", this);
                throw soapSecurityException;
            }
            this.checkExpiration();
            return this._certificate;
        }

        public byte[] getBinary() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException soapSecurityException = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)soapSecurityException, clsName + ".getBinary", "1249", this);
                throw soapSecurityException;
            }
            this.checkExpiration();
            return this._binary;
        }

        public String getEncodedBinary() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException soapSecurityException = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)soapSecurityException, clsName + ".getEncodedBinary", "1259", this);
                throw soapSecurityException;
            }
            this.checkExpiration();
            if (this._encodedBinary == null) {
                this._encodedBinary = Base64.encode(this._binary);
            }
            return this._encodedBinary;
        }

        public String getSubjectDN() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException soapSecurityException = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)soapSecurityException, clsName + ".getSubjectDN", "1272", this);
                throw soapSecurityException;
            }
            this.checkExpiration();
            return this._encSubjectDN;
        }

        public String getIssuerDN() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException soapSecurityException = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)soapSecurityException, clsName + ".getIssuerDN", "1282", this);
                throw soapSecurityException;
            }
            this.checkExpiration();
            return this._encIssuerDN;
        }

        public String getIssuerSerial() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2) {
                SoapSecurityException soapSecurityException = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)soapSecurityException, clsName + ".getIssuerSerial", "1292", this);
                throw soapSecurityException;
            }
            this.checkExpiration();
            return this._issuerSerial;
        }

        public String getB64KeyId() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2 || (this._status & 4) == 4) {
                SoapSecurityException soapSecurityException = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)soapSecurityException, clsName + ".getB64KeyId", "1303", this);
                throw soapSecurityException;
            }
            this.checkExpiration();
            return this._b64KeyId;
        }

        public String getB64KeyId60() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2 || (this._status & 4) == 4) {
                SoapSecurityException soapSecurityException = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)soapSecurityException, clsName + ".getB64KeyId60", "1314", this);
                throw soapSecurityException;
            }
            this.checkExpiration();
            return this._b64KeyId60;
        }

        public String getB64Thumbprint() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2 || (this._status & 8) == 8) {
                SoapSecurityException soapSecurityException = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)soapSecurityException, clsName + ".getB64Thumbprint", "1325", this);
                throw soapSecurityException;
            }
            this.checkExpiration();
            return this._b64Thumbprint;
        }

        public String getHexKeyId() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2 || (this._status & 4) == 4) {
                SoapSecurityException soapSecurityException = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)soapSecurityException, clsName + ".getHexKeyId", "1336", this);
                throw soapSecurityException;
            }
            this.checkExpiration();
            return this._hexKeyId;
        }

        public String getHexKeyId60() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2 || (this._status & 4) == 4) {
                SoapSecurityException soapSecurityException = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)soapSecurityException, clsName + ".getHexKeyId60", "1347", this);
                throw soapSecurityException;
            }
            this.checkExpiration();
            return this._hexKeyId60;
        }

        public String getHexThumbprint() throws SoapSecurityException {
            if ((this._status & 1) == 1 || (this._status & 2) == 2 || (this._status & 8) == 8) {
                SoapSecurityException soapSecurityException = new SoapSecurityException(this._errorMes);
                Tr.processException((Throwable)soapSecurityException, clsName + ".getHexThumbprint", "1358", this);
                throw soapSecurityException;
            }
            this.checkExpiration();
            return this._hexThumbprint;
        }

        private void checkExpiration() throws SoapSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkExpiration()");
            }
            if (this._expiration >= 0L) {
                long l = this._expiration - System.currentTimeMillis();
                if (l < 0L) {
                    this._status += 2;
                    this._errorMes = ConfigUtil.getMessage("security.wssecurity.WSEC5181E", new String[]{this._subjectDN, this._alias, this._kspath, "expiration time - current system time = " + l + " ms."});
                    SoapSecurityException soapSecurityException = new SoapSecurityException(this._errorMes);
                    Tr.processException((Throwable)soapSecurityException, clsName + ".checkExpiration", "1382", this);
                    throw soapSecurityException;
                }
                if (l < this._daysInMSBeforeExpireWarning) {
                    long l2 = l / 86400000L;
                    Tr.warning(tc, "security.wssecurity.WSEC5189W", new Object[]{this._subjectDN, this._alias, this._kspath, new Long(l2)});
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkExpiration()");
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getClass().getName()).append("(");
            stringBuffer.append("keystorePath=[").append(this._kspath).append("], ");
            stringBuffer.append("alias=[").append(this._alias).append("], ");
            stringBuffer.append("name=[").append(this._name).append("], ");
            stringBuffer.append("status=[").append(this._status).append("], ");
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        static /* synthetic */ byte[] access$302(KeyInformation keyInformation, byte[] byArray) {
            keyInformation._binary = byArray;
            return byArray;
        }
    }
}

