/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.wssapi.XMLStructure;
import com.ibm.websphere.wssecurity.wssapi.token.DerivedKeyToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.wssapi.OMStructure;
import com.ibm.ws.wssecurity.wssapi.token.impl.BinarySecurityTokenImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenImpl;
import java.security.SecurityPermission;
import javax.xml.namespace.QName;

public class DKToken
extends SecurityTokenImpl
implements DerivedKeyToken {
    private static final TraceComponent tc = Tr.register(BinarySecurityTokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final long serialVersionUID = 99538763796610756L;
    private static final SecurityPermission GETBYTES_PERM = new SecurityPermission("wssapi.DKToken.getBytes");
    private static final SecurityPermission SETSECRET_PERM = new SecurityPermission("wssapi.DKToken.setSecret");
    private static final SecurityPermission SETSECRET_ARRAY_PERM = new SecurityPermission("wssapi.DKToken.setSecret_array");
    private static final SecurityPermission SETSCTUUID_PERM = new SecurityPermission("wssapi.DKToken.setSecurityContextTokenUUID");
    private static final SecurityPermission SETSERVICELABEL_PERM = new SecurityPermission("wssapi.DKToken.setServiceLabel");
    private static final SecurityPermission SETCLIENTLABEL_PERM = new SecurityPermission("wssapi.DKToken.setClientLabel");
    private QName vtype = null;
    private byte[] dktbyte = new byte[0];
    private byte[] nonce = null;
    private byte[] secret = new byte[0];
    private String refTokenUUID = null;
    private String refTokenId = null;
    private QName refTokenType = null;
    private String algorithm = Constants.SC_DK_ALGO_PSHA1;
    private String sLabel = null;
    private String cLabel = null;
    private String label;
    private int length = 0;
    private SecurityContextToken sct = null;
    private XMLStructure props = null;
    int offset = 0;
    protected static final int ENCRYPTION = 1;
    protected static final int SIGNATURE = 2;
    protected static final int DECRYPTION = 3;
    protected static final int VERIFICATION = 4;

    public DKToken() {
        this.valueType = DerivedKeyToken.ValueType;
        this.tokenQName = DerivedKeyToken.TokenQname;
    }

    public QName getType() {
        return this.vtype;
    }

    public void setType(QName qName) {
        if (!this.readOnly) {
            this.vtype = qName;
        }
    }

    public void setType(String string, String string2) {
        if (!this.readOnly) {
            this.vtype = new QName(string, string2);
        }
    }

    public boolean isTrusted() {
        return false;
    }

    public void setTrusted(boolean bl) {
        if (!this.readOnly) {
            // empty if block
        }
    }

    public boolean isValid() {
        return false;
    }

    public long getExpiration() {
        return 0L;
    }

    public byte[] getBytes() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETBYTES_PERM.toString());
            }
            securityManager.checkPermission(GETBYTES_PERM);
        }
        byte[] byArray = this.dktbyte;
        if (this.readOnly && byArray != null) {
            int n = this.dktbyte.length;
            byArray = new byte[n];
            System.arraycopy(this.dktbyte, 0, byArray, 0, n);
        }
        return byArray;
    }

    public void setBytes(byte[] byArray) {
        if (!this.readOnly) {
            this.dktbyte = byArray;
        }
    }

    public byte[] getNonce() {
        byte[] byArray = this.nonce;
        if (this.readOnly && byArray != null) {
            int n = this.nonce.length;
            byArray = new byte[n];
            System.arraycopy(this.nonce, 0, byArray, 0, n);
        }
        return this.nonce;
    }

    public void setNonce(byte[] byArray) {
        if (!this.readOnly) {
            this.nonce = byArray;
        }
    }

    public QName getrefTokenType() {
        return this.refTokenType;
    }

    public void setrefTokenType(QName qName) {
        if (!this.readOnly) {
            this.refTokenType = qName;
        }
    }

    public void setrefTokenType(String string, String string2) {
        if (!this.readOnly) {
            this.refTokenType = new QName(string, string2);
        }
    }

    public String getSecurityContextTokenTokenUUID() {
        return this.refTokenUUID;
    }

    public void setSecurityContextTokenUUID(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETSCTUUID_PERM.toString());
            }
            securityManager.checkPermission(SETSCTUUID_PERM);
        }
        if (!this.readOnly) {
            this.refTokenUUID = string;
        }
    }

    public String getrefTokenId() {
        return this.refTokenId;
    }

    public void setrefTokenId(String string) {
        if (!this.readOnly) {
            this.refTokenId = string;
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String string) {
        if (!this.readOnly) {
            this.algorithm = string;
        }
    }

    public String getServiceLabel() {
        return this.sLabel;
    }

    public void setServiceLabel(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETSERVICELABEL_PERM.toString());
            }
            securityManager.checkPermission(SETSERVICELABEL_PERM);
        }
        if (!this.readOnly) {
            this.sLabel = string;
        }
    }

    public String getClientLabel() {
        return this.cLabel;
    }

    public void setClientLabel(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETCLIENTLABEL_PERM.toString());
            }
            securityManager.checkPermission(SETCLIENTLABEL_PERM);
        }
        if (!this.readOnly) {
            this.cLabel = string;
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        if (!this.readOnly) {
            this.label = string;
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        if (!this.readOnly) {
            this.length = n;
        }
    }

    public byte[] getSecret() {
        byte[] byArray = this.secret;
        if (this.readOnly && byArray != null) {
            int n = this.secret.length;
            byArray = new byte[n];
            System.arraycopy(this.secret, 0, byArray, 0, n);
        }
        return this.secret;
    }

    public SecurityContextToken getSecurityContextToken() {
        return this.sct;
    }

    public void setSecurityContextToken(SecurityContextToken securityContextToken) {
        if (!this.readOnly) {
            this.sct = securityContextToken;
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        if (!this.readOnly) {
            this.offset = n;
        }
    }

    public XMLStructure getProperties() {
        XMLStructure xMLStructure = this.props;
        if (this.readOnly && xMLStructure != null) {
            xMLStructure = new OMStructure(((OMStructure)xMLStructure).getNode().cloneOMElement());
        }
        return xMLStructure;
    }

    public void setProperties(XMLStructure xMLStructure) {
        if (!this.readOnly) {
            this.props = xMLStructure;
        }
    }

    public String getSecurityContextTokenId() {
        return this.refTokenId;
    }
}

