/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.ws.wssecurity.core.token.TokenGeneratorComponent;
import com.ibm.ws.wssecurity.util.ConfigUtil;
import com.ibm.ws.wssecurity.util.DOMUtils;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.CommonCallbackHandler;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTGenerateLoginModule;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.wssapi.token.impl.X509GenerateLoginModule;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import com.ibm.wsspi.wssecurity.core.config.CallbackHandlerConfig;
import com.ibm.wsspi.wssecurity.core.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.wssapi.OMStructure;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonTokenGenerator
implements TokenGeneratorComponent {
    private static final TraceComponent tc = Tr.register(CommonTokenGenerator.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = CommonTokenGenerator.class.getName();
    private boolean initialized = false;

    @Override
    public void init(Map<Object, Object> map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(Map map)");
        }
        if (!this.initialized) {
            this.initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init(Map map)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invoke(OMDocument oMDocument, OMElement oMElement, Map<Object, Object> map) throws SoapSecurityException {
        Object object;
        Object object2;
        SecurityToken securityToken;
        Object object3;
        Object object4;
        Object object5;
        String string;
        Object object6;
        block47: {
            Object object7;
            Serializable serializable;
            Class clazz;
            Object object8;
            if (tc.isEntryEnabled()) {
                object6 = new StringBuffer("invoke(");
                ((StringBuffer)object6).append("OMDocument doc[").append(DOMUtils.getDisplayName(oMDocument)).append("], ");
                ((StringBuffer)object6).append("OMElement parent[").append(DOMUtils.getDisplayName(oMElement)).append("], ");
                ((StringBuffer)object6).append("Map context)");
                Tr.entry(tc, ((StringBuffer)object6).toString());
            }
            object6 = (TokenGeneratorConfig)map.get("com.ibm.wsspi.wssecurity.impl.config.tokenGenerator.configKey");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TokenGeneratorConfig [" + object6 + "].");
            }
            CallbackHandlerConfig callbackHandlerConfig = object6.getCallbackHandler();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CallbackHandlerConfig [" + object6 + "].");
            }
            CallbackHandler callbackHandler = null;
            if (callbackHandlerConfig != null) {
                callbackHandler = callbackHandlerConfig.getInstance();
                if (callbackHandler == null) {
                    string = callbackHandlerConfig.getClassName();
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Instantiating the callback handler [" + string + "]...");
                        }
                        object8 = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "invoke(OMDocument, OMElement, Map");
                                }
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                        clazz = null;
                        if (object8 != null) {
                            try {
                                clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>((ClassLoader)object8, string){
                                    final /* synthetic */ ClassLoader val$loader;
                                    final /* synthetic */ String val$cbhname;
                                    {
                                        this.val$loader = classLoader;
                                        this.val$cbhname = string;
                                    }

                                    @Override
                                    public Object run() throws ClassNotFoundException {
                                        return this.val$loader.loadClass(this.val$cbhname);
                                    }
                                });
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                clazz = Class.forName(string);
                            }
                        } else {
                            clazz = Class.forName(string);
                        }
                        if (!CallbackHandler.class.isAssignableFrom(clazz)) {
                            SoapSecurityException soapSecurityException = SoapSecurityException.format("security.wssecurity.ConfigUtil.s17", string, CallbackHandler.class.getName());
                            Tr.processException((Throwable)soapSecurityException, clsName + ".invoke", "149", this);
                            throw soapSecurityException;
                        }
                        serializable = new HashMap();
                        serializable.put("com.ibm.wsspi.wssecurity.impl.config.callbackHandler.configKey", callbackHandlerConfig);
                        object7 = clazz.getConstructor(Map.class);
                        callbackHandler = (CallbackHandler)((Constructor)object7).newInstance(serializable);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Succeeded to Instantiate the callback handler [" + string + "].");
                        }
                    }
                    catch (SoapSecurityException soapSecurityException) {
                        Tr.processException(soapSecurityException, clsName + ".invoke", "153");
                        throw soapSecurityException;
                    }
                    catch (Exception exception) {
                        String string2 = "security.wssecurity.X509TokenGenerator.s01";
                        SoapSecurityException soapSecurityException = SoapSecurityException.format(string2, string, (Throwable)exception);
                        Tr.processException((Throwable)exception, clsName + ".invoke", "159", this);
                        Tr.error(tc, string2, new Object[]{soapSecurityException});
                        throw soapSecurityException;
                    }
                    callbackHandlerConfig.setInstance(callbackHandler);
                }
                map.putAll(callbackHandlerConfig.getProperties());
            }
            map.put("com.ibm.ws.wssecurity.constants.processingElement", oMElement);
            string = object6.getJAASConfig();
            map.putAll(object6.getJAASConfigProperties());
            object8 = new CommonCallbackHandler(callbackHandler, map);
            clazz = map.get("com.ibm.wsspi.wssecurity.core.subject");
            if (clazz == null || !(clazz instanceof Subject)) {
                serializable = new Subject();
                map.put("com.ibm.wsspi.wssecurity.core.subject", serializable);
            } else {
                serializable = (Subject)((Object)clazz);
            }
            object7 = serializable;
            boolean bl = false;
            LoginModule loginModule = null;
            String string3 = (String)object6.getProperties().get("com.ibm.ws.wssecurity.token.ourLoginConfig");
            if (ConfigUtil.hasValue(string3)) {
                if ("system.wss.generate.sct".equals(string3)) {
                    loginModule = new SCTGenerateLoginModule();
                    bl = true;
                } else if ("system.wss.generate.x509".equals(string3)) {
                    loginModule = new X509GenerateLoginModule();
                    bl = true;
                }
            }
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Avoiding JAAS login for " + string);
                }
                object5 = new HashMap();
                object4 = new HashMap();
                loginModule.initialize((Subject)object7, (CallbackHandler)object8, (Map<String, ?>)object5, (Map<String, ?>)object4);
                try {
                    if (loginModule.login()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Succeeded to login");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to login");
                        }
                        throw new LoginException("Login module " + loginModule.getClass().getName() + " login() method returned false");
                    }
                    if (loginModule.commit()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Succeeded to commit");
                        }
                        break block47;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to commit");
                    }
                    throw new LoginException("Login module " + loginModule.getClass().getName() + " commit() method returned false");
                }
                catch (LoginException loginException) {
                    Tr.processException(loginException, clsName + ".invoke", "236");
                    Tr.error(tc, "security.wssecurity.X509TokenConsumer.s02", new Object[]{loginException});
                    throw SoapSecurityException.format("security.wssecurity.X509TokenConsumer.s02", loginException);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing JAAS login for " + string);
            }
            object5 = null;
            try {
                object5 = (LoginContext)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>((Subject)object7, (CommonCallbackHandler)object8){
                    final /* synthetic */ Subject val$subject;
                    final /* synthetic */ CommonCallbackHandler val$commonCBH;
                    {
                        this.val$subject = subject;
                        this.val$commonCBH = commonCallbackHandler;
                    }

                    @Override
                    public Object run() throws LoginException {
                        LoginContext loginContext = new LoginContext(string, this.val$subject, this.val$commonCBH);
                        return loginContext;
                    }
                });
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeed to construct the login context.");
                }
                ((LoginContext)object5).login();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Succeed to login.");
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                LoginException loginException = (LoginException)privilegedActionException.getCause();
                Tr.processException(loginException, clsName + ".invoke", "264");
                Tr.error(tc, "security.wssecurity.X509TokenConsumer.s01", new Object[]{loginException});
                throw SoapSecurityException.format("security.wssecurity.X509TokenConsumer.s01", loginException);
            }
            catch (LoginException loginException) {
                Tr.processException(loginException, clsName + ".invoke", "268");
                Tr.error(tc, "security.wssecurity.X509TokenConsumer.s02", new Object[]{loginException});
                throw SoapSecurityException.format("security.wssecurity.X509TokenConsumer.s02", loginException);
            }
        }
        map.remove(Constants.WSSECURITY_TOKEN_FOR_ERROR_HANDLING);
        map.remove("com.ibm.ws.wssecurity.UNTGUIPromptCallbackHandler.cacheTokens");
        object5 = (List)map.remove(Constants.WSSECURITY_TOKEN_PROCESSED);
        if (object5 == null) {
            object4 = SoapSecurityException.format("security.wssecurity.X509TokenGenerator.s03", string);
            Tr.processException(object4, clsName + ".invoke", "287", this);
            throw object4;
        }
        object4 = (SecurityTokenManagerImpl)map.get("com.ibm.wsspi.wssecurity.core.securityTokenManager");
        String string4 = (String)map.get(Constants.WSSECURITY_KEYINFO_TYPE);
        boolean bl = false;
        for (int i = object5.size() - 1; i >= 0; --i) {
            object3 = (SecurityToken)object5.get(i);
            SecurityTokenWrapper securityTokenWrapper = ((SecurityTokenManagerImpl)object4).getTokenWrapper((SecurityToken)object3);
            if (securityTokenWrapper == null) {
                securityToken = new SecurityTokenWrapper((SecurityToken)object3);
                object2 = object6;
                object = string4;
                AccessController.doPrivileged(new PrivilegedAction<Object>((SecurityTokenWrapper)securityToken, (TokenGeneratorConfig)object2, (String)object){
                    final /* synthetic */ SecurityTokenWrapper val$tw;
                    final /* synthetic */ TokenGeneratorConfig val$tconfig;
                    final /* synthetic */ String val$kit;
                    {
                        this.val$tw = securityTokenWrapper;
                        this.val$tconfig = tokenGeneratorConfig;
                        this.val$kit = string;
                    }

                    @Override
                    public Object run() {
                        this.val$tw.setUsedTokenGenerator(this.val$tconfig.hashCode());
                        this.val$tw.setKeyInfoType(this.val$kit);
                        return null;
                    }
                });
                ((SecurityTokenManagerImpl)object4).addTokenWrapper((SecurityTokenWrapper)securityToken);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SecurityTokenWrapper[" + i + "] added: " + securityToken);
                }
            }
            if (bl) continue;
            map.put(Constants.WSSECURITY_TOKEN_LOGININFO, object3);
            bl = true;
        }
        List list = (List)map.remove(Constants.WSSECURITY_TOKEN_TO_BE_INSERTED);
        if (list != null && list.size() > 0) {
            object3 = (OMNode)map.get(Constants.WSSECURITY_TOKENELEMENT_REFERENCED);
            for (int i = list.size() - 1; i >= 0; --i) {
                securityToken = (SecurityToken)list.get(i);
                object2 = securityToken instanceof UsernameToken ? AccessController.doPrivileged(new PrivilegedAction<OMStructure>(){

                    @Override
                    public OMStructure run() {
                        OMStructure oMStructure = (OMStructure)securityToken.getXML();
                        return oMStructure;
                    }
                }) : (OMStructure)securityToken.getXML();
                if (object2 == null) continue;
                object = object2.getNode();
                if (object3 == null) {
                    OMNode oMNode = oMElement.getFirstOMChild();
                    if (oMNode == null) {
                        oMElement.addChild((OMNode)object);
                        continue;
                    }
                    oMNode.insertSiblingBefore((OMNode)object);
                    continue;
                }
                object3.insertSiblingAfter((OMNode)object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke(OMDocument, OMElement, Map)");
        }
    }
}

