/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.token.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wssecurity.wssapi.token.BinarySecurityToken;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.SecurityPermission;
import org.apache.axis2.util.ObjectStateUtils;

public abstract class BinarySecurityTokenImpl
extends SecurityTokenImpl
implements BinarySecurityToken {
    private static final TraceComponent tc = Tr.register(BinarySecurityTokenImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String VERSION_NUMBER = "1.0";
    private static final SecurityPermission GETBYTES_PERM = new SecurityPermission("wssapi.BinarySecurityToken.getBytes");
    private static final SecurityPermission SETBYTES_PERM = new SecurityPermission("wssapi.BinarySecurityToken.setBytes");
    protected byte[] binary;

    public BinarySecurityTokenImpl() {
        this.tokenQName = BinarySecurityToken.TokenQname;
    }

    public byte[] getBinary() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETBYTES_PERM.toString());
            }
            securityManager.checkPermission(GETBYTES_PERM);
        }
        byte[] byArray = this.binary;
        if (this.readOnly && byArray != null) {
            int n = this.binary.length;
            byArray = new byte[n];
            System.arraycopy(this.binary, 0, byArray, 0, n);
        }
        return this.binary;
    }

    public void setBinary(byte[] byArray) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + SETBYTES_PERM.toString());
            }
            securityManager.checkPermission(SETBYTES_PERM);
        }
        if (!this.readOnly) {
            this.binary = byArray;
        }
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.id;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object;
        super.readExternal(objectInput);
        String string = ObjectStateUtils.readString(objectInput, "BinarySecurityToken.version");
        if (VERSION_NUMBER.equals(string) && (object = ObjectStateUtils.readObject(objectInput, "BinarySecurityToken.binary")) != null) {
            this.binary = (byte[])object;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        ObjectStateUtils.writeString(objectOutput, VERSION_NUMBER, "BinarySecurityToken.version");
        ObjectStateUtils.writeObject(objectOutput, this.binary, "BinarySecurityToken.binary");
    }
}

