/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.sig.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSTimestamp;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignPart;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignature;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.sig.impl.WSSSignPartImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.Generatable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSSignatureImpl
implements WSSSignature,
Generatable {
    private static final TraceComponent tc = Tr.register(WSSSignatureImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSSignatureImpl.class.getName();
    private static final long serialVersionUID = -5969154429557443129L;
    private SecurityToken token;
    private List<WSSSignPart> signParts = new ArrayList<WSSSignPart>();
    private String canonicalizationMethod = DefaultValueManager.getInstance().getCanonicalizationMethod();
    private String signatureMethod = DefaultValueManager.getInstance().getSignatureMethod();
    private boolean signatureConfirmation;
    private boolean requriredSignatureConfirmation;
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSSignatureImpl(SecurityTokenManagerImpl securityTokenManagerImpl) {
        this.securityTokenManager = securityTokenManagerImpl;
    }

    public WSSSignatureImpl(SecurityToken securityToken, SecurityTokenManagerImpl securityTokenManagerImpl) {
        this.token = securityToken;
        this.securityTokenManager = securityTokenManagerImpl;
        SecurityTokenWrapper securityTokenWrapper = this.securityTokenManager.getTokenWrapper(this.token);
        securityTokenWrapper.setWssapiReferenceType(DefaultValueManager.getInstance().getTokenReferenceForSignature());
    }

    @Override
    public void setCanonicalizationMethod(String string) throws WSSException {
        AlgorithmFactory algorithmFactory;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "setCanonicalizationMethod(" + string + ")");
        }
        if (!(algorithmFactory = WSSUtil.getAlgorithmFactory()).getCanonicalizationAlgorithms().contains(string)) {
            String string2 = "security.wssecurity.PrivateConsumerConfig.s09";
            WSSException wSSException = WSSException.format(string2, string);
            Tr.processException((Throwable)wSSException, clsName + ".setCanonicalizationMethod", "117", this);
            Tr.error(tc, string2, new Object[]{wSSException});
            throw wSSException;
        }
        this.canonicalizationMethod = string;
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "setCanonicalizationMethod(String)");
        }
    }

    @Override
    public void setSignatureMethod(String string) throws WSSException {
        AlgorithmFactory algorithmFactory;
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "setSignatureMethod(" + string + ")");
        }
        if (!(algorithmFactory = WSSUtil.getAlgorithmFactory()).getSignatureAlgorithms().contains(string)) {
            String string2 = "security.wssecurity.PrivateConsumerConfig.s08";
            WSSException wSSException = WSSException.format(string2, string);
            Tr.processException((Throwable)wSSException, clsName + ".setSignatureMethod", "142", this);
            Tr.error(tc, string2, new Object[]{wSSException});
            throw wSSException;
        }
        this.signatureMethod = string;
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "setSignatureMethod(String)");
        }
    }

    @Override
    public void addSignPart(int n) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignPart( " + n + " )");
        }
        WSSSignPartImpl wSSSignPartImpl = new WSSSignPartImpl(this.token, this.securityTokenManager);
        wSSSignPartImpl.setSignPart(n);
        this.signParts.add(wSSSignPartImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSignPart( " + n + " )");
        }
    }

    @Override
    public void addSignPart(WSSSignPart wSSSignPart) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignPart(" + wSSSignPart + ")");
        }
        this.signParts.add(wSSSignPart);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSignPart(" + wSSSignPart + ")");
        }
    }

    @Override
    public void addSignPartByXPath(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignPartByXPath( " + string + " )");
        }
        WSSSignPartImpl wSSSignPartImpl = new WSSSignPartImpl(this.token, this.securityTokenManager);
        wSSSignPartImpl.setSignPartByXPath(string);
        this.signParts.add(wSSSignPartImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSignPartByXPath( " + string + " )");
        }
    }

    @Override
    public void addSignPart(SecurityToken securityToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignPart(" + securityToken.toString() + ")");
        }
        WSSSignPartImpl wSSSignPartImpl = new WSSSignPartImpl(this.token, this.securityTokenManager);
        wSSSignPartImpl.setSignPart(securityToken);
        this.signParts.add(wSSSignPartImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSignPart(SecurityToken)");
        }
    }

    @Override
    public void addSignHeader(QName qName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignHeader(" + qName + ")");
        }
        WSSSignPartImpl wSSSignPartImpl = new WSSSignPartImpl(this.token, this.securityTokenManager);
        wSSSignPartImpl.setSignHeader(qName);
        this.signParts.add(wSSSignPartImpl);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignHeader(QName header)");
        }
    }

    @Override
    public void addSignPart(WSSTimestamp wSSTimestamp) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addSignPart(" + wSSTimestamp + ")");
        }
        WSSSignPartImpl wSSSignPartImpl = new WSSSignPartImpl(this.token, this.securityTokenManager);
        wSSSignPartImpl.setSignPart(wSSTimestamp);
        this.signParts.add(wSSSignPartImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addSignPart(WSSTimestamp)");
        }
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public List<WSSSignPart> getSignedParts() {
        return this.signParts;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    @Override
    public void setTokenReference(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenReference(" + n + ")");
        }
        if (this.token != null) {
            SecurityTokenWrapper securityTokenWrapper = this.securityTokenManager.getTokenWrapper(this.token);
            securityTokenWrapper.setWssapiReferenceType(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTokenReference(int tokenReference)");
        }
    }

    public String getTokenReferenceByStr() {
        String string = null;
        if (this.token != null) {
            SecurityTokenWrapper securityTokenWrapper = this.securityTokenManager.getTokenWrapper(this.token);
            string = securityTokenWrapper.getWssapiReferenceTypeByStr();
        }
        return string;
    }

    public int getTokenReference() {
        int n = 0;
        if (this.token != null) {
            SecurityTokenWrapper securityTokenWrapper = this.securityTokenManager.getTokenWrapper(this.token);
            n = securityTokenWrapper.getWssapiReferenceType();
        }
        return n;
    }

    public boolean isRequiredSignatureConfirmation() {
        return this.requriredSignatureConfirmation;
    }

    public boolean isSignatureConfirmation() {
        return this.signatureConfirmation;
    }

    @Override
    public void requireSignatureConfirmation() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requireSignatureConfirmation()");
            Tr.exit(tc, "requireSignatureConfirmation()");
        }
        this.signatureConfirmation = true;
        this.requriredSignatureConfirmation = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[WSSSignatureImpl:");
        stringBuffer.append(" token: ");
        stringBuffer.append(this.token);
        stringBuffer.append(", canonicalizationMethod: ");
        stringBuffer.append(this.canonicalizationMethod);
        stringBuffer.append(", signatureMethod: ");
        stringBuffer.append(this.signatureMethod);
        stringBuffer.append(", signedParts: ");
        stringBuffer.append(this.signParts);
        stringBuffer.append(", signatureConfirmation: ");
        stringBuffer.append(this.signatureConfirmation);
        stringBuffer.append(", requriredSignatureConfirmation: ");
        stringBuffer.append(this.requriredSignatureConfirmation);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

