/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.sig.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSTimestamp;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignPart;
import com.ibm.websphere.wssecurity.wssapi.spec.TransformParameterSpec;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.AlgorithmParameterData;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSSignPartImpl
implements WSSSignPart {
    private static final TraceComponent tc = Tr.register(WSSSignPartImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSSignPartImpl.class.getName();
    private static final long serialVersionUID = -8045109640922047674L;
    private static final Map<Integer, String> partMap = new HashMap<Integer, String>();
    private SecurityToken token;
    private List<AlgorithmParameterData> transforms = new ArrayList<AlgorithmParameterData>();
    private String digestMethod = DefaultValueManager.getInstance().getDigestMethod();
    private String dialect = Constants.DIALECT_WAS;
    private String keyword;
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSSignPartImpl(SecurityTokenManagerImpl securityTokenManagerImpl) {
        this.securityTokenManager = securityTokenManagerImpl;
    }

    public WSSSignPartImpl(SecurityToken securityToken, SecurityTokenManagerImpl securityTokenManagerImpl) {
        this.token = securityToken;
        this.securityTokenManager = securityTokenManagerImpl;
        SecurityTokenWrapper securityTokenWrapper = securityTokenManagerImpl.getTokenWrapper(this.token);
        securityTokenWrapper.setWssapiReferenceType(DefaultValueManager.getInstance().getTokenReferenceForSignature());
    }

    @Override
    public void addTransform(String string, TransformParameterSpec transformParameterSpec) throws WSSException {
        AlgorithmFactory algorithmFactory;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTransform( algorithm[" + string + "], TransformParameterSpec)");
        }
        if (!(algorithmFactory = WSSUtil.getAlgorithmFactory()).getTransformAlgorithms().contains(string)) {
            String string2 = "security.wssecurity.PrivateConsumerConfig.s12";
            WSSException wSSException = WSSException.format(string2, string);
            Tr.processException((Throwable)wSSException, clsName + ".addTransform", "140", this);
            Tr.error(tc, string2, new Object[]{wSSException});
            throw wSSException;
        }
        AlgorithmParameterData algorithmParameterData = new AlgorithmParameterData(string, transformParameterSpec);
        this.transforms.add(algorithmParameterData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTransform( algorithm, TransformParameterSpec)");
        }
    }

    @Override
    public void addTransform(String string) throws WSSException {
        AlgorithmFactory algorithmFactory;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTransform(" + string + ")");
        }
        if (!(algorithmFactory = WSSUtil.getAlgorithmFactory()).getTransformAlgorithms().contains(string)) {
            String string2 = "security.wssecurity.PrivateConsumerConfig.s12";
            WSSException wSSException = WSSException.format(string2, string);
            Tr.processException((Throwable)wSSException, clsName + ".addTransform", "169", this);
            Tr.error(tc, string2, new Object[]{wSSException});
            throw wSSException;
        }
        AlgorithmParameterData algorithmParameterData = new AlgorithmParameterData(string);
        this.transforms.add(algorithmParameterData);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTransform(String algorithm)");
        }
    }

    @Override
    public void setDigestMethod(String string) throws WSSException {
        AlgorithmFactory algorithmFactory;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDigestMethod(" + string + ")");
        }
        if (!(algorithmFactory = WSSUtil.getAlgorithmFactory()).getDigestAlgorithms().contains(string)) {
            WSSException wSSException = WSSException.format("security.wssecurity.PrivateConsumerConfig.s11", string);
            Tr.processException((Throwable)wSSException, clsName + ".setDigestMethod", "195", this);
            Tr.error(tc, clsName + "PrivateConsumerConfig.s11", new Object[]{wSSException});
        }
        this.digestMethod = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDigestMethod(String algorithm)");
        }
    }

    @Override
    public void setSignHeader(QName qName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignHeader(" + qName + ")");
        }
        this.dialect = Constants.DIALECT_XPATH;
        this.keyword = "//*[namespace-uri()='" + qName.getNamespaceURI() + "' and local-name()='" + qName.getLocalPart() + "']";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignHeader(QName)");
        }
    }

    @Override
    public void setSignPart(SecurityToken securityToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignPart(" + securityToken.toString() + ")");
        }
        this.dialect = Constants.DIALECT_WAS;
        this.keyword = IntegralDialectElementSelector.WASDIALECTS[2];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignHeader(SecurityToken)");
        }
    }

    @Override
    public void setSignPart(int n) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignPart(" + n + ")");
        }
        this.dialect = Constants.DIALECT_WAS;
        this.keyword = this.getKeyword(n);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignPart(int)");
        }
    }

    @Override
    public void setSignPart(WSSTimestamp wSSTimestamp) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignPart(" + wSSTimestamp + ")");
        }
        this.dialect = Constants.DIALECT_WAS;
        this.keyword = IntegralDialectElementSelector.WASDIALECTS[1];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignPart(WSSTimestamp)");
        }
    }

    @Override
    public void setSignPartByXPath(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignPartByXPath(" + string + ")");
        }
        this.dialect = Constants.DIALECT_XPATH;
        this.keyword = string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignPartByXPath(String)");
        }
    }

    public String getDigestMethod() {
        return this.digestMethod;
    }

    public List<AlgorithmParameterData> getTransforms() {
        return this.transforms;
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getKeyword(int n) throws WSSException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyword( " + n + ")");
        }
        if ((string = partMap.get(n)) == null) {
            String string2 = "security.wssecurity.WSEC7010E";
            WSSException wSSException = WSSException.format(string2);
            Tr.processException((Throwable)wSSException, clsName + ".getKeyword", "374", this);
            Tr.error(tc, string2, new Object[]{wSSException});
            throw wSSException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyword( " + n + ")");
        }
        return string;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    static {
        partMap.put(21, IntegralDialectElementSelector.WASDIALECTS[0]);
        partMap.put(22, IntegralDialectElementSelector.WASDIALECTS[13]);
        partMap.put(23, IntegralDialectElementSelector.WASDIALECTS[1]);
    }
}

