/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.enc.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryptPart;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryption;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignature;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.enc.impl.WSSEncryptPartImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.Generatable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSEncryptionImpl
implements WSSEncryption,
Generatable {
    private static final TraceComponent tc = Tr.register(WSSEncryptionImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSEncryptionImpl.class.getName();
    private static final long serialVersionUID = -5305579588438074252L;
    private static Map<Integer, String> referenceMap = new HashMap<Integer, String>();
    private SecurityToken token;
    private List<SecurityToken> tokensToBeEncrypted = new ArrayList<SecurityToken>();
    private List<WSSEncryptPart> encryptParts = new ArrayList<WSSEncryptPart>();
    private String encryptionMethod = DefaultValueManager.getInstance().getDataEncryptionMethod();
    private String keyEncryptionMethod = DefaultValueManager.getInstance().getKeyEncryptionMethod();
    private boolean encryptKey = DefaultValueManager.getInstance().isKeyEncrypted();
    private boolean optimized = DefaultValueManager.getInstance().isOptimized();
    private int tokenReference;
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSEncryptionImpl(SecurityTokenManagerImpl securityTokenManagerImpl) {
        this.securityTokenManager = securityTokenManagerImpl;
        this.tokenReference = DefaultValueManager.getInstance().getTokenReferenceForEncryption();
    }

    public WSSEncryptionImpl(SecurityToken securityToken, SecurityTokenManagerImpl securityTokenManagerImpl) {
        this.token = securityToken;
        this.securityTokenManager = securityTokenManagerImpl;
        SecurityTokenWrapper securityTokenWrapper = securityTokenManagerImpl.getTokenWrapper(this.token);
        securityTokenWrapper.setWssapiReferenceType(DefaultValueManager.getInstance().getTokenReferenceForEncryption());
    }

    @Override
    public void addEncryptHeader(QName qName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEncryptPart(" + qName + ")");
        }
        WSSEncryptPartImpl wSSEncryptPartImpl = new WSSEncryptPartImpl();
        wSSEncryptPartImpl.setEncryptHeader(qName);
        this.encryptParts.add(wSSEncryptPartImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEncryptPart(QName)");
        }
    }

    @Override
    public void addEncryptPart(int n) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEncryptPart( " + n + ")");
        }
        WSSEncryptPartImpl wSSEncryptPartImpl = new WSSEncryptPartImpl();
        wSSEncryptPartImpl.setEncryptPart(n);
        this.encryptParts.add(wSSEncryptPartImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEncryptPart(int)");
        }
    }

    @Override
    public void addEncryptPart(WSSEncryptPart wSSEncryptPart) {
        this.encryptParts.add(wSSEncryptPart);
    }

    @Override
    public void addEncryptPart(WSSSignature wSSSignature) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEncryptPart(WSSSignature signature)");
        }
        WSSEncryptPartImpl wSSEncryptPartImpl = new WSSEncryptPartImpl();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "signature[" + wSSSignature + "]");
        }
        wSSEncryptPartImpl.setEncryptPart(wSSSignature);
        this.encryptParts.add(wSSEncryptPartImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEncryptPart(WSSSignature signature)");
        }
    }

    @Override
    public void addEncryptPartByXPath(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEncryptPartByXPath(" + string + ")");
        }
        WSSEncryptPartImpl wSSEncryptPartImpl = new WSSEncryptPartImpl();
        wSSEncryptPartImpl.setEncryptPartByXPath(string);
        this.encryptParts.add(wSSEncryptPartImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEncryptPartByXPath(" + string + ")");
        }
    }

    @Override
    public void encryptKey(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encryptKey(" + bl + ")");
            Tr.exit(tc, "encryptKey(boolean)");
        }
        this.encryptKey = bl;
    }

    @Override
    public void setOptimize(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setOptimize(" + bl + ")");
            Tr.exit(tc, "setOptimize(boolean)");
        }
        this.optimized = bl;
    }

    @Override
    public void setEncryptionMethod(String string) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getDataEncryptionAlgorithms().contains(string)) {
            String string2 = "security.wssecurity.PrivateConsumerConfig.s14";
            WSSException wSSException = WSSException.format(string2, string);
            Tr.processException((Throwable)wSSException, clsName + ".setEncryptionMethod", "303", this);
            Tr.error(tc, string2, new Object[]{wSSException});
            throw wSSException;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptionMethod(" + string + ")");
        }
        this.encryptionMethod = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptionMethod(String)");
        }
    }

    @Override
    public void setKeyEncryptionMethod(String string) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getKeyEncryptionAlgorithms().contains(string)) {
            String string2 = "security.wssecurity.PrivateConsumerConfig.s15";
            WSSException wSSException = WSSException.format(string2, string);
            Tr.processException((Throwable)wSSException, clsName + ".setKeyEncryptionMethod", "329", this);
            Tr.error(tc, string2, new Object[]{wSSException});
            throw wSSException;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setKeyEncryptionMethod(" + string + ")");
        }
        this.keyEncryptionMethod = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setKeyEncryptionMethod(String)");
        }
    }

    public List<WSSEncryptPart> getEncryptParts() {
        return this.encryptParts;
    }

    public String getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public String getKeyEncryptionMethod() {
        return this.keyEncryptionMethod;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    public List<SecurityToken> getTokensToBeEncrypted() {
        return this.tokensToBeEncrypted;
    }

    public boolean isEncryptKey() {
        return this.encryptKey;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    @Override
    public void addEncryptPart(SecurityToken securityToken, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEncryptPart(SecurityToken [" + securityToken.toString() + "], boolean[" + bl + "])");
        }
        this.tokensToBeEncrypted.add(securityToken);
        WSSEncryptPartImpl wSSEncryptPartImpl = new WSSEncryptPartImpl();
        wSSEncryptPartImpl.setEncryptPart(securityToken, bl);
        this.encryptParts.add(wSSEncryptPartImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEncryptPart(SecurityToken securityToken, boolean isElement)");
        }
    }

    @Override
    public void setTokenReference(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenReference(" + n + ")");
        }
        if (this.token == null) {
            this.tokenReference = n;
        } else {
            SecurityTokenWrapper securityTokenWrapper = this.securityTokenManager.getTokenWrapper(this.token);
            securityTokenWrapper.setWssapiReferenceType(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenReference(int)");
        }
    }

    public String getTokenReferenceByStr() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenReferenceByStr()");
        }
        String string = null;
        if (this.token == null) {
            string = referenceMap.get(this.tokenReference);
        } else {
            SecurityTokenWrapper securityTokenWrapper = this.securityTokenManager.getTokenWrapper(this.token);
            string = securityTokenWrapper.getWssapiReferenceTypeByStr();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenReferenceByStr()");
        }
        return string;
    }

    public int getTokenReference() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenReference()");
        }
        int n = 0;
        if (this.token == null) {
            n = this.tokenReference;
        } else {
            SecurityTokenWrapper securityTokenWrapper = this.securityTokenManager.getTokenWrapper(this.token);
            n = securityTokenWrapper.getWssapiReferenceType();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenReference()");
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[WSSEncryptionImpl:");
        stringBuffer.append(" token: ");
        stringBuffer.append(this.token);
        stringBuffer.append(", encryptParts: ");
        stringBuffer.append(this.encryptParts);
        stringBuffer.append(", encryptionMethod: ");
        stringBuffer.append(this.encryptionMethod);
        stringBuffer.append(", keyEncryptionMethod: ");
        stringBuffer.append(this.keyEncryptionMethod);
        stringBuffer.append(", encryptKey: ");
        stringBuffer.append(this.encryptKey);
        stringBuffer.append(", tokenReference: ");
        stringBuffer.append(this.tokenReference);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static {
        referenceMap.put(65, "STRREF");
        referenceMap.put(66, "KEYID");
        referenceMap.put(67, "EMB");
        referenceMap.put(68, "THUMBPRINT");
        referenceMap.put(71, "X509ISSUER");
    }
}

