/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.enc.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryptPart;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignature;
import com.ibm.websphere.wssecurity.wssapi.spec.TransformParameterSpec;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class WSSEncryptPartImpl
implements WSSEncryptPart {
    private static final TraceComponent tc = Tr.register(WSSEncryptPartImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSEncryptPartImpl.class.getName();
    private static final long serialVersionUID = 8535931437145662325L;
    private static final Map<Integer, String> partMap = new HashMap<Integer, String>();
    private String dialect = Constants.DIALECT_WAS;
    private String keyword;

    public void addTransform(String string, TransformParameterSpec transformParameterSpec) throws WSSException {
        String string2 = "security.wssecurity.WSEC7012E";
        WSSException wSSException = WSSException.format(string2, clsName + ".addTransform(String, TransformParameterSpec)");
        Tr.processException((Throwable)wSSException, clsName + ".addTransform", "91", this);
        Tr.error(tc, string2, new Object[]{wSSException});
        throw wSSException;
    }

    public void addTransform(String string) throws WSSException {
        String string2 = "security.wssecurity.WSEC7012E";
        WSSException wSSException = WSSException.format(string2, clsName + ".addTransform(String)");
        Tr.processException((Throwable)wSSException, clsName + ".addTransform", "106", this);
        Tr.error(tc, string2, new Object[]{wSSException});
        throw wSSException;
    }

    public void setEncryptHeader(QName qName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptHeader(" + qName.toString() + ")");
        }
        this.dialect = Constants.DIALECT_XPATH;
        this.keyword = "//*[namespace-uri()='" + qName.getNamespaceURI() + "' and local-name()='" + qName.getLocalPart() + "']";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptHeader(QName)");
        }
    }

    public void setEncryptPart(int n) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptPart(" + n + ")");
        }
        this.dialect = Constants.DIALECT_WAS;
        this.keyword = this.getKeyword(n);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptPart(int)");
        }
    }

    public void setEncryptPart(WSSSignature wSSSignature) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSSignature signature");
        }
        this.dialect = Constants.DIALECT_WAS;
        this.keyword = ConfidentialDialectElementSelector.WASDIALECTS[3];
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSSignature signature");
        }
    }

    public void setEncryptPartByXPath(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptPartByXPath(" + string + " )");
        }
        this.dialect = Constants.DIALECT_XPATH;
        this.keyword = string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptPartByXPath(" + string + " )");
        }
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getKeyword(int n) throws WSSException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyword( " + n + ")");
        }
        if ((string = partMap.get(n)) == null) {
            String string2 = "security.wssecurity.WSEC7010E";
            WSSException wSSException = WSSException.format(string2);
            Tr.processException((Throwable)wSSException, clsName + ".getKeyword", "252", this);
            Tr.error(tc, string2, new Object[]{wSSException});
            throw wSSException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "keyword[" + string + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyword( " + n + ")");
        }
        return string;
    }

    public void setEncryptPart(SecurityToken securityToken, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryptPart(" + securityToken + ", " + bl + ")");
        }
        QName qName = securityToken.getTokenQname();
        String string = bl ? "" : "/node()";
        this.dialect = Constants.DIALECT_XPATH;
        this.keyword = "//*[namespace-uri()='" + qName.getNamespaceURI() + "' and local-name()='" + qName.getLocalPart() + "']" + string;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "dialect=[" + this.dialect + "], keyword=[" + this.keyword + "]");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryptPart(SecurityToken, boolean)");
        }
    }

    static {
        partMap.put(31, ConfidentialDialectElementSelector.WASDIALECTS[0]);
        partMap.put(32, ConfidentialDialectElementSelector.WASDIALECTS[3]);
    }
}

