/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.dec.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryptPart;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryption;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.dec.impl.WSSDecryptPartImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.Consumable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSDecryptionImpl
implements WSSDecryption,
Consumable {
    private static final TraceComponent tc = Tr.register(WSSDecryptionImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSDecryptionImpl.class.getName();
    private static final long serialVersionUID = -7471925006791048796L;
    private SecurityToken token;
    private List<WSSDecryptPart> decryptParts = new ArrayList<WSSDecryptPart>();
    private List<String> dataEncryptionMethods = new ArrayList<String>();
    private List<String> keyEncryptionMethods = new ArrayList<String>();
    private boolean encryptKey = true;
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSDecryptionImpl(SecurityTokenManagerImpl securityTokenManagerImpl) {
        this.securityTokenManager = securityTokenManagerImpl;
    }

    public WSSDecryptionImpl(Class clazz, CallbackHandler callbackHandler, String string, SecurityTokenManagerImpl securityTokenManagerImpl) throws WSSException {
        this.securityTokenManager = securityTokenManagerImpl;
        this.addToken(clazz, callbackHandler, string);
    }

    @Override
    public void addRequiredDecryptPart(int n) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRequiredDecryptPart( " + n + " )");
        }
        WSSDecryptPartImpl wSSDecryptPartImpl = new WSSDecryptPartImpl();
        wSSDecryptPartImpl.setRequiredDecryptPart(n);
        this.decryptParts.add(wSSDecryptPartImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRequiredDecryptPart( " + n + " )");
        }
    }

    @Override
    public void addRequiredDecryptPart(WSSDecryptPart wSSDecryptPart) {
        this.decryptParts.add(wSSDecryptPart);
    }

    @Override
    public void addRequiredDecryptPart(WSSVerification wSSVerification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRequiredDecryptPart(WSSVerification verification)");
        }
        WSSDecryptPartImpl wSSDecryptPartImpl = new WSSDecryptPartImpl();
        wSSDecryptPartImpl.setRequiredDecryptPart(wSSVerification);
        this.decryptParts.add(wSSDecryptPartImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRequiredDecryptPart(WSSVerification verification)");
        }
    }

    @Override
    public void addRequiredDecryptHeader(QName qName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRequiredDecryptPart(QName qname)");
        }
        WSSDecryptPartImpl wSSDecryptPartImpl = new WSSDecryptPartImpl();
        wSSDecryptPartImpl.setRequiredDecryptHeader(qName);
        this.decryptParts.add(wSSDecryptPartImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRequiredDecryptPart(Qname qname)");
        }
    }

    @Override
    public void addRequiredDecryptPartByXPath(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRequiredDecryptPartByXPath(" + string + ")");
        }
        WSSDecryptPartImpl wSSDecryptPartImpl = new WSSDecryptPartImpl();
        wSSDecryptPartImpl.setRequiredDecryptPartByXPath(string);
        this.decryptParts.add(wSSDecryptPartImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRequiredDecryptPartByXPath(" + string + ")");
        }
    }

    @Override
    public void addAllowedEncryptionMethod(String string) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getDataEncryptionAlgorithms().contains(string)) {
            String string2 = "security.wssecurity.PrivateConsumerConfig.s14";
            WSSException wSSException = WSSException.format(string2, string);
            Tr.processException((Throwable)wSSException, clsName + ".addAllowedEncryptionMethod", "213", this);
            Tr.error(tc, string2, new Object[]{wSSException});
            throw wSSException;
        }
        this.dataEncryptionMethods.add(string);
    }

    @Override
    public void addAllowedKeyEncryptionMethod(String string) throws WSSException {
        AlgorithmFactory algorithmFactory = WSSUtil.getAlgorithmFactory();
        if (!algorithmFactory.getKeyEncryptionAlgorithms().contains(string)) {
            String string2 = "security.wssecurity.PrivateConsumerConfig.s15";
            WSSException wSSException = WSSException.format(string2, string);
            Tr.processException((Throwable)wSSException, clsName + ".addAllowedKeyEncryptionMethod", "231", this);
            Tr.error(tc, string2, new Object[]{wSSException});
            throw wSSException;
        }
        this.keyEncryptionMethods.add(string);
    }

    @Override
    public void encryptKey(boolean bl) {
        this.encryptKey = bl;
    }

    public List<String> getDataEncrpytionMethods() {
        return this.dataEncryptionMethods;
    }

    public List<String> getKeyEncryptionMethods() {
        return this.keyEncryptionMethods;
    }

    public List<WSSDecryptPart> getDecryptParts() {
        return this.decryptParts;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    public boolean isEncryptKey() {
        return this.encryptKey;
    }

    @Override
    public void addToken(Class clazz, CallbackHandler callbackHandler, String string) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToken(Class tokenClass, CallbackHandler callbackHandler, String loginConfigName)");
        }
        this.token = WSSUtil.newSecurityTokenForConsumer(clazz, callbackHandler, string, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToken(class tokenClass, CallbackHandler callbackHandler, String loginConfigName)");
        }
    }

    @Override
    public void addToken(Class clazz, CallbackHandler callbackHandler) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToken(Class tokenClass, CallbackHandler callbackHandler)");
        }
        this.token = WSSUtil.newSecurityTokenForConsumer(clazz, callbackHandler, null, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToken(Class tokenClass, CallbackHandler callbackHandler)");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[WSSDecryptionImpl:");
        stringBuffer.append(" dataEncryptionMethods: ");
        stringBuffer.append(this.dataEncryptionMethods);
        stringBuffer.append(", keyEncryptionMethods: ");
        stringBuffer.append(this.keyEncryptionMethods);
        stringBuffer.append(", decryptParts: ");
        stringBuffer.append(this.decryptParts);
        stringBuffer.append(", encryptKey: ");
        stringBuffer.append(this.encryptKey);
        stringBuffer.append(", token: ");
        stringBuffer.append(this.token);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

