/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi.dec.impl;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryptPart;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.util.ConfidentialDialectElementSelector;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.AlgorithmParameterData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

public class WSSDecryptPartImpl
implements WSSDecryptPart {
    private static final TraceComponent tc = Tr.register(WSSDecryptPartImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSDecryptPartImpl.class.getName();
    private static final long serialVersionUID = 5579201733361587003L;
    private static final Map<Integer, String> partMap = new HashMap<Integer, String>();
    private SecurityToken token;
    private List<AlgorithmParameterData> transforms = new ArrayList<AlgorithmParameterData>();
    private String dialect = Constants.DIALECT_WAS;
    private String keyword;

    public void addRequiredTransform(String string) throws WSSException {
        String string2 = "security.wssecurity.WSEC7012E";
        WSSException wSSException = WSSException.format(string2, clsName + ".addTransform(String, TransformParameterSpec)");
        Tr.processException((Throwable)wSSException, clsName + ".addAllowedKeyEncryptionMethod", "105", this);
        Tr.error(tc, string2, new Object[]{wSSException});
        throw wSSException;
    }

    public void setRequiredDecryptHeader(QName qName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRequiredDecryptHeader( header)");
        }
        this.dialect = Constants.DIALECT_XPATH;
        this.keyword = "//*[namespace-uri()='" + qName.getNamespaceURI() + "' and local-name()='" + qName.getLocalPart() + "']";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRequiredDecryptHeader( header)");
        }
    }

    public void setRequiredDecryptPart(int n) throws WSSException {
        this.keyword = this.getKeyword(n);
    }

    public void setRequiredDecryptPart(WSSVerification wSSVerification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRequiredDecryptPart(WSSVerification verification");
        }
        this.keyword = ConfidentialDialectElementSelector.WASDIALECTS[3];
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRequiredDecryptPart(WSSVerification verification");
        }
    }

    public void setRequiredDecryptPartByXPath(String string) {
        this.dialect = Constants.DIALECT_XPATH;
        this.keyword = string;
    }

    void setDecrpytHeader(QName qName) {
        this.dialect = Constants.DIALECT_HEADER;
        this.keyword = qName.getNamespaceURI();
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getKeyword(int n) throws WSSException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyword(" + n + ")");
        }
        if ((string = partMap.get(n)) == null) {
            String string2 = "security.wssecurity.WSEC7010E";
            WSSException wSSException = WSSException.format(string2);
            Tr.processException((Throwable)wSSException, clsName + ".getKeyword", "212", this);
            Tr.error(tc, string2, new Object[]{wSSException});
            throw wSSException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyword(" + n + ")");
        }
        return string;
    }

    public SecurityToken getToken() {
        return this.token;
    }

    static {
        partMap.put(51, ConfidentialDialectElementSelector.WASDIALECTS[0]);
        partMap.put(52, ConfidentialDialectElementSelector.WASDIALECTS[1]);
        partMap.put(53, ConfidentialDialectElementSelector.WASDIALECTS[3]);
    }
}

