/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAPropagationToken;
import com.ibm.websphere.wssecurity.wssapi.token.LTPAToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.token.UsernameToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509PKCS7Token;
import com.ibm.websphere.wssecurity.wssapi.token.X509PKIPathToken;
import com.ibm.websphere.wssecurity.wssapi.token.X509Token;
import com.ibm.ws.wssecurity.common.WSSAlgorithmFactory;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.TokenMapping;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.xml.xss4j.AlgorithmFactory;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;

public class WSSUtil {
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSUtil.class.getName();
    private static AlgorithmFactory algorithmFactoryInstance = null;
    private static Map<QName, Class> classMap = new HashMap<QName, Class>();
    private static Map<String, String> tokenMap;

    public static Class getTokenClass(QName qName) {
        return classMap.get(qName);
    }

    public static SecurityToken newSecurityTokenForGnenerator(Class clazz, CallbackHandler callbackHandler, String string, SecurityTokenManagerImpl securityTokenManagerImpl) throws WSSException {
        Object object;
        TokenMapping tokenMapping;
        if (clazz == null) {
            throw WSSException.format("security.wssecurity.WSEC7011E", new String[]{"newSecurityToken"});
        }
        SecurityToken securityToken = null;
        String string2 = clazz.getName();
        String string3 = tokenMap.get(string2);
        if (string3 == null) {
            string3 = string2;
        }
        try {
            securityToken = (SecurityToken)Class.forName(string3).newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.processException(illegalAccessException, clsName + ".processSCT()", "%C");
            throw WSSException.format("security.wssecurity.WSEC7076E", string3, (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Tr.processException(instantiationException, clsName + ".processSCT()", "%C");
            throw WSSException.format("security.wssecurity.WSEC7076E", string3, (Throwable)instantiationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.processException(classNotFoundException, clsName + ".processSCT()", "%C");
            throw WSSException.format("security.wssecurity.WSEC7076E", string3, (Throwable)classNotFoundException);
        }
        if (string == null && (string = (tokenMapping = (object = DefaultValueManager.getInstance().getTokenMapping()).get(securityToken.getValueType())).getJaasLoginConfigNameForGenerator()) == null) {
            throw WSSException.format("security.wssecurity.WSEC7077E");
        }
        object = new SecurityTokenWrapper(securityToken, callbackHandler, string);
        securityTokenManagerImpl.addTokenWrapper((SecurityTokenWrapper)object);
        return securityToken;
    }

    public static SecurityToken newSecurityTokenForConsumer(Class clazz, CallbackHandler callbackHandler, String string, SecurityTokenManagerImpl securityTokenManagerImpl) throws WSSException {
        Object object;
        TokenMapping tokenMapping;
        if (clazz == null) {
            throw WSSException.format("security.wssecurity.WSEC7011E", new String[]{"newSecurityToken"});
        }
        SecurityToken securityToken = null;
        String string2 = clazz.getName();
        String string3 = tokenMap.get(string2);
        if (string3 == null) {
            string3 = string2;
        }
        try {
            securityToken = (SecurityToken)Class.forName(string3).newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.processException(illegalAccessException, clsName + ".processSCT()", "%C");
            throw WSSException.format("security.wssecurity.WSEC7076E", string3, (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Tr.processException(instantiationException, clsName + ".processSCT()", "%C");
            throw WSSException.format("security.wssecurity.WSEC7076E", string3, (Throwable)instantiationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.processException(classNotFoundException, clsName + ".processSCT()", "%C");
            throw WSSException.format("security.wssecurity.WSEC7076E", string3, (Throwable)classNotFoundException);
        }
        if (string == null && (string = (tokenMapping = (object = DefaultValueManager.getInstance().getTokenMapping()).get(securityToken.getValueType())).getJaasLoginConfigNameForConsumer()) == null) {
            throw WSSException.format("security.wssecurity.WSEC7077E");
        }
        object = new SecurityTokenWrapper(securityToken, callbackHandler, string);
        securityTokenManagerImpl.addTokenWrapper((SecurityTokenWrapper)object);
        return securityToken;
    }

    public static AlgorithmFactory getAlgorithmFactory() {
        if (algorithmFactoryInstance == null) {
            algorithmFactoryInstance = WSSAlgorithmFactory.getInstance();
        }
        return algorithmFactoryInstance;
    }

    static {
        classMap.put(X509Token.ValueType, X509Token.class);
        classMap.put(UsernameToken.ValueType, UsernameToken.class);
        classMap.put(X509PKCS7Token.ValueType, X509PKCS7Token.class);
        classMap.put(X509PKIPathToken.ValueType, X509PKIPathToken.class);
        classMap.put(LTPAToken.ValueType, LTPAToken.class);
        classMap.put(LTPAPropagationToken.ValueType, LTPAPropagationToken.class);
        classMap.put(SecurityContextToken.ValueType, SecurityContextToken.class);
        tokenMap = new HashMap<String, String>();
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.UsernameToken", "com.ibm.ws.wssecurity.wssapi.token.impl.UsernameTokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.X509Token", "com.ibm.ws.wssecurity.wssapi.token.impl.X509TokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.X509PKCS7Token", "com.ibm.ws.wssecurity.wssapi.token.impl.X509PKCS7TokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.X509PKIPathToken", "com.ibm.ws.wssecurity.wssapi.token.impl.X509PKIPathTokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.LTPAToken", "com.ibm.ws.wssecurity.wssapi.token.impl.LTPATokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.LTPAPropagationToken", "com.ibm.ws.wssecurity.wssapi.token.impl.LTPAPropagationTokenImpl");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.DerivedKeyToken", "com.ibm.ws.wssecurity.wssapi.token.impl.DKToken");
        tokenMap.put("com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken", "com.ibm.ws.wssecurity.wssapi.token.impl.SCTWrapper");
    }
}

