/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSTimestamp;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryption;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignature;
import com.ibm.websphere.wssecurity.wssapi.spec.TransformParameterSpec;
import com.ibm.websphere.wssecurity.wssapi.spec.XPathFilter2ParameterSpec;
import com.ibm.websphere.wssecurity.wssapi.spec.XPathType;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.config.ReferencePartConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateGeneratorConfig;
import com.ibm.ws.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.core.token.TokenGeneratorComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.AlgorithmParameterData;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.TokenMapping;
import com.ibm.ws.wssecurity.wssapi.WSSTimestampImpl;
import com.ibm.ws.wssecurity.wssapi.enc.impl.WSSEncryptPartImpl;
import com.ibm.ws.wssecurity.wssapi.enc.impl.WSSEncryptionImpl;
import com.ibm.ws.wssecurity.wssapi.sig.impl.WSSSignPartImpl;
import com.ibm.ws.wssecurity.wssapi.sig.impl.WSSSignatureImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.Generatable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.wsspi.wssecurity.core.Constants;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSOutboundConfig
extends PrivateGeneratorConfig {
    private static final TraceComponent tc = Tr.register(WSSOutboundConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String COMMON_KEYINFO_CONTENT_GENERATOR = "com.ibm.ws.wssecurity.wssapi.CommonContentGenerator";
    private static final String COMMON_TOKEN_GENERATOR = "com.ibm.ws.wssecurity.wssapi.token.impl.CommonTokenGenerator";
    private Map<SecurityToken, PrivateGeneratorConfig.TokenGeneratorConfImpl> tokenGeneratorMap = new HashMap<SecurityToken, PrivateGeneratorConfig.TokenGeneratorConfImpl>();
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSOutboundConfig(SecurityTokenManagerImpl securityTokenManagerImpl) {
        this._properties = new HashMap();
        this.securityTokenManager = securityTokenManagerImpl;
        try {
            try {
                this._nonceManager = AccessController.doPrivileged(new PrivilegedExceptionAction<NonceManager>(){

                    @Override
                    public NonceManager run() throws SoapSecurityException {
                        return NonceManagerFactory.getInstance();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof SoapSecurityException) {
                    throw (SoapSecurityException)throwable;
                }
                throw new SoapSecurityException(throwable.getMessage());
            }
        }
        catch (SoapSecurityException soapSecurityException) {
            this._nonceManager = null;
        }
    }

    public void process(Generatable generatable) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "process(Generatable generatable)");
        }
        if (generatable instanceof SecurityTokenWrapper) {
            this.setTokenWrapper((SecurityTokenWrapper)generatable);
        } else if (generatable instanceof WSSSignature) {
            this.setSignature((WSSSignature)((Object)generatable));
        } else if (generatable instanceof WSSEncryption) {
            this.setEncryption((WSSEncryption)((Object)generatable));
        } else if (generatable instanceof WSSTimestamp) {
            this.setTimeStamp((WSSTimestamp)((Object)generatable), false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "process(Generatable)");
        }
    }

    public void setActor(String string) {
        this._targetActor = string;
    }

    public void setTimeStamp(WSSTimestamp wSSTimestamp, boolean bl) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTimeStamp(WSSTimestamp wssTimestamp, " + bl + ")");
        }
        this._timestampGenerator = new PrivateGeneratorConfig.TimestampGeneratorConfImpl();
        this._timestampGenerator._duration = ((WSSTimestampImpl)wSSTimestamp).getDuration();
        this._timestampEnabled = true;
        this._timestampGenerator.setToBeSigned(bl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTimeStamp(WSSTimestamp, " + bl + ")");
        }
    }

    public void setTokenWrapper(SecurityTokenWrapper securityTokenWrapper) throws WSSException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenWrapper(SecurityTokenWrapper tokenWrapper)");
        }
        QName qName = securityTokenWrapper.getValueType();
        String string = securityTokenWrapper.getWssapiLoginConfigName();
        if (string == null && (string = ((TokenMapping)(object2 = (object = DefaultValueManager.getInstance().getTokenMapping()).get(qName))).getJaasLoginConfigNameForGenerator()) == null) {
            throw WSSException.format("security.wssecurity.WSEC7077E");
        }
        object = this.createTokenGeneratorConfig(qName, string, securityTokenWrapper.getWssapiCallbackHandler());
        object2 = securityTokenWrapper.getSecurityToken();
        if (!this.tokenGeneratorMap.containsKey(object2)) {
            this.tokenGeneratorMap.put((SecurityToken)object2, (PrivateGeneratorConfig.TokenGeneratorConfImpl)object);
        }
        this._tokenGenerators.add(object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTokenWrapper(SecurityTokenWrapper)");
        }
    }

    public void setSignature(WSSSignature wSSSignature) throws WSSException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object6;
        List<Integer> list;
        WSSSignatureImpl wSSSignatureImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSignature(WSSSignature signature)");
        }
        if ((wSSSignatureImpl = (WSSSignatureImpl)wSSSignature).isSignatureConfirmation()) {
            this._signatureConfirmationRequired = true;
            this._request = wSSSignatureImpl.isRequiredSignatureConfirmation();
        }
        if (wSSSignatureImpl.getSignedParts().size() == 0) {
            list = DefaultValueManager.getInstance().getSignParts();
            object6 = list.iterator();
            while (object6.hasNext()) {
                int n = object6.next();
                if (n == 23) {
                    this.setTimeStamp(new WSSTimestampImpl(), true);
                }
                wSSSignature.addSignPart(n);
            }
        }
        list = new ArrayList<Integer>();
        object6 = null;
        for (WSSSignPartImpl object52 : wSSSignatureImpl.getSignedParts()) {
            if (object52.getKeyword().equals("timestamp")) {
                if (this._timestampGenerator == null) {
                    this.setTimeStamp(new WSSTimestampImpl(), true);
                }
                this._timestampGenerator.setToBeSigned(true);
            }
            if ((object4 = object52.getToken()) != null && (object6 = this.tokenGeneratorMap.get(object4)) == null) {
                Map<QName, TokenMapping> map;
                TokenMapping tokenMapping;
                object3 = this.securityTokenManager.getTokenWrapper((SecurityToken)object4);
                object2 = ((SecurityTokenWrapper)object3).getValueType();
                object = ((SecurityTokenWrapper)object3).getWssapiLoginConfigName();
                if (object == null && (object = (tokenMapping = (map = DefaultValueManager.getInstance().getTokenMapping()).get(object2)).getJaasLoginConfigNameForGenerator()) == null) {
                    throw WSSException.format("security.wssecurity.WSEC7077E");
                }
                object6 = this.createTokenGeneratorConfig((QName)object2, (String)object, ((SecurityTokenWrapper)object3).getWssapiCallbackHandler());
                this._tokenGenerators.add(object6);
                this.tokenGeneratorMap.put((SecurityToken)object4, (PrivateGeneratorConfig.TokenGeneratorConfImpl)object6);
                ((PrivateGeneratorConfig.TokenGeneratorConfImpl)object6)._standAlone = false;
                ((PrivateGeneratorConfig.TokenGeneratorConfImpl)object6)._usedForSignature = true;
            }
            object3 = new PrivateCommonConfig.SigningReferenceConfImpl();
            ((PrivateCommonConfig.SigningReferenceConfImpl)object3)._digestMethod = this.createAlgorithmConfig(object52.getDigestMethod());
            ((PrivateCommonConfig.SigningReferenceConfImpl)object3).getTransforms().addAll(this.createTransforms(object52.getTransforms()));
            object2 = new PrivateCommonConfig.ReferencePartConfImpl();
            object = this.createPartConfig(object52.getDialect(), object52.getKeyword());
            ((PrivateCommonConfig.ReferencePartConfImpl)object2).getParts().add((ReferencePartConfig.PartConfig)object);
            ((PrivateCommonConfig.SigningReferenceConfImpl)object3)._reference = object2;
            list.add((Integer)object3);
        }
        SecurityToken securityToken = wSSSignatureImpl.getToken();
        if (securityToken != null && (object6 = this.tokenGeneratorMap.get(securityToken)) == null) {
            SecurityTokenWrapper securityTokenWrapper = this.securityTokenManager.getTokenWrapper(securityToken);
            object4 = securityTokenWrapper.getValueType();
            object3 = securityTokenWrapper.getWssapiLoginConfigName();
            if (object3 == null && (object3 = ((TokenMapping)(object = (TokenMapping)(object2 = DefaultValueManager.getInstance().getTokenMapping()).get(object4))).getJaasLoginConfigNameForGenerator()) == null) {
                throw WSSException.format("security.wssecurity.WSEC7077E");
            }
            object6 = this.createTokenGeneratorConfig((QName)object4, (String)object3, securityTokenWrapper.getWssapiCallbackHandler());
            this._tokenGenerators.add(object6);
            this.tokenGeneratorMap.put(securityToken, (PrivateGeneratorConfig.TokenGeneratorConfImpl)object6);
            ((PrivateGeneratorConfig.TokenGeneratorConfImpl)object6)._standAlone = false;
            ((PrivateGeneratorConfig.TokenGeneratorConfImpl)object6)._usedForSignature = true;
        }
        PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl keyInfoContentGeneratorConfImpl = this.createkeyInfoContentGeneratorConfig(wSSSignatureImpl.getTokenReferenceByStr(), (PrivateGeneratorConfig.TokenGeneratorConfImpl)object6);
        object4 = this.createKeyInfoGeneratorConfig(keyInfoContentGeneratorConfImpl);
        object3 = this.createSignatureGeneratorConfig(wSSSignatureImpl, (PrivateGeneratorConfig.KeyInfoGeneratorConfImpl)object4, list);
        this._signatureEnabled = true;
        this._operationGenerators.add(object3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSignature(WSSSignature)");
        }
    }

    private String getTokenReference(WSSEncryptionImpl wSSEncryptionImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTokenReference(WSSEncryptionImpl encryptionImpl)");
        }
        String string = wSSEncryptionImpl.getTokenReferenceByStr();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTokenReference(WSSEncryptionImpl)");
        }
        return string;
    }

    public void setEncryption(WSSEncryption wSSEncryption) throws WSSException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEncryption(WSSEncryption encryption)");
        }
        WSSEncryptionImpl wSSEncryptionImpl = (WSSEncryptionImpl)wSSEncryption;
        PrivateCommonConfig.ReferencePartConfImpl referencePartConfImpl = new PrivateCommonConfig.ReferencePartConfImpl();
        if (wSSEncryptionImpl.getEncryptParts().size() == 0) {
            object6 = DefaultValueManager.getInstance().getEncryptionParts();
            object5 = object6.iterator();
            while (object5.hasNext()) {
                int n = (Integer)object5.next();
                wSSEncryption.addEncryptPart(n);
            }
        }
        object6 = null;
        for (SecurityToken securityToken : wSSEncryptionImpl.getTokensToBeEncrypted()) {
            TokenMapping tokenMapping;
            if (securityToken == null || (object6 = this.tokenGeneratorMap.get(securityToken)) != null) continue;
            object4 = this.securityTokenManager.getTokenWrapper(securityToken);
            object3 = ((SecurityTokenWrapper)object4).getValueType();
            object2 = ((SecurityTokenWrapper)object4).getWssapiLoginConfigName();
            if (object2 == null && (object2 = (tokenMapping = (object = DefaultValueManager.getInstance().getTokenMapping()).get(object3)).getJaasLoginConfigNameForGenerator()) == null) {
                throw WSSException.format("security.wssecurity.WSEC7077E");
            }
            object6 = this.createTokenGeneratorConfig((QName)object3, (String)object2, ((SecurityTokenWrapper)object4).getWssapiCallbackHandler());
            this._tokenGenerators.add(object6);
            this.tokenGeneratorMap.put(securityToken, (PrivateGeneratorConfig.TokenGeneratorConfImpl)object6);
        }
        for (WSSEncryptPartImpl wSSEncryptPartImpl : wSSEncryptionImpl.getEncryptParts()) {
            object4 = this.createPartConfig(wSSEncryptPartImpl.getDialect(), wSSEncryptPartImpl.getKeyword());
            referencePartConfImpl.getParts().add((ReferencePartConfig.PartConfig)object4);
        }
        object5 = wSSEncryptionImpl.getToken();
        if (object5 != null && (object6 = this.tokenGeneratorMap.get(object5)) == null) {
            SecurityTokenWrapper securityTokenWrapper = this.securityTokenManager.getTokenWrapper((SecurityToken)object5);
            object4 = securityTokenWrapper.getValueType();
            object3 = securityTokenWrapper.getWssapiLoginConfigName();
            if (object3 == null && (object3 = ((TokenMapping)(object = (TokenMapping)(object2 = DefaultValueManager.getInstance().getTokenMapping()).get(object4))).getJaasLoginConfigNameForGenerator()) == null) {
                throw WSSException.format("security.wssecurity.WSEC7077E");
            }
            object6 = this.createTokenGeneratorConfig((QName)object4, (String)object3, securityTokenWrapper.getWssapiCallbackHandler());
            this._tokenGenerators.add(object6);
            this.tokenGeneratorMap.put((SecurityToken)object5, (PrivateGeneratorConfig.TokenGeneratorConfImpl)object6);
            ((PrivateGeneratorConfig.TokenGeneratorConfImpl)object6)._standAlone = false;
            ((PrivateGeneratorConfig.TokenGeneratorConfImpl)object6)._usedForEncryption = true;
        }
        PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl keyInfoContentGeneratorConfImpl = this.createkeyInfoContentGeneratorConfig(this.getTokenReference(wSSEncryptionImpl), (PrivateGeneratorConfig.TokenGeneratorConfImpl)object6);
        object4 = this.createKeyInfoGeneratorConfig(keyInfoContentGeneratorConfImpl);
        object3 = this.createEncryptionGeneratorConfig(wSSEncryptionImpl, (PrivateGeneratorConfig.KeyInfoGeneratorConfImpl)object4, referencePartConfImpl);
        this._encryptionEnabled = true;
        this._operationGenerators.add(object3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEncryption(WSSEncryption encryption)");
        }
    }

    private List<PrivateCommonConfig.AlgorithmConfImpl> createTransforms(List<AlgorithmParameterData> list) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTransforms(List<AlgorithmParameterData> transforms)");
        }
        ArrayList<PrivateCommonConfig.AlgorithmConfImpl> arrayList = new ArrayList<PrivateCommonConfig.AlgorithmConfImpl>();
        if (list.size() == 0) {
            List<String> list2 = DefaultValueManager.getInstance().getTransformMethodsForSignature();
            if (list2 != null) {
                Iterator<String> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(this.createAlgorithmConfig(iterator.next()));
                }
            }
        } else {
            for (AlgorithmParameterData algorithmParameterData : list) {
                arrayList.add(this.createAlgorithmConfig(algorithmParameterData));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTransforms(List<AlgorithmParameterData> transforms)");
        }
        return arrayList;
    }

    private PrivateCommonConfig.PartConfImpl createPartConfig(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPartConfig(String dialect, String keyword)");
        }
        PrivateCommonConfig.PartConfImpl partConfImpl = new PrivateCommonConfig.PartConfImpl();
        partConfImpl._dialect = string;
        if (string.equals(com.ibm.ws.wssecurity.common.Constants.DIALECT_HEADER)) {
            partConfImpl._headerNamespace = string2;
        } else {
            partConfImpl._keyword = string2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPartConfig(String dialect, String keyword)");
        }
        return partConfImpl;
    }

    private PrivateCommonConfig.AlgorithmConfImpl createAlgorithmConfig(String string) {
        PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
        algorithmConfImpl._algorithm = string;
        return algorithmConfImpl;
    }

    private PrivateCommonConfig.AlgorithmConfImpl createAlgorithmConfig(AlgorithmParameterData algorithmParameterData) throws WSSException {
        PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
        algorithmConfImpl._algorithm = algorithmParameterData.getAlgorithm();
        this.getAlgorithm(algorithmConfImpl, algorithmParameterData.getSpec());
        return algorithmConfImpl;
    }

    private void getAlgorithm(PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl, TransformParameterSpec transformParameterSpec) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAlgorithm(AlgorithmConfImpl algorithmConf, TransformParameterSpec spec)");
        }
        if (transformParameterSpec instanceof XPathFilter2ParameterSpec) {
            XPathFilter2ParameterSpec xPathFilter2ParameterSpec = (XPathFilter2ParameterSpec)transformParameterSpec;
            int n = 0;
            for (XPathType xPathType : xPathFilter2ParameterSpec.getXPathList()) {
                algorithmConfImpl._properties.put(Constants.WSSECURITY_XPATH2_ORDER + "_" + n, Integer.toString(n));
                algorithmConfImpl._properties.put(Constants.WSSECURITY_XPATH2_FILTER + "_" + n, xPathType.getFilter().toString());
                String string = xPathType.getExpression();
                if (xPathType.getNamespaceMap() != null) {
                    String string2 = this.getPrefix(string);
                    String string3 = (String)xPathType.getNamespaceMap().get(string2);
                    if (string3 != null) {
                        algorithmConfImpl._properties.put(Constants.WSSECURITY_XPATH2_EXPRESSION + "_" + n, this.convertExpression(string, string3));
                    } else {
                        algorithmConfImpl._properties.put(Constants.WSSECURITY_XPATH2_EXPRESSION + "_" + n, string);
                    }
                } else {
                    algorithmConfImpl._properties.put(Constants.WSSECURITY_XPATH2_EXPRESSION + "_" + n, string);
                }
                ++n;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAlgorithm(AlgorithmConfImpl algorithmConf, TransformParameterSpec spec)");
        }
    }

    private String convertExpression(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertExpression(" + string + "," + string2 + ")");
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertExpression(" + string + "," + string2 + ")");
            }
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("//*[namespace-uri()='");
        stringBuffer.append(string2 + "' and local-name()='");
        StringBuffer stringBuffer2 = new StringBuffer(string);
        int n = stringBuffer2.indexOf("//");
        if (n == -1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertExpression(" + string + "," + string2 + ")");
            }
            return null;
        }
        int n2 = stringBuffer2.indexOf(":");
        if (n2 == -1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "convertExpression(" + string + "," + string2 + ")");
            }
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertExpression(" + string + "," + string2 + ")");
        }
        return stringBuffer.append(stringBuffer2.substring(n2 + 1) + "']").toString();
    }

    private String getPrefix(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrefix(" + string + ")");
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPrefix(" + string + ")");
            }
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.indexOf("//");
        if (n == -1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPrefix(" + string + ")");
            }
            return null;
        }
        int n2 = stringBuffer.indexOf(":");
        if (n2 == -1) {
            int n3 = stringBuffer.length();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPrefix(" + string + ")");
            }
            return stringBuffer.substring(n + 2, n3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrefix(" + string + ")");
        }
        return stringBuffer.substring(n + 2, n2);
    }

    private PrivateGeneratorConfig.TokenGeneratorConfImpl createTokenGeneratorConfig(QName qName, String string, CallbackHandler callbackHandler) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            object2 = new StringBuffer("createTokenGeneratorConfig(");
            ((StringBuffer)object2).append("QName valueType[").append(qName).append("], ");
            ((StringBuffer)object2).append("String loginConfigName[").append(string).append("], ");
            ((StringBuffer)object2).append("CallbackHandler callbackHandler)");
            Tr.entry(tc, ((StringBuffer)object2).toString());
        }
        object2 = new PrivateGeneratorConfig.TokenGeneratorConfImpl();
        ((PrivateGeneratorConfig.TokenGeneratorConfImpl)object2)._className = COMMON_TOKEN_GENERATOR;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
        hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", ((PrivateGeneratorConfig.TokenGeneratorConfImpl)object2)._className);
        try {
            object = WSSFactory.getInstance("soap");
            ((PrivateGeneratorConfig.TokenGeneratorConfImpl)object2)._instance = (TokenGeneratorComponent)((WSSFactory)object).createGenerator(hashMap, hashMap2);
        }
        catch (SoapSecurityException soapSecurityException) {
            soapSecurityException.printStackTrace();
        }
        ((PrivateGeneratorConfig.TokenGeneratorConfImpl)object2)._type = qName;
        ((PrivateGeneratorConfig.TokenGeneratorConfImpl)object2)._standAlone = true;
        ((PrivateGeneratorConfig.TokenGeneratorConfImpl)object2)._usedForSignature = false;
        ((PrivateGeneratorConfig.TokenGeneratorConfImpl)object2)._usedForEncryption = false;
        ((PrivateGeneratorConfig.TokenGeneratorConfImpl)object2)._jaasConfig = string;
        object = new PrivateCommonConfig.CallbackHandlerConfImpl();
        ((PrivateCommonConfig.CallbackHandlerConfImpl)object)._className = callbackHandler.getClass().getName();
        ((PrivateCommonConfig.CallbackHandlerConfImpl)object)._instance = callbackHandler;
        ((PrivateGeneratorConfig.TokenGeneratorConfImpl)object2)._callbackHandler = object;
        this._tokenEnabled = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTokenGeneratorConfig(QName, String, CallbackHandler)");
        }
        return object2;
    }

    private PrivateGeneratorConfig.EncryptionGeneratorConfImpl createEncryptionGeneratorConfig(WSSEncryptionImpl wSSEncryptionImpl, PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfoGeneratorConfImpl, PrivateCommonConfig.ReferencePartConfImpl referencePartConfImpl) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("createEncryptionGeneratorConfig(");
            ((StringBuffer)object).append("WSSEncryptionImpl encryptionImpl, ");
            ((StringBuffer)object).append("KeyInfoGeneratorConfImpl keyInfoGeneratorConfig, ");
            ((StringBuffer)object).append("ReferencePartConfImpl referencePartConfig)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = new PrivateGeneratorConfig.EncryptionGeneratorConfImpl();
        boolean bl = wSSEncryptionImpl.isEncryptKey();
        ((PrivateGeneratorConfig.EncryptionGeneratorConfImpl)object)._dataEncryptionMethod = this.createAlgorithmConfig(wSSEncryptionImpl.getEncryptionMethod());
        ((PrivateGeneratorConfig.EncryptionGeneratorConfImpl)object)._keyEncryptionMethod = bl ? this.createAlgorithmConfig(wSSEncryptionImpl.getKeyEncryptionMethod()) : null;
        ((PrivateGeneratorConfig.EncryptionGeneratorConfImpl)object)._encryptionKeyInfo = keyInfoGeneratorConfImpl;
        ((PrivateGeneratorConfig.EncryptionGeneratorConfImpl)object)._reference = referencePartConfImpl;
        boolean bl2 = wSSEncryptionImpl.isOptimized();
        if (bl2) {
            ((PrivateGeneratorConfig.EncryptionGeneratorConfImpl)object)._properties.put(Constants.WSSECURITY_MTOM_OPTIMIZE_ENCRYPTED_DATA, "true");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createEncryptionGeneratorConfig(WSSEncryptionImpl, KeyInfoGeneratorConfImpl, ReferencePartConfImpl)");
        }
        return object;
    }

    private PrivateGeneratorConfig.SignatureGeneratorConfImpl createSignatureGeneratorConfig(WSSSignatureImpl wSSSignatureImpl, PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfoGeneratorConfImpl, List<PrivateCommonConfig.SigningReferenceConfImpl> list) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("createSignatureGeneratorConfig(");
            ((StringBuffer)object).append("WSSSignatureImpl signatureImpl, ");
            ((StringBuffer)object).append("KeyInfoGeneratorConfImpl keyInfoGeneratorConfig, ");
            ((StringBuffer)object).append("List references)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = new PrivateGeneratorConfig.SignatureGeneratorConfImpl();
        ((PrivateGeneratorConfig.SignatureGeneratorConfImpl)object)._canonicalizationMethod = this.createAlgorithmConfig(wSSSignatureImpl.getCanonicalizationMethod());
        ((PrivateGeneratorConfig.SignatureGeneratorConfImpl)object)._signatureMethod = this.createAlgorithmConfig(wSSSignatureImpl.getSignatureMethod());
        ((PrivateGeneratorConfig.SignatureGeneratorConfImpl)object)._signingKeyInfo = keyInfoGeneratorConfImpl;
        ((PrivateGeneratorConfig.SignatureGeneratorConfImpl)object)._references.addAll(list);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSignatureGeneratorConfig(WSSSignatureImpl, KeyInfoGeneratorConfImpl, List)");
        }
        return object;
    }

    private PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl createkeyInfoContentGeneratorConfig(String string, PrivateGeneratorConfig.TokenGeneratorConfImpl tokenGeneratorConfImpl) {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("createkeyInfoContentGeneratorConfig(");
            ((StringBuffer)object).append("String tokenReference[").append(string).append("], ");
            ((StringBuffer)object).append("TokenGeneratorConfImpl tokenGeneratorConfig)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = new PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl();
        ((PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)object)._className = COMMON_KEYINFO_CONTENT_GENERATOR;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
        hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", ((PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)object)._className);
        try {
            WSSFactory wSSFactory = WSSFactory.getInstance("soap");
            ((PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)object)._instance = (KeyInfoContentGeneratorComponent)wSSFactory.createGenerator(hashMap, hashMap2);
        }
        catch (SoapSecurityException soapSecurityException) {
            soapSecurityException.printStackTrace();
        }
        ((PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)object)._keyInfoType = string;
        ((PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl)object)._tokenGenerator = tokenGeneratorConfImpl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createkeyInfoContentGeneratorConfig(String, TokenGeneratorConfImpl) ");
        }
        return object;
    }

    private PrivateGeneratorConfig.KeyInfoGeneratorConfImpl createKeyInfoGeneratorConfig(PrivateGeneratorConfig.KeyInfoContentGeneratorConfImpl keyInfoContentGeneratorConfImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createKeyInfoGeneratorConfig(KeyInfoContentGeneratorConfig keyInfoContentGeneratorConfig)");
        }
        PrivateGeneratorConfig.KeyInfoGeneratorConfImpl keyInfoGeneratorConfImpl = new PrivateGeneratorConfig.KeyInfoGeneratorConfImpl();
        keyInfoGeneratorConfImpl._contentGenerator = keyInfoContentGeneratorConfImpl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKeyInfoGeneratorConfig(KeyInfoContentGeneratorConfImpl)");
        }
        return keyInfoGeneratorConfImpl;
    }
}

