/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSTimestamp;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryption;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import com.ibm.ws.wssecurity.common.Constants;
import com.ibm.ws.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.wssecurity.config.SigningReferenceConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateCommonConfig;
import com.ibm.ws.wssecurity.confimpl.PrivateConsumerConfig;
import com.ibm.ws.wssecurity.core.NonceManagerFactory;
import com.ibm.ws.wssecurity.core.WSSFactory;
import com.ibm.ws.wssecurity.core.token.TokenConsumerComponent;
import com.ibm.ws.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.wssecurity.token.NonceManager;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.AlgorithmParameterData;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.dec.impl.WSSDecryptPartImpl;
import com.ibm.ws.wssecurity.wssapi.dec.impl.WSSDecryptionImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.Consumable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.wssapi.verify.impl.WSSVerificationImpl;
import com.ibm.ws.wssecurity.wssapi.verify.impl.WSSVerifyPartImpl;
import com.ibm.wsspi.wssecurity.core.SoapSecurityException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSInboundConfig
extends PrivateConsumerConfig {
    private static final TraceComponent tc = Tr.register(WSSInboundConfig.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String COMMON_KEYINFO_CONTENT_CONSUMER = "com.ibm.ws.wssecurity.wssapi.CommonContentConsumer";
    private static final String COMMON_TOKEN_CONSUMER = "com.ibm.ws.wssecurity.wssapi.token.impl.CommonTokenConsumer";
    private Map<SecurityToken, PrivateConsumerConfig.TokenConsumerConfImpl> tokenConsumerMap = new HashMap<SecurityToken, PrivateConsumerConfig.TokenConsumerConfImpl>();
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSInboundConfig(SecurityTokenManagerImpl securityTokenManagerImpl) {
        this._properties = new HashMap();
        this.securityTokenManager = securityTokenManagerImpl;
        try {
            try {
                this._nonceManager = AccessController.doPrivileged(new PrivilegedExceptionAction<NonceManager>(){

                    @Override
                    public NonceManager run() throws SoapSecurityException {
                        return NonceManagerFactory.getInstance();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof SoapSecurityException) {
                    throw (SoapSecurityException)throwable;
                }
                throw new SoapSecurityException(throwable.getMessage());
            }
        }
        catch (SoapSecurityException soapSecurityException) {
            this._nonceManager = null;
        }
    }

    public void setActor(String string) {
        this._myActor = string;
    }

    public void setTimeStamp() {
        this._timestampConsumer = new PrivateConsumerConfig.TimestampConsumerConfImpl();
        this._timestampRequired = true;
    }

    public void process(Consumable consumable, WSSConsumingContext wSSConsumingContext) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "process(Consumable consumable, WSSConsumingContext context)");
        }
        if (consumable instanceof SecurityTokenWrapper) {
            this.setTokenWrapper((SecurityTokenWrapper)consumable);
        } else if (consumable instanceof WSSDecryption) {
            this.setDecryption((WSSDecryption)((Object)consumable), wSSConsumingContext);
        } else if (consumable instanceof WSSVerification) {
            this.setVerification((WSSVerification)((Object)consumable), wSSConsumingContext);
        } else if (consumable instanceof WSSTimestamp) {
            this.setTimeStamp();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "process(Consumable, WSSConsumingContext)");
        }
    }

    public void setTokenWrapper(SecurityTokenWrapper securityTokenWrapper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTokenWrapper(SecurityTokenWrapper tokenWrapper)");
        }
        PrivateConsumerConfig.TokenConsumerConfImpl tokenConsumerConfImpl = this.createTokenConsumerConfig(securityTokenWrapper.getValueType(), securityTokenWrapper.getWssapiLoginConfigName(), securityTokenWrapper.getWssapiCallbackHandler());
        SecurityToken securityToken = securityTokenWrapper.getSecurityToken();
        this._tokenConsumers.add(tokenConsumerConfImpl);
        if (!this.tokenConsumerMap.containsKey(securityToken)) {
            this.tokenConsumerMap.put(securityToken, tokenConsumerConfImpl);
        }
        this._requiredSecurityTokens.add(tokenConsumerConfImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTokenWrapper(SecurityTokenWrapper)");
        }
    }

    public void setVerification(WSSVerification wSSVerification, WSSConsumingContext wSSConsumingContext) throws WSSException {
        Object object;
        Object object2;
        WSSVerificationImpl wSSVerificationImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setVerification(WSSVerification verfication, WSSConsumingContext context");
        }
        if ((wSSVerificationImpl = (WSSVerificationImpl)wSSVerification).isSignatureConfirmation()) {
            this._signatureConfirmationRequired = true;
            this._request = wSSVerificationImpl.isRequriredSignatureConfirmation();
        }
        if (wSSVerificationImpl.getCanonicalizationMethods().size() == 0) {
            object2 = DefaultValueManager.getInstance().getAllowedCanonicalizationMethods();
            object = object2.iterator();
            while (object.hasNext()) {
                wSSVerification.addAllowedCanonicalizationMethod(object.next());
            }
            this._allowedCanonicalizationMethods.addAll(object2);
        } else {
            this._allowedCanonicalizationMethods.addAll(wSSVerificationImpl.getCanonicalizationMethods());
        }
        if (wSSVerificationImpl.getSignatureMethods().size() == 0) {
            object2 = DefaultValueManager.getInstance().getAllowedSignatureMethods();
            object = object2.iterator();
            while (object.hasNext()) {
                wSSVerification.addAllowedSignatureMethod(object.next());
            }
            this._allowedSignatureMethods.addAll(object2);
        } else {
            this._allowedSignatureMethods.addAll(wSSVerificationImpl.getSignatureMethods());
        }
        object2 = wSSVerificationImpl.getCanonicalizationMethods().iterator();
        while (object2.hasNext()) {
            object = new PrivateConsumerConfig.SignatureConsumerConfImpl();
            ((PrivateConsumerConfig.SignatureConsumerConfImpl)object)._canonicalizationMethod = this.createAlgorithmConfig((String)object2.next());
            Iterator<String> iterator = wSSVerificationImpl.getSignatureMethods().iterator();
            while (iterator.hasNext()) {
                Object object3;
                Object object4;
                PrivateConsumerConfig.KeyInfoConsumerConfImpl keyInfoConsumerConfImpl;
                Object object5;
                ((PrivateConsumerConfig.SignatureConsumerConfImpl)object)._signatureMethod = this.createAlgorithmConfig(iterator.next());
                SecurityToken securityToken = wSSVerificationImpl.getToken();
                PrivateConsumerConfig.TokenConsumerConfImpl tokenConsumerConfImpl = this.tokenConsumerMap.get(securityToken);
                if (tokenConsumerConfImpl == null) {
                    object5 = this.securityTokenManager.getTokenWrapper(securityToken);
                    tokenConsumerConfImpl = this.createTokenConsumerConfig(((SecurityTokenWrapper)object5).getValueType(), ((SecurityTokenWrapper)object5).getWssapiLoginConfigName(), ((SecurityTokenWrapper)object5).getWssapiCallbackHandler());
                    this.tokenConsumerMap.put(securityToken, tokenConsumerConfImpl);
                    this._tokenConsumers.add(tokenConsumerConfImpl);
                } else {
                    this._requiredSecurityTokens.remove(tokenConsumerConfImpl);
                }
                tokenConsumerConfImpl._usedForVerification = true;
                object5 = this.createKeyInfoContentConsumerConfig(tokenConsumerConfImpl);
                ArrayList<KeyInfoContentConsumerConfig> arrayList = new ArrayList<KeyInfoContentConsumerConfig>();
                arrayList.add((KeyInfoContentConsumerConfig)object5);
                ((PrivateConsumerConfig.SignatureConsumerConfImpl)object)._signingKeyInfo = keyInfoConsumerConfImpl = this.createKeyInfoConsumerConfig(arrayList);
                if (((WSSVerificationImpl)wSSVerification).getVerifyParts().size() == 0 && (object4 = DefaultValueManager.getInstance().getVerifyParts()) != null) {
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        wSSVerification.addRequiredVerifyPart((Integer)object3.next());
                    }
                }
                object4 = wSSVerificationImpl.getVerifyParts().iterator();
                while (object4.hasNext()) {
                    Iterator<Object> iterator2;
                    List<AlgorithmParameterData> list;
                    object3 = (WSSVerifyPartImpl)object4.next();
                    if (((WSSVerifyPartImpl)object3).getDigestMethods().size() == 0) {
                        ((WSSVerifyPartImpl)object3).addAllowedDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
                        this._allowedDigestMethods.add("http://www.w3.org/2000/09/xmldsig#sha1");
                    } else {
                        this._allowedDigestMethods.addAll(((WSSVerifyPartImpl)object3).getDigestMethods());
                    }
                    if (((WSSVerifyPartImpl)object3).getTransforms().size() == 0) {
                        list = DefaultValueManager.getInstance().getTransformMethodsForVerification();
                        iterator2 = list.iterator();
                        while (iterator2.hasNext()) {
                            ((WSSVerifyPartImpl)object3).addAllowedTransform((String)iterator2.next());
                        }
                        this._allowedTransforms.addAll(list);
                    } else {
                        list = ((WSSVerifyPartImpl)object3).getTransforms();
                        if (list != null) {
                            iterator2 = list.iterator();
                            while (iterator2.hasNext()) {
                                this._allowedTransforms.add(((AlgorithmParameterData)iterator2.next()).getAlgorithm());
                            }
                        }
                    }
                    list = new PrivateCommonConfig.SigningReferenceConfImpl();
                    for (String string : ((WSSVerifyPartImpl)object3).getDigestMethods()) {
                        ((PrivateCommonConfig.SigningReferenceConfImpl)((Object)list))._digestMethod = this.createAlgorithmConfig(string);
                        ((PrivateCommonConfig.SigningReferenceConfImpl)((Object)list)).getTransforms().addAll(this.createTransforms(((WSSVerifyPartImpl)object3).getTransforms()));
                        PrivateCommonConfig.ReferencePartConfImpl referencePartConfImpl = new PrivateCommonConfig.ReferencePartConfImpl();
                        PrivateCommonConfig.PartConfImpl partConfImpl = this.createPartConfig(((WSSVerifyPartImpl)object3).getDialect(), ((WSSVerifyPartImpl)object3).getKeyword());
                        referencePartConfImpl.getParts().add(partConfImpl);
                        ((PrivateCommonConfig.SigningReferenceConfImpl)((Object)list))._reference = referencePartConfImpl;
                        ((PrivateConsumerConfig.SignatureConsumerConfImpl)object).getReferences().add((SigningReferenceConfig)((Object)list));
                    }
                }
            }
            this._requiredIntegralParts.addAll(this.getIntegralParts(((PrivateConsumerConfig.SignatureConsumerConfImpl)object).getReferences()));
            this._signatureConsumers.add(object);
        }
        this._verificationRequired = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setVerification(WSSVerification, WSSConsumingContext)");
        }
    }

    public void setDecryption(WSSDecryption wSSDecryption, WSSConsumingContext wSSConsumingContext) throws WSSException {
        Iterator<String> iterator;
        List<String> list;
        WSSDecryptionImpl wSSDecryptionImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDecryption(WSSDecryption decryption, WSSConsumingContext context)");
        }
        if ((wSSDecryptionImpl = (WSSDecryptionImpl)wSSDecryption).getDataEncrpytionMethods().size() == 0) {
            list = DefaultValueManager.getInstance().getAllowedDataEncryptionMethods();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                wSSDecryptionImpl.addAllowedEncryptionMethod(iterator.next());
            }
            this._allowedDataEncryptionMethods.addAll(list);
        } else {
            this._allowedDataEncryptionMethods.addAll(wSSDecryptionImpl.getDataEncrpytionMethods());
        }
        if (wSSDecryptionImpl.getKeyEncryptionMethods().size() == 0) {
            list = DefaultValueManager.getInstance().getAllowedKeyEncryptionMethods();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                wSSDecryption.addAllowedKeyEncryptionMethod(iterator.next());
            }
            this._allowedKeyEncryptionMethods.addAll(list);
        } else {
            this._allowedKeyEncryptionMethods.addAll(wSSDecryptionImpl.getKeyEncryptionMethods());
        }
        boolean bl = wSSDecryptionImpl.isEncryptKey();
        iterator = wSSDecryptionImpl.getDataEncrpytionMethods().iterator();
        while (iterator.hasNext()) {
            PrivateConsumerConfig.EncryptionConsumerConfImpl encryptionConsumerConfImpl = new PrivateConsumerConfig.EncryptionConsumerConfImpl();
            encryptionConsumerConfImpl._dataEncryptionMethod = this.createAlgorithmConfig(iterator.next());
            for (String string : wSSDecryptionImpl.getKeyEncryptionMethods()) {
                Object object;
                Object object2;
                PrivateConsumerConfig.KeyInfoConsumerConfImpl keyInfoConsumerConfImpl;
                Object object3;
                encryptionConsumerConfImpl._keyEncryptionMethod = bl ? this.createAlgorithmConfig(string) : null;
                SecurityToken securityToken = wSSDecryptionImpl.getToken();
                PrivateConsumerConfig.TokenConsumerConfImpl tokenConsumerConfImpl = this.tokenConsumerMap.get(securityToken);
                if (tokenConsumerConfImpl == null) {
                    object3 = this.securityTokenManager.getTokenWrapper(securityToken);
                    tokenConsumerConfImpl = this.createTokenConsumerConfig(((SecurityTokenWrapper)object3).getValueType(), ((SecurityTokenWrapper)object3).getWssapiLoginConfigName(), ((SecurityTokenWrapper)object3).getWssapiCallbackHandler());
                    this.tokenConsumerMap.put(securityToken, tokenConsumerConfImpl);
                    this._tokenConsumers.add(tokenConsumerConfImpl);
                } else {
                    this._requiredSecurityTokens.remove(tokenConsumerConfImpl);
                }
                tokenConsumerConfImpl._usedForDecryption = true;
                object3 = this.createKeyInfoContentConsumerConfig(tokenConsumerConfImpl);
                ArrayList<KeyInfoContentConsumerConfig> arrayList = new ArrayList<KeyInfoContentConsumerConfig>();
                arrayList.add((KeyInfoContentConsumerConfig)object3);
                encryptionConsumerConfImpl._encryptionKeyInfo = keyInfoConsumerConfImpl = this.createKeyInfoConsumerConfig(arrayList);
                PrivateCommonConfig.ReferencePartConfImpl referencePartConfImpl = new PrivateCommonConfig.ReferencePartConfImpl();
                if (wSSDecryptionImpl.getDecryptParts().size() == 0 && (object2 = DefaultValueManager.getInstance().getDecryptionParts()) != null) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        wSSDecryption.addRequiredDecryptPart((Integer)object.next());
                    }
                }
                object2 = wSSDecryptionImpl.getDecryptParts().iterator();
                while (object2.hasNext()) {
                    object = (WSSDecryptPartImpl)object2.next();
                    PrivateCommonConfig.PartConfImpl partConfImpl = this.createPartConfig(((WSSDecryptPartImpl)object).getDialect(), ((WSSDecryptPartImpl)object).getKeyword());
                    referencePartConfImpl.getParts().add(partConfImpl);
                }
                encryptionConsumerConfImpl._reference = referencePartConfImpl;
            }
            this._requiredConfidentialParts.add(encryptionConsumerConfImpl._reference);
            this._encryptionConsumers.add(encryptionConsumerConfImpl);
        }
        this._decryptionRequired = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDecryption(WSSDecryption, WSSConsumingContext)");
        }
    }

    private PrivateCommonConfig.AlgorithmConfImpl createAlgorithmConfig(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAlgorithmConfig(String methodName)");
        }
        PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
        algorithmConfImpl._algorithm = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAlgorithmConfig(String)");
        }
        return algorithmConfImpl;
    }

    private PrivateCommonConfig.AlgorithmConfImpl createAlgorithmConfig(AlgorithmParameterData algorithmParameterData) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAlgorithmConfig(AlgorithmParameterData paramData)");
        }
        PrivateCommonConfig.AlgorithmConfImpl algorithmConfImpl = new PrivateCommonConfig.AlgorithmConfImpl();
        algorithmConfImpl._algorithm = algorithmParameterData.getAlgorithm();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAlgorithmConfig(AlgorithmParameterData)");
        }
        return algorithmConfImpl;
    }

    private List<PrivateCommonConfig.ReferencePartConfImpl> getIntegralParts(List<SigningReferenceConfig> list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getIntegralPart(List references)");
        }
        ArrayList<PrivateCommonConfig.ReferencePartConfImpl> arrayList = new ArrayList<PrivateCommonConfig.ReferencePartConfImpl>();
        for (PrivateCommonConfig.SigningReferenceConfImpl signingReferenceConfImpl : list) {
            arrayList.add(signingReferenceConfImpl._reference);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getIntegralPart(List)");
        }
        return arrayList;
    }

    private PrivateCommonConfig.PartConfImpl createPartConfig(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createPartConfig(" + string + ", " + string2 + ")");
        }
        PrivateCommonConfig.PartConfImpl partConfImpl = new PrivateCommonConfig.PartConfImpl();
        partConfImpl._dialect = string;
        if (string.equals(Constants.DIALECT_HEADER)) {
            partConfImpl._headerNamespace = string2;
        }
        partConfImpl._keyword = string2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createPartConfig(String, String)");
        }
        return partConfImpl;
    }

    private List<PrivateCommonConfig.AlgorithmConfImpl> createTransforms(List<AlgorithmParameterData> list) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTransforms(List<AlgorithmParameterData>    transforms)");
        }
        ArrayList<PrivateCommonConfig.AlgorithmConfImpl> arrayList = new ArrayList<PrivateCommonConfig.AlgorithmConfImpl>();
        if (list.size() == 0) {
            List<String> list2 = DefaultValueManager.getInstance().getTransformMethodsForSignature();
            if (list2 != null) {
                Iterator<String> iterator = list2.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(this.createAlgorithmConfig(iterator.next()));
                }
            }
        } else {
            for (AlgorithmParameterData algorithmParameterData : list) {
                arrayList.add(this.createAlgorithmConfig(algorithmParameterData));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTransforms(List)");
        }
        return arrayList;
    }

    private PrivateConsumerConfig.TokenConsumerConfImpl createTokenConsumerConfig(QName qName, String string, CallbackHandler callbackHandler) {
        Object object;
        Object object2;
        block5: {
            if (tc.isEntryEnabled()) {
                object2 = new StringBuffer("createTokenConsumerConfig(");
                ((StringBuffer)object2).append("QName valueType[").append(qName).append("], ");
                ((StringBuffer)object2).append("String loginConfigName[").append(string).append("], ");
                ((StringBuffer)object2).append("CallbackHandler callbackHandler)");
                Tr.entry(tc, ((StringBuffer)object2).toString());
            }
            object2 = new PrivateConsumerConfig.TokenConsumerConfImpl();
            ((PrivateConsumerConfig.TokenConsumerConfImpl)object2)._className = COMMON_TOKEN_CONSUMER;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
            hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
            hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", ((PrivateConsumerConfig.TokenConsumerConfImpl)object2)._className);
            try {
                object = WSSFactory.getInstance("soap");
                ((PrivateConsumerConfig.TokenConsumerConfImpl)object2)._instance = (TokenConsumerComponent)((WSSFactory)object).createConsumer(hashMap, hashMap2);
            }
            catch (SoapSecurityException soapSecurityException) {
                if (!tc.isDebugEnabled()) break block5;
                soapSecurityException.printStackTrace();
            }
        }
        ((PrivateConsumerConfig.TokenConsumerConfImpl)object2)._type = qName;
        ((PrivateConsumerConfig.TokenConsumerConfImpl)object2)._usedForDecryption = false;
        ((PrivateConsumerConfig.TokenConsumerConfImpl)object2)._usedForVerification = false;
        ((PrivateConsumerConfig.TokenConsumerConfImpl)object2)._jaasConfig = string;
        if (callbackHandler != null) {
            object = new PrivateCommonConfig.CallbackHandlerConfImpl();
            ((PrivateCommonConfig.CallbackHandlerConfImpl)object)._className = callbackHandler.getClass().getName();
            ((PrivateCommonConfig.CallbackHandlerConfImpl)object)._instance = callbackHandler;
            ((PrivateConsumerConfig.TokenConsumerConfImpl)object2)._callbackHandler = object;
        }
        this._tokenRequired = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTokenConsumerConfig(QName, String, CallbackHandler)");
        }
        return object2;
    }

    private PrivateConsumerConfig.KeyInfoContentConsumerConfImpl createKeyInfoContentConsumerConfig(PrivateConsumerConfig.TokenConsumerConfImpl tokenConsumerConfImpl) {
        PrivateConsumerConfig.KeyInfoContentConsumerConfImpl keyInfoContentConsumerConfImpl;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createKeyInfoContentConsumeConfig(TokenConsumerConfig tokenConsumerConfig)");
            }
            keyInfoContentConsumerConfImpl = new PrivateConsumerConfig.KeyInfoContentConsumerConfImpl();
            keyInfoContentConsumerConfImpl._className = COMMON_KEYINFO_CONTENT_CONSUMER;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
            hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.type", "com.ibm.ws.wssecurity.impl.core.wssfactory.custom");
            hashMap.put("com.ibm.ws.wssecurity.impl.core.wssfactory.classname", keyInfoContentConsumerConfImpl._className);
            try {
                WSSFactory wSSFactory = WSSFactory.getInstance("soap");
                keyInfoContentConsumerConfImpl._instance = (KeyInfoContentConsumerComponent)wSSFactory.createConsumer(hashMap, hashMap2);
            }
            catch (SoapSecurityException soapSecurityException) {
                if (!tc.isDebugEnabled()) break block4;
                soapSecurityException.printStackTrace();
            }
        }
        keyInfoContentConsumerConfImpl._tokenConsumer = tokenConsumerConfImpl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createKeyInfoContentConsumeConfig(TokenConsumerConfig)");
        }
        return keyInfoContentConsumerConfImpl;
    }

    private PrivateConsumerConfig.KeyInfoConsumerConfImpl createKeyInfoConsumerConfig(List<KeyInfoContentConsumerConfig> list) {
        PrivateConsumerConfig.KeyInfoConsumerConfImpl keyInfoConsumerConfImpl = new PrivateConsumerConfig.KeyInfoConsumerConfImpl();
        keyInfoConsumerConfImpl._contentConsumers = list;
        return keyInfoConsumerConfImpl;
    }
}

