/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.ws.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSContextRetrieverFactory;
import com.ibm.ws.wssecurity.wssapi.WSSGenerationContextImpl;
import com.ibm.ws.wssecurity.wssapi.WSSGenerationContextRetriever;
import com.ibm.ws.wssecurity.wssapi.WSSGeneratorTransform;
import com.ibm.ws.wssecurity.wssapi.WSSOutboundConfig;
import com.ibm.ws.wssecurity.wssapi.token.impl.Generatable;

public class WSSGeneratorTransformImpl
implements WSSGeneratorTransform {
    private static final TraceComponent tc = Tr.register(WSSGeneratorTransformImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static WSSGeneratorTransform instance = new WSSGeneratorTransformImpl();

    private WSSGeneratorTransformImpl() {
    }

    public static WSSGeneratorTransform getInstance() {
        return instance;
    }

    public WSSGeneratorConfig transform(Object object) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transform(Object obj)");
        }
        if (object == null) {
            throw WSSException.format("security.wssecurity.WSEC7006E", new String[]{"WSSGeneratorTransform", "obj"});
        }
        WSSContextRetrieverFactory wSSContextRetrieverFactory = WSSContextRetrieverFactory.getInstance();
        WSSGenerationContextRetriever wSSGenerationContextRetriever = wSSContextRetrieverFactory.getWSSGeneratoinContextRetrieverFactory(object);
        WSSGenerationContextImpl wSSGenerationContextImpl = (WSSGenerationContextImpl)wSSGenerationContextRetriever.getWSSGeneratoinContext(object);
        if (wSSGenerationContextImpl == null) {
            throw WSSException.format("security.wssecurity.WSEC7006E", new String[]{"WSSGeneratorTransform", "genContext"});
        }
        WSSOutboundConfig wSSOutboundConfig = new WSSOutboundConfig(wSSGenerationContextImpl.getSecurityTokenManagerImpl());
        wSSOutboundConfig.setActor(wSSGenerationContextImpl.getActor());
        for (Generatable generatable : wSSGenerationContextImpl.getContexts()) {
            wSSOutboundConfig.process(generatable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transform(Object obj)");
        }
        return wSSOutboundConfig;
    }
}

