/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSGenerationContext;
import com.ibm.websphere.wssecurity.wssapi.WSSTimestamp;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryption;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignature;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSContextPutterFactory;
import com.ibm.ws.wssecurity.wssapi.WSSGenerationContextPutter;
import com.ibm.ws.wssecurity.wssapi.token.impl.Generatable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import java.util.ArrayList;
import java.util.List;

public class WSSGenerationContextImpl
implements WSSGenerationContext {
    private static final TraceComponent tc = Tr.register(WSSGenerationContextImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final long serialVersionUID = 8735531148854013027L;
    private List<Generatable> targetList = new ArrayList<Generatable>();
    private String actor;
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSGenerationContextImpl(SecurityTokenManagerImpl securityTokenManagerImpl) {
        this.securityTokenManager = securityTokenManagerImpl;
    }

    public WSSGenerationContextImpl(String string, SecurityTokenManagerImpl securityTokenManagerImpl) {
        this.actor = string;
        this.securityTokenManager = securityTokenManagerImpl;
    }

    public void add(WSSSignature wSSSignature) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add(WSSSignature sig)");
        }
        this.targetList.add((Generatable)((Object)wSSSignature));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(WSSSignature sig)");
        }
    }

    public void add(WSSEncryption wSSEncryption) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add(WSSEncryption enc)");
        }
        this.targetList.add((Generatable)((Object)wSSEncryption));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(WSSEncryption enc)");
        }
    }

    public void add(SecurityToken securityToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add(SecurityToken token)");
        }
        SecurityTokenWrapper securityTokenWrapper = this.securityTokenManager.getTokenWrapper(securityToken);
        this.targetList.add(securityTokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(SecurityToken token)");
        }
    }

    public void add(WSSTimestamp wSSTimestamp) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add(WSSTimestamp ts)");
        }
        this.targetList.add((Generatable)((Object)wSSTimestamp));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(WSSTimestamp ts)");
        }
    }

    public void process(Object object) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "process(Object messageContext)");
        }
        if (object == null) {
            WSSException.format("security.wssecurity.WSEC7008E");
        }
        WSSContextPutterFactory wSSContextPutterFactory = WSSContextPutterFactory.getInstance();
        WSSGenerationContextPutter wSSGenerationContextPutter = wSSContextPutterFactory.getWSSGeneratoinContextPutterFactory(object);
        wSSGenerationContextPutter.put(object, this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "process(Object messageContext)");
        }
    }

    public List getContexts() {
        return this.targetList;
    }

    public String getActor() {
        return this.actor;
    }

    public SecurityTokenManagerImpl getSecurityTokenManagerImpl() {
        return this.securityTokenManager;
    }
}

