/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.WSSFactory;
import com.ibm.websphere.wssecurity.wssapi.WSSGenerationContext;
import com.ibm.websphere.wssecurity.wssapi.WSSTimestamp;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryptPart;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryption;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryptPart;
import com.ibm.websphere.wssecurity.wssapi.encryption.WSSEncryption;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignPart;
import com.ibm.websphere.wssecurity.wssapi.signature.WSSSignature;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerifyPart;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.CommonCallbackHandler;
import com.ibm.ws.wssecurity.wssapi.DefaultValueManager;
import com.ibm.ws.wssecurity.wssapi.TokenMapping;
import com.ibm.ws.wssecurity.wssapi.WSSConsumingContextImpl;
import com.ibm.ws.wssecurity.wssapi.WSSGenerationContextImpl;
import com.ibm.ws.wssecurity.wssapi.WSSTimestampImpl;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.dec.impl.WSSDecryptPartImpl;
import com.ibm.ws.wssecurity.wssapi.dec.impl.WSSDecryptionImpl;
import com.ibm.ws.wssecurity.wssapi.enc.impl.WSSEncryptPartImpl;
import com.ibm.ws.wssecurity.wssapi.enc.impl.WSSEncryptionImpl;
import com.ibm.ws.wssecurity.wssapi.sig.impl.WSSSignPartImpl;
import com.ibm.ws.wssecurity.wssapi.sig.impl.WSSSignatureImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SCTWrapper;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import com.ibm.ws.wssecurity.wssapi.verify.impl.WSSVerificationImpl;
import com.ibm.ws.wssecurity.wssapi.verify.impl.WSSVerifyPartImpl;
import com.ibm.wsspi.wssecurity.core.Constants;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class WSSFactoryImpl
extends WSSFactory {
    private static final TraceComponent tc = Tr.register(WSSFactoryImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSFactoryImpl.class.getName();
    private static Map<String, String> tokensMap = new HashMap<String, String>();
    private Map<Object, Object> context = new HashMap<Object, Object>();
    private SecurityTokenManagerImpl securityTokenManager = new SecurityTokenManagerImpl(this.context);

    public WSSGenerationContext newWSSGenerationContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSGenerationContext()");
        }
        WSSGenerationContextImpl wSSGenerationContextImpl = new WSSGenerationContextImpl(this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSGenerationContext()");
        }
        return wSSGenerationContextImpl;
    }

    public WSSGenerationContext newWSSGenerationContext(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSGenerationContext(" + string + ")");
        }
        WSSGenerationContextImpl wSSGenerationContextImpl = new WSSGenerationContextImpl(string, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSGenerationContext(String)");
        }
        return wSSGenerationContextImpl;
    }

    public WSSConsumingContext newWSSConsumingContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSConsumingContext()");
        }
        WSSConsumingContextImpl wSSConsumingContextImpl = new WSSConsumingContextImpl(this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSConsumingContext()");
        }
        return wSSConsumingContextImpl;
    }

    public WSSConsumingContext newWSSConsumingContext(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSConsumingContext(" + string + ")");
        }
        WSSConsumingContextImpl wSSConsumingContextImpl = new WSSConsumingContextImpl(string, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSConsumingContext(actor)");
        }
        return wSSConsumingContextImpl;
    }

    public WSSSignature newWSSSignature(SecurityToken securityToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSSignature(" + securityToken.toString() + ")");
        }
        WSSSignatureImpl wSSSignatureImpl = new WSSSignatureImpl(securityToken, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSSignature(SecurityToken)");
        }
        return wSSSignatureImpl;
    }

    public WSSSignPart newWSSSignPart() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSSignPart()");
        }
        WSSSignPartImpl wSSSignPartImpl = new WSSSignPartImpl(this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSSignPart()");
        }
        return wSSSignPartImpl;
    }

    public WSSEncryption newWSSEncryption(SecurityToken securityToken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSEncryption( token[" + securityToken.toString() + "])");
        }
        WSSEncryptionImpl wSSEncryptionImpl = new WSSEncryptionImpl(securityToken, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSEncryption(SecurityToken)");
        }
        return wSSEncryptionImpl;
    }

    public WSSEncryption newWSSEncryption() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSEncryption()");
        }
        WSSEncryptionImpl wSSEncryptionImpl = new WSSEncryptionImpl(this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSEncryption()");
        }
        return wSSEncryptionImpl;
    }

    public WSSEncryptPart newWSSEncryptPart() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSEncryptPart()");
        }
        WSSEncryptPartImpl wSSEncryptPartImpl = new WSSEncryptPartImpl();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSEncryptPart()");
        }
        return wSSEncryptPartImpl;
    }

    public WSSTimestamp newWSSTimestamp() throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSTimestamp()");
        }
        WSSTimestampImpl wSSTimestampImpl = new WSSTimestampImpl();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSTimestamp()");
        }
        return wSSTimestampImpl;
    }

    public SecurityToken newSecurityToken(Class clazz, CallbackHandler callbackHandler, String string) throws WSSException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("newSecurityToken(");
            ((StringBuffer)object).append("String loginConfigName[").append(string).append("], ");
            ((StringBuffer)object).append("CallbackHandler callbackHandler, ");
            ((StringBuffer)object).append("Class tokenClass[");
            ((StringBuffer)object).append(clazz == null ? null : clazz.getName());
            ((StringBuffer)object).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = WSSUtil.newSecurityTokenForGnenerator(clazz, callbackHandler, string, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("newSecurityToken(");
            stringBuffer.append("String, CallbackHandler, Class)");
            stringBuffer.append(" returns SecurityToken[").append(object).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return object;
    }

    public SecurityToken[] newSecurityTokens(Class[] classArray, CallbackHandler callbackHandler, String string) throws WSSException {
        SecurityToken[] securityTokenArray;
        CharSequence charSequence;
        if (tc.isEntryEnabled()) {
            charSequence = new StringBuffer("newSecurityToken(");
            ((StringBuffer)charSequence).append("String loginConfigName[").append(string).append("], ");
            ((StringBuffer)charSequence).append("CallbackHandler callbackHandler, ");
            ((StringBuffer)charSequence).append("Class[] tokenClasses[");
            ((StringBuffer)charSequence).append(classArray == null ? "null" : "not null");
            ((StringBuffer)charSequence).append("])");
            Tr.entry(tc, ((StringBuffer)charSequence).toString());
        }
        if (classArray == null || classArray.length != 1) {
            throw WSSException.format("security.wssecurity.WSEC7011E", new String[]{"newSecurityToken"});
        }
        charSequence = classArray[0].getName();
        CharSequence charSequence2 = tokensMap.get(charSequence);
        if (charSequence2 == null) {
            charSequence2 = charSequence;
        }
        if (!charSequence2.equals("com.ibm.ws.wssecurity.wssapi.token.impl.SCTWrapper")) {
            throw WSSException.format("security.wssecurity.WSEC7011E", new String[]{"newSecurityToken"});
        }
        SecurityToken securityToken = null;
        try {
            securityToken = (SecurityToken)Class.forName(charSequence2).newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.processException(illegalAccessException, clsName + ".processSCT()", "%C");
            Tr.error(tc, "security.wssecurity.WSEC7076E", new Object[]{charSequence2});
            throw WSSException.format("security.wssecurity.WSEC7076E", charSequence2, (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Tr.processException(instantiationException, clsName + ".processSCT()", "%C");
            Tr.error(tc, "security.wssecurity.WSEC7076E", new Object[]{charSequence2});
            throw WSSException.format("security.wssecurity.WSEC7076E", charSequence2, (Throwable)instantiationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.processException(classNotFoundException, clsName + ".processSCT()", "%C");
            Tr.error(tc, "security.wssecurity.WSEC7076E", new Object[]{charSequence2});
            throw WSSException.format("security.wssecurity.WSEC7076E", charSequence2, (Throwable)classNotFoundException);
        }
        if (string == null) {
            securityTokenArray = DefaultValueManager.getInstance().getTokenMapping();
            TokenMapping tokenMapping = (TokenMapping)securityTokenArray.get(securityToken.getValueType());
            string = tokenMapping.getJaasLoginConfigNameForGenerator();
        }
        securityTokenArray = this.processSCT(string, callbackHandler);
        int n = securityTokenArray.length;
        for (int i = 0; i < n; ++i) {
            SecurityTokenWrapper securityTokenWrapper = new SecurityTokenWrapper(securityTokenArray[i], callbackHandler, string);
            this.securityTokenManager.addTokenWrapper(securityTokenWrapper);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("newSecurityToken(");
            stringBuffer.append("String, CallbackHandler, Class[])");
            stringBuffer.append(" returns SecurityToken[][").append(securityTokenArray).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return securityTokenArray;
    }

    private SecurityToken[] processSCT(final String string, CallbackHandler callbackHandler) throws WSSException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            object2 = new StringBuffer("processSCT(");
            ((StringBuffer)object2).append("String loginConfigName[").append(string).append("], ");
            ((StringBuffer)object2).append("CallbackHandker callbackHandler)");
            Tr.entry(tc, ((StringBuffer)object2).toString());
        }
        object2 = this.securityTokenManager.getContext();
        final Subject subject = (Subject)object2.get("com.ibm.wsspi.wssecurity.core.subject");
        final CommonCallbackHandler commonCallbackHandler = new CommonCallbackHandler(callbackHandler, (Map<Object, Object>)object2);
        try {
            object = (LoginContext)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws LoginException {
                    LoginContext loginContext = new LoginContext(string, subject, commonCallbackHandler);
                    return loginContext;
                }
            });
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Succeed to construct the login context.");
            }
            ((LoginContext)object).login();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Succeed to login.");
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            LoginException loginException = (LoginException)privilegedActionException.getCause();
            Tr.processException(loginException, clsName + ".processSCT()", "%C");
            Tr.error(tc, "security.wssecurity.X509TokenConsumer.s01", new Object[]{loginException});
            throw WSSException.format("security.wssecurity.X509TokenConsumer.s01", loginException);
        }
        catch (LoginException loginException) {
            Tr.processException(loginException, clsName + ".processSCT()", "%C");
            Tr.error(tc, "security.wssecurity.X509TokenConsumer.s02", new Object[]{loginException});
            throw WSSException.format("security.wssecurity.X509TokenConsumer.s02", loginException);
        }
        object = (List)object2.get(Constants.WSSECURITY_TOKEN_PROCESSED);
        SecurityToken[] securityTokenArray = object.toArray(new SecurityToken[0]);
        for (int i = 0; i < securityTokenArray.length; ++i) {
            if (securityTokenArray[i] == null || !(securityTokenArray[i] instanceof SCTWrapper)) continue;
            ((SCTWrapper)securityTokenArray[i]).setSecurityTokenManagerImpl(this.securityTokenManager);
        }
        if (tc.isEntryEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("newSecurityToken(");
            stringBuffer.append("String, CallbackHandler, Class[])");
            stringBuffer.append(" returns SecurityToken[][").append(securityTokenArray).append("]");
            Tr.exit(tc, stringBuffer.toString());
        }
        return securityTokenArray;
    }

    public SecurityToken newSecurityToken(Class clazz, CallbackHandler callbackHandler) throws WSSException {
        return this.newSecurityToken(clazz, callbackHandler, null);
    }

    public SecurityToken[] newSecurityTokens(Class[] classArray, CallbackHandler callbackHandler) throws WSSException {
        return this.newSecurityTokens(classArray, callbackHandler, null);
    }

    public WSSVerification newWSSVerification(Class clazz) throws WSSException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("newWSSVerification(");
            ((StringBuffer)object).append("Class tokenClass[").append(clazz).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = new WSSVerificationImpl(clazz, null, null, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSVerification(Class)");
        }
        return object;
    }

    public WSSVerification newWSSVerification(Class clazz, CallbackHandler callbackHandler) throws WSSException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("newWSSVerification(");
            ((StringBuffer)object).append("Class tokenClass[").append(clazz).append("], ");
            ((StringBuffer)object).append("CallbackHandker callbackHandler)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = new WSSVerificationImpl(clazz, callbackHandler, null, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSVerification(Class, CallbackHandler)");
        }
        return object;
    }

    public WSSVerification newWSSVerification(Class clazz, CallbackHandler callbackHandler, String string) throws WSSException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("newWSSVerification(");
            ((StringBuffer)object).append("Class tokenClass[").append(clazz).append("], ");
            ((StringBuffer)object).append("CallbackHandker callbackHandler, ");
            ((StringBuffer)object).append("String loginConfigName[").append(string).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = new WSSVerificationImpl(clazz, callbackHandler, string, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSVerification(Class, CallbackHandler, String)");
        }
        return object;
    }

    public WSSVerifyPart newWSSVerifyPart() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSVerifyPart");
        }
        WSSVerifyPartImpl wSSVerifyPartImpl = new WSSVerifyPartImpl();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSVerifyPart");
        }
        return wSSVerifyPartImpl;
    }

    public WSSDecryption newWSSDecryption() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSDecryption()");
        }
        WSSDecryptionImpl wSSDecryptionImpl = new WSSDecryptionImpl(this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSDecryption()");
        }
        return wSSDecryptionImpl;
    }

    public WSSDecryption newWSSDecryption(Class clazz) throws WSSException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("newWSSDecryptPart(");
            ((StringBuffer)object).append("Class tokenClass[").append(clazz).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = new WSSDecryptionImpl(clazz, null, null, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSDecryption(Class)");
        }
        return object;
    }

    public WSSDecryption newWSSDecryption(Class clazz, CallbackHandler callbackHandler) throws WSSException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("newWSSDecryptPart(");
            ((StringBuffer)object).append("Class tokenClass[").append(clazz).append("], ");
            ((StringBuffer)object).append("CallbackHandker callbackHandler)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = new WSSDecryptionImpl(clazz, callbackHandler, null, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSDecryption(Class, CallbackHandler)");
        }
        return object;
    }

    public WSSDecryption newWSSDecryption(Class clazz, CallbackHandler callbackHandler, String string) throws WSSException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("newWSSDecryptPart(");
            ((StringBuffer)object).append("Class tokenClass[").append(clazz).append("], ");
            ((StringBuffer)object).append("CallbackHandker callbackHandler, ");
            ((StringBuffer)object).append("String loginConfigName[").append(string).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = new WSSDecryptionImpl(clazz, callbackHandler, string, this.securityTokenManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSDecryption(Class, CallbackHandler, String)");
        }
        return object;
    }

    public WSSDecryptPart newWSSDecryptPart() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "newWSSDecryptPart()");
        }
        WSSDecryptPartImpl wSSDecryptPartImpl = new WSSDecryptPartImpl();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "newWSSDecryptPart()");
        }
        return wSSDecryptPartImpl;
    }

    static {
        tokensMap.put("com.ibm.websphere.wssecurity.wssapi.token.SecurityContextToken", "com.ibm.ws.wssecurity.wssapi.token.impl.SCTWrapper");
    }
}

