/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSConsumingContextPutter;
import com.ibm.ws.wssecurity.wssapi.WSSGenerationContextPutter;
import java.util.HashMap;
import java.util.Map;

public class WSSContextPutterFactory {
    private static final TraceComponent tc = Tr.register(WSSContextPutterFactory.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSContextPutterFactory.class.getName();
    private static Map<String, String> generatorMap = new HashMap<String, String>();
    private static Map<String, String> consumerMap = new HashMap<String, String>();
    private static Map<String, WSSGenerationContextPutter> cacheGeneratorMap = new HashMap<String, WSSGenerationContextPutter>();
    private static Map<String, WSSConsumingContextPutter> cacheConsumerMap = new HashMap<String, WSSConsumingContextPutter>();
    private static WSSContextPutterFactory instance;

    private WSSContextPutterFactory() {
    }

    public static WSSContextPutterFactory getInstance() {
        return instance;
    }

    public WSSGenerationContextPutter getWSSGeneratoinContextPutterFactory(Object object) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSGeneratoinContextPutterFactory(Object object)");
        }
        if (object == null) {
            throw WSSException.format("security.wssecurity.WSEC7011E", new String[]{"getWSSGeneratoinContextPutterFactory"});
        }
        String string = null;
        string = object instanceof Map ? generatorMap.get("java.util.Map") : generatorMap.get("org.apache.axis2.client.ServiceClient");
        if (string == null) {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "Cannot find class [" + object.getClass().getName() + "] in generatorMap");
            }
            throw WSSException.format("security.wssecurity.WSEC7007E");
        }
        WSSGenerationContextPutter wSSGenerationContextPutter = null;
        try {
            wSSGenerationContextPutter = cacheGeneratorMap.get(string);
            if (wSSGenerationContextPutter == null) {
                wSSGenerationContextPutter = (WSSGenerationContextPutter)Class.forName(string).newInstance();
                cacheGeneratorMap.put(string, wSSGenerationContextPutter);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.processException((Throwable)illegalAccessException, clsName + ".getWSSGeneratoinContextPutterFactory", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", string, (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Tr.processException((Throwable)instantiationException, clsName + ".getWSSGeneratoinContextPutterFactory", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", string, (Throwable)instantiationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.processException((Throwable)classNotFoundException, clsName + ".getWSSGeneratoinContextPutterFactory", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", string, (Throwable)classNotFoundException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSGeneratoinContextPutterFactory(Object object)");
        }
        return wSSGenerationContextPutter;
    }

    public WSSConsumingContextPutter getWSSConsumingContextPutterFactory(Object object) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSSConsumingContextPutterFactory(Object object)");
        }
        if (object == null) {
            throw WSSException.format("security.wssecurity.WSEC7011E", new String[]{"getWSSConsumingContextPutterFactory"});
        }
        String string = null;
        string = object instanceof Map ? consumerMap.get("java.util.Map") : consumerMap.get("org.apache.axis2.client.ServiceClient");
        if (string == null) {
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "Cannot find class [" + object.getClass().getName() + "] in consumerMap");
            }
            throw WSSException.format("security.wssecurity.WSEC7007E");
        }
        WSSConsumingContextPutter wSSConsumingContextPutter = null;
        try {
            wSSConsumingContextPutter = cacheConsumerMap.get(string);
            if (wSSConsumingContextPutter == null) {
                wSSConsumingContextPutter = (WSSConsumingContextPutter)Class.forName(string).newInstance();
                cacheConsumerMap.put(string, wSSConsumingContextPutter);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.processException((Throwable)illegalAccessException, clsName + ".getWSSConsumingContextPutterFactory", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", string, (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Tr.processException((Throwable)instantiationException, clsName + ".getWSSConsumingContextPutterFactory", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", string, (Throwable)instantiationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.processException((Throwable)classNotFoundException, clsName + ".getWSSConsumingContextPutterFactory", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", string, (Throwable)classNotFoundException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSSConsumingContextPutterFactory(Object object)");
        }
        return wSSConsumingContextPutter;
    }

    static {
        generatorMap.put("java.util.Map", "com.ibm.ws.wssecurity.wssapi.JAXWSGenerationContextPutter");
        generatorMap.put("org.apache.axis2.client.ServiceClient", "com.ibm.ws.wssecurity.wssapi.Axis2GenerationContextPutter");
        consumerMap.put("java.util.Map", "com.ibm.ws.wssecurity.wssapi.JAXWSConsumingContextPutter");
        consumerMap.put("org.apache.axis2.client.ServiceClient", "com.ibm.ws.wssecurity.wssapi.Axis2ConsumingContextPutter");
        instance = new WSSContextPutterFactory();
    }
}

