/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSConsumingContext;
import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.websphere.wssecurity.wssapi.decryption.WSSDecryption;
import com.ibm.websphere.wssecurity.wssapi.token.SecurityToken;
import com.ibm.websphere.wssecurity.wssapi.verification.WSSVerification;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSContextPutterFactory;
import com.ibm.ws.wssecurity.wssapi.WSSUtil;
import com.ibm.ws.wssecurity.wssapi.token.impl.Consumable;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenManagerImpl;
import com.ibm.ws.wssecurity.wssapi.token.impl.SecurityTokenWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;

public class WSSConsumingContextImpl
implements WSSConsumingContext {
    private static final TraceComponent tc = Tr.register(WSSConsumingContextImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSConsumingContextImpl.class.getName();
    private static final long serialVersionUID = -4814725885349270383L;
    private static Map<Integer, String> partMap = new HashMap<Integer, String>();
    private List<Consumable> targetList = new ArrayList<Consumable>();
    private String actor;
    private SecurityTokenManagerImpl securityTokenManager = null;

    public WSSConsumingContextImpl(SecurityTokenManagerImpl securityTokenManagerImpl) {
        this.securityTokenManager = securityTokenManagerImpl;
    }

    public WSSConsumingContextImpl(String string, SecurityTokenManagerImpl securityTokenManagerImpl) {
        this.actor = string;
        this.securityTokenManager = securityTokenManagerImpl;
    }

    public void add(WSSVerification wSSVerification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add(WSSVerification verifiaction)");
        }
        this.targetList.add((Consumable)((Object)wSSVerification));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(WSSVerification)");
        }
    }

    public void add(WSSDecryption wSSDecryption) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add(WSSDecryption decryption)");
        }
        this.targetList.add((Consumable)((Object)wSSDecryption));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(WSSDecryption)");
        }
    }

    public void process(Object object) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "process(Object messageContext)");
        }
        WSSContextPutterFactory.getInstance().getWSSConsumingContextPutterFactory(object).put(object, this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "process(Object)");
        }
    }

    public void add(Class clazz, CallbackHandler callbackHandler, String string) throws WSSException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("add(");
            ((StringBuffer)object).append("Class tokenClass[").append(clazz).append("], ");
            ((StringBuffer)object).append("CallbackHandler callbackHandler, ");
            ((StringBuffer)object).append("String loginConfigName[").append(string).append("])");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = WSSUtil.newSecurityTokenForConsumer(clazz, callbackHandler, string, this.securityTokenManager);
        SecurityTokenWrapper securityTokenWrapper = this.securityTokenManager.getTokenWrapper((SecurityToken)object);
        this.targetList.add(securityTokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(Class, CallbackHandler, String)");
        }
    }

    public void add(Class clazz, CallbackHandler callbackHandler) throws WSSException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new StringBuffer("add(");
            ((StringBuffer)object).append("Class tokenClass[").append(clazz).append("], ");
            ((StringBuffer)object).append("CallbackHandler callbackHandler)");
            Tr.entry(tc, ((StringBuffer)object).toString());
        }
        object = WSSUtil.newSecurityTokenForConsumer(clazz, callbackHandler, null, this.securityTokenManager);
        SecurityTokenWrapper securityTokenWrapper = this.securityTokenManager.getTokenWrapper((SecurityToken)object);
        this.targetList.add(securityTokenWrapper);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(Class, CallbackHandler)");
        }
    }

    public void add(int n) throws WSSException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "add(int keyword[" + n + "])");
        }
        if ((string = partMap.get(n)) == null) {
            throw WSSException.format("security.wssecurity.WSEC7010E");
        }
        Object var3_3 = null;
        try {
            var3_3 = Class.forName(string).newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.processException((Throwable)illegalAccessException, clsName + ".add", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", string, (Throwable)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            Tr.processException((Throwable)instantiationException, clsName + ".add", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", string, (Throwable)instantiationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.processException((Throwable)classNotFoundException, clsName + ".add", "%C", this);
            throw WSSException.format("security.wssecurity.WSEC7076E", string, (Throwable)classNotFoundException);
        }
        this.targetList.add(var3_3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "add(int keyword)");
        }
    }

    public List getContexts() {
        return this.targetList;
    }

    public SecurityTokenManagerImpl getSecurityTokenManagerImpl() {
        return this.securityTokenManager;
    }

    public String getActor() {
        return this.actor;
    }

    static {
        partMap.put(11, "com.ibm.ws.wssecurity.wssapi.WSSTimestampImpl");
    }
}

