/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.wssapi;

import com.ibm.websphere.wssecurity.wssapi.WSSException;
import com.ibm.ws.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.wssecurity.util.Tr;
import com.ibm.ws.wssecurity.util.TraceComponent;
import com.ibm.ws.wssecurity.wssapi.WSSConsumerTransform;
import com.ibm.ws.wssecurity.wssapi.WSSConsumingContextImpl;
import com.ibm.ws.wssecurity.wssapi.WSSConsumingContextRetriever;
import com.ibm.ws.wssecurity.wssapi.WSSContextRetrieverFactory;
import com.ibm.ws.wssecurity.wssapi.WSSInboundConfig;
import com.ibm.ws.wssecurity.wssapi.token.impl.Consumable;

public class WSSConsumerTransformImpl
implements WSSConsumerTransform {
    private static final TraceComponent tc = Tr.register(WSSConsumerTransformImpl.class, "Web Services Security", "com.ibm.ws.wssecurity.resources.wssmessages");
    private static final String comp = "security.wssecurity";
    private static WSSConsumerTransform instance = new WSSConsumerTransformImpl();

    private WSSConsumerTransformImpl() {
    }

    public static WSSConsumerTransform getInstance() {
        return instance;
    }

    public WSSConsumerConfig transform(Object object) throws WSSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "transform(Object obj)");
        }
        if (object == null) {
            throw WSSException.format("security.wssecurity.WSEC7006E", new String[]{"WSSConsumerTransform", "obj"});
        }
        WSSContextRetrieverFactory wSSContextRetrieverFactory = WSSContextRetrieverFactory.getInstance();
        WSSConsumingContextRetriever wSSConsumingContextRetriever = wSSContextRetrieverFactory.getWSSConsumingContextRetrieverFactory(object);
        WSSConsumingContextImpl wSSConsumingContextImpl = (WSSConsumingContextImpl)wSSConsumingContextRetriever.getWSSConsumingContext(object);
        if (wSSConsumingContextImpl == null) {
            WSSException.format("security.wssecurity.WSEC7006E", new String[]{"WSSConsumerTransform", "conContext"});
        }
        WSSInboundConfig wSSInboundConfig = new WSSInboundConfig(wSSConsumingContextImpl.getSecurityTokenManagerImpl());
        wSSInboundConfig.setActor(wSSConsumingContextImpl.getActor());
        for (Consumable consumable : wSSConsumingContextImpl.getContexts()) {
            wSSInboundConfig.process(consumable, wSSConsumingContextImpl);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "transform(Object obj)");
        }
        return wSSInboundConfig;
    }
}

